/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.io;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.io.Base58Codec;

public final class Base58 {
    private Base58() {
    }

    public static String encodeBytes(byte[] bytes) {
        Objects.requireNonNull(bytes);
        return new String(Base58Codec.encode(bytes), StandardCharsets.UTF_8);
    }

    public static String encode(Bytes bytes) {
        Objects.requireNonNull(bytes);
        return Base58.encodeBytes(bytes.toArrayUnsafe());
    }

    public static byte[] decodeBytes(String b58) {
        Objects.requireNonNull(b58);
        return Base58Codec.decode(b58);
    }

    public static Bytes decode(String b58) {
        return Bytes.wrap((byte[])Base58.decodeBytes(b58));
    }
}

