/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.genesis;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/apache/tuweni/genesis/Allocation;", "", "address", "Lorg/apache/tuweni/eth/Address;", "amount", "Lorg/apache/tuweni/units/bigints/UInt256;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "(Lorg/apache/tuweni/eth/Address;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;)V", "getAddress", "()Lorg/apache/tuweni/eth/Address;", "getAmount", "()Lorg/apache/tuweni/units/bigints/UInt256;", "getKeyPair", "()Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "genesis"})
public final class Allocation {
    @NotNull
    private final Address address;
    @NotNull
    private final UInt256 amount;
    @NotNull
    private final SECP256K1.KeyPair keyPair;

    public Allocation(@NotNull Address address, @NotNull UInt256 amount, @NotNull SECP256K1.KeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        this.address = address;
        this.amount = amount;
        this.keyPair = keyPair;
    }

    @NotNull
    public final Address getAddress() {
        return this.address;
    }

    @NotNull
    public final UInt256 getAmount() {
        return this.amount;
    }

    @NotNull
    public final SECP256K1.KeyPair getKeyPair() {
        return this.keyPair;
    }

    @NotNull
    public final Address component1() {
        return this.address;
    }

    @NotNull
    public final UInt256 component2() {
        return this.amount;
    }

    @NotNull
    public final SECP256K1.KeyPair component3() {
        return this.keyPair;
    }

    @NotNull
    public final Allocation copy(@NotNull Address address, @NotNull UInt256 amount, @NotNull SECP256K1.KeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        return new Allocation(address, amount, keyPair);
    }

    public static /* synthetic */ Allocation copy$default(Allocation allocation, Address address, UInt256 uInt256, SECP256K1.KeyPair keyPair, int n, Object object) {
        if ((n & 1) != 0) {
            address = allocation.address;
        }
        if ((n & 2) != 0) {
            uInt256 = allocation.amount;
        }
        if ((n & 4) != 0) {
            keyPair = allocation.keyPair;
        }
        return allocation.copy(address, uInt256, keyPair);
    }

    @NotNull
    public String toString() {
        return "Allocation(address=" + this.address + ", amount=" + this.amount + ", keyPair=" + this.keyPair + ")";
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = result * 31 + this.amount.hashCode();
        result = result * 31 + this.keyPair.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Allocation)) {
            return false;
        }
        Allocation allocation = (Allocation)other;
        if (!Intrinsics.areEqual((Object)this.address, (Object)allocation.address)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.amount, (Object)allocation.amount)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.keyPair, (Object)allocation.keyPair);
    }
}

