/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5.topic;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.devp2p.DiscoveryService;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.devp2p.v5.topic.TargetAd;
import org.apache.tuweni.devp2p.v5.topic.Topic;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bJ\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u001a\u001a\u00020\u0013J\u0016\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0019J\u0018\u0010\u001d\u001a\u00020\u000b*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\u0018\u0010\u001e\u001a\u00020\u000b*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0006\u001a6\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\u0007j\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/apache/tuweni/devp2p/v5/topic/TopicTable;", "", "tableCapacity", "", "queueCapacity", "(II)V", "table", "Ljava/util/HashMap;", "Lorg/apache/tuweni/devp2p/v5/topic/Topic;", "Lcom/google/common/cache/Cache;", "", "Lorg/apache/tuweni/devp2p/v5/topic/TargetAd;", "Lkotlin/collections/HashMap;", "timeSupplier", "Lkotlin/Function0;", "", "clear", "", "contains", "", "topic", "createNewQueue", "gcTable", "getNodes", "", "Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "isEmpty", "put", "enr", "oldest", "youngest", "Companion", "devp2p"})
public final class TopicTable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int tableCapacity;
    private final int queueCapacity;
    @NotNull
    private final Function0<Long> timeSupplier;
    @NotNull
    private final HashMap<Topic, Cache<String, TargetAd>> table;
    public static final int MAX_ENTRIES_PER_TOPIC = 100;
    private static final int MAX_TABLE_CAPACITY = 500;
    private static final long TARGET_AD_LIFETIME_MS = 900000L;
    @NotNull
    private static final String QUEUE_EMPTY_MSG = "Queue is empty.";

    public TopicTable(int tableCapacity, int queueCapacity) {
        this.tableCapacity = tableCapacity;
        this.queueCapacity = queueCapacity;
        this.timeSupplier = DiscoveryService.Companion.getCURRENT_TIME_SUPPLIER$devp2p();
        this.table = new HashMap(this.tableCapacity);
        if (!(this.tableCapacity > 0)) {
            boolean $i$a$-require-TopicTable$32 = false;
            String $i$a$-require-TopicTable$32 = "Table capacity value must be positive";
            throw new IllegalArgumentException($i$a$-require-TopicTable$32.toString());
        }
        if (!(this.queueCapacity > 0)) {
            boolean bl = false;
            String string = "Queue capacity value must be positive";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ TopicTable(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 500;
        }
        if ((n3 & 2) != 0) {
            n2 = 100;
        }
        this(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EthereumNodeRecord> getNodes(@NotNull Topic topic) {
        List list;
        Cache<String, TargetAd> values;
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Cache<String, TargetAd> cache = values = this.table.get(topic);
        if (cache == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Cache<String, TargetAd> it = cache;
            boolean bl = false;
            Iterable $this$map$iv = values.asMap().values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                TargetAd targetAd = (TargetAd)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it2.getEnr());
            }
            list = (List)destination$iv$iv;
        }
        List list2 = list;
        if (list == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized long put(@NotNull Topic topic, @NotNull EthereumNodeRecord enr) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)enr, (String)"enr");
        this.gcTable();
        Cache<String, TargetAd> topicQueue = this.table.get(topic);
        String nodeId = enr.nodeId().toHexString();
        if (topicQueue != null) {
            if (topicQueue.size() < (long)this.queueCapacity) {
                topicQueue.put((Object)nodeId, (Object)new TargetAd(((Number)this.timeSupplier.invoke()).longValue(), enr));
                return 0L;
            }
            return 900000L - (((Number)this.timeSupplier.invoke()).longValue() - this.oldest(topicQueue).getRegTime());
        }
        if (this.table.size() < this.tableCapacity) {
            Cache<String, TargetAd> cache;
            Map map = this.table;
            Cache<String, TargetAd> $this$put_u24lambda_u2d4 = cache = this.createNewQueue();
            boolean bl = false;
            $this$put_u24lambda_u2d4.put((Object)nodeId, (Object)new TargetAd(((Number)this.timeSupplier.invoke()).longValue(), enr));
            map.put(topic, cache);
            return 0L;
        }
        Set<Map.Entry<Topic, Cache<String, TargetAd>>> bl = this.table.entrySet();
        Intrinsics.checkNotNullExpressionValue(bl, (String)"table.entries");
        Iterable $this$map$iv = bl;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            collection.add(this.youngest((Cache<String, TargetAd>)((Cache)v)).getRegTime());
        }
        Long l = (Long)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
        long oldestInTable = l == null ? -1L : l;
        return 900000L - (((Number)this.timeSupplier.invoke()).longValue() - oldestInTable);
    }

    public final boolean contains(@NotNull Topic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.table.containsKey(topic);
    }

    public final boolean isEmpty() {
        return this.table.isEmpty();
    }

    public final void clear() {
        this.table.clear();
    }

    private final Cache<String, TargetAd> createNewQueue() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(900000L, TimeUnit.MILLISECONDS).initialCapacity(this.queueCapacity).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"newBuilder()\n      .expi\u2026eCapacity)\n      .build()");
        return cache;
    }

    private final void gcTable() {
        this.table.entrySet().removeIf(TopicTable::gcTable$lambda-6);
    }

    private final TargetAd oldest(Cache<String, TargetAd> $this$oldest) {
        Object v0;
        Iterable $this$minByOrNull$iv = $this$oldest.asMap().values();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                TargetAd it = (TargetAd)minElem$iv;
                boolean bl = false;
                long minValue$iv = it.getRegTime();
                do {
                    Object e$iv = iterator$iv.next();
                    TargetAd it2 = (TargetAd)e$iv;
                    $i$a$-minByOrNull-TopicTable$oldest$1 = false;
                    long v$iv = it2.getRegTime();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        TargetAd targetAd = v0;
        if (targetAd == null) {
            throw new IllegalArgumentException(QUEUE_EMPTY_MSG);
        }
        return targetAd;
    }

    private final TargetAd youngest(Cache<String, TargetAd> $this$youngest) {
        Object v0;
        Iterable $this$maxByOrNull$iv = $this$youngest.asMap().values();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                TargetAd it = (TargetAd)maxElem$iv;
                boolean bl = false;
                long maxValue$iv = it.getRegTime();
                do {
                    Object e$iv = iterator$iv.next();
                    TargetAd it2 = (TargetAd)e$iv;
                    $i$a$-maxByOrNull-TopicTable$youngest$1 = false;
                    long v$iv = it2.getRegTime();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        TargetAd targetAd = v0;
        if (targetAd == null) {
            throw new IllegalArgumentException(QUEUE_EMPTY_MSG);
        }
        return targetAd;
    }

    private static final boolean gcTable$lambda-6(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Cache)it.getValue()).size() == 0L;
    }

    public TopicTable() {
        this(0, 0, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/apache/tuweni/devp2p/v5/topic/TopicTable$Companion;", "", "()V", "MAX_ENTRIES_PER_TOPIC", "", "MAX_TABLE_CAPACITY", "QUEUE_EMPTY_MSG", "", "TARGET_AD_LIFETIME_MS", "", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

