/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.CompletableAsyncResult;
import org.apache.tuweni.concurrent.ExpiringMap;
import org.apache.tuweni.concurrent.coroutines.AsyncCompletionKt;
import org.apache.tuweni.concurrent.coroutines.AsyncResultKt;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.devp2p.v5.DefaultDiscoveryV5Service;
import org.apache.tuweni.devp2p.v5.DiscoveryV5Service;
import org.apache.tuweni.devp2p.v5.ENRStorage;
import org.apache.tuweni.devp2p.v5.HandshakeSession;
import org.apache.tuweni.devp2p.v5.RoutingTable;
import org.apache.tuweni.devp2p.v5.Session;
import org.apache.tuweni.devp2p.v5.encrypt.SessionKey;
import org.apache.tuweni.devp2p.v5.topic.TopicTable;
import org.apache.tuweni.io.Base64URLSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 J2\u00020\u0001:\u0001JBY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J!\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0011\u0010.\u001a\u00020*H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J(\u00100\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001a2\n\b\u0002\u00101\u001a\u0004\u0018\u0001022\n\b\u0002\u00103\u001a\u0004\u0018\u00010\u000eH\u0002J(\u00104\u001a\u00020%2\u0006\u00105\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001a2\u0006\u00106\u001a\u0002072\u0006\u00103\u001a\u00020\u000eH\u0002J\b\u0010+\u001a\u00020\u000eH\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J9\u0010<\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00070>0=2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010CJ\u0018\u0010D\u001a\u0002092\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010F\u001a\u00020GH\u0002J\u0011\u0010H\u001a\u00020*H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\u0011\u0010I\u001a\u000209H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \"*\u0004\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n \"*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006K"}, d2={"Lorg/apache/tuweni/devp2p/v5/DefaultDiscoveryV5Service;", "Lorg/apache/tuweni/devp2p/v5/DiscoveryV5Service;", "vertx", "Lio/vertx/core/Vertx;", "bindAddress", "Ljava/net/InetSocketAddress;", "bootstrapENRList", "", "", "enrStorage", "Lorg/apache/tuweni/devp2p/v5/ENRStorage;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "selfEnr", "Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "routingTable", "Lorg/apache/tuweni/devp2p/v5/RoutingTable;", "topicTable", "Lorg/apache/tuweni/devp2p/v5/topic/TopicTable;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/vertx/core/Vertx;Ljava/net/InetSocketAddress;Ljava/util/List;Lorg/apache/tuweni/devp2p/v5/ENRStorage;Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;Lorg/apache/tuweni/devp2p/EthereumNodeRecord;Lorg/apache/tuweni/devp2p/v5/RoutingTable;Lorg/apache/tuweni/devp2p/v5/topic/TopicTable;Lkotlin/coroutines/CoroutineContext;)V", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "handshakes", "Lorg/apache/tuweni/concurrent/ExpiringMap;", "Lio/vertx/core/net/SocketAddress;", "Lorg/apache/tuweni/devp2p/v5/HandshakeSession;", "nodeId", "Lorg/apache/tuweni/bytes/Bytes32;", "receiveJob", "Lkotlinx/coroutines/Job;", "server", "Lio/vertx/core/datagram/DatagramSocket;", "kotlin.jvm.PlatformType", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/apache/tuweni/devp2p/v5/Session;", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "whoAreYouHeader", "addPeer", "Lorg/apache/tuweni/concurrent/AsyncCompletion;", "enr", "address", "(Lorg/apache/tuweni/devp2p/EthereumNodeRecord;Lio/vertx/core/net/SocketAddress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "bootstrap", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createHandshake", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "receivedEnr", "createSession", "newSession", "sessionKey", "Lorg/apache/tuweni/devp2p/v5/encrypt/SessionKey;", "receiveDatagram", "", "packet", "Lio/vertx/core/datagram/DatagramPacket;", "requestNodes", "Lorg/apache/tuweni/concurrent/AsyncResult;", "", "distance", "", "maxSecondsToWait", "", "(IJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "send", "addr", "message", "Lorg/apache/tuweni/bytes/Bytes;", "start", "terminate", "Companion", "devp2p"})
public final class DefaultDiscoveryV5Service
implements DiscoveryV5Service {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vertx vertx;
    @NotNull
    private final InetSocketAddress bindAddress;
    @NotNull
    private final List<String> bootstrapENRList;
    @NotNull
    private final ENRStorage enrStorage;
    @NotNull
    private final SECP256K1.KeyPair keyPair;
    @NotNull
    private final EthereumNodeRecord selfEnr;
    @NotNull
    private final RoutingTable routingTable;
    @NotNull
    private final TopicTable topicTable;
    @NotNull
    private final CoroutineContext coroutineContext;
    private final DatagramSocket server;
    @NotNull
    private final ExpiringMap<SocketAddress, HandshakeSession> handshakes;
    @NotNull
    private final ConcurrentHashMap<SocketAddress, Session> sessions;
    @NotNull
    private final AtomicBoolean started;
    @NotNull
    private final Bytes32 nodeId;
    private final Bytes32 whoAreYouHeader;
    private Job receiveJob;
    private static final Logger logger = LoggerFactory.getLogger(DefaultDiscoveryV5Service.class);

    public DefaultDiscoveryV5Service(@NotNull Vertx vertx, @NotNull InetSocketAddress bindAddress, @NotNull List<String> bootstrapENRList, @NotNull ENRStorage enrStorage, @NotNull SECP256K1.KeyPair keyPair, @NotNull EthereumNodeRecord selfEnr, @NotNull RoutingTable routingTable, @NotNull TopicTable topicTable, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)bindAddress, (String)"bindAddress");
        Intrinsics.checkNotNullParameter(bootstrapENRList, (String)"bootstrapENRList");
        Intrinsics.checkNotNullParameter((Object)enrStorage, (String)"enrStorage");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)selfEnr, (String)"selfEnr");
        Intrinsics.checkNotNullParameter((Object)routingTable, (String)"routingTable");
        Intrinsics.checkNotNullParameter((Object)topicTable, (String)"topicTable");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.vertx = vertx;
        this.bindAddress = bindAddress;
        this.bootstrapENRList = bootstrapENRList;
        this.enrStorage = enrStorage;
        this.keyPair = keyPair;
        this.selfEnr = selfEnr;
        this.routingTable = routingTable;
        this.topicTable = topicTable;
        this.coroutineContext = coroutineContext;
        this.server = this.vertx.createDatagramSocket();
        this.handshakes = new ExpiringMap();
        this.sessions = new ConcurrentHashMap();
        this.started = new AtomicBoolean(false);
        Bytes[] bytesArray = this.keyPair.publicKey();
        Intrinsics.checkNotNullExpressionValue((Object)bytesArray, (String)"keyPair.publicKey()");
        this.nodeId = EthereumNodeRecord.Companion.nodeId((SECP256K1.PublicKey)bytesArray);
        bytesArray = new Bytes[2];
        bytesArray[0] = (Bytes)this.nodeId;
        String string = "WHOAREYOU";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        bytesArray[1] = Bytes.wrap((byte[])byArray);
        this.whoAreYouHeader = Hash.sha2_256((Bytes)Bytes.concatenate((Bytes[])bytesArray));
    }

    public /* synthetic */ DefaultDiscoveryV5Service(Vertx vertx, InetSocketAddress inetSocketAddress, List list, ENRStorage eNRStorage, SECP256K1.KeyPair keyPair, EthereumNodeRecord ethereumNodeRecord, RoutingTable routingTable, TopicTable topicTable, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            routingTable = new RoutingTable(ethereumNodeRecord);
        }
        if ((n & 0x80) != 0) {
            topicTable = new TopicTable(0, 0, 3, null);
        }
        if ((n & 0x100) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(vertx, inetSocketAddress, list, eNRStorage, keyPair, ethereumNodeRecord, routingTable, topicTable, coroutineContext);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object start(@NotNull Continuation<? super AsyncCompletion> var1_1) {
        if (!(var1_1 instanceof start.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultDiscoveryV5Service this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.start((Continuation<? super AsyncCompletion>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = this.server.handler((Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, receiveDatagram(io.vertx.core.datagram.DatagramPacket ), (Lio/vertx/core/datagram/DatagramPacket;)V)((DefaultDiscoveryV5Service)this)).listen(this.bindAddress.getPort(), this.bindAddress.getHostString());
                Intrinsics.checkNotNullExpressionValue((Object)var2_5, (String)"server.handler(this::rec\u2026, bindAddress.hostString)");
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = VertxCoroutineKt.await((Future)var2_5, (Continuation)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl24
            }
            case 1: {
                this = (DefaultDiscoveryV5Service)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = this.bootstrap((Continuation<? super AsyncCompletion>)$continuation);
                if (v1 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl33
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object terminate(@NotNull Continuation<? super Unit> $completion) {
        if (this.started.compareAndSet(true, false)) {
            Job job = this.receiveJob;
            if (job == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"receiveJob");
                job = null;
            }
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            Future future = this.server.close();
            Intrinsics.checkNotNullExpressionValue((Object)future, (String)"server.close()");
            Object object = VertxCoroutineKt.await((Future)future, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public EthereumNodeRecord enr() {
        return this.selfEnr;
    }

    @Override
    @Nullable
    public Object addPeer(@NotNull EthereumNodeRecord enr, @NotNull SocketAddress address, @NotNull Continuation<? super AsyncCompletion> $completion) {
        Session session2 = this.sessions.get(address);
        if (session2 == null) {
            logger.trace("Creating new session for peer {}", (Object)enr);
            HandshakeSession handshakeSession = (HandshakeSession)this.handshakes.computeIfAbsent((Object)address, arg_0 -> DefaultDiscoveryV5Service.addPeer$lambda-0(this, enr, arg_0));
            return AsyncCompletionKt.asyncCompletion$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(enr, handshakeSession, null){
                int label;
                final /* synthetic */ EthereumNodeRecord $enr;
                final /* synthetic */ HandshakeSession $handshakeSession;
                {
                    this.$enr = $enr;
                    this.$handshakeSession = $handshakeSession;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            DefaultDiscoveryV5Service.access$getLogger$cp().trace("Handshake connection start {}", (Object)this.$enr);
                            this.label = 1;
                            v0 = this.$handshakeSession.connect((Continuation<? super AsyncResult<SessionKey>>)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            this.label = 2;
                            v1 = AsyncResultKt.await((AsyncResult)((AsyncResult)v0), (Continuation)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl22
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl22:
                            // 2 sources

                            DefaultDiscoveryV5Service.access$getLogger$cp().trace("Handshake connection done {}", (Object)this.$enr);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        logger.trace("Session found for peer {}", (Object)enr);
        AsyncCompletion asyncCompletion = AsyncCompletion.completed();
        Intrinsics.checkNotNullExpressionValue((Object)asyncCompletion, (String)"completed()");
        return asyncCompletion;
    }

    private final void send(SocketAddress addr, Bytes message) {
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, message, addr, null){
            int label;
            final /* synthetic */ DefaultDiscoveryV5Service this$0;
            final /* synthetic */ Bytes $message;
            final /* synthetic */ SocketAddress $addr;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                this.$addr = $addr;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Future future = DefaultDiscoveryV5Service.access$getServer$p(this.this$0).send(Buffer.buffer((byte[])this.$message.toArrayUnsafe()), this.$addr.port(), this.$addr.host());
                        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"server.send(Buffer.buffe\u2026addr.port(), addr.host())");
                        this.label = 1;
                        Object object3 = VertxCoroutineKt.await((Future)future, (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object bootstrap(Continuation<? super AsyncCompletion> var1_1) {
        if (!(var1_1 instanceof bootstrap.1)) ** GOTO lbl-1000
        var16_2 = var1_1;
        if ((var16_2.label & -2147483648) != 0) {
            var16_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultDiscoveryV5Service this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultDiscoveryV5Service.access$bootstrap(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var17_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$map$iv = this.bootstrapENRList;
                $i$f$map = false;
                var5_7 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var8_10 = $this$mapTo$iv$iv.iterator();
lbl18:
                // 2 sources

                while (var8_10.hasNext()) {
                    item$iv$iv = var8_10.next();
                    var10_12 = (String)item$iv$iv;
                    var14_16 = destination$iv$iv;
                    $i$a$-map-DefaultDiscoveryV5Service$bootstrap$2 = false;
                    DefaultDiscoveryV5Service.logger.trace("Connecting to bootstrap peer {}", (Object)it);
                    encodedEnr = it;
                    if (StringsKt.startsWith$default((String)it, (String)"enr:", (boolean)false, (int)2, null)) {
                        encodedEnr = StringsKt.substringAfter$default((String)it, (String)"enr:", null, (int)2, null);
                    }
                    rlpENR = Base64URLSafe.decode((String)encodedEnr);
                    Intrinsics.checkNotNullExpressionValue((Object)rlpENR, (String)"rlpENR");
                    $continuation.L$0 = this;
                    $continuation.L$1 = destination$iv$iv;
                    $continuation.L$2 = var8_10;
                    $continuation.L$3 = var14_16;
                    $continuation.label = 1;
                    v0 = this.addPeer(rlpENR, (Continuation<? super AsyncCompletion>)$continuation);
                    if (v0 == var17_4) {
                        return var17_4;
                    }
                    ** GOTO lbl49
                }
                break;
            }
            case 1: {
                $i$f$map = false;
                $i$f$mapTo = false;
                $i$a$-map-DefaultDiscoveryV5Service$bootstrap$2 = false;
                var14_16 = (Collection)$continuation.L$3;
                var8_10 = (Iterator<T>)$continuation.L$2;
                destination$iv$iv = (Collection)$continuation.L$1;
                this = (DefaultDiscoveryV5Service)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl49:
                // 2 sources

                var14_16.add((AsyncCompletion)v0);
                ** GOTO lbl18
            }
        }
        var2_17 = AsyncCompletion.allOf((Collection)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)var2_17, (String)"allOf(\n    bootstrapENRL\u2026addPeer(rlpENR)\n    }\n  )");
        return var2_17;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void receiveDatagram(DatagramPacket packet) {
        Ref.ObjectRef session2 = new Ref.ObjectRef();
        session2.element = this.sessions.get(packet.sender());
        int size = Math.min(1280, packet.data().length());
        ByteBuffer buffer = ByteBuffer.allocate(size);
        packet.data().getByteBuf().readBytes(buffer);
        buffer.flip();
        Bytes message = Bytes.wrapByteBuffer((ByteBuffer)buffer);
        if (Intrinsics.areEqual((Object)message.slice(0, 32), (Object)this.whoAreYouHeader) && session2.element != null) {
            this.sessions.remove(packet.sender());
            session2.element = null;
        }
        if (session2.element == null) {
            HandshakeSession handshakeSession = (HandshakeSession)this.handshakes.computeIfAbsent((Object)packet.sender(), arg_0 -> DefaultDiscoveryV5Service.receiveDatagram$lambda-2(this, arg_0));
            BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(handshakeSession, message, null){
                int label;
                final /* synthetic */ HandshakeSession $handshakeSession;
                final /* synthetic */ Bytes $message;
                {
                    this.$handshakeSession = $handshakeSession;
                    this.$message = $message;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Bytes bytes = this.$message;
                            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"message");
                            this.label = 1;
                            Object object3 = this.$handshakeSession.processMessage(bytes, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<Session>)session2, message, null){
                int label;
                final /* synthetic */ Ref.ObjectRef<Session> $session;
                final /* synthetic */ Bytes $message;
                {
                    this.$session = $session;
                    this.$message = $message;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Session session2 = (Session)this.$session.element;
                            Bytes bytes = this.$message;
                            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"message");
                            this.label = 1;
                            Object object3 = session2.processMessage(bytes, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final HandshakeSession createHandshake(SocketAddress address, SECP256K1.PublicKey publicKey, EthereumNodeRecord receivedEnr) {
        logger.trace("Creating new handshake with {}", (Object)address);
        HandshakeSession newSession2 = new HandshakeSession(this.keyPair, address, publicKey, (Function2<? super SocketAddress, ? super Bytes, Unit>)((Function2)new Function2<SocketAddress, Bytes, Unit>((Object)this){

            public final void invoke(@NotNull SocketAddress p0, @NotNull Bytes p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                DefaultDiscoveryV5Service.access$send((DefaultDiscoveryV5Service)this.receiver, p0, p1);
            }
        }), (Function0<EthereumNodeRecord>)((Function0)new Function0<EthereumNodeRecord>((Object)this){

            @NotNull
            public final EthereumNodeRecord invoke() {
                return ((DefaultDiscoveryV5Service)this.receiver).enr();
            }
        }), this.getCoroutineContext());
        newSession2.awaitConnection().thenAccept(arg_0 -> DefaultDiscoveryV5Service.createHandshake$lambda-4(receivedEnr, newSession2, this, address, arg_0)).exceptionally(DefaultDiscoveryV5Service::createHandshake$lambda-5);
        return newSession2;
    }

    static /* synthetic */ HandshakeSession createHandshake$default(DefaultDiscoveryV5Service defaultDiscoveryV5Service, SocketAddress socketAddress, SECP256K1.PublicKey publicKey, EthereumNodeRecord ethereumNodeRecord, int n, Object object) {
        if ((n & 2) != 0) {
            publicKey = null;
        }
        if ((n & 4) != 0) {
            ethereumNodeRecord = null;
        }
        return defaultDiscoveryV5Service.createHandshake(socketAddress, publicKey, ethereumNodeRecord);
    }

    private final Session createSession(HandshakeSession newSession2, SocketAddress address, SessionKey sessionKey, EthereumNodeRecord receivedEnr) {
        Session session2 = new Session(receivedEnr, this.keyPair, newSession2.getNodeId(), newSession2.tag(), sessionKey, address, (Function2<? super SocketAddress, ? super Bytes, Unit>)((Function2)new Function2<SocketAddress, Bytes, Unit>((Object)this){

            public final void invoke(@NotNull SocketAddress p0, @NotNull Bytes p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                DefaultDiscoveryV5Service.access$send((DefaultDiscoveryV5Service)this.receiver, p0, p1);
            }
        }), (Function0<EthereumNodeRecord>)((Function0)new Function0<EthereumNodeRecord>((Object)this){

            @NotNull
            public final EthereumNodeRecord invoke() {
                return ((DefaultDiscoveryV5Service)this.receiver).enr();
            }
        }), this.routingTable, this.topicTable, (Function1<? super Integer, Boolean>)((Function1)createSession.session.3.INSTANCE), this.getCoroutineContext());
        logger.trace("Adding ENR discovered by connecting to peer");
        this.enrStorage.set(receivedEnr);
        ((Map)this.sessions).put(address, session2);
        return session2;
    }

    @Override
    @Nullable
    public Object requestNodes(int distance, long maxSecondsToWait, @NotNull Continuation<? super AsyncResult<Map<EthereumNodeRecord, List<EthereumNodeRecord>>>> $completion) {
        return AsyncResultKt.asyncResult$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<EthereumNodeRecord, ? extends List<? extends EthereumNodeRecord>>>, Object>(this, distance, maxSecondsToWait, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DefaultDiscoveryV5Service this$0;
            final /* synthetic */ int $distance;
            final /* synthetic */ long $maxSecondsToWait;
            {
                this.this$0 = $receiver;
                this.$distance = $distance;
                this.$maxSecondsToWait = $maxSecondsToWait;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$asyncResult = (CoroutineScope)this.L$0;
                        ConcurrentHashMap<EthereumNodeRecord, List<EthereumNodeRecord>> results = new ConcurrentHashMap<EthereumNodeRecord, List<EthereumNodeRecord>>();
                        DefaultDiscoveryV5Service.access$getLogger$cp().debug("Requesting from " + DefaultDiscoveryV5Service.access$getSessions$p(this.this$0).size() + " sessions with distance " + this.$distance);
                        Collection<V> collection = DefaultDiscoveryV5Service.access$getSessions$p(this.this$0).values();
                        Intrinsics.checkNotNullExpressionValue(collection, (String)"sessions.values");
                        Iterable iterable = collection;
                        int n = this.$distance;
                        long l = this.$maxSecondsToWait;
                        boolean $i$f$map = false;
                        Iterable iterable2 = iterable;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void session2;
                            Session session3 = (Session)item$iv$iv;
                            Collection collection2 = destination$iv$iv;
                            boolean bl = false;
                            collection2.add(BuildersKt.async$default((CoroutineScope)$this$asyncResult, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>((Session)session2, n, l, results, null){
                                int label;
                                final /* synthetic */ Session $session;
                                final /* synthetic */ int $distance;
                                final /* synthetic */ long $maxSecondsToWait;
                                final /* synthetic */ ConcurrentHashMap<EthereumNodeRecord, List<EthereumNodeRecord>> $results;
                                {
                                    this.$session = $session;
                                    this.$distance = $distance;
                                    this.$maxSecondsToWait = $maxSecondsToWait;
                                    this.$results = $results;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 * Could not resolve type clashes
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            this.label = 1;
                                            v0 = this.$session.sendFindNodes(this.$distance, (Continuation<? super AsyncResult<List<EthereumNodeRecord>>>)((Continuation)this));
                                            ** if (v0 != var4_2) goto lbl11
lbl10:
                                            // 1 sources

                                            return var4_2;
lbl11:
                                            // 1 sources

                                            ** GOTO lbl17
                                        }
                                        case 1: {
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl17:
                                                // 2 sources

                                                oneResult = (List)((AsyncResult)v0).get(this.$maxSecondsToWait, TimeUnit.SECONDS);
                                                v1 = DefaultDiscoveryV5Service.access$getLogger$cp();
                                                v2 = oneResult;
                                                Intrinsics.checkNotNull((Object)v2);
                                                v1.debug("Received " + v2.size() + " results");
                                                var2_3 /* !! */  = this.$results.put(this.$session.getEnr(), oneResult);
                                            }
                                            catch (Exception var3_4) {
                                                DefaultDiscoveryV5Service.access$getLogger$cp().debug("Timeout waiting for nodes");
                                                var2_3 /* !! */  = Unit.INSTANCE;
                                            }
                                            return var2_3 /* !! */ ;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<Object> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null));
                        }
                        this.L$0 = results;
                        this.label = 1;
                        Object object3 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                        if (object3 != object2) return results;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ConcurrentHashMap<EthereumNodeRecord, List<EthereumNodeRecord>> results = (ConcurrentHashMap<EthereumNodeRecord, List<EthereumNodeRecord>>)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return results;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Map<EthereumNodeRecord, ? extends List<EthereumNodeRecord>>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @Nullable
    public Object addPeer(@NotNull Bytes rlpENR, @NotNull Continuation<? super AsyncCompletion> $completion) {
        return DiscoveryV5Service.DefaultImpls.addPeer(this, rlpENR, $completion);
    }

    @Override
    @NotNull
    public AsyncCompletion startAsync() {
        return DiscoveryV5Service.DefaultImpls.startAsync(this);
    }

    @Override
    @NotNull
    public AsyncCompletion terminateAsync() {
        return DiscoveryV5Service.DefaultImpls.terminateAsync(this);
    }

    private static final HandshakeSession addPeer$lambda-0(DefaultDiscoveryV5Service this$0, EthereumNodeRecord $enr, SocketAddress addr) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$enr, (String)"$enr");
        Intrinsics.checkNotNullExpressionValue((Object)addr, (String)"addr");
        return this$0.createHandshake(addr, $enr.publicKey(), $enr);
    }

    private static final HandshakeSession receiveDatagram$lambda-2(DefaultDiscoveryV5Service this$0, SocketAddress it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return DefaultDiscoveryV5Service.createHandshake$default(this$0, it, null, null, 6, null);
    }

    private static final void createHandshake$lambda-4(EthereumNodeRecord $receivedEnr, HandshakeSession $newSession, DefaultDiscoveryV5Service this$0, SocketAddress $address, SessionKey it) {
        Intrinsics.checkNotNullParameter((Object)$newSession, (String)"$newSession");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
        EthereumNodeRecord ethereumNodeRecord = $receivedEnr;
        if (ethereumNodeRecord == null) {
            EthereumNodeRecord ethereumNodeRecord2 = $newSession.getReceivedEnr();
            ethereumNodeRecord = ethereumNodeRecord2;
            Intrinsics.checkNotNull((Object)ethereumNodeRecord2);
        }
        EthereumNodeRecord peerEnr = ethereumNodeRecord;
        logger.trace("Handshake connection done {}", (Object)peerEnr);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Session session2 = this$0.createSession($newSession, $address, it, peerEnr);
        Bytes bytes = $newSession.getRequestId();
        if (bytes != null) {
            Bytes requestId = bytes;
            boolean bl = false;
            Map map = session2.getActiveFindNodes();
            CompletableAsyncResult completableAsyncResult = AsyncResult.incomplete();
            Intrinsics.checkNotNullExpressionValue((Object)completableAsyncResult, (String)"incomplete()");
            map.put(requestId, completableAsyncResult);
        }
    }

    private static final void createHandshake$lambda-5(Throwable it) {
        logger.error("Error during connection", it);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ DatagramSocket access$getServer$p(DefaultDiscoveryV5Service $this) {
        return $this.server;
    }

    public static final /* synthetic */ Object access$bootstrap(DefaultDiscoveryV5Service $this, Continuation $completion) {
        return $this.bootstrap((Continuation<? super AsyncCompletion>)$completion);
    }

    public static final /* synthetic */ void access$send(DefaultDiscoveryV5Service $this, SocketAddress addr, Bytes message) {
        $this.send(addr, message);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getSessions$p(DefaultDiscoveryV5Service $this) {
        return $this.sessions;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apache/tuweni/devp2p/v5/DefaultDiscoveryV5Service$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

