/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.DecodingException;
import org.apache.tuweni.devp2p.Node;
import org.apache.tuweni.devp2p.Packet;
import org.apache.tuweni.devp2p.PacketKt;
import org.apache.tuweni.devp2p.PacketType;
import org.apache.tuweni.devp2p.SigHash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPException;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/apache/tuweni/devp2p/NeighborsPacket;", "Lorg/apache/tuweni/devp2p/Packet;", "nodeId", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "nodes", "", "Lorg/apache/tuweni/devp2p/Node;", "expiration", "", "(Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lorg/apache/tuweni/crypto/SECP256K1$Signature;Lorg/apache/tuweni/bytes/Bytes32;Ljava/util/List;J)V", "getNodes", "()Ljava/util/List;", "encode", "Lorg/apache/tuweni/bytes/Bytes;", "Companion", "devp2p"})
public final class NeighborsPacket
extends Packet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Node> nodes;
    public static final int RLP_MIN_SIZE = 109;

    private NeighborsPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, List<Node> nodes, long expiration) {
        super(nodeId, signature, hash, expiration, null);
        this.nodes = nodes;
    }

    @NotNull
    public final List<Node> getNodes() {
        return this.nodes;
    }

    @Override
    @NotNull
    public Bytes encode() {
        return this.encodeTo(PacketType.NEIGHBORS, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(this){
            final /* synthetic */ NeighborsPacket this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RLPWriter writer) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                org.apache.tuweni.devp2p.NeighborsPacket$Companion.access$encodeTo(NeighborsPacket.Companion, writer, this.this$0.getNodes(), this.this$0.getExpiration());
            }
        }));
    }

    public /* synthetic */ NeighborsPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, List nodes, long expiration, DefaultConstructorMarker $constructor_marker) {
        this(nodeId, signature, hash, nodes, expiration);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ&\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001c\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/apache/tuweni/devp2p/NeighborsPacket$Companion;", "", "()V", "RLP_MIN_SIZE", "", "create", "Lorg/apache/tuweni/devp2p/NeighborsPacket;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "now", "", "nodes", "", "Lorg/apache/tuweni/devp2p/Node;", "createRequired", "decode", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "encodeTo", "", "writer", "Lorg/apache/tuweni/rlp/RLPWriter;", "expiration", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NeighborsPacket create(@NotNull SECP256K1.KeyPair keyPair, long now, @NotNull List<Node> nodes) {
            Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            long expiration = Packet.expirationFor(now);
            SigHash sigHash2 = Packet.createSignature(PacketType.NEIGHBORS, keyPair, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(nodes, expiration){
                final /* synthetic */ List<Node> $nodes;
                final /* synthetic */ long $expiration;
                {
                    this.$nodes = $nodes;
                    this.$expiration = $expiration;
                    super(1);
                }

                public final void invoke(@NotNull RLPWriter writer) {
                    Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                    org.apache.tuweni.devp2p.NeighborsPacket$Companion.access$encodeTo(NeighborsPacket.Companion, writer, this.$nodes, this.$expiration);
                }
            }));
            SECP256K1.PublicKey publicKey = keyPair.publicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyPair.publicKey()");
            return new NeighborsPacket(publicKey, sigHash2.getSignature(), sigHash2.getHash(), nodes, expiration, null);
        }

        @NotNull
        public final List<NeighborsPacket> createRequired(@NotNull SECP256K1.KeyPair keyPair, long now, @NotNull List<Node> nodes) {
            Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            List result2 = new ArrayList();
            List nodeSubset = new ArrayList();
            int size = 109;
            for (Node node : nodes) {
                int nodeSize = node.rlpSize$devp2p();
                if ((size += nodeSize) > 1280) {
                    result2.add(this.create(keyPair, now, nodeSubset));
                    nodeSubset = new ArrayList();
                    size = 109 + nodeSize;
                }
                nodeSubset.add(node);
            }
            result2.add(this.create(keyPair, now, nodeSubset));
            return result2;
        }

        @NotNull
        public final NeighborsPacket decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            try {
                Object object = RLP.decodeList((Bytes)payload, arg_0 -> Companion.decode$lambda-2(publicKey, signature, hash, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decodeList(payload) { re\u2026ec(expiration))\n        }");
                return (NeighborsPacket)object;
            }
            catch (RLPException e) {
                throw new DecodingException("Invalid nodes packet", e);
            }
        }

        private final void encodeTo(RLPWriter writer, List<Node> nodes, long expiration) {
            writer.writeList(arg_0 -> Companion.encodeTo$lambda-5(nodes, arg_0));
            writer.writeLong(PacketKt.access$msecToSec(expiration));
        }

        private static final Node decode$lambda-2$lambda-1$lambda-0(RLPReader nr) {
            Intrinsics.checkNotNullExpressionValue((Object)nr, (String)"nr");
            return Node.Companion.readFrom(nr);
        }

        private static final Unit decode$lambda-2$lambda-1(List $nodes, RLPReader r) {
            Intrinsics.checkNotNullParameter((Object)$nodes, (String)"$nodes");
            while (!r.isComplete()) {
                Node node = (Node)r.readList(Companion::decode$lambda-2$lambda-1$lambda-0);
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
                $nodes.add(node);
            }
            return Unit.INSTANCE;
        }

        private static final NeighborsPacket decode$lambda-2(SECP256K1.PublicKey $publicKey, SECP256K1.Signature $signature, Bytes32 $hash, RLPReader reader) {
            Intrinsics.checkNotNullParameter((Object)$publicKey, (String)"$publicKey");
            Intrinsics.checkNotNullParameter((Object)$signature, (String)"$signature");
            Intrinsics.checkNotNullParameter((Object)$hash, (String)"$hash");
            List nodes = new ArrayList();
            reader.readList(arg_0 -> Companion.decode$lambda-2$lambda-1(nodes, arg_0));
            long expiration = reader.readLong();
            return new NeighborsPacket($publicKey, $signature, $hash, nodes, PacketKt.access$secToMsec(expiration), null);
        }

        private static final void encodeTo$lambda-5$lambda-4$lambda-3(Node $node, RLPWriter nw) {
            Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
            Intrinsics.checkNotNullExpressionValue((Object)nw, (String)"nw");
            $node.writeTo$devp2p(nw);
        }

        private static final void encodeTo$lambda-5(List $nodes, RLPWriter w) {
            Intrinsics.checkNotNullParameter((Object)$nodes, (String)"$nodes");
            Iterable $this$forEach$iv = $nodes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node node = (Node)element$iv;
                boolean bl = false;
                w.writeList(arg_0 -> Companion.encodeTo$lambda-5$lambda-4$lambda-3(node, arg_0));
            }
        }

        public static final /* synthetic */ void access$encodeTo(Companion $this, RLPWriter writer, List nodes, long expiration) {
            $this.encodeTo(writer, nodes, expiration);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

