/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.evmdsl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.evmdsl.Instruction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/apache/tuweni/evmdsl/Dup;", "Lorg/apache/tuweni/evmdsl/Instruction;", "dupIndex", "", "(I)V", "getDupIndex", "()I", "stackItemsConsumed", "stackItemsNeeded", "stackItemsProduced", "toBytes", "Lorg/apache/tuweni/bytes/Bytes;", "toString", "", "evm-dsl"})
public final class Dup
implements Instruction {
    private final int dupIndex;

    public Dup(int dupIndex) {
        this.dupIndex = dupIndex;
    }

    public final int getDupIndex() {
        return this.dupIndex;
    }

    @Override
    @NotNull
    public Bytes toBytes() {
        int[] nArray = new int[]{128 + this.dupIndex - 1};
        Bytes bytes = Bytes.of((int[])nArray);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"of(0x80 + dupIndex - 1)");
        return bytes;
    }

    @NotNull
    public String toString() {
        return "DUP" + this.dupIndex;
    }

    @Override
    public int stackItemsNeeded() {
        return this.dupIndex;
    }

    @Override
    public int stackItemsConsumed() {
        return 0;
    }

    @Override
    public int stackItemsProduced() {
        return this.dupIndex;
    }

    @Override
    public boolean end() {
        return Instruction.DefaultImpls.end(this);
    }
}

