/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.evmdsl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.evmdsl.CodeValidationError;
import org.apache.tuweni.evmdsl.Error;
import org.apache.tuweni.evmdsl.Instruction;
import org.apache.tuweni.evmdsl.InstructionModel;
import org.apache.tuweni.evmdsl.InstructionRegistry;
import org.apache.tuweni.evmdsl.Invalid;
import org.apache.tuweni.evmdsl.Jump;
import org.apache.tuweni.evmdsl.JumpDest;
import org.apache.tuweni.evmdsl.Jumpi;
import org.apache.tuweni.evmdsl.Origin;
import org.apache.tuweni.evmdsl.Pop;
import org.apache.tuweni.evmdsl.Push;
import org.apache.tuweni.evmdsl.Return;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u0004\u0018\u00010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/apache/tuweni/evmdsl/Code;", "", "instructions", "", "Lorg/apache/tuweni/evmdsl/Instruction;", "(Ljava/util/List;)V", "getInstructions", "()Ljava/util/List;", "toBytes", "Lorg/apache/tuweni/bytes/Bytes;", "toString", "", "validate", "Lorg/apache/tuweni/evmdsl/CodeValidationError;", "Companion", "evm-dsl"})
public final class Code {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Instruction> instructions;

    public Code(@NotNull List<? extends Instruction> instructions) {
        Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
        this.instructions = instructions;
    }

    @NotNull
    public final List<Instruction> getInstructions() {
        return this.instructions;
    }

    @Nullable
    public final CodeValidationError validate() {
        int stackSize = 0;
        Set visited = new LinkedHashSet();
        int index = 0;
        Set jumpDests = new LinkedHashSet();
        Map jumpSrcs = new LinkedHashMap();
        while (visited.add(index) && (Instruction)CollectionsKt.getOrNull(this.instructions, (int)index) != null) {
            Instruction currentInstruction;
            if (currentInstruction.stackItemsNeeded() > stackSize) {
                return new CodeValidationError(currentInstruction, index, Error.STACK_UNDERFLOW);
            }
            if ((stackSize += currentInstruction.stackItemsProduced()) > 1024) {
                return new CodeValidationError(currentInstruction, index, Error.STACK_OVERFLOW);
            }
            if (currentInstruction instanceof Invalid) {
                return new CodeValidationError(currentInstruction, index, Error.HIT_INVALID_OPCODE);
            }
            if (Intrinsics.areEqual((Object)currentInstruction, (Object)Jump.INSTANCE) || Intrinsics.areEqual((Object)currentInstruction, (Object)Jumpi.INSTANCE)) {
                jumpSrcs.put(index, stackSize);
            }
            if (Intrinsics.areEqual((Object)currentInstruction, (Object)JumpDest.INSTANCE)) {
                jumpDests.add(index);
            }
            if (currentInstruction.end()) {
                stackSize = 0;
            }
            int n = index;
            index = n + 1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bytes toBytes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.instructions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Instruction instruction = (Instruction)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toBytes());
        }
        Bytes bytes = Bytes.wrap((List)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrap(instructions.map { it.toBytes() })");
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.instructions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Instruction instruction = (Instruction)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/apache/tuweni/evmdsl/Code$Companion;", "", "()V", "generate", "Lorg/apache/tuweni/evmdsl/Code;", "size", "", "read", "codeBytes", "Lorg/apache/tuweni/bytes/Bytes;", "evm-dsl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Code read(@NotNull Bytes codeBytes) {
            InstructionModel model;
            List list;
            Intrinsics.checkNotNullParameter((Object)codeBytes, (String)"codeBytes");
            List $this$read_u24lambda_u2d0 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            for (int index = 0; index < codeBytes.size(); index += model.getAdditionalBytesToRead()) {
                model = InstructionRegistry.INSTANCE.getOpcodes().get(codeBytes.get(index));
                if (model == null) {
                    byte[] byArray = new byte[]{codeBytes.get(index)};
                    throw new IllegalArgumentException("Unknown opcode " + Bytes.of((byte[])byArray) + " at index " + index);
                }
                int n = index;
                index = n + 1;
                $this$read_u24lambda_u2d0.add(model.getCreator().invoke((Object)codeBytes, (Object)index));
            }
            List list2 = CollectionsKt.build((List)list);
            return new Code(list2);
        }

        @NotNull
        public final Code generate(int size) {
            int n = size;
            int n2 = 34;
            int n3 = n / n2;
            if ((n ^ n2) < 0 && n3 * n2 != n) {
                n3 += -1;
            }
            int words32 = n3;
            int remainder = size % 34;
            List list = new ArrayList();
            n3 = 0;
            while (n3 < words32) {
                int i = n3++;
                Bytes32 bytes32 = Bytes32.rightPad((Bytes)Bytes.fromHexString((CharSequence)"0x0b4dc0ff33"));
                Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"rightPad(Bytes.fromHexString(\"0x0b4dc0ff33\"))");
                list.add(new Push((Bytes)bytes32));
                list.add(Pop.INSTANCE);
            }
            if (remainder > 2) {
                Bytes[] bytesArray = new Bytes[]{Bytes.repeat((byte)1, (int)(remainder - 2))};
                Bytes bytes = Bytes.wrap((Bytes[])bytesArray);
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrap(Bytes.repeat(1.toByte(), remainder - 2))");
                list.add(new Push(bytes));
            }
            if (remainder == 2) {
                list.add(Origin.INSTANCE);
            }
            if (remainder > 0) {
                list.add(Return.INSTANCE);
            }
            return new Code(list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

