/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.prometheus.client.Collector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

class LabelNameSanitizer
implements Function<String, String> {
    private final Function<String, String> delegate;
    private final Map<String, String> cache = new ConcurrentHashMap<String, String>();

    public LabelNameSanitizer() {
        this(Collector::sanitizeMetricName);
    }

    LabelNameSanitizer(Function<String, String> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String apply(String labelName) {
        return this.cache.computeIfAbsent(labelName, this.delegate);
    }
}

