/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.eth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.devp2p.eth.BlockchainInformation;
import org.apache.tuweni.devp2p.eth.ForkInfo;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/apache/tuweni/devp2p/eth/SimpleBlockchainInformation;", "Lorg/apache/tuweni/devp2p/eth/BlockchainInformation;", "networkID", "Lorg/apache/tuweni/units/bigints/UInt256;", "totalDifficulty", "bestHash", "Lorg/apache/tuweni/eth/Hash;", "bestNumber", "genesisHash", "possibleForks", "", "", "(Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/eth/Hash;Ljava/util/List;)V", "getBestHash", "()Lorg/apache/tuweni/eth/Hash;", "getBestNumber", "()Lorg/apache/tuweni/units/bigints/UInt256;", "forkIds", "Lorg/apache/tuweni/devp2p/eth/ForkInfo;", "forks", "getGenesisHash", "genesisHashCrc", "Lorg/apache/tuweni/bytes/Bytes;", "getNetworkID", "getTotalDifficulty", "getLastestApplicableFork", "number", "devp2p-eth"})
public final class SimpleBlockchainInformation
implements BlockchainInformation {
    @NotNull
    private final UInt256 networkID;
    @NotNull
    private final UInt256 totalDifficulty;
    @NotNull
    private final Hash bestHash;
    @NotNull
    private final UInt256 bestNumber;
    @NotNull
    private final Hash genesisHash;
    @NotNull
    private final List<ForkInfo> forkIds;
    @NotNull
    private final List<Long> forks;
    @NotNull
    private final Bytes genesisHashCrc;

    /*
     * WARNING - void declaration
     */
    public SimpleBlockchainInformation(@NotNull UInt256 networkID, @NotNull UInt256 totalDifficulty, @NotNull Hash bestHash, @NotNull UInt256 bestNumber, @NotNull Hash genesisHash, @NotNull List<Long> possibleForks) {
        Object $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)networkID, (String)"networkID");
        Intrinsics.checkNotNullParameter((Object)totalDifficulty, (String)"totalDifficulty");
        Intrinsics.checkNotNullParameter((Object)bestHash, (String)"bestHash");
        Intrinsics.checkNotNullParameter((Object)bestNumber, (String)"bestNumber");
        Intrinsics.checkNotNullParameter((Object)genesisHash, (String)"genesisHash");
        Intrinsics.checkNotNullParameter(possibleForks, (String)"possibleForks");
        this.networkID = networkID;
        this.totalDifficulty = totalDifficulty;
        this.bestHash = bestHash;
        this.bestNumber = bestNumber;
        this.genesisHash = genesisHash;
        Iterable iterable = possibleForks;
        SimpleBlockchainInformation simpleBlockchainInformation = this;
        boolean $i$f$filter22 = false;
        void var9_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            long it = ((Number)element$iv$iv).longValue();
            boolean bl = false;
            if (!(it > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        simpleBlockchainInformation.forks = CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)));
        CRC32 crc = new CRC32();
        crc.update(this.genesisHash.toArrayUnsafe());
        Bytes $i$f$filter22 = Bytes.ofUnsignedInt((long)crc.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$filter22, (String)"ofUnsignedInt(crc.value)");
        this.genesisHashCrc = $i$f$filter22;
        $this$filterTo$iv$iv = new Bytes[]{this.genesisHashCrc};
        List forkHashes = CollectionsKt.mutableListOf((Object[])$this$filterTo$iv$iv);
        $this$filterTo$iv$iv = this.forks.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            long f = ((Number)$this$filterTo$iv$iv.next()).longValue();
            byte[] byteRepresentationFork = Bytes.ofUnsignedLong((long)f).toArrayUnsafe();
            crc.update(byteRepresentationFork, 0, byteRepresentationFork.length);
            Bytes bytes = Bytes.ofUnsignedInt((long)crc.getValue());
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"ofUnsignedInt(crc.value)");
            forkHashes.add(bytes);
        }
        List mutableForkIds = new ArrayList();
        int n = 0;
        int n2 = this.forks.size();
        while (n < n2) {
            int i = n++;
            mutableForkIds.add(new ForkInfo(((Number)this.forks.get(i)).longValue(), (Bytes)forkHashes.get(i)));
        }
        if (!((Collection)this.forks).isEmpty()) {
            mutableForkIds.add(new ForkInfo(0L, (Bytes)CollectionsKt.last((List)forkHashes)));
        }
        this.forkIds = CollectionsKt.toList((Iterable)mutableForkIds);
    }

    @NotNull
    public final UInt256 getNetworkID() {
        return this.networkID;
    }

    @NotNull
    public final UInt256 getTotalDifficulty() {
        return this.totalDifficulty;
    }

    @NotNull
    public final Hash getBestHash() {
        return this.bestHash;
    }

    @NotNull
    public final UInt256 getBestNumber() {
        return this.bestNumber;
    }

    @NotNull
    public final Hash getGenesisHash() {
        return this.genesisHash;
    }

    @Override
    @NotNull
    public UInt256 networkID() {
        return this.networkID;
    }

    @Override
    @NotNull
    public UInt256 totalDifficulty() {
        return this.totalDifficulty;
    }

    @Override
    @NotNull
    public Hash bestHash() {
        return this.bestHash;
    }

    @Override
    @NotNull
    public UInt256 bestNumber() {
        return this.bestNumber;
    }

    @Override
    @NotNull
    public Hash genesisHash() {
        return this.genesisHash;
    }

    @Override
    @NotNull
    public List<Long> forks() {
        return this.forks;
    }

    @Override
    @NotNull
    public ForkInfo getLastestApplicableFork(long number) {
        for (ForkInfo fork : this.forkIds) {
            if (number >= fork.getNext()) continue;
            return fork;
        }
        ForkInfo forkInfo = (ForkInfo)CollectionsKt.lastOrNull(this.forkIds);
        if (forkInfo == null) {
            forkInfo = new ForkInfo(0L, this.genesisHashCrc);
        }
        return forkInfo;
    }

    @Override
    @NotNull
    public List<Bytes> getForkHashes() {
        return BlockchainInformation.DefaultImpls.getForkHashes(this);
    }
}

