/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.evm.impl.homestead;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.evm.EVMExecutionStatusCode;
import org.apache.tuweni.evm.EVMMessage;
import org.apache.tuweni.evm.HostContext;
import org.apache.tuweni.evm.impl.GasManager;
import org.apache.tuweni.evm.impl.Memory;
import org.apache.tuweni.evm.impl.Opcode;
import org.apache.tuweni.evm.impl.Result;
import org.apache.tuweni.evm.impl.Stack;
import org.apache.tuweni.evm.impl.homestead.OpCodesKt;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt256Value;
import org.apache.tuweni.units.ethereum.Gas;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010$\n\u0002\u0010\u0005\n\u0002\b,\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010N\u001a\b\u0012\u0004\u0012\u00020P0O2\u0006\u0010Q\u001a\u00020R\u001a\u000e\u0010S\u001a\u00020\u00012\u0006\u0010T\u001a\u00020P\u001a\u000e\u0010U\u001a\u00020\u00012\u0006\u0010V\u001a\u00020P\u001a\u000e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z\u001a\u000e\u0010[\u001a\u00020\u00012\u0006\u0010Y\u001a\u00020P\u001a\u000e\u0010\\\u001a\u00020\u00012\u0006\u0010T\u001a\u00020P\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00010!\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\"\u000e\u0010%\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010&\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010'\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010(\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010)\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010*\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010+\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010,\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010-\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010.\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010/\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00100\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00101\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00102\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00103\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00104\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00105\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00106\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00107\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00108\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00109\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010:\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010;\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010<\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010=\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010>\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010?\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010@\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010A\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010B\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010C\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010D\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010E\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010F\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010G\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010H\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010I\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010J\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010K\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010L\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010M\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"add", "Lorg/apache/tuweni/evm/impl/Opcode;", "addmod", "address", "and", "balance", "blockhash", "byte", "call", "callcode", "calldatacopy", "calldataload", "calldatasize", "caller", "callvalue", "chainid", "codecopy", "codesize", "coinbase", "create", "delegatecall", "difficulty", "div", "eq", "exp", "extcodecopy", "extcodehash", "extcodesize", "gas", "gasLimit", "gasPrice", "gt", "homesteadOpcodes", "", "", "getHomesteadOpcodes", "()Ljava/util/Map;", "invalid", "isZero", "jump", "jumpdest", "jumpi", "lt", "mload", "mod", "msize", "mstore", "mstore8", "mul", "mulmod", "not", "number", "or", "origin", "pc", "pop", "retuRn", "returndatacopy", "returndatasize", "revert", "sar", "sdiv", "selfbalance", "selfdestruct", "sgt", "sha3", "shl", "shr", "signextend", "sload", "slt", "smod", "sstore", "staticcall", "stop", "sub", "timestamp", "xor", "computeValidJumpDestinations", "", "", "code", "Lorg/apache/tuweni/bytes/Bytes;", "dup", "index", "log", "topics", "memoryCost", "Lorg/apache/tuweni/units/ethereum/Gas;", "length", "Lorg/apache/tuweni/units/bigints/UInt256;", "push", "swap", "evm"})
public final class OpCodesKt {
    @NotNull
    private static final Opcode add;
    @NotNull
    private static final Opcode addmod;
    @NotNull
    private static final Opcode not;
    @NotNull
    private static final Opcode eq;
    @NotNull
    private static final Opcode lt;
    @NotNull
    private static final Opcode slt;
    @NotNull
    private static final Opcode gt;
    @NotNull
    private static final Opcode sgt;
    @NotNull
    private static final Opcode isZero;
    @NotNull
    private static final Opcode and;
    @NotNull
    private static final Opcode pop;
    @NotNull
    private static final Opcode or;
    @NotNull
    private static final Opcode xor;
    @NotNull
    private static final Opcode byte;
    @NotNull
    private static final Opcode mul;
    @NotNull
    private static final Opcode mod;
    @NotNull
    private static final Opcode smod;
    @NotNull
    private static final Opcode mulmod;
    @NotNull
    private static final Opcode sub;
    @NotNull
    private static final Opcode exp;
    @NotNull
    private static final Opcode div;
    @NotNull
    private static final Opcode sstore;
    @NotNull
    private static final Opcode sload;
    @NotNull
    private static final Opcode stop;
    @NotNull
    private static final Opcode invalid;
    @NotNull
    private static final Opcode retuRn;
    @NotNull
    private static final Opcode address;
    @NotNull
    private static final Opcode origin;
    @NotNull
    private static final Opcode caller;
    @NotNull
    private static final Opcode callvalue;
    @NotNull
    private static final Opcode balance;
    @NotNull
    private static final Opcode pc;
    @NotNull
    private static final Opcode gasPrice;
    @NotNull
    private static final Opcode gas;
    @NotNull
    private static final Opcode coinbase;
    @NotNull
    private static final Opcode gasLimit;
    @NotNull
    private static final Opcode difficulty;
    @NotNull
    private static final Opcode number;
    @NotNull
    private static final Opcode blockhash;
    @NotNull
    private static final Opcode codesize;
    @NotNull
    private static final Opcode timestamp;
    @NotNull
    private static final Opcode codecopy;
    @NotNull
    private static final Opcode extcodecopy;
    @NotNull
    private static final Opcode returndatasize;
    @NotNull
    private static final Opcode returndatacopy;
    @NotNull
    private static final Opcode mstore;
    @NotNull
    private static final Opcode mstore8;
    @NotNull
    private static final Opcode mload;
    @NotNull
    private static final Opcode extcodesize;
    @NotNull
    private static final Opcode extcodehash;
    @NotNull
    private static final Opcode msize;
    @NotNull
    private static final Opcode calldatasize;
    @NotNull
    private static final Opcode calldatacopy;
    @NotNull
    private static final Opcode calldataload;
    @NotNull
    private static final Opcode sha3;
    @NotNull
    private static final Opcode jump;
    @NotNull
    private static final Opcode jumpi;
    @NotNull
    private static final Opcode jumpdest;
    @NotNull
    private static final Opcode sdiv;
    @NotNull
    private static final Opcode signextend;
    @NotNull
    private static final Opcode selfdestruct;
    @NotNull
    private static final Opcode shl;
    @NotNull
    private static final Opcode shr;
    @NotNull
    private static final Opcode sar;
    @NotNull
    private static final Opcode create;
    @NotNull
    private static final Opcode call;
    @NotNull
    private static final Opcode delegatecall;
    @NotNull
    private static final Opcode callcode;
    @NotNull
    private static final Opcode staticcall;
    @NotNull
    private static final Opcode selfbalance;
    @NotNull
    private static final Opcode chainid;
    @NotNull
    private static final Opcode revert;
    @NotNull
    private static final Map<Byte, Opcode> homesteadOpcodes;

    @NotNull
    public static final Opcode push(int length) {
        return new Opcode(length){
            final /* synthetic */ int $length;
            {
                this.$length = $length;
            }

            @Nullable
            public final Object execute(@NotNull GasManager gasManager, @NotNull HostContext $noName_1, @NotNull Stack stack, @NotNull EVMMessage $noName_3, @NotNull Bytes code, int currentIndex, @NotNull Memory $noName_6, @Nullable Result $noName_7, @NotNull Continuation<? super Result> $completion) {
                gasManager.add(3L);
                int minLength = Math.min(this.$length, code.size() - currentIndex);
                Bytes bytes = code.slice(currentIndex, minLength);
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"code.slice(currentIndex, minLength)");
                stack.push(bytes);
                return new Result(null, Boxing.boxInt((int)(currentIndex + minLength)), null, null, 13, null);
            }
        };
    }

    @NotNull
    public static final Opcode dup(int index) {
        return new Opcode(index){
            final /* synthetic */ int $index;
            {
                this.$index = $index;
            }

            @Nullable
            public final Object execute(@NotNull GasManager gasManager, @NotNull HostContext $noName_1, @NotNull Stack stack, @NotNull EVMMessage $noName_3, @NotNull Bytes $noName_4, int $noName_5, @NotNull Memory $noName_6, @Nullable Result $noName_7, @NotNull Continuation<? super Result> $completion) {
                gasManager.add(3L);
                UInt256 uInt256 = stack.get(this.$index - 1);
                if (uInt256 == null) {
                    return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
                }
                UInt256 value = uInt256;
                stack.push((Bytes)value);
                return new Result(null, null, null, null, 15, null);
            }
        };
    }

    @NotNull
    public static final Opcode swap(int index) {
        return new Opcode(index){
            final /* synthetic */ int $index;
            {
                this.$index = $index;
            }

            @Nullable
            public final Object execute(@NotNull GasManager gasManager, @NotNull HostContext $noName_1, @NotNull Stack stack, @NotNull EVMMessage $noName_3, @NotNull Bytes $noName_4, int $noName_5, @NotNull Memory $noName_6, @Nullable Result $noName_7, @NotNull Continuation<? super Result> $completion) {
                gasManager.add(3L);
                UInt256 uInt256 = stack.get(this.$index);
                if (uInt256 == null) {
                    return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
                }
                UInt256 eltN = uInt256;
                UInt256 uInt2562 = stack.pop();
                if (uInt2562 == null) {
                    return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
                }
                UInt256 elt0 = uInt2562;
                stack.push((Bytes)eltN);
                stack.set(this.$index, elt0);
                return new Result(null, null, null, null, 15, null);
            }
        };
    }

    @NotNull
    public static final Gas memoryCost(@NotNull UInt256 length) {
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        UInt256 base = length.multiply(length).divide(UInt256.valueOf((long)512L));
        Gas gas2 = Gas.valueOf((UInt256)UInt256.valueOf((long)3L).multiply(length).add(base));
        Intrinsics.checkNotNullExpressionValue((Object)gas2, (String)"valueOf(UInt256.valueOf(\u2026ltiply(length).add(base))");
        return gas2;
    }

    @NotNull
    public static final Set<Integer> computeValidJumpDestinations(@NotNull Bytes code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        int index = 0;
        HashSet<Integer> destinations = new HashSet<Integer>();
        while (index < code.size()) {
            int n;
            int currentOpcode = code.get(index);
            if (currentOpcode == 91) {
                destinations.add(index);
            }
            boolean bl = 96 <= (n = currentOpcode) ? n < 128 : false;
            if (bl) {
                index += currentOpcode - 96 + 1;
            }
            n = index;
            index = n + 1;
        }
        return destinations;
    }

    @NotNull
    public static final Opcode log(int topics) {
        return new Opcode(topics){
            final /* synthetic */ int $topics;
            {
                this.$topics = $topics;
            }

            @Nullable
            public final Object execute(@NotNull GasManager gasManager, @NotNull HostContext hostContext, @NotNull Stack stack, @NotNull EVMMessage msg, @NotNull Bytes $noName_4, int $noName_5, @NotNull Memory memory, @Nullable Result $noName_7, @NotNull Continuation<? super Result> $completion) {
                UInt256 location = stack.pop();
                UInt256 length = stack.pop();
                if (location == null || length == null) {
                    return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
                }
                Gas cost = (Gas)((Gas)Gas.valueOf((long)375L).add(Gas.valueOf((long)8L).multiply((UInt256Value)Gas.valueOf((UInt256)length)))).add(Gas.valueOf((long)375L).multiply((UInt256Value)Gas.valueOf((long)this.$topics)));
                UInt256 uInt256 = memory.newSize(location, length).subtract(memory.size());
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"memory.newSize(location,\u2026).subtract(memory.size())");
                UInt256Value uInt256Value = cost.addSafe((UInt256Value)OpCodesKt.memoryCost(uInt256));
                Intrinsics.checkNotNullExpressionValue((Object)uInt256Value, (String)"cost.addSafe(memoryCost(\u2026subtract(memory.size())))");
                gasManager.add((Gas)uInt256Value);
                Address address2 = msg.getDestination();
                Bytes data = Memory.read$default(memory, location, length, false, 4, null);
                List topicList = new ArrayList<E>();
                int n = 0;
                while (n < this.$topics) {
                    int i = n++;
                    UInt256 uInt2562 = stack.pop();
                    if (uInt2562 == null) {
                        return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
                    }
                    topicList.add(uInt2562);
                }
                Bytes bytes = data;
                if (bytes == null) {
                    bytes = Bytes.EMPTY;
                }
                Bytes bytes2 = bytes;
                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"data ?: Bytes.EMPTY");
                hostContext.emitLog(address2, bytes2, CollectionsKt.toList((Iterable)topicList));
                return data == null ? new Result(null, null, null, EVMExecutionStatusCode.INVALID_MEMORY_ACCESS, 7, null) : new Result(null, null, null, null, 15, null);
            }
        };
    }

    @NotNull
    public static final Map<Byte, Opcode> getHomesteadOpcodes() {
        return homesteadOpcodes;
    }

    static {
        int i;
        Map map;
        add = add.1.INSTANCE;
        addmod = addmod.1.INSTANCE;
        not = not.1.INSTANCE;
        eq = eq.1.INSTANCE;
        lt = lt.1.INSTANCE;
        slt = slt.1.INSTANCE;
        gt = gt.1.INSTANCE;
        sgt = sgt.1.INSTANCE;
        isZero = isZero.1.INSTANCE;
        and = and.1.INSTANCE;
        pop = pop.1.INSTANCE;
        or = or.1.INSTANCE;
        xor = xor.1.INSTANCE;
        byte = byte.1.INSTANCE;
        mul = mul.1.INSTANCE;
        mod = mod.1.INSTANCE;
        smod = smod.1.INSTANCE;
        mulmod = mulmod.1.INSTANCE;
        sub = sub.1.INSTANCE;
        exp = exp.1.INSTANCE;
        div = div.1.INSTANCE;
        sstore = sstore.1.INSTANCE;
        sload = sload.1.INSTANCE;
        stop = stop.1.INSTANCE;
        invalid = invalid.1.INSTANCE;
        retuRn = retuRn.1.INSTANCE;
        address = address.1.INSTANCE;
        origin = origin.1.INSTANCE;
        caller = caller.1.INSTANCE;
        callvalue = callvalue.1.INSTANCE;
        balance = balance.1.INSTANCE;
        pc = pc.1.INSTANCE;
        gasPrice = gasPrice.1.INSTANCE;
        gas = gas.1.INSTANCE;
        coinbase = coinbase.1.INSTANCE;
        gasLimit = gasLimit.1.INSTANCE;
        difficulty = difficulty.1.INSTANCE;
        number = number.1.INSTANCE;
        blockhash = blockhash.1.INSTANCE;
        codesize = codesize.1.INSTANCE;
        timestamp = timestamp.1.INSTANCE;
        codecopy = codecopy.1.INSTANCE;
        extcodecopy = extcodecopy.1.INSTANCE;
        returndatasize = returndatasize.1.INSTANCE;
        returndatacopy = returndatacopy.1.INSTANCE;
        mstore = mstore.1.INSTANCE;
        mstore8 = mstore8.1.INSTANCE;
        mload = mload.1.INSTANCE;
        extcodesize = extcodesize.1.INSTANCE;
        extcodehash = extcodehash.1.INSTANCE;
        msize = msize.1.INSTANCE;
        calldatasize = calldatasize.1.INSTANCE;
        calldatacopy = calldatacopy.1.INSTANCE;
        calldataload = calldataload.1.INSTANCE;
        sha3 = sha3.1.INSTANCE;
        jump = jump.1.INSTANCE;
        jumpi = jumpi.1.INSTANCE;
        jumpdest = jumpdest.1.INSTANCE;
        sdiv = sdiv.1.INSTANCE;
        signextend = signextend.1.INSTANCE;
        selfdestruct = selfdestruct.1.INSTANCE;
        shl = shl.1.INSTANCE;
        shr = shr.1.INSTANCE;
        sar = sar.1.INSTANCE;
        create = create.1.INSTANCE;
        call = call.1.INSTANCE;
        delegatecall = delegatecall.1.INSTANCE;
        callcode = callcode.1.INSTANCE;
        staticcall = staticcall.1.INSTANCE;
        selfbalance = selfbalance.1.INSTANCE;
        chainid = chainid.1.INSTANCE;
        revert = revert.1.INSTANCE;
        Map $this$homesteadOpcodes_u24lambda_u2d0 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)0, stop);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)1, add);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)2, mul);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)3, sub);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)4, div);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)5, sdiv);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)6, mod);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)7, smod);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)8, addmod);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)9, mulmod);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)16, lt);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)17, gt);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)18, slt);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)19, sgt);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)10, exp);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)11, signextend);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)20, eq);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)21, isZero);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)22, and);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)23, or);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)24, xor);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)25, not);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)26, byte);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)27, shl);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)28, shr);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)29, sar);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)32, sha3);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)48, address);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)49, balance);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)50, origin);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)51, caller);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)52, callvalue);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)53, calldataload);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)54, calldatasize);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)55, calldatacopy);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)56, codesize);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)57, codecopy);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)58, gasPrice);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)59, extcodesize);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)60, extcodecopy);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)61, returndatasize);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)62, returndatacopy);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)63, extcodehash);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)64, blockhash);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)65, coinbase);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)66, timestamp);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)67, number);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)68, difficulty);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)69, gasLimit);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)70, chainid);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)71, selfbalance);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)80, pop);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)81, mload);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)82, mstore);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)83, mstore8);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)84, sload);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)85, sstore);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)86, jump);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)87, jumpi);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)88, pc);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)89, msize);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)90, gas);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)91, jumpdest);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)-16, create);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)-15, call);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)-14, callcode);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)-13, retuRn);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)-12, delegatecall);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)-6, staticcall);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)-3, revert);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)-2, invalid);
        $this$homesteadOpcodes_u24lambda_u2d0.put((byte)-1, selfdestruct);
        int n = 1;
        while (n < 33) {
            i = n++;
            $this$homesteadOpcodes_u24lambda_u2d0.put((byte)(96 + i - 1), OpCodesKt.push(i));
        }
        n = 1;
        while (n < 17) {
            i = n++;
            $this$homesteadOpcodes_u24lambda_u2d0.put((byte)(128 + i - 1), OpCodesKt.dup(i));
        }
        n = 1;
        while (n < 17) {
            i = n++;
            $this$homesteadOpcodes_u24lambda_u2d0.put((byte)(144 + i - 1), OpCodesKt.swap(i));
        }
        n = 0;
        while (n < 5) {
            i = n++;
            $this$homesteadOpcodes_u24lambda_u2d0.put((byte)(160 + i), OpCodesKt.log(i));
        }
        homesteadOpcodes = MapsKt.build((Map)map);
    }
}

