/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.evm.impl;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0003J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\fJ\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000fJ\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\fJ\u0006\u0010\b\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/apache/tuweni/evm/impl/Stack;", "", "maxSize", "", "(I)V", "mutableStack", "Lorg/apache/tuweni/bytes/MutableBytes;", "kotlin.jvm.PlatformType", "size", "stackElements", "", "get", "Lorg/apache/tuweni/units/bigints/UInt256;", "i", "getBytes", "Lorg/apache/tuweni/bytes/Bytes;", "overflowed", "", "pop", "popBytes", "push", "value", "set", "", "elt", "evm"})
public final class Stack {
    private final int maxSize;
    private final MutableBytes mutableStack;
    private int size;
    @NotNull
    private final List<Integer> stackElements;

    public Stack(int maxSize) {
        this.maxSize = maxSize;
        this.mutableStack = MutableBytes.create((int)(this.maxSize * 32));
        this.stackElements = new ArrayList();
    }

    public /* synthetic */ Stack(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1025;
        }
        this(n);
    }

    @Nullable
    public final UInt256 get(int i) {
        UInt256 uInt256;
        if (i >= this.size) {
            return null;
        }
        Bytes bytes = this.mutableStack.slice((this.size - i - 1) * 32, ((Number)this.stackElements.get(this.size - i - 1)).intValue());
        if (bytes == null) {
            uInt256 = null;
        } else {
            Bytes it = bytes;
            boolean bl = false;
            uInt256 = UInt256.fromBytes((Bytes)it);
        }
        return uInt256;
    }

    @Nullable
    public final Bytes getBytes(int i) {
        if (i >= this.size) {
            return null;
        }
        return this.mutableStack.slice((this.size - i - 1) * 32, ((Number)this.stackElements.get(this.size - i - 1)).intValue());
    }

    @Nullable
    public final UInt256 pop() {
        UInt256 uInt256;
        if (this.size <= 0) {
            return null;
        }
        int n = this.size;
        this.size = n + -1;
        int elementSize = ((Number)this.stackElements.get(this.stackElements.size() - 1)).intValue();
        this.stackElements.remove(this.stackElements.size() - 1);
        Bytes bytes = this.mutableStack.slice(this.size * 32, elementSize);
        if (bytes == null) {
            uInt256 = null;
        } else {
            Bytes it = bytes;
            boolean bl = false;
            uInt256 = UInt256.fromBytes((Bytes)it);
        }
        return uInt256;
    }

    @Nullable
    public final Bytes popBytes() {
        if (this.size <= 0) {
            return null;
        }
        int n = this.size;
        this.size = n + -1;
        int elementSize = ((Number)this.stackElements.get(this.stackElements.size() - 1)).intValue();
        this.stackElements.remove(this.stackElements.size() - 1);
        return this.mutableStack.slice(this.size * 32, elementSize);
    }

    public final boolean push(@NotNull Bytes value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.size >= this.maxSize) {
            return false;
        }
        this.mutableStack.set(this.size * 32, value);
        int n = this.size;
        this.size = n + 1;
        this.stackElements.add(value.size());
        return true;
    }

    public final int size() {
        return this.size;
    }

    public final boolean overflowed() {
        return this.size >= this.maxSize;
    }

    public final void set(int i, @NotNull UInt256 elt) {
        Intrinsics.checkNotNullParameter((Object)elt, (String)"elt");
        this.stackElements.set(this.size - i - 1, elt.size());
        this.mutableStack.set((this.size - i - 1) * 32, (Bytes)elt);
    }

    public Stack() {
        this(0, 1, null);
    }
}

