@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%"=="" @echo off
@rem ##########################################################################
@rem
@rem  jsonrpc startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%"=="" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and JSONRPC_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if %ERRORLEVEL% equ 0 goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\tuweni-jsonrpc-app-2.3.0.jar;%APP_HOME%\lib\tuweni-jsonrpc-2.3.0.jar;%APP_HOME%\lib\tuweni-app-commons-2.3.0.jar;%APP_HOME%\lib\tuweni-eth-2.3.0.jar;%APP_HOME%\lib\tuweni-net-2.3.0.jar;%APP_HOME%\lib\tuweni-merkle-trie-2.3.0.jar;%APP_HOME%\lib\tuweni-crypto-2.3.0.jar;%APP_HOME%\lib\tuweni-kv-2.3.0.jar;%APP_HOME%\lib\tuweni-units-2.3.0.jar;%APP_HOME%\lib\tuweni-rlp-2.3.0.jar;%APP_HOME%\lib\tuweni-bytes-2.3.0.jar;%APP_HOME%\lib\tuweni-config-2.3.0.jar;%APP_HOME%\lib\tuweni-concurrent-coroutines-2.3.0.jar;%APP_HOME%\lib\tuweni-concurrent-2.3.0.jar;%APP_HOME%\lib\tuweni-metrics-2.3.0.jar;%APP_HOME%\lib\swagger-jaxrs2-jakarta-2.2.1.jar;%APP_HOME%\lib\swagger-integration-jakarta-2.2.1.jar;%APP_HOME%\lib\swagger-core-jakarta-2.2.1.jar;%APP_HOME%\lib\swagger-models-jakarta-2.2.1.jar;%APP_HOME%\lib\jackson-jakarta-rs-json-provider-2.13.3.jar;%APP_HOME%\lib\jackson-module-jakarta-xmlbind-annotations-2.13.3.jar;%APP_HOME%\lib\jackson-datatype-jsr310-2.13.3.jar;%APP_HOME%\lib\jackson-annotations-2.13.3.jar;%APP_HOME%\lib\vertx-lang-kotlin-coroutines-4.1.2.jar;%APP_HOME%\lib\vertx-lang-kotlin-4.1.2.jar;%APP_HOME%\lib\vertx-opentelemetry-4.1.2.jar;%APP_HOME%\lib\vertx-web-4.1.2.jar;%APP_HOME%\lib\vertx-web-client-4.1.2.jar;%APP_HOME%\lib\vertx-web-common-4.1.2.jar;%APP_HOME%\lib\vertx-auth-common-4.1.2.jar;%APP_HOME%\lib\vertx-bridge-common-4.1.2.jar;%APP_HOME%\lib\vertx-core-4.1.2.jar;%APP_HOME%\lib\jackson-jakarta-rs-base-2.13.3.jar;%APP_HOME%\lib\jackson-dataformat-yaml-2.13.3.jar;%APP_HOME%\lib\jackson-core-2.13.3.jar;%APP_HOME%\lib\jackson-databind-2.13.3.jar;%APP_HOME%\lib\HikariCP-4.0.3.jar;%APP_HOME%\lib\dnsjava-3.3.1.jar;%APP_HOME%\lib\flyway-core-7.8.1.jar;%APP_HOME%\lib\swagger-ui-3.50.0.jar;%APP_HOME%\lib\opentelemetry-exporter-otlp-metrics-1.2.0-alpha.jar;%APP_HOME%\lib\opentelemetry-exporter-otlp-1.2.0.jar;%APP_HOME%\lib\opentelemetry-exporter-otlp-trace-1.2.0.jar;%APP_HOME%\lib\opentelemetry-exporter-otlp-common-1.2.0.jar;%APP_HOME%\lib\opentelemetry-sdk-1.2.0.jar;%APP_HOME%\lib\opentelemetry-exporter-prometheus-1.2.0-alpha.jar;%APP_HOME%\lib\opentelemetry-sdk-metrics-1.2.0-alpha.jar;%APP_HOME%\lib\javax.servlet-api-4.0.1.jar;%APP_HOME%\lib\bcprov-jdk15on-1.66.jar;%APP_HOME%\lib\infinispan-cachestore-rocksdb-12.1.3.Final.jar;%APP_HOME%\lib\infinispan-core-12.1.3.Final.jar;%APP_HOME%\lib\kotlinx-coroutines-core-jvm-1.6.0.jar;%APP_HOME%\lib\kotlinx-coroutines-jdk8-1.6.0.jar;%APP_HOME%\lib\jetty-servlet-11.0.11.jar;%APP_HOME%\lib\jetty-security-11.0.11.jar;%APP_HOME%\lib\jetty-server-11.0.11.jar;%APP_HOME%\lib\jetty-servlets-11.0.11.jar;%APP_HOME%\lib\jetty-http-11.0.11.jar;%APP_HOME%\lib\jetty-io-11.0.11.jar;%APP_HOME%\lib\jetty-util-11.0.11.jar;%APP_HOME%\lib\logback-classic-1.2.3.jar;%APP_HOME%\lib\concurrency-limits-core-0.3.6.jar;%APP_HOME%\lib\slf4j-api-1.7.30.jar;%APP_HOME%\lib\tuweni-toml-2.3.0.jar;%APP_HOME%\lib\tuweni-io-2.3.0.jar;%APP_HOME%\lib\kotlin-stdlib-jdk8-1.6.20.jar;%APP_HOME%\lib\kotlin-stdlib-jdk7-1.6.20.jar;%APP_HOME%\lib\kotlin-stdlib-1.6.10.jar;%APP_HOME%\lib\postgresql-42.2.19.jar;%APP_HOME%\lib\jersey-container-servlet-3.0.5.jar;%APP_HOME%\lib\jersey-container-servlet-core-3.0.5.jar;%APP_HOME%\lib\jersey-server-3.0.5.jar;%APP_HOME%\lib\jersey-hk2-3.0.5.jar;%APP_HOME%\lib\jaxb-api-2.3.1.jar;%APP_HOME%\lib\javax.ws.rs-api-2.1.1.jar;%APP_HOME%\lib\framework-1.3.2.jar;%APP_HOME%\lib\framework-internal-1.3.2.jar;%APP_HOME%\lib\grpc-netty-shaded-1.38.0.jar;%APP_HOME%\lib\grpc-core-1.38.0.jar;%APP_HOME%\lib\opentelemetry-proto-1.2.0-alpha.jar;%APP_HOME%\lib\grpc-protobuf-1.36.1.jar;%APP_HOME%\lib\grpc-stub-1.36.1.jar;%APP_HOME%\lib\grpc-protobuf-lite-1.36.1.jar;%APP_HOME%\lib\grpc-api-1.38.0.jar;%APP_HOME%\lib\guava-31.0.1-jre.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\error_prone_annotations-2.15.0.jar;%APP_HOME%\lib\jnr-ffi-2.1.9.jar;%APP_HOME%\lib\opentelemetry-sdk-trace-1.2.0.jar;%APP_HOME%\lib\opentelemetry-api-metrics-1.2.0-alpha.jar;%APP_HOME%\lib\javax.persistence-api-2.2.jar;%APP_HOME%\lib\opentelemetry-sdk-common-1.2.0.jar;%APP_HOME%\lib\opentelemetry-semconv-1.2.0-alpha.jar;%APP_HOME%\lib\opentelemetry-api-1.2.0.jar;%APP_HOME%\lib\simpleclient_httpserver-0.8.1.jar;%APP_HOME%\lib\simpleclient_common-0.8.1.jar;%APP_HOME%\lib\simpleclient-0.8.1.jar;%APP_HOME%\lib\commons-net-3.8.0.jar;%APP_HOME%\lib\classgraph-4.8.138.jar;%APP_HOME%\lib\javassist-3.28.0-GA.jar;%APP_HOME%\lib\swagger-annotations-jakarta-2.2.1.jar;%APP_HOME%\lib\netty-handler-proxy-4.1.65.Final.jar;%APP_HOME%\lib\netty-codec-http2-4.1.65.Final.jar;%APP_HOME%\lib\netty-codec-http-4.1.65.Final.jar;%APP_HOME%\lib\netty-resolver-dns-4.1.65.Final.jar;%APP_HOME%\lib\netty-handler-4.1.65.Final.jar;%APP_HOME%\lib\netty-codec-socks-4.1.65.Final.jar;%APP_HOME%\lib\netty-codec-dns-4.1.65.Final.jar;%APP_HOME%\lib\netty-codec-4.1.65.Final.jar;%APP_HOME%\lib\netty-transport-4.1.65.Final.jar;%APP_HOME%\lib\netty-buffer-4.1.65.Final.jar;%APP_HOME%\lib\netty-resolver-4.1.65.Final.jar;%APP_HOME%\lib\netty-common-4.1.65.Final.jar;%APP_HOME%\lib\infinispan-commons-12.1.3.Final.jar;%APP_HOME%\lib\protostream-types-4.4.1.Final.jar;%APP_HOME%\lib\protostream-4.4.1.Final.jar;%APP_HOME%\lib\jgroups-4.2.12.Final.jar;%APP_HOME%\lib\caffeine-2.8.4.jar;%APP_HOME%\lib\jboss-transaction-api_1.2_spec-1.1.1.Final.jar;%APP_HOME%\lib\jboss-threads-2.3.3.Final.jar;%APP_HOME%\lib\jboss-logging-3.4.1.Final.jar;%APP_HOME%\lib\rocksdbjni-7.3.1.jar;%APP_HOME%\lib\annotations-16.0.3.jar;%APP_HOME%\lib\kotlin-stdlib-common-1.6.10.jar;%APP_HOME%\lib\checker-qual-3.12.0.jar;%APP_HOME%\lib\jetty-jakarta-servlet-api-5.0.2.jar;%APP_HOME%\lib\jersey-client-3.0.5.jar;%APP_HOME%\lib\jersey-common-3.0.5.jar;%APP_HOME%\lib\jakarta.ws.rs-api-3.0.0.jar;%APP_HOME%\lib\jakarta.annotation-api-2.0.0.jar;%APP_HOME%\lib\hk2-locator-3.0.3.jar;%APP_HOME%\lib\hk2-api-3.0.3.jar;%APP_HOME%\lib\hk2-utils-3.0.3.jar;%APP_HOME%\lib\jakarta.inject-api-2.0.1.jar;%APP_HOME%\lib\jakarta.validation-api-3.0.0.jar;%APP_HOME%\lib\javax.activation-api-1.2.0.jar;%APP_HOME%\lib\logback-core-1.2.3.jar;%APP_HOME%\lib\antlr4-4.10.1.jar;%APP_HOME%\lib\antlr4-runtime-4.10.1.jar;%APP_HOME%\lib\commons-codec-1.14.jar;%APP_HOME%\lib\jffi-1.2.17.jar;%APP_HOME%\lib\jffi-1.2.17-native.jar;%APP_HOME%\lib\asm-commons-5.0.3.jar;%APP_HOME%\lib\asm-analysis-5.0.3.jar;%APP_HOME%\lib\asm-util-5.0.3.jar;%APP_HOME%\lib\asm-tree-5.0.3.jar;%APP_HOME%\lib\asm-5.0.3.jar;%APP_HOME%\lib\jnr-a64asm-1.0.0.jar;%APP_HOME%\lib\jnr-x86asm-1.0.2.jar;%APP_HOME%\lib\opentelemetry-context-1.2.0.jar;%APP_HOME%\lib\protobuf-java-3.15.7.jar;%APP_HOME%\lib\rxjava-3.0.4.jar;%APP_HOME%\lib\wildfly-common-1.3.0.Final.jar;%APP_HOME%\lib\osgi-resource-locator-1.0.3.jar;%APP_HOME%\lib\aopalliance-repackaged-3.0.3.jar;%APP_HOME%\lib\ST4-4.3.3.jar;%APP_HOME%\lib\antlr-runtime-3.5.3.jar;%APP_HOME%\lib\org.abego.treelayout.core-1.0.3.jar;%APP_HOME%\lib\javax.json-1.0.4.jar;%APP_HOME%\lib\icu4j-69.1.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\j2objc-annotations-1.3.jar;%APP_HOME%\lib\gson-2.8.6.jar;%APP_HOME%\lib\annotations-4.1.1.4.jar;%APP_HOME%\lib\animal-sniffer-annotations-1.19.jar;%APP_HOME%\lib\perfmark-api-0.23.0.jar;%APP_HOME%\lib\proto-google-common-protos-2.0.1.jar;%APP_HOME%\lib\commons-lang3-3.12.0.jar;%APP_HOME%\lib\jakarta.xml.bind-api-3.0.0.jar;%APP_HOME%\lib\reactive-streams-1.0.3.jar;%APP_HOME%\lib\grpc-context-1.38.0.jar;%APP_HOME%\lib\jakarta.activation-2.0.1.jar;%APP_HOME%\lib\snakeyaml-1.30.jar


@rem Execute jsonrpc
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %JSONRPC_OPTS%  -classpath "%CLASSPATH%" org.apache.tuweni.jsonrpc.app.JSONRPCApp %*

:end
@rem End local scope for the variables with windows NT shell
if %ERRORLEVEL% equ 0 goto mainEnd

:fail
rem Set variable JSONRPC_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
set EXIT_CODE=%ERRORLEVEL%
if %EXIT_CODE% equ 0 set EXIT_CODE=1
if not ""=="%JSONRPC_EXIT_CONSOLE%" exit %EXIT_CODE%
exit /b %EXIT_CODE%

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
