/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.tx.lookup;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import org.infinispan.commons.util.Util;

public final class LookupNames {
    private LookupNames() {
    }

    public static enum TransactionManagerFactory {
        WEBSPHERE_51_6("com.ibm.ws.Transaction.TransactionManagerFactory", "WebSphere 5.1 and 6.0", "getTransactionManager"),
        WEBSPHERE_6("com.ibm.ejs.jts.jta.TransactionManagerFactory", "WebSphere 5.0", "getTransactionManager"),
        WEBSPHERE_4("com.ibm.ejs.jts.jta.JTSXA", "WebSphere 4.0", "getTransactionManager"),
        WILDFLY("org.wildfly.transaction.client.ContextTransactionManager", "Wildfly 11 and later", "getInstance"),
        JBOSS_TM("com.arjuna.ats.jta.TransactionManager", "JBoss Standalone TM", "transactionManager");

        private final String factoryClazz;
        private final String prettyName;
        private final String factoryMethod;

        private TransactionManagerFactory(String factoryClazz, String prettyName, String factoryMethod) {
            this.factoryClazz = factoryClazz;
            this.prettyName = prettyName;
            this.factoryMethod = factoryMethod;
        }

        public String getFactoryClazz() {
            return this.factoryClazz;
        }

        public String getPrettyName() {
            return this.prettyName;
        }

        public TransactionManager tryLookup(ClassLoader classLoader) {
            try {
                Class clazz = Util.loadClassStrict(this.factoryClazz, classLoader);
                Method method = clazz.getMethod(this.factoryMethod, new Class[0]);
                return (TransactionManager)method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
                return null;
            }
        }
    }

    public static enum JndiTransactionManager {
        JBOSS_AS_7("java:jboss/TransactionManager", "JBoss AS 7"),
        JBOSS_AS_4_6("java:/TransactionManager", "JBoss AS 4 ~ 6, JRun4"),
        RESIN_3("java:comp/TransactionManager", "Resin 3.x"),
        GLASSFISH("java:appserver/TransactionManager", "Sun Glassfish"),
        BORLAND_SUN("java:pm/TransactionManager", "Borland, Sun"),
        WEBLOGIC("javax.transaction.TransactionManager", "BEA WebLogic"),
        RESIN_ORION_JONAS("java:comp/UserTransaction", "Resin, Orion, JOnAS (JOTM)");

        private final String jndiLookup;
        private final String prettyName;

        private JndiTransactionManager(String jndiLookup, String prettyName) {
            this.jndiLookup = jndiLookup;
            this.prettyName = prettyName;
        }

        public String getJndiLookup() {
            return this.jndiLookup;
        }

        public String getPrettyName() {
            return this.prettyName;
        }
    }
}

