/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.evm.impl;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\nJ\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nJ\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\nJ&\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0015R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lorg/apache/tuweni/evm/impl/Memory;", "", "()V", "memoryData", "Lorg/apache/tuweni/bytes/MutableBytes;", "getMemoryData", "()Lorg/apache/tuweni/bytes/MutableBytes;", "setMemoryData", "(Lorg/apache/tuweni/bytes/MutableBytes;)V", "wordsSize", "Lorg/apache/tuweni/units/bigints/UInt256;", "kotlin.jvm.PlatformType", "getWordsSize", "()Lorg/apache/tuweni/units/bigints/UInt256;", "setWordsSize", "(Lorg/apache/tuweni/units/bigints/UInt256;)V", "allocatedBytes", "newSize", "memOffset", "length", "read", "Lorg/apache/tuweni/bytes/Bytes;", "from", "updateMemorySize", "", "size", "write", "offset", "sourceOffset", "numBytes", "code", "Companion", "evm"})
public final class Memory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private UInt256 wordsSize = UInt256.ZERO;
    @Nullable
    private MutableBytes memoryData;
    private static final int capacity = 1000000000;
    private static final Logger logger = LoggerFactory.getLogger(Memory.class);

    public final UInt256 getWordsSize() {
        return this.wordsSize;
    }

    public final void setWordsSize(UInt256 uInt256) {
        this.wordsSize = uInt256;
    }

    @Nullable
    public final MutableBytes getMemoryData() {
        return this.memoryData;
    }

    public final void setMemoryData(@Nullable MutableBytes mutableBytes) {
        this.memoryData = mutableBytes;
    }

    public final boolean write(@NotNull UInt256 offset, @NotNull UInt256 sourceOffset, @NotNull UInt256 numBytes, @NotNull Bytes code) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)sourceOffset, (String)"sourceOffset");
        Intrinsics.checkNotNullParameter((Object)numBytes, (String)"numBytes");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        logger.trace("Write to memory at offset " + offset + ", size " + numBytes);
        UInt256 maxDistance = offset.add(numBytes);
        if (!(offset.fitsInt() && numBytes.fitsInt() && maxDistance.fitsInt() && maxDistance.intValue() <= capacity)) {
            logger.warn("Memory write aborted, values too large");
            return false;
        }
        MutableBytes localMemoryData = this.memoryData;
        if (localMemoryData == null) {
            localMemoryData = MutableBytes.wrapByteBuffer((ByteBuffer)ByteBuffer.allocate(maxDistance.intValue()));
        } else if (localMemoryData.size() < maxDistance.intValue()) {
            ByteBuffer buffer = ByteBuffer.allocate(maxDistance.intValue() * 2);
            buffer.put(localMemoryData.toArrayUnsafe());
            localMemoryData = MutableBytes.wrapByteBuffer((ByteBuffer)buffer);
        }
        this.memoryData = localMemoryData;
        if (sourceOffset.fitsInt() && sourceOffset.intValue() < code.size()) {
            int maxCodeLength = code.size() - sourceOffset.intValue();
            int length = maxCodeLength < numBytes.intValue() ? maxCodeLength : numBytes.intValue();
            Bytes toWrite = code.slice(sourceOffset.intValue(), length);
            logger.trace("Writing " + toWrite);
            MutableBytes mutableBytes = this.memoryData;
            Intrinsics.checkNotNull((Object)mutableBytes);
            mutableBytes.set(offset.intValue(), toWrite);
        }
        this.wordsSize = this.newSize(offset, numBytes);
        return true;
    }

    @NotNull
    public final UInt256 allocatedBytes() {
        UInt256 uInt256 = this.wordsSize.multiply(32L);
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"wordsSize.multiply(32)");
        return uInt256;
    }

    @NotNull
    public final UInt256 size() {
        UInt256 uInt256 = this.wordsSize;
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"wordsSize");
        return uInt256;
    }

    @NotNull
    public final UInt256 newSize(@NotNull UInt256 memOffset, @NotNull UInt256 length) {
        UInt256 uInt256;
        Intrinsics.checkNotNullParameter((Object)memOffset, (String)"memOffset");
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        if (length.isZero()) {
            UInt256 uInt2562 = this.wordsSize;
            Intrinsics.checkNotNullExpressionValue((Object)uInt2562, (String)"wordsSize");
            return uInt2562;
        }
        UInt256 candidate = memOffset.add(length);
        if (candidate.compareTo((Bytes)memOffset) < 0 || candidate.compareTo((Bytes)length) < 0) {
            UInt256 uInt2563 = UInt256.MAX_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)uInt2563, (String)"MAX_VALUE");
            return uInt2563;
        }
        UInt256 candidateWords = candidate.divideCeil(32L);
        if (this.wordsSize.compareTo((Bytes)candidateWords) > 0) {
            UInt256 uInt2564 = this.wordsSize;
            Intrinsics.checkNotNullExpressionValue((Object)uInt2564, (String)"wordsSize");
            uInt256 = uInt2564;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)candidateWords, (String)"candidateWords");
            uInt256 = candidateWords;
        }
        return uInt256;
    }

    @Nullable
    public final Bytes read(@NotNull UInt256 from, @NotNull UInt256 length, boolean updateMemorySize) {
        MutableBytes localMemoryData;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        if (length.isZero()) {
            return Bytes.EMPTY;
        }
        UInt256 max = from.add(length);
        if (!(from.fitsInt() && length.fitsInt() && max.fitsInt())) {
            return null;
        }
        if (updateMemorySize) {
            this.wordsSize = this.newSize(from, length);
        }
        if ((localMemoryData = this.memoryData) != null) {
            if (from.intValue() >= localMemoryData.size()) {
                return Bytes.repeat((byte)0, (int)length.intValue());
            }
            if (localMemoryData.size() < max.intValue()) {
                int l = max.intValue() - localMemoryData.size();
                Bytes[] bytesArray = new Bytes[]{localMemoryData.slice(from.intValue(), length.intValue() - l), Bytes.repeat((byte)0, (int)l)};
                return Bytes.concatenate((Bytes[])bytesArray);
            }
            return localMemoryData.slice(from.intValue(), length.intValue());
        }
        return Bytes.repeat((byte)0, (int)length.intValue());
    }

    public static /* synthetic */ Bytes read$default(Memory memory, UInt256 uInt256, UInt256 uInt2562, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return memory.read(uInt256, uInt2562, bl);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/apache/tuweni/evm/impl/Memory$Companion;", "", "()V", "capacity", "", "getCapacity", "()I", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "evm"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCapacity() {
            return capacity;
        }

        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

