/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethclient;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.ethclient.RLPxServiceConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\u0004\u001a\u00020\u0003H\u0016J\t\u0010\u0019\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003JY\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\b\u0010&\u001a\u00020\u0003H\u0016J\t\u0010'\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010\u00a8\u0006)"}, d2={"Lorg/apache/tuweni/ethclient/RLPxServiceConfigurationImpl;", "Lorg/apache/tuweni/ethclient/RLPxServiceConfiguration;", "name", "", "clientName", "port", "", "networkInterface", "advertisedPort", "repository", "peerRepository", "key", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAdvertisedPort", "()I", "getClientName", "()Ljava/lang/String;", "getKey", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "kotlin.jvm.PlatformType", "getNetworkInterface", "getPeerRepository", "getPort", "getRepository", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "", "getName", "hashCode", "toString", "eth-client"})
public final class RLPxServiceConfigurationImpl
implements RLPxServiceConfiguration {
    @NotNull
    private final String name;
    @NotNull
    private final String clientName;
    private final int port;
    @NotNull
    private final String networkInterface;
    private final int advertisedPort;
    @NotNull
    private final String repository;
    @NotNull
    private final String peerRepository;
    @NotNull
    private final String key;
    private final SECP256K1.KeyPair keyPair;

    public RLPxServiceConfigurationImpl(@NotNull String name, @NotNull String clientName, int port, @NotNull String networkInterface, int advertisedPort, @NotNull String repository, @NotNull String peerRepository, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)clientName, (String)"clientName");
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)peerRepository, (String)"peerRepository");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.name = name;
        this.clientName = clientName;
        this.port = port;
        this.networkInterface = networkInterface;
        this.advertisedPort = advertisedPort;
        this.repository = repository;
        this.peerRepository = peerRepository;
        this.key = key;
        this.keyPair = SECP256K1.KeyPair.fromSecretKey((SECP256K1.SecretKey)SECP256K1.SecretKey.fromBytes((Bytes32)Bytes32.fromHexString((CharSequence)this.key)));
    }

    @NotNull
    public final String getClientName() {
        return this.clientName;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getNetworkInterface() {
        return this.networkInterface;
    }

    public final int getAdvertisedPort() {
        return this.advertisedPort;
    }

    @NotNull
    public final String getRepository() {
        return this.repository;
    }

    @NotNull
    public final String getPeerRepository() {
        return this.peerRepository;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    @NotNull
    public String networkInterface() {
        return this.networkInterface;
    }

    @Override
    public int advertisedPort() {
        return this.advertisedPort;
    }

    @Override
    @NotNull
    public SECP256K1.KeyPair keyPair() {
        SECP256K1.KeyPair keyPair = this.keyPair;
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"keyPair");
        return keyPair;
    }

    @Override
    @NotNull
    public String repository() {
        return this.repository;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String clientName() {
        return this.clientName;
    }

    @Override
    @NotNull
    public String peerRepository() {
        return this.peerRepository;
    }

    private final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.clientName;
    }

    public final int component3() {
        return this.port;
    }

    @NotNull
    public final String component4() {
        return this.networkInterface;
    }

    public final int component5() {
        return this.advertisedPort;
    }

    @NotNull
    public final String component6() {
        return this.repository;
    }

    @NotNull
    public final String component7() {
        return this.peerRepository;
    }

    @NotNull
    public final String component8() {
        return this.key;
    }

    @NotNull
    public final RLPxServiceConfigurationImpl copy(@NotNull String name, @NotNull String clientName, int port, @NotNull String networkInterface, int advertisedPort, @NotNull String repository, @NotNull String peerRepository, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)clientName, (String)"clientName");
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)peerRepository, (String)"peerRepository");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new RLPxServiceConfigurationImpl(name, clientName, port, networkInterface, advertisedPort, repository, peerRepository, key);
    }

    public static /* synthetic */ RLPxServiceConfigurationImpl copy$default(RLPxServiceConfigurationImpl rLPxServiceConfigurationImpl, String string, String string2, int n, String string3, int n2, String string4, String string5, String string6, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = rLPxServiceConfigurationImpl.name;
        }
        if ((n3 & 2) != 0) {
            string2 = rLPxServiceConfigurationImpl.clientName;
        }
        if ((n3 & 4) != 0) {
            n = rLPxServiceConfigurationImpl.port;
        }
        if ((n3 & 8) != 0) {
            string3 = rLPxServiceConfigurationImpl.networkInterface;
        }
        if ((n3 & 0x10) != 0) {
            n2 = rLPxServiceConfigurationImpl.advertisedPort;
        }
        if ((n3 & 0x20) != 0) {
            string4 = rLPxServiceConfigurationImpl.repository;
        }
        if ((n3 & 0x40) != 0) {
            string5 = rLPxServiceConfigurationImpl.peerRepository;
        }
        if ((n3 & 0x80) != 0) {
            string6 = rLPxServiceConfigurationImpl.key;
        }
        return rLPxServiceConfigurationImpl.copy(string, string2, n, string3, n2, string4, string5, string6);
    }

    @NotNull
    public String toString() {
        return "RLPxServiceConfigurationImpl(name=" + this.name + ", clientName=" + this.clientName + ", port=" + this.port + ", networkInterface=" + this.networkInterface + ", advertisedPort=" + this.advertisedPort + ", repository=" + this.repository + ", peerRepository=" + this.peerRepository + ", key=" + this.key + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.clientName.hashCode();
        result = result * 31 + Integer.hashCode(this.port);
        result = result * 31 + this.networkInterface.hashCode();
        result = result * 31 + Integer.hashCode(this.advertisedPort);
        result = result * 31 + this.repository.hashCode();
        result = result * 31 + this.peerRepository.hashCode();
        result = result * 31 + this.key.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RLPxServiceConfigurationImpl)) {
            return false;
        }
        RLPxServiceConfigurationImpl rLPxServiceConfigurationImpl = (RLPxServiceConfigurationImpl)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)rLPxServiceConfigurationImpl.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clientName, (Object)rLPxServiceConfigurationImpl.clientName)) {
            return false;
        }
        if (this.port != rLPxServiceConfigurationImpl.port) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.networkInterface, (Object)rLPxServiceConfigurationImpl.networkInterface)) {
            return false;
        }
        if (this.advertisedPort != rLPxServiceConfigurationImpl.advertisedPort) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.repository, (Object)rLPxServiceConfigurationImpl.repository)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.peerRepository, (Object)rLPxServiceConfigurationImpl.peerRepository)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.key, (Object)rLPxServiceConfigurationImpl.key);
    }
}

