/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.faucet;

import io.vertx.core.Vertx;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.wallet.Wallet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.web.reactive.function.client.WebClient;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SpringBootApplication
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0017H\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0017J\b\u0010\u0019\u001a\u00020\u0013H\u0017J\u001c\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u00042\b\b\u0001\u0010\u001d\u001a\u00020\u0004H\u0017J\b\u0010\u001e\u001a\u00020\u001fH\u0017J\u001e\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0018\u00010!2\u0006\u0010$\u001a\u00020\u001fH\u0017R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\u00048\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u00020\r8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lorg/apache/tuweni/faucet/FaucetApplication;", "", "()V", "authorizedOrg", "", "getAuthorizedOrg", "()Ljava/lang/String;", "setAuthorizedOrg", "(Ljava/lang/String;)V", "banner", "getBanner", "setBanner", "disabledOrgMembership", "", "getDisabledOrgMembership", "()Z", "setDisabledOrgMembership", "(Z)V", "vertx", "Lio/vertx/core/Vertx;", "kotlin.jvm.PlatformType", "getVertx", "()Lio/vertx/core/Vertx;", "", "close", "createVertx", "createWallet", "Lorg/apache/tuweni/wallet/Wallet;", "path", "password", "createWebClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "oauth2UserService", "Lorg/springframework/security/oauth2/client/userinfo/OAuth2UserService;", "Lorg/springframework/security/oauth2/client/userinfo/OAuth2UserRequest;", "Lorg/springframework/security/oauth2/core/user/OAuth2User;", "rest", "eth-faucet"})
public class FaucetApplication {
    @Value(value="${banner}")
    @Nullable
    private String banner;
    @Value(value="${auth.disabledOrg}")
    private boolean disabledOrgMembership;
    @Value(value="${auth.org}")
    @Nullable
    private String authorizedOrg;
    private final Vertx vertx = Vertx.vertx();

    @Nullable
    public String getBanner() {
        return this.banner;
    }

    public void setBanner(@Nullable String string) {
        this.banner = string;
    }

    public boolean getDisabledOrgMembership() {
        return this.disabledOrgMembership;
    }

    public void setDisabledOrgMembership(boolean bl) {
        this.disabledOrgMembership = bl;
    }

    @Nullable
    public String getAuthorizedOrg() {
        return this.authorizedOrg;
    }

    public void setAuthorizedOrg(@Nullable String string) {
        this.authorizedOrg = string;
    }

    @Bean(value={"wallet"})
    @NotNull
    public Wallet createWallet(@Value(value="${wallet.path}") @NotNull String path, @Value(value="${wallet.password}") @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Path walletPath = Paths.get(path, new String[0]).toAbsolutePath();
        if (!Files.exists(walletPath, new LinkOption[0])) {
            Intrinsics.checkNotNullExpressionValue((Object)walletPath, (String)"walletPath");
            return Wallet.Companion.create(walletPath, password);
        }
        Intrinsics.checkNotNullExpressionValue((Object)walletPath, (String)"walletPath");
        return Wallet.Companion.open(walletPath, password);
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    @Bean
    @NotNull
    public Vertx createVertx() {
        Vertx vertx = this.getVertx();
        Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
        return vertx;
    }

    @Bean
    @NotNull
    public WebClient createWebClient() {
        WebClient webClient = WebClient.create();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"create()");
        return webClient;
    }

    @Bean
    @Nullable
    public OAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService(@NotNull WebClient rest) {
        Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
        DefaultOAuth2UserService delegate = new DefaultOAuth2UserService();
        return arg_0 -> FaucetApplication.oauth2UserService$lambda-2(delegate, this, rest, arg_0);
    }

    @PostConstruct
    public void banner() {
        String string = this.getBanner();
        if (string != null) {
            String it = string;
            boolean bl = false;
            System.out.println((Object)it);
        }
    }

    @PreDestroy
    public void close() {
        this.getVertx().close();
    }

    private static final boolean oauth2UserService$lambda-2$lambda-1$lambda-0(FaucetApplication this$0, Object org) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = org;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        }
        return Intrinsics.areEqual((Object)this$0.getAuthorizedOrg(), ((Map)object).get("login"));
    }

    private static final OAuth2User oauth2UserService$lambda-2(DefaultOAuth2UserService $delegate, FaucetApplication this$0, WebClient $rest, OAuth2UserRequest request) {
        Intrinsics.checkNotNullParameter((Object)$delegate, (String)"$delegate");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$rest, (String)"$rest");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        OAuth2User user = $delegate.loadUser(request);
        if (!this$0.getDisabledOrgMembership()) {
            String string = this$0.getAuthorizedOrg();
            if (string != null) {
                boolean bl;
                Stream stream;
                boolean found;
                List orgs;
                List list;
                String it = string;
                boolean bl2 = false;
                OAuth2AuthorizedClient client = new OAuth2AuthorizedClient(request.getClientRegistration(), user.getName(), request.getAccessToken());
                String url = (String)user.getAttribute("organizations_url");
                WebClient.RequestHeadersUriSpec requestHeadersUriSpec = $rest.get();
                String string2 = url;
                if (string2 == null) {
                    string2 = "";
                }
                boolean bl3 = (list = (orgs = (List)requestHeadersUriSpec.uri(string2, new Object[0]).attributes(ServerOAuth2AuthorizedClientExchangeFilterFunction.oauth2AuthorizedClient((OAuth2AuthorizedClient)client)).retrieve().bodyToMono(List.class).block())) == null ? false : (found = (stream = list.stream()) == null ? false : (bl = stream.anyMatch(arg_0 -> FaucetApplication.oauth2UserService$lambda-2$lambda-1$lambda-0(this$0, arg_0))));
                if (!found) {
                    throw new OAuth2AuthenticationException(new OAuth2Error("invalid_token", "Not in authorized team", ""));
                }
            }
        }
        return user;
    }
}

