/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.genesis;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.genesis.Allocation;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/apache/tuweni/genesis/AllocationGenerator;", "", "()V", "createAllocations", "", "Lorg/apache/tuweni/genesis/Allocation;", "numberAllocations", "", "amount", "Lorg/apache/tuweni/units/bigints/UInt256;", "genesis"})
public final class AllocationGenerator {
    @NotNull
    public final List<Allocation> createAllocations(int numberAllocations, @NotNull UInt256 amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        List allocs = new ArrayList();
        int n = 0;
        if (n <= numberAllocations) {
            int i;
            do {
                i = n++;
                SECP256K1.KeyPair keyPair = SECP256K1.KeyPair.random();
                Address address = Address.fromPublicKey((SECP256K1.PublicKey)keyPair.publicKey());
                Intrinsics.checkNotNullExpressionValue((Object)address, (String)"fromPublicKey(keyPair.publicKey())");
                Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"keyPair");
                allocs.add(new Allocation(address, amount, keyPair));
            } while (i != numberAllocations);
        }
        return allocs;
    }
}

