/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.DecodingException;
import org.apache.tuweni.devp2p.Packet;
import org.apache.tuweni.devp2p.PacketKt;
import org.apache.tuweni.devp2p.PacketType;
import org.apache.tuweni.devp2p.SigHash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPException;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/apache/tuweni/devp2p/FindNodePacket;", "Lorg/apache/tuweni/devp2p/Packet;", "nodeId", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "target", "expiration", "", "(Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lorg/apache/tuweni/crypto/SECP256K1$Signature;Lorg/apache/tuweni/bytes/Bytes32;Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;J)V", "getTarget", "()Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "encode", "Lorg/apache/tuweni/bytes/Bytes;", "Companion", "devp2p"})
public final class FindNodePacket
extends Packet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SECP256K1.PublicKey target;

    private FindNodePacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, SECP256K1.PublicKey target, long expiration) {
        super(nodeId, signature, hash, expiration, null);
        this.target = target;
    }

    @NotNull
    public final SECP256K1.PublicKey getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public Bytes encode() {
        return this.encodeTo(PacketType.FIND_NODE, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(this){
            final /* synthetic */ FindNodePacket this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RLPWriter writer) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                org.apache.tuweni.devp2p.FindNodePacket$Companion.access$encodeTo(FindNodePacket.Companion, writer, this.this$0.getTarget(), this.this$0.getExpiration());
            }
        }));
    }

    public /* synthetic */ FindNodePacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, SECP256K1.PublicKey target, long expiration, DefaultConstructorMarker $constructor_marker) {
        this(nodeId, signature, hash, target, expiration);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ&\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/apache/tuweni/devp2p/FindNodePacket$Companion;", "", "()V", "create", "Lorg/apache/tuweni/devp2p/FindNodePacket;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "now", "", "target", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "decode", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "encodeTo", "", "writer", "Lorg/apache/tuweni/rlp/RLPWriter;", "expiration", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FindNodePacket create(@NotNull SECP256K1.KeyPair keyPair, long now, @NotNull SECP256K1.PublicKey target) {
            Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            long expiration = Packet.expirationFor(now);
            SigHash sigHash2 = Packet.createSignature(PacketType.FIND_NODE, keyPair, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(target, expiration){
                final /* synthetic */ SECP256K1.PublicKey $target;
                final /* synthetic */ long $expiration;
                {
                    this.$target = $target;
                    this.$expiration = $expiration;
                    super(1);
                }

                public final void invoke(@NotNull RLPWriter writer) {
                    Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                    org.apache.tuweni.devp2p.FindNodePacket$Companion.access$encodeTo(FindNodePacket.Companion, writer, this.$target, this.$expiration);
                }
            }));
            SECP256K1.PublicKey publicKey = keyPair.publicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyPair.publicKey()");
            return new FindNodePacket(publicKey, sigHash2.getSignature(), sigHash2.getHash(), target, expiration, null);
        }

        @NotNull
        public final FindNodePacket decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            try {
                Object object = RLP.decodeList((Bytes)payload, arg_0 -> Companion.decode$lambda-0(publicKey, signature, hash, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decodeList(payload) { re\u2026ec(expiration))\n        }");
                return (FindNodePacket)object;
            }
            catch (RLPException e) {
                throw new DecodingException("Invalid find nodes packet", e);
            }
        }

        private final void encodeTo(RLPWriter writer, SECP256K1.PublicKey target, long expiration) {
            writer.writeValue(target.bytes());
            writer.writeLong(PacketKt.access$msecToSec(expiration));
        }

        private static final FindNodePacket decode$lambda-0(SECP256K1.PublicKey $publicKey, SECP256K1.Signature $signature, Bytes32 $hash, RLPReader reader) {
            Intrinsics.checkNotNullParameter((Object)$publicKey, (String)"$publicKey");
            Intrinsics.checkNotNullParameter((Object)$signature, (String)"$signature");
            Intrinsics.checkNotNullParameter((Object)$hash, (String)"$hash");
            SECP256K1.PublicKey target = SECP256K1.PublicKey.fromBytes((Bytes)reader.readValue());
            long expiration = reader.readLong();
            Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
            return new FindNodePacket($publicKey, $signature, $hash, target, PacketKt.access$secToMsec(expiration), null);
        }

        public static final /* synthetic */ void access$encodeTo(Companion $this, RLPWriter writer, SECP256K1.PublicKey target, long expiration) {
            $this.encodeTo(writer, target, expiration);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

