/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.lib;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.scuttlebutt.lib.model.CouldNotSerializeException;
import org.apache.tuweni.scuttlebutt.lib.model.FeedMessage;
import org.apache.tuweni.scuttlebutt.lib.model.ScuttlebuttMessageContent;
import org.apache.tuweni.scuttlebutt.lib.model.StreamHandler;
import org.apache.tuweni.scuttlebutt.rpc.RPCAsyncRequest;
import org.apache.tuweni.scuttlebutt.rpc.RPCFunction;
import org.apache.tuweni.scuttlebutt.rpc.RPCResponse;
import org.apache.tuweni.scuttlebutt.rpc.RPCStreamRequest;
import org.apache.tuweni.scuttlebutt.rpc.mux.Multiplexer;
import org.apache.tuweni.scuttlebutt.rpc.mux.ScuttlebuttStreamHandler;
import org.apache.tuweni.scuttlebutt.rpc.mux.exceptions.ConnectionClosedException;

public final class FeedService {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Multiplexer multiplexer;

    FeedService(Multiplexer multiplexer) {
        this.multiplexer = multiplexer;
    }

    public <T extends ScuttlebuttMessageContent> AsyncResult<FeedMessage> publish(T content) throws JsonProcessingException {
        JsonNode jsonNode = objectMapper.valueToTree(content);
        RPCAsyncRequest asyncRequest = new RPCAsyncRequest(new RPCFunction("publish"), Arrays.asList(jsonNode));
        return this.multiplexer.makeAsyncRequest(asyncRequest).thenApply(rpcResponse -> {
            try {
                return (FeedMessage)rpcResponse.asJSON(objectMapper, FeedMessage.class);
            }
            catch (IOException ex) {
                throw new CouldNotSerializeException(ex);
            }
        });
    }

    public void createFeedStream(final Function<Runnable, StreamHandler<FeedMessage>> streamHandler) throws JsonProcessingException, ConnectionClosedException {
        RPCStreamRequest streamRequest = new RPCStreamRequest(new RPCFunction("createFeedStream"), Arrays.asList(new Object[0]));
        this.multiplexer.openStream(streamRequest, closer -> new ScuttlebuttStreamHandler(){
            StreamHandler<FeedMessage> handler;
            final /* synthetic */ Runnable val$closer;
            {
                this.val$closer = runnable;
                this.handler = (StreamHandler)streamHandler.apply(this.val$closer);
            }

            public void onMessage(RPCResponse message) {
                try {
                    this.handler.onMessage((FeedMessage)message.asJSON(objectMapper, FeedMessage.class));
                }
                catch (IOException e) {
                    this.handler.onStreamError(e);
                }
            }

            public void onStreamEnd() {
                this.handler.onStreamEnd();
            }

            public void onStreamError(Exception ex) {
                this.handler.onStreamError(ex);
            }
        });
    }
}

