/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlp;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.rlp.InvalidRLPEncodingException;
import org.apache.tuweni.rlp.InvalidRLPTypeException;
import org.apache.tuweni.units.bigints.UInt256;

public interface RLPReader {
    public boolean isLenient();

    default public Bytes readValue() {
        return this.readValue(this.isLenient());
    }

    public Bytes readValue(boolean var1);

    default public byte[] readByteArray() {
        return this.readValue().toArrayUnsafe();
    }

    default public byte readByte() {
        return this.readByte(this.isLenient());
    }

    default public byte readByte(boolean lenient) {
        Bytes bytes = this.readValue(lenient);
        if (bytes.size() != 1) {
            throw new InvalidRLPTypeException("Value is not a single byte");
        }
        return bytes.get(0);
    }

    default public int readInt() {
        return this.readInt(this.isLenient());
    }

    default public int readInt(boolean lenient) {
        Bytes bytes = this.readValue();
        if (!lenient && bytes.hasLeadingZeroByte()) {
            throw new InvalidRLPEncodingException("Integer value was not minimally encoded");
        }
        try {
            return bytes.toInt();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRLPTypeException("Value is too large to be represented as an int");
        }
    }

    default public long readLong() {
        return this.readLong(this.isLenient());
    }

    default public long readLong(boolean lenient) {
        Bytes bytes = this.readValue();
        if (!lenient && bytes.hasLeadingZeroByte()) {
            throw new InvalidRLPEncodingException("Integer value was not minimally encoded");
        }
        try {
            return bytes.toLong();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRLPTypeException("Value is too large to be represented as a long");
        }
    }

    default public UInt256 readUInt256() {
        return this.readUInt256(this.isLenient());
    }

    default public UInt256 readUInt256(boolean lenient) {
        Bytes bytes = this.readValue();
        if (!lenient && bytes.hasLeadingZeroByte()) {
            throw new InvalidRLPEncodingException("Integer value was not minimally encoded");
        }
        try {
            return UInt256.fromBytes((Bytes)bytes);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRLPTypeException("Value is too large to be represented as a UInt256");
        }
    }

    default public BigInteger readBigInteger() {
        return this.readBigInteger(this.isLenient());
    }

    default public BigInteger readBigInteger(boolean lenient) {
        Bytes bytes = this.readValue();
        if (!lenient && bytes.hasLeadingZeroByte()) {
            throw new InvalidRLPEncodingException("Integer value was not minimally encoded");
        }
        return bytes.toUnsignedBigInteger();
    }

    default public String readString() {
        return this.readString(this.isLenient());
    }

    default public String readString(boolean lenient) {
        return new String(this.readValue(lenient).toArrayUnsafe(), StandardCharsets.UTF_8);
    }

    public boolean nextIsList();

    public boolean nextIsEmpty();

    default public <T> T readList(Function<RLPReader, T> fn) {
        return this.readList(this.isLenient(), fn);
    }

    public <T> T readList(boolean var1, Function<RLPReader, T> var2);

    default public List<Object> readList(BiConsumer<RLPReader, List<Object>> fn) {
        return this.readList(this.isLenient(), fn);
    }

    default public <T> List<T> readListContents(Function<RLPReader, T> fn) {
        return this.readListContents(this.isLenient(), fn);
    }

    default public List<Object> readList(boolean lenient, BiConsumer<RLPReader, List<Object>> fn) {
        Objects.requireNonNull(fn);
        return this.readList(lenient, (RLPReader reader) -> {
            ArrayList list = new ArrayList();
            fn.accept((RLPReader)reader, list);
            return list;
        });
    }

    default public <T> List<T> readListContents(boolean lenient, Function<RLPReader, T> fn) {
        Objects.requireNonNull(fn);
        return this.readList(lenient, (RLPReader reader) -> {
            ArrayList list = new ArrayList();
            while (!reader.isComplete()) {
                list.add(fn.apply((RLPReader)reader));
            }
            return list;
        });
    }

    default public void skipNext() {
        this.skipNext(this.isLenient());
    }

    public void skipNext(boolean var1);

    public int remaining();

    public boolean isComplete();

    public int position();

    public Bytes readRemaining();
}

