/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth;

import java.math.BigInteger;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPException;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.ethereum.Gas;
import org.apache.tuweni.units.ethereum.Wei;
import org.jetbrains.annotations.Nullable;

public final class Transaction {
    private static final int V_BASE = 27;
    private final UInt256 nonce;
    private final Wei gasPrice;
    private final Gas gasLimit;
    @Nullable
    private final Address to;
    private final Wei value;
    private final SECP256K1.Signature signature;
    private final Bytes payload;
    private final Integer chainId;
    private volatile Hash hash;
    private volatile Address sender;
    private volatile Boolean validSignature;

    public static Transaction fromBytes(Bytes encoded) {
        return Transaction.fromBytes(encoded, false);
    }

    public static Transaction fromBytes(Bytes encoded, boolean lenient) {
        Objects.requireNonNull(encoded);
        return (Transaction)RLP.decode((Bytes)encoded, (boolean)lenient, reader -> {
            Transaction tx = (Transaction)reader.readList(Transaction::readFrom);
            if (!reader.isComplete()) {
                throw new RLPException("Additional bytes present at the end of the encoded transaction");
            }
            return tx;
        });
    }

    public static Transaction readFrom(RLPReader reader) {
        Address address;
        UInt256 nonce = reader.readUInt256();
        Wei gasPrice = Wei.valueOf((UInt256)reader.readUInt256());
        Gas gasLimit = Gas.valueOf((long)reader.readLong());
        Bytes addressBytes = reader.readValue();
        try {
            address = addressBytes.isEmpty() ? null : Address.fromBytes(addressBytes);
        }
        catch (IllegalArgumentException e) {
            throw new RLPException("Value is the wrong size to be an address", (Throwable)e);
        }
        Wei value = Wei.valueOf((UInt256)reader.readUInt256());
        Bytes payload = reader.readValue();
        int encodedV = reader.readInt();
        Bytes rbytes = reader.readValue();
        if (rbytes.size() > 32) {
            throw new RLPException("r-value of the signature is " + rbytes.size() + ", it should be at most 32 bytes");
        }
        BigInteger r = rbytes.toUnsignedBigInteger();
        Bytes sbytes = reader.readValue();
        if (sbytes.size() > 32) {
            throw new RLPException("s-value of the signature is " + sbytes.size() + ", it should be at most 32 bytes");
        }
        BigInteger s = sbytes.toUnsignedBigInteger();
        if (!reader.isComplete()) {
            throw new RLPException("Additional bytes present at the end of the encoding");
        }
        try {
            return Transaction.fromEncoded(nonce, gasPrice, gasLimit, address, value, payload, r, s, encodedV);
        }
        catch (IllegalArgumentException e) {
            throw new RLPException(e.getMessage(), (Throwable)e);
        }
    }

    public Transaction(UInt256 nonce, Wei gasPrice, Gas gasLimit, @Nullable Address to, Wei value, Bytes payload, SECP256K1.KeyPair keyPair) {
        this(nonce, gasPrice, gasLimit, to, value, payload, keyPair, null);
    }

    public Transaction(UInt256 nonce, Wei gasPrice, Gas gasLimit, @Nullable Address to, Wei value, Bytes payload, SECP256K1.KeyPair keyPair, @Nullable Integer chainId) {
        this(nonce, gasPrice, gasLimit, to, value, payload, chainId, Transaction.generateSignature(nonce, gasPrice, gasLimit, to, value, payload, chainId, keyPair));
    }

    public Transaction(UInt256 nonce, Wei gasPrice, Gas gasLimit, @Nullable Address to, Wei value, Bytes payload, @Nullable Integer chainId, SECP256K1.Signature signature) {
        Objects.requireNonNull(nonce);
        if (nonce.compareTo((Bytes)UInt256.ZERO) < 0) {
            throw new IllegalArgumentException("nonce must be >= 0");
        }
        Objects.requireNonNull(gasPrice);
        Objects.requireNonNull(value);
        Objects.requireNonNull(signature);
        Objects.requireNonNull(payload);
        this.nonce = nonce;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.to = to;
        this.value = value;
        this.signature = signature;
        this.payload = payload;
        this.chainId = chainId;
    }

    public static Transaction fromEncoded(UInt256 nonce, Wei gasPrice, Gas gasLimit, @Nullable Address to, Wei value, Bytes payload, BigInteger r, BigInteger s, int encodedV) {
        SECP256K1.Signature signature;
        byte v;
        Integer chainId = null;
        if (encodedV == 27 || encodedV == 28) {
            v = (byte)(encodedV - 27);
        } else if (encodedV > 35) {
            chainId = (encodedV - 35) / 2;
            v = (byte)(encodedV - (2 * chainId + 35));
        } else {
            throw new RLPException("Invalid v encoded value " + encodedV);
        }
        try {
            signature = SECP256K1.Signature.create((byte)v, (BigInteger)r, (BigInteger)s);
        }
        catch (IllegalArgumentException e) {
            throw new RLPException("Invalid signature: " + e.getMessage());
        }
        return new Transaction(nonce, gasPrice, gasLimit, to, value, payload, chainId, signature);
    }

    public UInt256 getNonce() {
        return this.nonce;
    }

    public Wei getGasPrice() {
        return this.gasPrice;
    }

    public Gas getGasLimit() {
        return this.gasLimit;
    }

    @Nullable
    public Address getTo() {
        return this.to;
    }

    public boolean isContractCreation() {
        return this.to == null;
    }

    public Wei getValue() {
        return this.value;
    }

    public SECP256K1.Signature getSignature() {
        return this.signature;
    }

    public Bytes getPayload() {
        return this.payload;
    }

    public Integer getChainId() {
        return this.chainId;
    }

    public Hash getHash() {
        if (this.hash != null) {
            return this.hash;
        }
        Bytes rlp = this.toBytes();
        this.hash = Hash.hash(rlp);
        return this.hash;
    }

    @Nullable
    public Address getSender() {
        if (this.validSignature != null) {
            return this.sender;
        }
        return this.verifySignatureAndGetSender();
    }

    @Nullable
    public SECP256K1.PublicKey extractPublicKey() {
        Bytes data = Transaction.signatureData(this.nonce, this.gasPrice, this.gasLimit, this.to, this.value, this.payload, this.chainId);
        SECP256K1.PublicKey publicKey = SECP256K1.PublicKey.recoverFromSignature((Bytes)data, (SECP256K1.Signature)this.signature);
        return publicKey;
    }

    @Nullable
    private Address verifySignatureAndGetSender() {
        SECP256K1.PublicKey publicKey = this.extractPublicKey();
        if (publicKey == null) {
            this.validSignature = false;
        } else {
            this.sender = Address.fromPublicKey(publicKey);
            this.validSignature = true;
        }
        return this.sender;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Transaction)) {
            return false;
        }
        Transaction that = (Transaction)obj;
        return this.nonce.equals((Object)that.nonce) && this.gasPrice.equals((Object)that.gasPrice) && this.gasLimit.equals((Object)that.gasLimit) && Objects.equals((Object)this.to, (Object)that.to) && this.value.equals((Object)that.value) && this.signature.equals((Object)that.signature) && this.payload.equals(that.payload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nonce, this.gasPrice, this.gasLimit, this.to, this.value, this.signature, this.payload});
    }

    public String toString() {
        return String.format("Transaction{nonce=%s, gasPrice=%s, gasLimit=%s, to=%s, value=%s, signature=%s, payload=%s", new Object[]{this.nonce, this.gasPrice, this.gasLimit, this.to, this.value, this.signature, this.payload});
    }

    public Bytes toBytes() {
        return RLP.encodeList(this::writeTo);
    }

    public void writeTo(RLPWriter writer) {
        writer.writeUInt256(this.nonce);
        writer.writeUInt256(this.gasPrice.toUInt256());
        writer.writeLong(this.gasLimit.toLong());
        writer.writeValue((Bytes)(this.to != null ? this.to : Bytes.EMPTY));
        writer.writeUInt256(this.value.toUInt256());
        writer.writeValue(this.payload);
        if (this.chainId != null) {
            int v = this.signature.v() + 27 + 8 + this.chainId * 2;
            writer.writeInt(v);
        } else {
            writer.writeInt(this.signature.v() + 27);
        }
        writer.writeBigInteger(this.signature.r());
        writer.writeBigInteger(this.signature.s());
    }

    private static SECP256K1.Signature generateSignature(UInt256 nonce, Wei gasPrice, Gas gasLimit, @Nullable Address to, Wei value, Bytes payload, @Nullable Integer chainId, SECP256K1.KeyPair keyPair) {
        return SECP256K1.sign((Bytes)Transaction.signatureData(nonce, gasPrice, gasLimit, to, value, payload, chainId), (SECP256K1.KeyPair)keyPair);
    }

    public static Bytes signatureData(UInt256 nonce, Wei gasPrice, Gas gasLimit, @Nullable Address to, Wei value, Bytes payload, @Nullable Integer chainId) {
        return RLP.encodeList(writer -> {
            writer.writeUInt256(nonce);
            writer.writeValue(gasPrice.toMinimalBytes());
            writer.writeValue(gasLimit.toMinimalBytes());
            writer.writeValue((Bytes)(to != null ? to : Bytes.EMPTY));
            writer.writeValue(value.toMinimalBytes());
            writer.writeValue(payload);
            if (chainId != null) {
                writer.writeInt(chainId.intValue());
                writer.writeUInt256(UInt256.ZERO);
                writer.writeUInt256(UInt256.ZERO);
            }
        });
    }
}

