/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.kv;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.kv.BytesSerializer;
import org.apache.tuweni.kv.KeyValueStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0006\u0018\u0000 $*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0001$Bg\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0011\u0010\u0015\u001a\u00020\u0016H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u001b\u0010\u001d\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001b\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J!\u0010 \u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u0019\u0010#\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2={"Lorg/apache/tuweni/kv/MapDBKeyValueStore;", "K", "V", "Lorg/apache/tuweni/kv/KeyValueStore;", "dbPath", "Ljava/nio/file/Path;", "keySerializer", "Lkotlin/Function1;", "Lorg/apache/tuweni/bytes/Bytes;", "valueSerializer", "keyDeserializer", "valueDeserializer", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/CoroutineContext;)V", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "db", "Lorg/mapdb/DB;", "storageData", "Lorg/mapdb/HTreeMap;", "clear", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "containsKey", "", "key", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "get", "keys", "", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "remove", "Companion", "kv"})
public final class MapDBKeyValueStore<K, V>
implements KeyValueStore<K, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<K, Bytes> keySerializer;
    @NotNull
    private final Function1<V, Bytes> valueSerializer;
    @NotNull
    private final Function1<Bytes, K> keyDeserializer;
    @NotNull
    private final Function1<Bytes, V> valueDeserializer;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final DB db;
    @NotNull
    private final HTreeMap<Bytes, Bytes> storageData;

    public MapDBKeyValueStore(@NotNull Path dbPath, @NotNull Function1<? super K, ? extends Bytes> keySerializer, @NotNull Function1<? super V, ? extends Bytes> valueSerializer, @NotNull Function1<? super Bytes, ? extends K> keyDeserializer, @NotNull Function1<? super Bytes, ? extends V> valueDeserializer, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)dbPath, (String)"dbPath");
        Intrinsics.checkNotNullParameter(keySerializer, (String)"keySerializer");
        Intrinsics.checkNotNullParameter(valueSerializer, (String)"valueSerializer");
        Intrinsics.checkNotNullParameter(keyDeserializer, (String)"keyDeserializer");
        Intrinsics.checkNotNullParameter(valueDeserializer, (String)"valueDeserializer");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.coroutineContext = coroutineContext;
        Files.createDirectories(dbPath.getParent(), new FileAttribute[0]);
        File file = dbPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dbPath.toFile()");
        this.db = DBMaker.fileDB((File)file).transactionEnable().closeOnJvmShutdown().make();
        this.storageData = this.db.hashMap("storageData", (Serializer)new BytesSerializer(), (Serializer)new BytesSerializer()).createOrOpen();
    }

    public /* synthetic */ MapDBKeyValueStore(Path path, Function1 function1, Function1 function12, Function1 function13, Function1 function14, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getIO();
        }
        this(path, function1, function12, function13, function14, coroutineContext);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @Override
    @Nullable
    public Object containsKey(K key, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((boolean)this.storageData.containsKey(this.keySerializer.invoke(key)));
    }

    @Override
    @Nullable
    public Object get(K key, @NotNull Continuation<? super V> $completion) {
        Bytes value = (Bytes)this.storageData.get(this.keySerializer.invoke(key));
        if (value != null) {
            return this.valueDeserializer.invoke((Object)value);
        }
        return value;
    }

    @Override
    @Nullable
    public Object remove(K key, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.storageData.remove(this.keySerializer.invoke(key));
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object put(K key, V value, @NotNull Continuation<? super Unit> $completion) {
        ((Map)this.storageData).put(this.keySerializer.invoke(key), this.valueSerializer.invoke(value));
        this.db.commit();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object keys(@NotNull Continuation<? super Iterable<? extends K>> $completion) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.storageData.keySet();
        Function1<Bytes, K> transform$iv = this.keyDeserializer;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(transform$iv.invoke(item$iv$iv));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Object clear(@NotNull Continuation<? super Unit> $completion) {
        this.storageData.clear();
        return Unit.INSTANCE;
    }

    @Override
    public void close() {
        this.db.close();
    }

    @Override
    @NotNull
    public AsyncResult<Boolean> containsKeyAsync(K key) {
        return KeyValueStore.DefaultImpls.containsKeyAsync(this, key);
    }

    @Override
    @NotNull
    public AsyncResult<V> getAsync(K key) {
        return KeyValueStore.DefaultImpls.getAsync(this, key);
    }

    @Override
    @NotNull
    public AsyncCompletion putAsync(K key, V value) {
        return KeyValueStore.DefaultImpls.putAsync(this, key, value);
    }

    @Override
    @NotNull
    public AsyncResult<Iterable<K>> keysAsync() {
        return KeyValueStore.DefaultImpls.keysAsync(this);
    }

    @Override
    @NotNull
    public AsyncCompletion clearAsync() {
        return KeyValueStore.DefaultImpls.clearAsync(this);
    }

    @JvmStatic
    @NotNull
    public static final <K, V> MapDBKeyValueStore<K, V> open(@NotNull Path dbPath, @NotNull Function<K, Bytes> keySerializer, @NotNull Function<V, Bytes> valueSerializer, @NotNull Function<Bytes, K> keyDeserializer, @NotNull Function<Bytes, V> valueDeserializer) {
        return Companion.open(dbPath, keySerializer, valueSerializer, keyDeserializer, valueDeserializer);
    }

    @JvmStatic
    @NotNull
    public static final MapDBKeyValueStore<Bytes, Bytes> open(@NotNull Path dbPath) {
        return Companion.open(dbPath);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007Jx\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u0004\"\u0004\b\u0002\u0010\b\"\u0004\b\u0003\u0010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00050\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\b0\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\t0\u000bH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/apache/tuweni/kv/MapDBKeyValueStore$Companion;", "", "()V", "open", "Lorg/apache/tuweni/kv/MapDBKeyValueStore;", "Lorg/apache/tuweni/bytes/Bytes;", "dbPath", "Ljava/nio/file/Path;", "K", "V", "keySerializer", "Ljava/util/function/Function;", "valueSerializer", "keyDeserializer", "valueDeserializer", "kv"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <K, V> MapDBKeyValueStore<K, V> open(@NotNull Path dbPath, @NotNull Function<K, Bytes> keySerializer, @NotNull Function<V, Bytes> valueSerializer, @NotNull Function<Bytes, K> keyDeserializer, @NotNull Function<Bytes, V> valueDeserializer) {
            Intrinsics.checkNotNullParameter((Object)dbPath, (String)"dbPath");
            Intrinsics.checkNotNullParameter(keySerializer, (String)"keySerializer");
            Intrinsics.checkNotNullParameter(valueSerializer, (String)"valueSerializer");
            Intrinsics.checkNotNullParameter(keyDeserializer, (String)"keyDeserializer");
            Intrinsics.checkNotNullParameter(valueDeserializer, (String)"valueDeserializer");
            return new MapDBKeyValueStore(dbPath, new Function1<K, Bytes>(keySerializer){

                @NotNull
                public final Bytes invoke(K p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            }, new Function1<V, Bytes>(valueSerializer){

                @NotNull
                public final Bytes invoke(V p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            }, new Function1<Bytes, K>(keyDeserializer){

                public final K invoke(@NotNull Bytes p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (K)((Function)this.receiver).apply(p0);
                }
            }, new Function1<Bytes, V>(valueDeserializer){

                public final V invoke(@NotNull Bytes p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (V)((Function)this.receiver).apply(p0);
                }
            }, null, 32, null);
        }

        @JvmStatic
        @NotNull
        public final MapDBKeyValueStore<Bytes, Bytes> open(@NotNull Path dbPath) {
            Intrinsics.checkNotNullParameter((Object)dbPath, (String)"dbPath");
            Function function = Function.identity();
            Intrinsics.checkNotNullExpressionValue(function, (String)"identity<Bytes>()");
            Function1 function1 = (Function1)new Function1<Bytes, Bytes>(function){

                public final Bytes invoke(Bytes p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            };
            function = Function.identity();
            Intrinsics.checkNotNullExpressionValue(function, (String)"identity<Bytes>()");
            Function1 function12 = (Function1)new Function1<Bytes, Bytes>(function){

                public final Bytes invoke(Bytes p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            };
            function = Function.identity();
            Intrinsics.checkNotNullExpressionValue(function, (String)"identity<Bytes>()");
            Function1 function13 = (Function1)new Function1<Bytes, Bytes>(function){

                public final Bytes invoke(Bytes p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            };
            function = Function.identity();
            Intrinsics.checkNotNullExpressionValue(function, (String)"identity<Bytes>()");
            return new MapDBKeyValueStore<Bytes, Bytes>(dbPath, function1, function12, function13, (Function1)new Function1<Bytes, Bytes>(function){

                public final Bytes invoke(Bytes p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            }, null, 32, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

