/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.kv;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.io.file.Files;
import org.apache.tuweni.kv.KeyValueStore;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0007\u0018\u0000 %*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0002%&Bq\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u0015\u001a\u00020\u0016H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0014H\u0002J\u001b\u0010\u001e\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001b\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J!\u0010!\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010\"\u001a\u00028\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J\u0019\u0010$\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"Lorg/apache/tuweni/kv/LevelDBKeyValueStore;", "K", "V", "Lorg/apache/tuweni/kv/KeyValueStore;", "dbPath", "Ljava/nio/file/Path;", "keySerializer", "Lkotlin/Function1;", "Lorg/apache/tuweni/bytes/Bytes;", "valueSerializer", "keyDeserializer", "valueDeserializer", "options", "Lorg/iq80/leveldb/Options;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lorg/iq80/leveldb/Options;Lkotlin/coroutines/CoroutineContext;)V", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "db", "Lorg/iq80/leveldb/DB;", "clear", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "containsKey", "", "key", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "create", "get", "keys", "", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "remove", "Companion", "KIterator", "kv"})
public final class LevelDBKeyValueStore<K, V>
implements KeyValueStore<K, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path dbPath;
    @NotNull
    private final Function1<K, Bytes> keySerializer;
    @NotNull
    private final Function1<V, Bytes> valueSerializer;
    @NotNull
    private final Function1<Bytes, K> keyDeserializer;
    @NotNull
    private final Function1<Bytes, V> valueDeserializer;
    @NotNull
    private final Options options;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private DB db;

    public LevelDBKeyValueStore(@NotNull Path dbPath, @NotNull Function1<? super K, ? extends Bytes> keySerializer, @NotNull Function1<? super V, ? extends Bytes> valueSerializer, @NotNull Function1<? super Bytes, ? extends K> keyDeserializer, @NotNull Function1<? super Bytes, ? extends V> valueDeserializer, @NotNull Options options, @NotNull CoroutineContext coroutineContext) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dbPath, (String)"dbPath");
        Intrinsics.checkNotNullParameter(keySerializer, (String)"keySerializer");
        Intrinsics.checkNotNullParameter(valueSerializer, (String)"valueSerializer");
        Intrinsics.checkNotNullParameter(keyDeserializer, (String)"keyDeserializer");
        Intrinsics.checkNotNullParameter(valueDeserializer, (String)"valueDeserializer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.dbPath = dbPath;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.options = options;
        this.coroutineContext = coroutineContext;
        this.db = this.create();
    }

    public /* synthetic */ LevelDBKeyValueStore(Path path, Function1 function1, Function1 function12, Function1 function13, Function1 function14, Options options, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n & 0x20) != 0) {
            Options options2 = new Options().createIfMissing(true).cacheSize(0x6400000L);
            Intrinsics.checkNotNullExpressionValue((Object)options2, (String)"Options().createIfMissin\u2026(100 * 1048576).toLong())");
            options = options2;
        }
        if ((n & 0x40) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getIO();
        }
        this(path, function1, function12, function13, function14, options, coroutineContext);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    private final DB create() {
        java.nio.file.Files.createDirectories(this.dbPath, new FileAttribute[0]);
        DB dB = JniDBFactory.factory.open(this.dbPath.toFile(), this.options);
        Intrinsics.checkNotNullExpressionValue((Object)dB, (String)"factory.open(dbPath.toFile(), options)");
        return dB;
    }

    @Override
    @Nullable
    public Object containsKey(K key, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((this.db.get(((Bytes)this.keySerializer.invoke(key)).toArrayUnsafe()) != null ? 1 : 0) != 0);
    }

    @Override
    @Nullable
    public Object get(K key, @NotNull Continuation<? super V> $completion) {
        Object object;
        byte[] rawValue = this.db.get(((Bytes)this.keySerializer.invoke(key)).toArrayUnsafe());
        if (rawValue == null) {
            object = null;
        } else {
            Bytes bytes = Bytes.wrap((byte[])rawValue);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrap(rawValue)");
            object = this.valueDeserializer.invoke((Object)bytes);
        }
        return object;
    }

    @Override
    @Nullable
    public Object remove(K key, @NotNull Continuation<? super Unit> $completion) {
        this.db.delete(((Bytes)this.keySerializer.invoke(key)).toArrayUnsafe());
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object put(K key, V value, @NotNull Continuation<? super Unit> $completion) {
        this.db.put(((Bytes)this.keySerializer.invoke(key)).toArrayUnsafe(), ((Bytes)this.valueSerializer.invoke(value)).toArrayUnsafe());
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object keys(@NotNull Continuation<? super Iterable<? extends K>> $completion) {
        DBIterator dBIterator = this.db.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)dBIterator, (String)"db.iterator()");
        DBIterator iter = dBIterator;
        iter.seekToFirst();
        return new Iterable<K>(iter, this){
            final /* synthetic */ DBIterator $iter$inlined;
            final /* synthetic */ LevelDBKeyValueStore this$0;
            {
                this.$iter$inlined = dBIterator;
                this.this$0 = levelDBKeyValueStore;
            }

            @NotNull
            public Iterator<K> iterator() {
                boolean bl = false;
                return new KIterator<K>(this.$iter$inlined, LevelDBKeyValueStore.access$getKeyDeserializer$p(this.this$0));
            }
        };
    }

    @Override
    @Nullable
    public Object clear(@NotNull Continuation<? super Unit> $completion) {
        this.close();
        Files.deleteRecursively((Path)this.dbPath);
        this.db = this.create();
        return Unit.INSTANCE;
    }

    @Override
    public void close() {
        this.db.close();
    }

    @Override
    @NotNull
    public AsyncResult<Boolean> containsKeyAsync(K key) {
        return KeyValueStore.DefaultImpls.containsKeyAsync(this, key);
    }

    @Override
    @NotNull
    public AsyncResult<V> getAsync(K key) {
        return KeyValueStore.DefaultImpls.getAsync(this, key);
    }

    @Override
    @NotNull
    public AsyncCompletion putAsync(K key, V value) {
        return KeyValueStore.DefaultImpls.putAsync(this, key, value);
    }

    @Override
    @NotNull
    public AsyncResult<Iterable<K>> keysAsync() {
        return KeyValueStore.DefaultImpls.keysAsync(this);
    }

    @Override
    @NotNull
    public AsyncCompletion clearAsync() {
        return KeyValueStore.DefaultImpls.clearAsync(this);
    }

    @JvmStatic
    @NotNull
    public static final <K, V> LevelDBKeyValueStore<K, V> open(@NotNull Path dbPath, @NotNull Function<K, Bytes> keySerializer, @NotNull Function<V, Bytes> valueSerializer, @NotNull Function<Bytes, K> keyDeserializer, @NotNull Function<Bytes, V> valueDeserializer) throws IOException {
        return Companion.open(dbPath, keySerializer, valueSerializer, keyDeserializer, valueDeserializer);
    }

    @JvmStatic
    @NotNull
    public static final <K, V> LevelDBKeyValueStore<K, V> open(@NotNull Path dbPath, @NotNull Function<K, Bytes> keySerializer, @NotNull Function<V, Bytes> valueSerializer, @NotNull Function<Bytes, K> keyDeserializer, @NotNull Function<Bytes, V> valueDeserializer, @NotNull Options options) throws IOException {
        return Companion.open(dbPath, keySerializer, valueSerializer, keyDeserializer, valueDeserializer, options);
    }

    @JvmStatic
    @NotNull
    public static final LevelDBKeyValueStore<Bytes, Bytes> open(@NotNull Path dbPath) throws IOException {
        return Companion.open(dbPath);
    }

    public static final /* synthetic */ Function1 access$getKeyDeserializer$p(LevelDBKeyValueStore $this) {
        return $this.keyDeserializer;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007Jx\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u0004\"\u0004\b\u0002\u0010\b\"\u0004\b\u0003\u0010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00050\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\b0\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\t0\u000bH\u0007J\u0080\u0001\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u0004\"\u0004\b\u0002\u0010\b\"\u0004\b\u0003\u0010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00050\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\b0\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lorg/apache/tuweni/kv/LevelDBKeyValueStore$Companion;", "", "()V", "open", "Lorg/apache/tuweni/kv/LevelDBKeyValueStore;", "Lorg/apache/tuweni/bytes/Bytes;", "dbPath", "Ljava/nio/file/Path;", "K", "V", "keySerializer", "Ljava/util/function/Function;", "valueSerializer", "keyDeserializer", "valueDeserializer", "options", "Lorg/iq80/leveldb/Options;", "kv"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <K, V> LevelDBKeyValueStore<K, V> open(@NotNull Path dbPath, @NotNull Function<K, Bytes> keySerializer, @NotNull Function<V, Bytes> valueSerializer, @NotNull Function<Bytes, K> keyDeserializer, @NotNull Function<Bytes, V> valueDeserializer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dbPath, (String)"dbPath");
            Intrinsics.checkNotNullParameter(keySerializer, (String)"keySerializer");
            Intrinsics.checkNotNullParameter(valueSerializer, (String)"valueSerializer");
            Intrinsics.checkNotNullParameter(keyDeserializer, (String)"keyDeserializer");
            Intrinsics.checkNotNullParameter(valueDeserializer, (String)"valueDeserializer");
            return new LevelDBKeyValueStore(dbPath, new Function1<K, Bytes>(keySerializer){

                @NotNull
                public final Bytes invoke(K p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            }, new Function1<V, Bytes>(valueSerializer){

                @NotNull
                public final Bytes invoke(V p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            }, new Function1<Bytes, K>(keyDeserializer){

                public final K invoke(@NotNull Bytes p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (K)((Function)this.receiver).apply(p0);
                }
            }, new Function1<Bytes, V>(valueDeserializer){

                public final V invoke(@NotNull Bytes p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (V)((Function)this.receiver).apply(p0);
                }
            }, null, null, 96, null);
        }

        @JvmStatic
        @NotNull
        public final <K, V> LevelDBKeyValueStore<K, V> open(@NotNull Path dbPath, @NotNull Function<K, Bytes> keySerializer, @NotNull Function<V, Bytes> valueSerializer, @NotNull Function<Bytes, K> keyDeserializer, @NotNull Function<Bytes, V> valueDeserializer, @NotNull Options options) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dbPath, (String)"dbPath");
            Intrinsics.checkNotNullParameter(keySerializer, (String)"keySerializer");
            Intrinsics.checkNotNullParameter(valueSerializer, (String)"valueSerializer");
            Intrinsics.checkNotNullParameter(keyDeserializer, (String)"keyDeserializer");
            Intrinsics.checkNotNullParameter(valueDeserializer, (String)"valueDeserializer");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new LevelDBKeyValueStore(dbPath, new Function1<K, Bytes>(keySerializer){

                @NotNull
                public final Bytes invoke(K p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            }, new Function1<V, Bytes>(valueSerializer){

                @NotNull
                public final Bytes invoke(V p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            }, new Function1<Bytes, K>(keyDeserializer){

                public final K invoke(@NotNull Bytes p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (K)((Function)this.receiver).apply(p0);
                }
            }, new Function1<Bytes, V>(valueDeserializer){

                public final V invoke(@NotNull Bytes p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (V)((Function)this.receiver).apply(p0);
                }
            }, options, null, 64, null);
        }

        @JvmStatic
        @NotNull
        public final LevelDBKeyValueStore<Bytes, Bytes> open(@NotNull Path dbPath) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dbPath, (String)"dbPath");
            Function function = Function.identity();
            Intrinsics.checkNotNullExpressionValue(function, (String)"identity<Bytes>()");
            Function1 function1 = (Function1)new Function1<Bytes, Bytes>(function){

                public final Bytes invoke(Bytes p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            };
            function = Function.identity();
            Intrinsics.checkNotNullExpressionValue(function, (String)"identity<Bytes>()");
            Function1 function12 = (Function1)new Function1<Bytes, Bytes>(function){

                public final Bytes invoke(Bytes p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            };
            function = Function.identity();
            Intrinsics.checkNotNullExpressionValue(function, (String)"identity<Bytes>()");
            Function1 function13 = (Function1)new Function1<Bytes, Bytes>(function){

                public final Bytes invoke(Bytes p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            };
            function = Function.identity();
            Intrinsics.checkNotNullExpressionValue(function, (String)"identity<Bytes>()");
            return new LevelDBKeyValueStore<Bytes, Bytes>(dbPath, function1, function12, function13, (Function1)new Function1<Bytes, Bytes>(function){

                public final Bytes invoke(Bytes p0) {
                    return (Bytes)((Function)this.receiver).apply(p0);
                }
            }, null, null, 96, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u000e\u0010\u000f\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/apache/tuweni/kv/LevelDBKeyValueStore$KIterator;", "K", "", "iter", "Lorg/iq80/leveldb/DBIterator;", "keyDeserializer", "Lkotlin/Function1;", "Lorg/apache/tuweni/bytes/Bytes;", "(Lorg/iq80/leveldb/DBIterator;Lkotlin/jvm/functions/Function1;)V", "getIter", "()Lorg/iq80/leveldb/DBIterator;", "getKeyDeserializer", "()Lkotlin/jvm/functions/Function1;", "hasNext", "", "next", "()Ljava/lang/Object;", "kv"})
    private static final class KIterator<K>
    implements Iterator<K>,
    KMappedMarker {
        @NotNull
        private final DBIterator iter;
        @NotNull
        private final Function1<Bytes, K> keyDeserializer;

        public KIterator(@NotNull DBIterator iter, @NotNull Function1<? super Bytes, ? extends K> keyDeserializer) {
            Intrinsics.checkNotNullParameter((Object)iter, (String)"iter");
            Intrinsics.checkNotNullParameter(keyDeserializer, (String)"keyDeserializer");
            this.iter = iter;
            this.keyDeserializer = keyDeserializer;
        }

        @NotNull
        public final DBIterator getIter() {
            return this.iter;
        }

        @NotNull
        public final Function1<Bytes, K> getKeyDeserializer() {
            return this.keyDeserializer;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public K next() {
            Bytes bytes = Bytes.wrap((byte[])((byte[])((Map.Entry)this.iter.next()).getKey()));
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrap(iter.next().key)");
            return (K)this.keyDeserializer.invoke((Object)bytes);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

