/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.hobbits;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.hobbits.MessageKt;
import org.apache.tuweni.hobbits.Protocol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/apache/tuweni/hobbits/Message;", "", "version", "", "protocol", "Lorg/apache/tuweni/hobbits/Protocol;", "headers", "Lorg/apache/tuweni/bytes/Bytes;", "body", "(ILorg/apache/tuweni/hobbits/Protocol;Lorg/apache/tuweni/bytes/Bytes;Lorg/apache/tuweni/bytes/Bytes;)V", "getBody", "()Lorg/apache/tuweni/bytes/Bytes;", "getHeaders", "getProtocol", "()Lorg/apache/tuweni/hobbits/Protocol;", "getVersion", "()I", "size", "toBytes", "toString", "", "Companion", "hobbits"})
public final class Message {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int version;
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final Bytes headers;
    @NotNull
    private final Bytes body;

    public Message(int version, @NotNull Protocol protocol, @NotNull Bytes headers, @NotNull Bytes body) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.version = version;
        this.protocol = protocol;
        this.headers = headers;
        this.body = body;
    }

    public /* synthetic */ Message(int n, Protocol protocol, Bytes bytes, Bytes bytes2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        this(n, protocol, bytes, bytes2);
    }

    public final int getVersion() {
        return this.version;
    }

    @NotNull
    public final Protocol getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final Bytes getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Bytes getBody() {
        return this.body;
    }

    @NotNull
    public final Bytes toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(MessageKt.getMESSAGE_HEADER_LENGTH());
        buffer.put(MessageKt.getPREAMBLE());
        buffer.putInt(this.version);
        buffer.put(this.protocol.getCode());
        buffer.putInt(this.headers.size());
        buffer.putInt(this.body.size());
        Bytes[] bytesArray = new Bytes[]{Bytes.wrap((byte[])buffer.array()), this.headers, this.body};
        Bytes bytes = Bytes.concatenate((Bytes[])bytesArray);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"concatenate(Bytes.wrap(b\u2026.array()), headers, body)");
        return bytes;
    }

    public final int size() {
        return MessageKt.getMESSAGE_HEADER_LENGTH() + this.headers.size() + this.body.size();
    }

    @NotNull
    public String toString() {
        String requestLine = "EWP " + this.version + " " + this.protocol + " " + this.headers.size() + " " + this.body.size() + "\n";
        return requestLine + this.headers.toHexString() + "\n" + this.body.toHexString();
    }

    @JvmStatic
    @Nullable
    public static final Message readMessage(@NotNull Bytes message) {
        return Companion.readMessage(message);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/apache/tuweni/hobbits/Message$Companion;", "", "()V", "readMessage", "Lorg/apache/tuweni/hobbits/Message;", "message", "Lorg/apache/tuweni/bytes/Bytes;", "hobbits"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Message readMessage(@NotNull Bytes message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (message.size() < MessageKt.getMESSAGE_HEADER_LENGTH()) {
                return null;
            }
            if (!Intrinsics.areEqual((Object)message.slice(0, MessageKt.getPREAMBLE().length), (Object)Bytes.wrap((byte[])MessageKt.getPREAMBLE()))) {
                throw new IllegalArgumentException("Message doesn't start with correct preamble");
            }
            int version = message.getInt(MessageKt.getPREAMBLE().length);
            Protocol protocol = Protocol.Companion.fromByte(message.get(MessageKt.getPREAMBLE().length + 4));
            int headersLength = message.getInt(MessageKt.getPREAMBLE().length + 4 + 1);
            int bodyLength = message.getInt(MessageKt.getPREAMBLE().length + 4 + 1 + 4);
            if (message.size() < MessageKt.getMESSAGE_HEADER_LENGTH() + headersLength + bodyLength) {
                return null;
            }
            Bytes headers = message.slice(MessageKt.getMESSAGE_HEADER_LENGTH(), headersLength);
            Bytes body = message.slice(MessageKt.getMESSAGE_HEADER_LENGTH() + headersLength, bodyLength);
            Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"headers");
            Intrinsics.checkNotNullExpressionValue((Object)body, (String)"body");
            return new Message(version, protocol, headers, body);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

