/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.sodium;

import java.util.Objects;
import javax.security.auth.Destroyable;
import jnr.ffi.Pointer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.sodium.Allocated;
import org.apache.tuweni.crypto.sodium.Box;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.crypto.sodium.Sodium;
import org.apache.tuweni.crypto.sodium.SodiumException;

public final class DiffieHelman {

    public static final class Secret
    implements Destroyable {
        final Allocated value;

        private Secret(Pointer ptr, int length) {
            this.value = new Allocated(ptr, length);
        }

        @Override
        public void destroy() {
            this.value.destroy();
        }

        @Override
        public boolean isDestroyed() {
            return this.value.isDestroyed();
        }

        public static Secret forKeys(SecretKey secretKey, PublicKey publicKey) {
            if (secretKey.isDestroyed()) {
                throw new IllegalStateException("SecretKey has been destroyed");
            }
            return Sodium.scalarMult(secretKey.value.pointer(), secretKey.value.length(), publicKey.value.pointer(), publicKey.value.length(), (ptr, len) -> {
                int secretLength = Secret.length();
                if (len != (long)secretLength) {
                    throw new IllegalStateException("Secret length " + secretLength + " is not same as generated key length " + len);
                }
                return new Secret((Pointer)ptr, secretLength);
            });
        }

        public static Secret fromBytes(Bytes bytes) {
            return Secret.fromBytes(bytes.toArrayUnsafe());
        }

        public static Secret fromBytes(byte[] bytes) {
            if ((long)bytes.length != Sodium.crypto_scalarmult_bytes()) {
                throw new IllegalArgumentException("key must be " + Sodium.crypto_scalarmult_bytes() + " bytes, got " + bytes.length);
            }
            return Sodium.dup(bytes, Secret::new);
        }

        public static int length() {
            long keybytes = Sodium.crypto_scalarmult_bytes();
            if (keybytes > Integer.MAX_VALUE) {
                throw new SodiumException("crypto_scalarmult_bytes: " + keybytes + " is too large");
            }
            return (int)keybytes;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Secret)) {
                return false;
            }
            Secret other = (Secret)obj;
            return other.value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public Bytes bytes() {
            return this.value.bytes();
        }

        public byte[] bytesArray() {
            return this.value.bytesArray();
        }
    }

    public static final class KeyPair {
        private final PublicKey publicKey;
        private final SecretKey secretKey;

        public KeyPair(PublicKey publicKey, SecretKey secretKey) {
            this.publicKey = publicKey;
            this.secretKey = secretKey;
        }

        public static KeyPair forSecretKey(SecretKey secretKey) {
            if (secretKey.isDestroyed()) {
                throw new IllegalStateException("SecretKey has been destroyed");
            }
            return Sodium.scalarMultBase(secretKey.value.pointer(), SecretKey.length(), (ptr, len) -> {
                int publicKeyLength = PublicKey.length();
                if (len != (long)publicKeyLength) {
                    throw new IllegalStateException("Public key length " + publicKeyLength + " is not same as generated key length " + len);
                }
                return new KeyPair(new PublicKey((Pointer)ptr, publicKeyLength), secretKey);
            });
        }

        public static KeyPair random() {
            return Sodium.randomBytes(SecretKey.length(), (ptr, len) -> KeyPair.forSecretKey(new SecretKey((Pointer)ptr, (int)len)));
        }

        public PublicKey publicKey() {
            return this.publicKey;
        }

        public SecretKey secretKey() {
            return this.secretKey;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof KeyPair)) {
                return false;
            }
            KeyPair other = (KeyPair)obj;
            return this.publicKey.equals(other.publicKey) && this.secretKey.equals(other.secretKey);
        }

        public int hashCode() {
            return Objects.hash(this.publicKey, this.secretKey);
        }
    }

    public static final class SecretKey
    implements Destroyable {
        final Allocated value;

        private SecretKey(Pointer ptr, int length) {
            this.value = new Allocated(ptr, length);
        }

        @Override
        public void destroy() {
            this.value.destroy();
        }

        @Override
        public boolean isDestroyed() {
            return this.value.isDestroyed();
        }

        public static SecretKey forBoxSecretKey(Box.SecretKey secretKey) {
            return new SecretKey(Sodium.dup(secretKey.value.pointer(), SecretKey.length()), SecretKey.length());
        }

        public static SecretKey forSignatureSecretKey(Signature.SecretKey secretKey) {
            return SecretKey.forBoxSecretKey(Box.SecretKey.forSignatureSecretKey(secretKey));
        }

        public static SecretKey fromBytes(Bytes bytes) {
            return SecretKey.fromBytes(bytes.toArrayUnsafe());
        }

        public static SecretKey fromBytes(byte[] bytes) {
            if ((long)bytes.length != Sodium.crypto_scalarmult_scalarbytes()) {
                throw new IllegalArgumentException("key must be " + Sodium.crypto_scalarmult_scalarbytes() + " bytes, got " + bytes.length);
            }
            return Sodium.dup(bytes, SecretKey::new);
        }

        public static int length() {
            long keybytes = Sodium.crypto_scalarmult_scalarbytes();
            if (keybytes > Integer.MAX_VALUE) {
                throw new SodiumException("crypto_scalarmult_scalarbytes: " + keybytes + " is too large");
            }
            return (int)keybytes;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SecretKey)) {
                return false;
            }
            SecretKey other = (SecretKey)obj;
            return other.value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public Bytes bytes() {
            return this.value.bytes();
        }

        public byte[] bytesArray() {
            return this.value.bytesArray();
        }
    }

    public static final class PublicKey {
        final Allocated value;

        private PublicKey(Pointer ptr, int length) {
            this.value = new Allocated(ptr, length);
        }

        public static PublicKey forBoxPublicKey(Box.PublicKey publicKey) {
            return new PublicKey(Sodium.dup(publicKey.value.pointer(), PublicKey.length()), PublicKey.length());
        }

        public static PublicKey forSignaturePublicKey(Signature.PublicKey publicKey) {
            return PublicKey.forBoxPublicKey(Box.PublicKey.forSignaturePublicKey(publicKey));
        }

        public static PublicKey fromBytes(Bytes bytes) {
            return PublicKey.fromBytes(bytes.toArrayUnsafe());
        }

        public static PublicKey fromBytes(byte[] bytes) {
            if ((long)bytes.length != Sodium.crypto_box_publickeybytes()) {
                throw new IllegalArgumentException("key must be " + Sodium.crypto_box_publickeybytes() + " bytes, got " + bytes.length);
            }
            return Sodium.dup(bytes, PublicKey::new);
        }

        public static int length() {
            long keybytes = Sodium.crypto_scalarmult_bytes();
            if (keybytes > Integer.MAX_VALUE) {
                throw new SodiumException("crypto_scalarmult_bytes: " + keybytes + " is too large");
            }
            return (int)keybytes;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PublicKey)) {
                return false;
            }
            PublicKey other = (PublicKey)obj;
            return other.value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public Bytes bytes() {
            return this.value.bytes();
        }

        public byte[] bytesArray() {
            return this.value.bytesArray();
        }
    }
}

