/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.stratum.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.stratum.server.JsonRpcRequest;
import org.apache.tuweni.stratum.server.JsonRpcSuccessResponse;
import org.apache.tuweni.stratum.server.PoWInput;
import org.apache.tuweni.stratum.server.PoWSolution;
import org.apache.tuweni.stratum.server.StratumConnection;
import org.apache.tuweni.stratum.server.StratumProtocol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 &2\u00020\u0001:\u0001&Bj\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\"\u0010\u0007\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0016H\u0016R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0007\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\bX\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"Lorg/apache/tuweni/stratum/server/Stratum1Protocol;", "Lorg/apache/tuweni/stratum/server/StratumProtocol;", "extranonce", "", "jobIdSupplier", "Lkotlin/Function0;", "subscriptionIdCreator", "submitCallback", "Lkotlin/Function2;", "Lorg/apache/tuweni/stratum/server/PoWSolution;", "Lkotlin/coroutines/Continuation;", "", "", "seedSupplier", "Lorg/apache/tuweni/bytes/Bytes32;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/CoroutineContext;)V", "activeConnections", "", "Lorg/apache/tuweni/stratum/server/StratumConnection;", "currentInput", "Lorg/apache/tuweni/stratum/server/PoWInput;", "Lkotlin/jvm/functions/Function2;", "canHandle", "initialMessage", "conn", "handle", "", "message", "handleMiningAuthorize", "Lorg/apache/tuweni/stratum/server/JsonRpcRequest;", "handleMiningSubmit", "onClose", "registerConnection", "sendNewWork", "setCurrentWorkTask", "input", "Companion", "server"})
public final class Stratum1Protocol
implements StratumProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String extranonce;
    @NotNull
    private final Function0<String> jobIdSupplier;
    @NotNull
    private final Function0<String> subscriptionIdCreator;
    @NotNull
    private final Function2<PoWSolution, Continuation<? super Boolean>, Object> submitCallback;
    @NotNull
    private final Function0<Bytes32> seedSupplier;
    @NotNull
    private final CoroutineContext coroutineContext;
    @Nullable
    private PoWInput currentInput;
    @NotNull
    private final List<StratumConnection> activeConnections;
    private static final Logger logger = LoggerFactory.getLogger(Stratum1Protocol.class);
    @NotNull
    private static final JsonMapper mapper = new JsonMapper();
    @NotNull
    private static final String STRATUM_1 = "EthereumStratum/1.0.0";

    public Stratum1Protocol(@NotNull String extranonce, @NotNull Function0<String> jobIdSupplier, @NotNull Function0<String> subscriptionIdCreator, @NotNull Function2<? super PoWSolution, ? super Continuation<? super Boolean>, ? extends Object> submitCallback, @NotNull Function0<? extends Bytes32> seedSupplier, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)extranonce, (String)"extranonce");
        Intrinsics.checkNotNullParameter(jobIdSupplier, (String)"jobIdSupplier");
        Intrinsics.checkNotNullParameter(subscriptionIdCreator, (String)"subscriptionIdCreator");
        Intrinsics.checkNotNullParameter(submitCallback, (String)"submitCallback");
        Intrinsics.checkNotNullParameter(seedSupplier, (String)"seedSupplier");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.extranonce = extranonce;
        this.jobIdSupplier = jobIdSupplier;
        this.subscriptionIdCreator = subscriptionIdCreator;
        this.submitCallback = submitCallback;
        this.seedSupplier = seedSupplier;
        this.coroutineContext = coroutineContext;
        this.activeConnections = new ArrayList();
    }

    public /* synthetic */ Stratum1Protocol(String string, Function0 function0, Function0 function02, Function2 function2, Function0 function03, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function02 = 2.INSTANCE;
        }
        this(string, (Function0<String>)function0, (Function0<String>)function02, (Function2<? super PoWSolution, ? super Continuation<? super Boolean>, ? extends Object>)function2, (Function0<? extends Bytes32>)function03, coroutineContext);
    }

    @Override
    public boolean canHandle(@NotNull String initialMessage, @NotNull StratumConnection conn2) {
        Intrinsics.checkNotNullParameter((Object)initialMessage, (String)"initialMessage");
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        if (!StringsKt.contains$default((CharSequence)initialMessage, (CharSequence)"mining.subscribe", (boolean)false, (int)2, null)) {
            logger.debug("Invalid first message method: {}", (Object)initialMessage);
            return false;
        }
        JsonRpcRequest requestBody = null;
        try {
            Object object = mapper.readValue(initialMessage, JsonRpcRequest.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(initial\u2026onRpcRequest::class.java)");
            requestBody = (JsonRpcRequest)object;
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
        try {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = new String[]{"mining.notify", (String)this.subscriptionIdCreator.invoke(), STRATUM_1};
            objectArray[0] = CollectionsKt.mutableListOf((Object[])objectArray2);
            objectArray[1] = this.extranonce;
            String notify = mapper.writeValueAsString((Object)new JsonRpcSuccessResponse(requestBody.getId(), null, CollectionsKt.mutableListOf((Object[])objectArray), 2, null));
            conn2.send(notify + "\n");
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private final void registerConnection(StratumConnection conn2) {
        this.activeConnections.add(conn2);
        if (this.currentInput != null) {
            this.sendNewWork(conn2);
        }
    }

    private final void sendNewWork(StratumConnection conn2) {
        PoWInput poWInput = this.currentInput;
        if (poWInput == null) {
            return;
        }
        PoWInput input = poWInput;
        Object[] objectArray = new Object[5];
        objectArray[0] = this.jobIdSupplier.invoke();
        Bytes[] bytesArray = new Bytes[]{input.getPrePowHash()};
        String string = Bytes.wrap((Bytes[])bytesArray).toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrap(input.prePowHash).toHexString()");
        objectArray[1] = string;
        string = ((Bytes32)this.seedSupplier.invoke()).toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"seedSupplier().toHexString()");
        objectArray[2] = string;
        string = input.getTarget().toBytes().toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.target.toBytes().toHexString()");
        objectArray[3] = string;
        objectArray[4] = true;
        List params = CollectionsKt.mutableListOf((Object[])objectArray);
        JsonRpcRequest req = new JsonRpcRequest("2.0", "mining.notify", params, 32L);
        try {
            conn2.send(mapper.writeValueAsString((Object)req) + "\n");
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void onClose(@NotNull StratumConnection conn2) {
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        this.activeConnections.remove(conn2);
    }

    @Override
    public void handle(@NotNull StratumConnection conn2, @NotNull String message) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        try {
            object = mapper.readValue(message, JsonRpcRequest.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n      mapper.readValue\u2026equest::class.java)\n    }");
            object = (JsonRpcRequest)object;
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            conn2.close(true);
            return;
        }
        Object req = object;
        if (Intrinsics.areEqual((Object)"mining.authorize", (Object)((JsonRpcRequest)req).getMethod())) {
            this.handleMiningAuthorize(conn2, (JsonRpcRequest)req);
        } else if (Intrinsics.areEqual((Object)"mining.submit", (Object)((JsonRpcRequest)req).getMethod())) {
            this.handleMiningSubmit(conn2, (JsonRpcRequest)req);
        }
    }

    private final void handleMiningSubmit(StratumConnection conn2, JsonRpcRequest message) {
        boolean bl;
        logger.debug("Miner submitted solution {}", (Object)message);
        PoWSolution solution = new PoWSolution(message.bytes(2).getLong(0), message.bytes32(4), null, message.bytes(3));
        PoWInput poWInput = this.currentInput;
        if (poWInput == null) {
            bl = false;
        } else {
            Bytes bytes = poWInput.getPrePowHash();
            bl = bytes == null ? false : bytes.equals(solution.getPowHash());
        }
        if (bl) {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.coroutineContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, solution, message, conn2, null){
                int label;
                final /* synthetic */ Stratum1Protocol this$0;
                final /* synthetic */ PoWSolution $solution;
                final /* synthetic */ JsonRpcRequest $message;
                final /* synthetic */ StratumConnection $conn;
                {
                    this.this$0 = $receiver;
                    this.$solution = $solution;
                    this.$message = $message;
                    this.$conn = $conn;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = Stratum1Protocol.access$getSubmitCallback$p(this.this$0).invoke((Object)this.$solution, (Object)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            result = (Boolean)v0;
                            response = Stratum1Protocol.access$getMapper$cp().writeValueAsString((Object)new JsonRpcSuccessResponse(this.$message.getId(), null, Boxing.boxBoolean((boolean)(result != false)), 2, null));
                            this.$conn.send(response + "\n");
                            this.$conn.handleClientResponseFeedback(result != false);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            String response = mapper.writeValueAsString((Object)new JsonRpcSuccessResponse(message.getId(), null, false, 2, null));
            conn2.send(response + "\n");
            conn2.handleClientResponseFeedback(false);
        }
    }

    private final void handleMiningAuthorize(StratumConnection conn2, JsonRpcRequest message) throws IOException {
        String confirm = mapper.writeValueAsString((Object)new JsonRpcSuccessResponse(message.getId(), null, true, 2, null));
        conn2.send(confirm + "\n");
        this.registerConnection(conn2);
    }

    @Override
    public void setCurrentWorkTask(@NotNull PoWInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.currentInput = input;
        logger.debug("Sending new work to miners: {}", (Object)input);
        for (StratumConnection conn2 : this.activeConnections) {
            this.sendNewWork(conn2);
        }
    }

    public static final /* synthetic */ Function2 access$getSubmitCallback$p(Stratum1Protocol $this) {
        return $this.submitCallback;
    }

    public static final /* synthetic */ JsonMapper access$getMapper$cp() {
        return mapper;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/apache/tuweni/stratum/server/Stratum1Protocol$Companion;", "", "()V", "STRATUM_1", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "createSubscriptionID", "server"})
    public static final class Companion {
        private Companion() {
        }

        private final String createSubscriptionID() {
            byte[] subscriptionBytes = new byte[16];
            new Random().nextBytes(subscriptionBytes);
            String string = Bytes.wrap((byte[])subscriptionBytes).toShortHexString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrap(subscriptionBytes).toShortHexString()");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

