/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.stratum.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.stratum.server.JsonRpcRequest;
import org.apache.tuweni.stratum.server.JsonRpcSuccessResponse;
import org.apache.tuweni.stratum.server.PoWInput;
import org.apache.tuweni.stratum.server.PoWSolution;
import org.apache.tuweni.stratum.server.StratumConnection;
import org.apache.tuweni.stratum.server.StratumProtocol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0001'BB\u0012\"\u0010\u0002\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u001e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0012H\u0016R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0002\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0003X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006("}, d2={"Lorg/apache/tuweni/stratum/server/Stratum1EthProxyProtocol;", "Lorg/apache/tuweni/stratum/server/StratumProtocol;", "submitCallback", "Lkotlin/Function2;", "Lorg/apache/tuweni/stratum/server/PoWSolution;", "Lkotlin/coroutines/Continuation;", "", "", "seedSupplier", "Lkotlin/Function0;", "Lorg/apache/tuweni/bytes/Bytes32;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/CoroutineContext;)V", "activeConnections", "", "Lorg/apache/tuweni/stratum/server/StratumConnection;", "currentInput", "Lorg/apache/tuweni/stratum/server/PoWInput;", "Lkotlin/jvm/functions/Function2;", "canHandle", "initialMessage", "", "conn", "handle", "", "message", "handleHashrateSubmit", "mapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "Lorg/apache/tuweni/stratum/server/JsonRpcRequest;", "handleMiningSubmit", "req", "onClose", "sendNewWork", "id", "", "setCurrentWorkTask", "input", "Companion", "server"})
public final class Stratum1EthProxyProtocol
implements StratumProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function2<PoWSolution, Continuation<? super Boolean>, Object> submitCallback;
    @NotNull
    private final Function0<Bytes32> seedSupplier;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final List<StratumConnection> activeConnections;
    @Nullable
    private PoWInput currentInput;
    private static final Logger logger = LoggerFactory.getLogger(Stratum1EthProxyProtocol.class);
    @NotNull
    private static final JsonMapper mapper = new JsonMapper();

    public Stratum1EthProxyProtocol(@NotNull Function2<? super PoWSolution, ? super Continuation<? super Boolean>, ? extends Object> submitCallback, @NotNull Function0<? extends Bytes32> seedSupplier, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter(submitCallback, (String)"submitCallback");
        Intrinsics.checkNotNullParameter(seedSupplier, (String)"seedSupplier");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.submitCallback = submitCallback;
        this.seedSupplier = seedSupplier;
        this.coroutineContext = coroutineContext;
        this.activeConnections = new ArrayList();
    }

    @Override
    public boolean canHandle(@NotNull String initialMessage, @NotNull StratumConnection conn2) {
        Intrinsics.checkNotNullParameter((Object)initialMessage, (String)"initialMessage");
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        try {
            JsonRpcRequest req = (JsonRpcRequest)mapper.readValue(initialMessage, JsonRpcRequest.class);
            if (!Intrinsics.areEqual((Object)req.getMethod(), (Object)"eth_submitLogin")) {
                logger.debug("Invalid first message method: {}", (Object)initialMessage);
                return false;
            }
            String response = mapper.writeValueAsString((Object)new JsonRpcSuccessResponse(req.getId(), null, true, 2, null));
            conn2.send(response + "\n");
            this.activeConnections.add(conn2);
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            conn2.close(true);
            return false;
        }
        return true;
    }

    private final void sendNewWork(StratumConnection conn2, long id) {
        PoWInput poWInput = this.currentInput;
        if (poWInput == null) {
            return;
        }
        PoWInput input = poWInput;
        Object[] objectArray = new String[]{input.getPrePowHash().toHexString(), ((Bytes32)this.seedSupplier.invoke()).toHexString(), input.getTarget().toHexString()};
        List result = CollectionsKt.mutableListOf((Object[])objectArray);
        JsonRpcSuccessResponse resp = new JsonRpcSuccessResponse(id, null, result, 2, null);
        try {
            conn2.send(mapper.writeValueAsString((Object)resp) + "\n");
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void onClose(@NotNull StratumConnection conn2) {
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        this.activeConnections.remove(conn2);
    }

    @Override
    public void handle(@NotNull StratumConnection conn2, @NotNull String message) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        try {
            object = mapper.readValue(message, JsonRpcRequest.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n      mapper.readValue\u2026equest::class.java)\n    }");
            object = (JsonRpcRequest)object;
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            conn2.close(true);
            return;
        }
        Object req = object;
        if (Intrinsics.areEqual((Object)"eth_getWork", (Object)((JsonRpcRequest)req).getMethod())) {
            this.sendNewWork(conn2, ((JsonRpcRequest)req).getId());
        } else if (Intrinsics.areEqual((Object)"eth_submitWork", (Object)((JsonRpcRequest)req).getMethod())) {
            this.handleMiningSubmit(conn2, (JsonRpcRequest)req);
        } else if (Intrinsics.areEqual((Object)"eth_submitHashrate", (Object)((JsonRpcRequest)req).getMethod())) {
            this.handleHashrateSubmit(mapper, conn2, (JsonRpcRequest)req);
        } else {
            logger.debug("Unsupported message: {}", (Object)((JsonRpcRequest)req).getMethod());
        }
    }

    private final void handleMiningSubmit(StratumConnection conn2, JsonRpcRequest req) throws IOException {
        boolean bl;
        logger.debug("Miner submitted solution {}", (Object)req);
        if (req.getParams().size() < 3) {
            logger.warn("Invalid solution");
            conn2.close(true);
            return;
        }
        PoWSolution solution = new PoWSolution(req.bytes(0).getLong(0), req.bytes32(2), null, req.bytes(1));
        PoWInput poWInput = this.currentInput;
        if (poWInput == null) {
            bl = false;
        } else {
            Bytes bytes = poWInput.getPrePowHash();
            bl = bytes == null ? false : bytes.equals(solution.getPowHash());
        }
        if (bl) {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.coroutineContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, solution, req, conn2, null){
                int label;
                final /* synthetic */ Stratum1EthProxyProtocol this$0;
                final /* synthetic */ PoWSolution $solution;
                final /* synthetic */ JsonRpcRequest $req;
                final /* synthetic */ StratumConnection $conn;
                {
                    this.this$0 = $receiver;
                    this.$solution = $solution;
                    this.$req = $req;
                    this.$conn = $conn;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = Stratum1EthProxyProtocol.access$getSubmitCallback$p(this.this$0).invoke((Object)this.$solution, (Object)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            result = (Boolean)v0;
                            response = Stratum1EthProxyProtocol.access$getMapper$cp().writeValueAsString((Object)new JsonRpcSuccessResponse(this.$req.getId(), null, Boxing.boxBoolean((boolean)(result != false)), 2, null));
                            this.$conn.send(response + "\n");
                            this.$conn.handleClientResponseFeedback(result != false);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            String response = mapper.writeValueAsString((Object)new JsonRpcSuccessResponse(req.getId(), null, false, 2, null));
            conn2.send(response + "\n");
            conn2.handleClientResponseFeedback(false);
        }
    }

    @Override
    public void setCurrentWorkTask(@NotNull PoWInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.currentInput = input;
        logger.debug("Sending new work to miners: {}", (Object)input);
        for (StratumConnection conn2 : this.activeConnections) {
            this.sendNewWork(conn2, 0L);
        }
    }

    public final void handleHashrateSubmit(@NotNull JsonMapper mapper, @NotNull StratumConnection conn2, @NotNull JsonRpcRequest message) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String response = mapper.writeValueAsString((Object)new JsonRpcSuccessResponse(message.getId(), null, true, 2, null));
        conn2.send(response + "\n");
    }

    public static final /* synthetic */ Function2 access$getSubmitCallback$p(Stratum1EthProxyProtocol $this) {
        return $this.submitCallback;
    }

    public static final /* synthetic */ JsonMapper access$getMapper$cp() {
        return mapper;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/apache/tuweni/stratum/server/Stratum1EthProxyProtocol$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

