/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.tracing.opentelemetry.HeadersPropagatorGetter;
import io.vertx.tracing.opentelemetry.HeadersPropagatorSetter;
import io.vertx.tracing.opentelemetry.VertxContextStorageProvider;
import java.util.Map;
import java.util.function.BiConsumer;

class OpenTelemetryTracer
implements VertxTracer<Scope, Scope> {
    private static final TextMapGetter<Iterable<Map.Entry<String, String>>> getter = new HeadersPropagatorGetter();
    private static final TextMapSetter<BiConsumer<String, String>> setter = new HeadersPropagatorSetter();
    private final Tracer tracer;
    private final ContextPropagators propagators;

    OpenTelemetryTracer(OpenTelemetry openTelemetry) {
        this.tracer = openTelemetry.getTracer("io.vertx");
        this.propagators = openTelemetry.getPropagators();
    }

    public <R> Scope receiveRequest(io.vertx.core.Context context, io.vertx.core.spi.tracing.SpanKind kind, TracingPolicy policy, R request, String operation, Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
        if (TracingPolicy.IGNORE.equals((Object)policy)) {
            return null;
        }
        Context tracingContext = (Context)context.getLocal(VertxContextStorageProvider.ACTIVE_CONTEXT);
        if (tracingContext == null) {
            tracingContext = Context.root();
        }
        if (Span.fromContextOrNull((Context)(tracingContext = this.propagators.getTextMapPropagator().extract(tracingContext, headers, getter))) == null && TracingPolicy.PROPAGATE.equals((Object)policy)) {
            return null;
        }
        Span span = this.tracer.spanBuilder(operation).setParent(tracingContext).setSpanKind(io.vertx.core.spi.tracing.SpanKind.RPC.equals((Object)kind) ? SpanKind.SERVER : SpanKind.CONSUMER).startSpan();
        tagExtractor.extractTo(request, (arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1));
        return VertxContextStorageProvider.VertxContextStorage.INSTANCE.attach(context, tracingContext.with((ImplicitContextKeyed)span));
    }

    public <R> void sendResponse(io.vertx.core.Context context, R response, Scope scope, Throwable failure, TagExtractor<R> tagExtractor) {
        if (scope == null) {
            return;
        }
        Span span = Span.fromContext((Context)((Context)context.getLocal(VertxContextStorageProvider.ACTIVE_CONTEXT)));
        if (failure != null) {
            span.recordException(failure);
        }
        if (response != null) {
            tagExtractor.extractTo(response, (arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1));
        }
        span.end();
        scope.close();
    }

    public <R> Scope sendRequest(io.vertx.core.Context context, io.vertx.core.spi.tracing.SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        if (TracingPolicy.IGNORE.equals((Object)policy) || request == null) {
            return null;
        }
        Context tracingContext = (Context)context.getLocal(VertxContextStorageProvider.ACTIVE_CONTEXT);
        if (tracingContext == null && !TracingPolicy.ALWAYS.equals((Object)policy)) {
            return null;
        }
        if (tracingContext == null) {
            tracingContext = Context.root();
        }
        Span span = this.tracer.spanBuilder(operation).setParent(tracingContext).setSpanKind(io.vertx.core.spi.tracing.SpanKind.RPC.equals((Object)kind) ? SpanKind.CLIENT : SpanKind.PRODUCER).startSpan();
        tagExtractor.extractTo(request, (arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1));
        tracingContext = tracingContext.with((ImplicitContextKeyed)span);
        this.propagators.getTextMapPropagator().inject(tracingContext, headers, setter);
        return VertxContextStorageProvider.VertxContextStorage.INSTANCE.attach(context, tracingContext);
    }

    public <R> void receiveResponse(io.vertx.core.Context context, R response, Scope scope, Throwable failure, TagExtractor<R> tagExtractor) {
        this.sendResponse(context, response, scope, failure, tagExtractor);
    }
}

