/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.genesis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.genesis.Allocation;
import org.apache.tuweni.genesis.AllocationGenerator;
import org.apache.tuweni.genesis.Genesis;
import org.apache.tuweni.genesis.QBFTGenesisExtraData;
import org.apache.tuweni.genesis.QuorumGenesisConfig;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0002"}, d2={"Lorg/apache/tuweni/genesis/QuorumConfig;", "", "genesis", "Lorg/apache/tuweni/genesis/Genesis;", "validators", "", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "allocations", "Lorg/apache/tuweni/genesis/Allocation;", "(Lorg/apache/tuweni/genesis/Genesis;Ljava/util/List;Ljava/util/List;)V", "getAllocations", "()Ljava/util/List;", "getGenesis", "()Lorg/apache/tuweni/genesis/Genesis;", "getValidators", "allocsToCsv", "", "Companion"})
public final class QuorumConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Genesis genesis;
    @NotNull
    private final List<SECP256K1.KeyPair> validators;
    @NotNull
    private final List<Allocation> allocations;
    @NotNull
    private static final String header = "User,Public key,Address,Secret key\n";

    public QuorumConfig(@NotNull Genesis genesis, @NotNull List<? extends SECP256K1.KeyPair> validators, @NotNull List<Allocation> allocations) {
        Intrinsics.checkNotNullParameter((Object)genesis, (String)"genesis");
        Intrinsics.checkNotNullParameter(validators, (String)"validators");
        Intrinsics.checkNotNullParameter(allocations, (String)"allocations");
        this.genesis = genesis;
        this.validators = validators;
        this.allocations = allocations;
    }

    @NotNull
    public final Genesis getGenesis() {
        return this.genesis;
    }

    @NotNull
    public final List<SECP256K1.KeyPair> getValidators() {
        return this.validators;
    }

    @NotNull
    public final List<Allocation> getAllocations() {
        return this.allocations;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String allocsToCsv() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.allocations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Allocation allocation = (Allocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("Unclaimed," + it.getKeyPair().publicKey().toHexString() + "," + it.getAddress().toHexString() + "," + it.getKeyPair().secretKey().bytes());
        }
        List lines = (List)destination$iv$iv;
        return header + CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jt\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u000e2\b\b\u0002\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\fJx\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001dR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006!"}, d2={"Lorg/apache/tuweni/genesis/QuorumConfig$Companion;", "", "()V", "header", "", "getHeader", "()Ljava/lang/String;", "generate", "Lorg/apache/tuweni/genesis/QuorumConfig;", "nonce", "Lorg/apache/tuweni/bytes/Bytes;", "difficulty", "Lorg/apache/tuweni/units/bigints/UInt256;", "mixHash", "Lorg/apache/tuweni/bytes/Bytes32;", "coinbase", "Lorg/apache/tuweni/eth/Address;", "timestamp", "", "gasLimit", "parentHash", "vanity", "config", "Lorg/apache/tuweni/genesis/QuorumGenesisConfig;", "numberValidators", "", "numberAllocations", "amount", "allocations", "", "Lorg/apache/tuweni/genesis/Allocation;", "validators", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "genesis"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getHeader() {
            return header;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final QuorumConfig generate(@NotNull Bytes nonce, @NotNull UInt256 difficulty, @NotNull Bytes32 mixHash, @NotNull Address coinbase, long timestamp, long gasLimit, @NotNull Bytes32 parentHash, @NotNull Bytes32 vanity, @NotNull QuorumGenesisConfig config, int numberValidators, int numberAllocations, @NotNull UInt256 amount) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
            Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
            Intrinsics.checkNotNullParameter((Object)mixHash, (String)"mixHash");
            Intrinsics.checkNotNullParameter((Object)coinbase, (String)"coinbase");
            Intrinsics.checkNotNullParameter((Object)parentHash, (String)"parentHash");
            Intrinsics.checkNotNullParameter((Object)vanity, (String)"vanity");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            List<Allocation> allocations = new AllocationGenerator().createAllocations(numberAllocations, amount);
            Iterable $this$map$iv = (Iterable)new IntRange(0, numberValidators);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SECP256K1.KeyPair.random());
            }
            List validators = (List)destination$iv$iv;
            return this.generate(nonce, difficulty, coinbase, timestamp, gasLimit, parentHash, config, vanity, mixHash, allocations, validators);
        }

        public static /* synthetic */ QuorumConfig generate$default(Companion companion, Bytes bytes, UInt256 uInt256, Bytes32 bytes32, Address address, long l, long l2, Bytes32 bytes322, Bytes32 bytes323, QuorumGenesisConfig quorumGenesisConfig, int n, int n2, UInt256 uInt2562, int n3, Object object) {
            Bytes bytes2;
            if ((n3 & 1) != 0) {
                bytes2 = Bytes.ofUnsignedLong((long)0L);
                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"ofUnsignedLong(0)");
                bytes = bytes2;
            }
            if ((n3 & 2) != 0) {
                bytes2 = UInt256.ONE.shiftLeft(252);
                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"ONE.shiftLeft(252)");
                uInt256 = bytes2;
            }
            if ((n3 & 8) != 0) {
                bytes2 = Address.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"ZERO");
                address = bytes2;
            }
            if ((n3 & 0x10) != 0) {
                l = 0L;
            }
            if ((n3 & 0x20) != 0) {
                l2 = 0L;
            }
            if ((n3 & 0x40) != 0) {
                bytes2 = Bytes32.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"ZERO");
                bytes322 = bytes2;
            }
            if ((n3 & 0x80) != 0) {
                bytes2 = Bytes32.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"ZERO");
                bytes323 = bytes2;
            }
            return companion.generate(bytes, uInt256, bytes32, address, l, l2, bytes322, bytes323, quorumGenesisConfig, n, n2, uInt2562);
        }

        @NotNull
        public final QuorumConfig generate(@NotNull Bytes nonce, @NotNull UInt256 difficulty, @NotNull Address coinbase, long timestamp, long gasLimit, @NotNull Bytes32 parentHash, @NotNull QuorumGenesisConfig config, @NotNull Bytes32 vanity, @NotNull Bytes32 mixHash, @NotNull List<Allocation> allocations, @NotNull List<? extends SECP256K1.KeyPair> validators) {
            Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
            Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
            Intrinsics.checkNotNullParameter((Object)coinbase, (String)"coinbase");
            Intrinsics.checkNotNullParameter((Object)parentHash, (String)"parentHash");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)vanity, (String)"vanity");
            Intrinsics.checkNotNullParameter((Object)mixHash, (String)"mixHash");
            Intrinsics.checkNotNullParameter(allocations, (String)"allocations");
            Intrinsics.checkNotNullParameter(validators, (String)"validators");
            Map allocs = new LinkedHashMap();
            for (Allocation alloc : allocations) {
                allocs.put(alloc.getAddress(), alloc.getAmount());
            }
            Bytes bytes = new QBFTGenesisExtraData(vanity, validators).toBytes();
            Genesis genesis = new Genesis(nonce, difficulty, mixHash, coinbase, timestamp, bytes, gasLimit, parentHash, allocs, config);
            return new QuorumConfig(genesis, validators, allocations);
        }

        public static /* synthetic */ QuorumConfig generate$default(Companion companion, Bytes bytes, UInt256 uInt256, Address address, long l, long l2, Bytes32 bytes32, QuorumGenesisConfig quorumGenesisConfig, Bytes32 bytes322, Bytes32 bytes323, List list, List list2, int n, Object object) {
            Bytes bytes2;
            if ((n & 1) != 0) {
                bytes2 = Bytes.ofUnsignedLong((long)0L);
                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"ofUnsignedLong(0)");
                bytes = bytes2;
            }
            if ((n & 2) != 0) {
                bytes2 = UInt256.ONE.shiftLeft(252);
                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"ONE.shiftLeft(252)");
                uInt256 = bytes2;
            }
            if ((n & 4) != 0) {
                bytes2 = Address.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"ZERO");
                address = bytes2;
            }
            if ((n & 8) != 0) {
                l = 0L;
            }
            if ((n & 0x10) != 0) {
                l2 = 0L;
            }
            if ((n & 0x20) != 0) {
                bytes2 = Bytes32.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"ZERO");
                bytes32 = bytes2;
            }
            if ((n & 0x80) != 0) {
                bytes2 = Bytes32.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"ZERO");
                bytes322 = bytes2;
            }
            return companion.generate(bytes, uInt256, address, l, l2, bytes32, quorumGenesisConfig, bytes322, bytes323, list, list2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

