/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.genesis;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/apache/tuweni/genesis/QBFTGenesisExtraData;", "", "vanity", "Lorg/apache/tuweni/bytes/Bytes32;", "validators", "", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "(Lorg/apache/tuweni/bytes/Bytes32;Ljava/util/List;)V", "getValidators", "()Ljava/util/List;", "getVanity", "()Lorg/apache/tuweni/bytes/Bytes32;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toBytes", "Lorg/apache/tuweni/bytes/Bytes;", "toString", "", "genesis"})
public final class QBFTGenesisExtraData {
    @NotNull
    private final Bytes32 vanity;
    @NotNull
    private final List<SECP256K1.KeyPair> validators;

    public QBFTGenesisExtraData(@NotNull Bytes32 vanity, @NotNull List<? extends SECP256K1.KeyPair> validators) {
        Intrinsics.checkNotNullParameter((Object)vanity, (String)"vanity");
        Intrinsics.checkNotNullParameter(validators, (String)"validators");
        this.vanity = vanity;
        this.validators = validators;
    }

    @NotNull
    public final Bytes32 getVanity() {
        return this.vanity;
    }

    @NotNull
    public final List<SECP256K1.KeyPair> getValidators() {
        return this.validators;
    }

    @NotNull
    public final Bytes toBytes() {
        Bytes bytes = RLP.encodeList(arg_0 -> QBFTGenesisExtraData.toBytes$lambda-3(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"encodeList {\n    it.writ\u2026)\n    it.writeList {}\n  }");
        return bytes;
    }

    @NotNull
    public final Bytes32 component1() {
        return this.vanity;
    }

    @NotNull
    public final List<SECP256K1.KeyPair> component2() {
        return this.validators;
    }

    @NotNull
    public final QBFTGenesisExtraData copy(@NotNull Bytes32 vanity, @NotNull List<? extends SECP256K1.KeyPair> validators) {
        Intrinsics.checkNotNullParameter((Object)vanity, (String)"vanity");
        Intrinsics.checkNotNullParameter(validators, (String)"validators");
        return new QBFTGenesisExtraData(vanity, validators);
    }

    public static /* synthetic */ QBFTGenesisExtraData copy$default(QBFTGenesisExtraData qBFTGenesisExtraData, Bytes32 bytes32, List list, int n, Object object) {
        if ((n & 1) != 0) {
            bytes32 = qBFTGenesisExtraData.vanity;
        }
        if ((n & 2) != 0) {
            list = qBFTGenesisExtraData.validators;
        }
        return qBFTGenesisExtraData.copy(bytes32, list);
    }

    @NotNull
    public String toString() {
        return "QBFTGenesisExtraData(vanity=" + this.vanity + ", validators=" + this.validators + ")";
    }

    public int hashCode() {
        int result = this.vanity.hashCode();
        result = result * 31 + ((Object)this.validators).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QBFTGenesisExtraData)) {
            return false;
        }
        QBFTGenesisExtraData qBFTGenesisExtraData = (QBFTGenesisExtraData)other;
        if (!Intrinsics.areEqual((Object)this.vanity, (Object)qBFTGenesisExtraData.vanity)) {
            return false;
        }
        return Intrinsics.areEqual(this.validators, qBFTGenesisExtraData.validators);
    }

    private static final void toBytes$lambda-3$lambda-0(QBFTGenesisExtraData this$0, RLPWriter valWriter) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (SECP256K1.KeyPair validator : this$0.validators) {
            valWriter.writeValue((Bytes)Address.fromPublicKey((SECP256K1.PublicKey)validator.publicKey()));
        }
    }

    private static final void toBytes$lambda-3$lambda-1(RLPWriter it) {
    }

    private static final void toBytes$lambda-3$lambda-2(RLPWriter it) {
    }

    private static final void toBytes$lambda-3(QBFTGenesisExtraData this$0, RLPWriter it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.writeValue((Bytes)this$0.vanity);
        it.writeList(arg_0 -> QBFTGenesisExtraData.toBytes$lambda-3$lambda-0(this$0, arg_0));
        it.writeList(QBFTGenesisExtraData::toBytes$lambda-3$lambda-1);
        it.writeString("");
        it.writeList(QBFTGenesisExtraData::toBytes$lambda-3$lambda-2);
    }
}

