/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.genesis;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.genesis.GenesisConfig;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;

@JsonPropertyOrder(value={"config", "nonce", "timestamp", "extraData", "gasLimit", "difficulty", "number", "gasUsed", "parentHash", "mixHash", "coinbase", "alloc"})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#J\u0006\u0010%\u001a\u00020#R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/apache/tuweni/genesis/Genesis;", "", "nonce", "Lorg/apache/tuweni/bytes/Bytes;", "difficulty", "Lorg/apache/tuweni/units/bigints/UInt256;", "mixHash", "Lorg/apache/tuweni/bytes/Bytes32;", "coinbase", "Lorg/apache/tuweni/eth/Address;", "timestamp", "", "extraData", "gasLimit", "parentHash", "alloc", "", "config", "Lorg/apache/tuweni/genesis/GenesisConfig;", "(Lorg/apache/tuweni/bytes/Bytes;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/bytes/Bytes32;Lorg/apache/tuweni/eth/Address;JLorg/apache/tuweni/bytes/Bytes;JLorg/apache/tuweni/bytes/Bytes32;Ljava/util/Map;Lorg/apache/tuweni/genesis/GenesisConfig;)V", "getAlloc", "()Ljava/util/Map;", "getCoinbase", "()Lorg/apache/tuweni/eth/Address;", "getConfig", "()Lorg/apache/tuweni/genesis/GenesisConfig;", "getDifficulty", "()Lorg/apache/tuweni/units/bigints/UInt256;", "getExtraData", "()Lorg/apache/tuweni/bytes/Bytes;", "getMixHash", "()Lorg/apache/tuweni/bytes/Bytes32;", "getNonce", "getParentHash", "getGasLimit", "", "getNumber", "getTimestamp", "genesis"})
public final class Genesis {
    @NotNull
    private final Bytes nonce;
    @NotNull
    private final UInt256 difficulty;
    @NotNull
    private final Bytes32 mixHash;
    @NotNull
    private final Address coinbase;
    private final long timestamp;
    @NotNull
    private final Bytes extraData;
    private final long gasLimit;
    @NotNull
    private final Bytes32 parentHash;
    @NotNull
    private final Map<Address, UInt256> alloc;
    @NotNull
    private final GenesisConfig config;

    public Genesis(@NotNull Bytes nonce, @NotNull UInt256 difficulty, @NotNull Bytes32 mixHash, @NotNull Address coinbase, long timestamp, @NotNull Bytes extraData, long gasLimit, @NotNull Bytes32 parentHash, @NotNull Map<Address, UInt256> alloc, @NotNull GenesisConfig config) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)mixHash, (String)"mixHash");
        Intrinsics.checkNotNullParameter((Object)coinbase, (String)"coinbase");
        Intrinsics.checkNotNullParameter((Object)extraData, (String)"extraData");
        Intrinsics.checkNotNullParameter((Object)parentHash, (String)"parentHash");
        Intrinsics.checkNotNullParameter(alloc, (String)"alloc");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.nonce = nonce;
        this.difficulty = difficulty;
        this.mixHash = mixHash;
        this.coinbase = coinbase;
        this.timestamp = timestamp;
        this.extraData = extraData;
        this.gasLimit = gasLimit;
        this.parentHash = parentHash;
        this.alloc = alloc;
        this.config = config;
    }

    @NotNull
    public final Bytes getNonce() {
        return this.nonce;
    }

    @NotNull
    public final UInt256 getDifficulty() {
        return this.difficulty;
    }

    @NotNull
    public final Bytes32 getMixHash() {
        return this.mixHash;
    }

    @NotNull
    public final Address getCoinbase() {
        return this.coinbase;
    }

    @NotNull
    public final Bytes getExtraData() {
        return this.extraData;
    }

    @NotNull
    public final Bytes32 getParentHash() {
        return this.parentHash;
    }

    @NotNull
    public final Map<Address, UInt256> getAlloc() {
        return this.alloc;
    }

    @NotNull
    public final GenesisConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final String getTimestamp() {
        if (this.timestamp == 0L) {
            return "0x0";
        }
        String string = Bytes.ofUnsignedLong((long)this.timestamp).toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ofUnsignedLong(timestamp).toHexString()");
        return string;
    }

    @NotNull
    public final String getGasLimit() {
        String string = Bytes.ofUnsignedLong((long)this.gasLimit).toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ofUnsignedLong(gasLimit).toHexString()");
        return string;
    }

    @NotNull
    public final String getNumber() {
        return "0x0";
    }
}

