/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.gossip;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tuweni.config.Configuration;
import org.apache.tuweni.config.PropertyValidator;
import org.apache.tuweni.config.Schema;
import org.apache.tuweni.config.SchemaBuilder;
import picocli.CommandLine;

final class GossipCommandLineOptions {
    @CommandLine.Option(names={"-c", "--config"}, description={"Configuration file."})
    private Path configPath = null;
    @CommandLine.Option(arity="0..*", names={"-p", "--peer"}, description={"Static peers list"})
    private String[] peers;
    @CommandLine.Option(names={"-l", "--listen"}, description={"Port to listen on"})
    private Integer port;
    @CommandLine.Option(names={"-r", "--rpc"}, description={"RPC port to listen on"})
    private Integer rpcPort;
    @CommandLine.Option(names={"-n", "--networkInterface"}, description={"Network interface to bind to"})
    private String networkInterface = "0.0.0.0";
    @CommandLine.Option(names={"-m", "--messageLog"}, description={"Log file where messages are stored"})
    private String messageLog;
    @CommandLine.Option(names={"--sendInterval"}, description={"Interval to wait in between sending messages in milliseconds (load testing)"})
    private Integer sendInterval;
    @CommandLine.Option(names={"--payloadSize"}, description={"Size of the random payload to send to other peers (load testing)"})
    private Integer payloadSize;
    @CommandLine.Option(names={"--numberOfMessages"}, description={"Number of messages to publish (load testing)"})
    private Integer numberOfMessages;
    @CommandLine.Option(names={"--sending"}, description={"Whether this peer sends random messages to all other peers (load testing)"})
    private Boolean sending;
    @CommandLine.Option(names={"-h", "--help"}, description={"Prints usage prompt"})
    private boolean help;
    private List<URI> peerAddresses;
    private Configuration config;

    static final Schema createConfigFileSchema() {
        return SchemaBuilder.create().addInteger("listenPort", Integer.valueOf(0), "Port to listen on", PropertyValidator.inRange((long)0L, (long)65536L)).addInteger("rpcPort", Integer.valueOf(0), "RPC port to listen on", PropertyValidator.inRange((long)0L, (long)65536L)).addString("networkInterface", "0.0.0.0", "Network interface to bind to", null).addListOfString("peers", Collections.emptyList(), "Static peers list", null).addString("messagelog", "messages.log", "Log file where messages are stored", null).addBoolean("sending", Boolean.valueOf(false), "Whether this peer sends random messages to all other peers (load testing)", null).addInteger("sendInterval", Integer.valueOf(1000), "Interval to wait in between sending messages in milliseconds (load testing)", null).addInteger("numberOfMessages", Integer.valueOf(100), "Number of messages to publish to other peers (load testing)", null).addInteger("payloadSize", Integer.valueOf(200), "Size of the random payload to send to other peers (load testing)", null).toSchema();
    }

    GossipCommandLineOptions() {
    }

    GossipCommandLineOptions(String[] peers, Integer port, String networkInterface, String messageLog, Integer rpcPort, Integer payloadSize, Integer sendInterval, Boolean sending, Integer numberOfMessages, Configuration config) {
        this.peers = peers;
        this.port = port;
        this.networkInterface = networkInterface;
        this.messageLog = messageLog;
        this.rpcPort = rpcPort;
        this.config = config;
        this.payloadSize = payloadSize;
        this.sendInterval = sendInterval;
        this.numberOfMessages = numberOfMessages;
        this.sending = sending;
    }

    private Configuration config() {
        if (this.config == null && this.configPath != null) {
            try {
                this.config = Configuration.fromToml((Path)this.configPath, (Schema)GossipCommandLineOptions.createConfigFileSchema());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.config;
    }

    List<URI> peers() {
        block2: {
            block3: {
                if (this.peerAddresses != null) break block2;
                this.peerAddresses = new ArrayList<URI>();
                if (this.peers == null) break block3;
                for (String peer : this.peers) {
                    this.readPeerInfo(peer);
                }
                break block2;
            }
            if (this.config() == null) break block2;
            for (String peer : this.config().getListOfString("peers")) {
                this.readPeerInfo(peer);
            }
        }
        return this.peerAddresses;
    }

    private void readPeerInfo(String peer) {
        URI peerURI = URI.create(peer);
        if (peerURI.getHost() == null) {
            throw new IllegalArgumentException("Invalid peer URI " + peerURI);
        }
        this.peerAddresses.add(peerURI);
    }

    void validate() {
        List errors;
        int listenPort = this.listenPort();
        if (listenPort < 0 || listenPort > 65535) {
            throw new IllegalArgumentException("Invalid port number " + listenPort);
        }
        int rpcPort = this.rpcPort();
        if (rpcPort < 0 || rpcPort > 65535) {
            throw new IllegalArgumentException("Invalid port number" + rpcPort);
        }
        this.peers();
        try {
            InetAddress.getByName(this.networkInterface);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid network interface");
        }
        if (this.config() != null && (errors = this.config().errors()).size() > 0) {
            String message = errors.stream().map(err -> "[" + err.position() + "] " + err.getMessage()).collect(Collectors.joining("\n"));
            throw new IllegalArgumentException(message);
        }
    }

    int listenPort() {
        if (this.port != null) {
            return this.port;
        }
        if (this.config() != null) {
            return this.config.getInteger("listenPort");
        }
        return 0;
    }

    int rpcPort() {
        if (this.rpcPort != null) {
            return this.rpcPort;
        }
        if (this.config() != null) {
            return this.config.getInteger("rpcPort");
        }
        return 0;
    }

    String networkInterface() {
        if (this.networkInterface != null) {
            return this.networkInterface;
        }
        if (this.config() != null) {
            return this.config.getString("networkInterface");
        }
        return "0.0.0.0";
    }

    String messageLog() {
        if (this.messageLog != null) {
            return this.messageLog;
        }
        if (this.config != null) {
            return this.config.getString("messageLog");
        }
        return "messages.log";
    }

    boolean sending() {
        if (this.sending != null) {
            return this.sending;
        }
        if (this.config != null) {
            return this.config.getBoolean("sending");
        }
        return false;
    }

    Integer payloadSize() {
        if (this.payloadSize != null) {
            return this.payloadSize;
        }
        if (this.config != null) {
            return this.config.getInteger("payloadSize");
        }
        return 200;
    }

    Integer sendInterval() {
        if (this.sendInterval != null) {
            return this.sendInterval;
        }
        if (this.config != null) {
            return this.config.getInteger("sendInterval");
        }
        return 1000;
    }

    Integer numberOfMessages() {
        if (this.numberOfMessages != null) {
            return this.numberOfMessages;
        }
        if (this.config != null) {
            return this.config.getInteger("numberOfMessages");
        }
        return 100;
    }

    boolean help() {
        return this.help;
    }
}

