/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.rpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.scuttlebutt.rpc.RPCCodec;
import org.apache.tuweni.scuttlebutt.rpc.RPCFlag;
import org.apache.tuweni.scuttlebutt.rpc.RPCFunction;
import org.apache.tuweni.scuttlebutt.rpc.RPCRequestBody;
import org.apache.tuweni.scuttlebutt.rpc.RPCRequestType;

public class RPCStreamRequest {
    private final RPCFunction function;
    private final List<Object> arguments;

    public RPCStreamRequest(RPCFunction function, List<Object> arguments) {
        this.function = function;
        this.arguments = arguments;
    }

    public Bytes toEncodedRpcMessage(ObjectMapper mapper) throws JsonProcessingException {
        RPCRequestBody body = new RPCRequestBody(this.function.asList(), RPCRequestType.SOURCE, this.arguments);
        return RPCCodec.encodeRequest(body.asBytes(mapper), this.getRPCFlags());
    }

    public RPCFlag[] getRPCFlags() {
        return new RPCFlag[]{RPCFlag.Stream.STREAM, RPCFlag.BodyType.JSON};
    }
}

