/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.rpc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.scuttlebutt.rpc.RPCFlag;

public class RPCResponse {
    private final Bytes body;
    private final RPCFlag.BodyType bodyType;

    public RPCResponse(Bytes body, RPCFlag.BodyType bodyType) {
        this.body = body;
        this.bodyType = bodyType;
    }

    public Bytes body() {
        return this.body;
    }

    public RPCFlag.BodyType bodyType() {
        return this.bodyType;
    }

    public String asString() {
        return new String(this.body().toArrayUnsafe(), StandardCharsets.UTF_8);
    }

    public <T> T asJSON(ObjectMapper objectMapper, Class<T> clazz) throws IOException {
        return (T)objectMapper.readerFor(clazz).readValue(this.body().toArrayUnsafe());
    }

    public <T> T asJSON(ObjectMapper objectMapper, TypeReference<T> typeReference) throws IOException {
        return (T)objectMapper.readerFor(typeReference).readValue(this.body().toArrayUnsafe());
    }
}

