/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.rpc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.scuttlebutt.rpc.RPCErrorBody;
import org.apache.tuweni.scuttlebutt.rpc.RPCFlag;
import org.apache.tuweni.scuttlebutt.rpc.mux.exceptions.RPCRequestFailedException;

public final class RPCMessage {
    private final byte rpcFlags;
    private final boolean stream;
    private final boolean lastMessageOrError;
    private final RPCFlag.BodyType bodyType;
    private final Bytes body;
    private final int requestNumber;

    public RPCMessage(Bytes messageBytes) {
        this.rpcFlags = messageBytes.get(0);
        this.stream = RPCFlag.Stream.STREAM.isApplied(this.rpcFlags);
        this.lastMessageOrError = RPCFlag.EndOrError.END.isApplied(this.rpcFlags);
        this.bodyType = RPCFlag.BodyType.JSON.isApplied(this.rpcFlags) ? RPCFlag.BodyType.JSON : (RPCFlag.BodyType.UTF_8_STRING.isApplied(this.rpcFlags) ? RPCFlag.BodyType.UTF_8_STRING : RPCFlag.BodyType.BINARY);
        int bodySize = messageBytes.slice(1, 4).toInt();
        this.requestNumber = messageBytes.slice(5, 4).toInt();
        if (messageBytes.size() < bodySize + 9) {
            throw new IllegalArgumentException("Message body " + (messageBytes.size() - 9) + " is less than body size " + bodySize);
        }
        this.body = messageBytes.slice(9, bodySize);
    }

    public boolean stream() {
        return this.stream;
    }

    public boolean lastMessageOrError() {
        return this.lastMessageOrError;
    }

    public boolean isSuccessfulLastMessage() {
        return this.lastMessageOrError() && this.asString().equals("true");
    }

    public boolean isErrorMessage() {
        return this.lastMessageOrError && !this.isSuccessfulLastMessage();
    }

    public Optional<RPCErrorBody> getErrorBody(ObjectMapper objectMapper) {
        if (!this.isErrorMessage()) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.asJSON(objectMapper, RPCErrorBody.class));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public Optional<RPCRequestFailedException> getException(ObjectMapper objectMapper) {
        if (this.isErrorMessage()) {
            Optional<RPCRequestFailedException> exception = this.getErrorBody(objectMapper).map(errorBody -> new RPCRequestFailedException(errorBody.getMessage()));
            if (!exception.isPresent()) {
                return Optional.of(new RPCRequestFailedException(this.asString()));
            }
            return exception;
        }
        return Optional.empty();
    }

    public RPCFlag.BodyType bodyType() {
        return this.bodyType;
    }

    public int requestNumber() {
        return this.requestNumber;
    }

    public Bytes body() {
        return this.body;
    }

    public byte rpcFlags() {
        return this.rpcFlags;
    }

    public String asString() {
        return new String(this.body().toArrayUnsafe(), StandardCharsets.UTF_8);
    }

    public <T> T asJSON(ObjectMapper objectMapper, Class<T> clazz) throws IOException {
        return (T)objectMapper.readerFor(clazz).readValue(this.body().toArrayUnsafe());
    }
}

