/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.stratum.server;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/apache/tuweni/stratum/server/PoWInput;", "", "target", "Lorg/apache/tuweni/units/bigints/UInt256;", "prePowHash", "Lorg/apache/tuweni/bytes/Bytes;", "blockNumber", "", "(Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/bytes/Bytes;J)V", "getBlockNumber", "()J", "getPrePowHash", "()Lorg/apache/tuweni/bytes/Bytes;", "getTarget", "()Lorg/apache/tuweni/units/bigints/UInt256;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "server"})
public final class PoWInput {
    @NotNull
    private final UInt256 target;
    @NotNull
    private final Bytes prePowHash;
    private final long blockNumber;

    public PoWInput(@NotNull UInt256 target, @NotNull Bytes prePowHash, long blockNumber) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)prePowHash, (String)"prePowHash");
        this.target = target;
        this.prePowHash = prePowHash;
        this.blockNumber = blockNumber;
    }

    @NotNull
    public final UInt256 getTarget() {
        return this.target;
    }

    @NotNull
    public final Bytes getPrePowHash() {
        return this.prePowHash;
    }

    public final long getBlockNumber() {
        return this.blockNumber;
    }

    @NotNull
    public final UInt256 component1() {
        return this.target;
    }

    @NotNull
    public final Bytes component2() {
        return this.prePowHash;
    }

    public final long component3() {
        return this.blockNumber;
    }

    @NotNull
    public final PoWInput copy(@NotNull UInt256 target, @NotNull Bytes prePowHash, long blockNumber) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)prePowHash, (String)"prePowHash");
        return new PoWInput(target, prePowHash, blockNumber);
    }

    public static /* synthetic */ PoWInput copy$default(PoWInput poWInput, UInt256 uInt256, Bytes bytes, long l, int n, Object object) {
        if ((n & 1) != 0) {
            uInt256 = poWInput.target;
        }
        if ((n & 2) != 0) {
            bytes = poWInput.prePowHash;
        }
        if ((n & 4) != 0) {
            l = poWInput.blockNumber;
        }
        return poWInput.copy(uInt256, bytes, l);
    }

    @NotNull
    public String toString() {
        return "PoWInput(target=" + this.target + ", prePowHash=" + this.prePowHash + ", blockNumber=" + this.blockNumber + ")";
    }

    public int hashCode() {
        int result = this.target.hashCode();
        result = result * 31 + this.prePowHash.hashCode();
        result = result * 31 + Long.hashCode(this.blockNumber);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PoWInput)) {
            return false;
        }
        PoWInput poWInput = (PoWInput)other;
        if (!Intrinsics.areEqual((Object)this.target, (Object)poWInput.target)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.prePowHash, (Object)poWInput.prePowHash)) {
            return false;
        }
        return this.blockNumber == poWInput.blockNumber;
    }
}

