/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.progpow;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt32;
import org.apache.tuweni.units.bigints.UInt32Value;
import org.apache.tuweni.units.bigints.UInt32s;
import org.apache.tuweni.units.bigints.UInt64;

final class ProgPoWMath {
    ProgPoWMath() {
    }

    static UInt32 math(UInt32 a, UInt32 b, UInt32 r) {
        switch (r.mod(UInt32.valueOf((int)11)).intValue()) {
            case 0: {
                return a.add(b);
            }
            case 1: {
                return a.multiply(b);
            }
            case 2: {
                return ProgPoWMath.mul_hi(a, b);
            }
            case 3: {
                return (UInt32)UInt32s.min((UInt32Value)a, (UInt32Value)b);
            }
            case 4: {
                return ProgPoWMath.rotl32(a, b);
            }
            case 5: {
                return ProgPoWMath.rotr32(a, b);
            }
            case 6: {
                return a.and(b);
            }
            case 7: {
                return a.or(b);
            }
            case 8: {
                return a.xor(b);
            }
            case 9: {
                return ProgPoWMath.clz(a).add(ProgPoWMath.clz(b));
            }
            case 10: {
                return ProgPoWMath.popcount(a).add(ProgPoWMath.popcount(b));
            }
        }
        throw new IllegalArgumentException("Value " + r + " has mod larger than 11 " + r.mod(UInt32.valueOf((int)11).intValue()));
    }

    private static UInt32 mul_hi(UInt32 x, UInt32 y) {
        return UInt32.fromBytes((Bytes)UInt64.fromBytes((Bytes)x.toBytes()).multiply(UInt64.fromBytes((Bytes)y.toBytes())).toBytes().slice(0, 4));
    }

    private static UInt32 clz(UInt32 value) {
        return UInt32.valueOf((int)value.numberOfLeadingZeros());
    }

    private static UInt32 popcount(UInt32 value) {
        return UInt32.valueOf((int)Long.bitCount(value.toLong()));
    }

    static UInt32 rotl32(UInt32 var, UInt32 hops) {
        return var.shiftLeft(hops.mod(UInt32.valueOf((int)32)).intValue()).or(var.shiftRight(UInt32.valueOf((int)32).subtract(hops.mod(UInt32.valueOf((int)32))).intValue()));
    }

    static UInt32 rotr32(UInt32 var, UInt32 hops) {
        return var.shiftRight(hops.mod(UInt32.valueOf((int)32)).intValue()).or(var.shiftLeft(UInt32.valueOf((int)32).subtract(hops.mod(UInt32.valueOf((int)32))).intValue()));
    }
}

