/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt;

import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.scuttlebutt.Identity;

final class SECP256K1PublicKeyIdentity
implements Identity {
    private final SECP256K1.PublicKey publicKey;

    SECP256K1PublicKeyIdentity(SECP256K1.PublicKey keyPair) {
        this.publicKey = keyPair;
    }

    @Override
    public Bytes sign(Bytes message) {
        throw new UnsupportedOperationException("Cannot sign messages with a public key identity");
    }

    @Override
    public boolean verify(Bytes signature, Bytes message) {
        return SECP256K1.verify((Bytes)message, (SECP256K1.Signature)SECP256K1.Signature.fromBytes((Bytes)signature), (SECP256K1.PublicKey)this.publicKey);
    }

    @Override
    public String publicKeyAsBase64String() {
        return this.publicKey.bytes().toBase64String();
    }

    @Override
    public Identity.Curve curve() {
        return Identity.Curve.SECP256K1;
    }

    @Override
    public Signature.PublicKey ed25519PublicKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SECP256K1.PublicKey secp256k1PublicKey() {
        return this.publicKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SECP256K1PublicKeyIdentity identity = (SECP256K1PublicKeyIdentity)o;
        return this.publicKey.equals((Object)identity.publicKey);
    }

    public int hashCode() {
        return Objects.hash(this.publicKey);
    }

    public String toString() {
        return this.toCanonicalForm();
    }
}

