/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt;

import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.scuttlebutt.Identity;

final class Ed25519KeyPairIdentity
implements Identity {
    private final Signature.KeyPair keyPair;

    Ed25519KeyPairIdentity(Signature.KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    @Override
    public Bytes sign(Bytes message) {
        return Signature.signDetached((Bytes)message, (Signature.SecretKey)this.keyPair.secretKey());
    }

    @Override
    public boolean verify(Bytes signature, Bytes message) {
        return Signature.verifyDetached((Bytes)message, (Bytes)signature, (Signature.PublicKey)this.keyPair.publicKey());
    }

    @Override
    public String publicKeyAsBase64String() {
        return this.keyPair.publicKey().bytes().toBase64String();
    }

    @Override
    public Identity.Curve curve() {
        return Identity.Curve.Ed25519;
    }

    @Override
    public Signature.PublicKey ed25519PublicKey() {
        return this.keyPair.publicKey();
    }

    @Override
    public SECP256K1.PublicKey secp256k1PublicKey() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ed25519KeyPairIdentity identity = (Ed25519KeyPairIdentity)o;
        return this.keyPair.equals((Object)identity.keyPair);
    }

    public int hashCode() {
        return Objects.hash(this.keyPair);
    }

    public String toString() {
        return this.toCanonicalForm();
    }
}

