/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.faucet.controller;

import io.vertx.core.Vertx;
import java.net.ConnectException;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.faucet.controller.FaucetControllerKt;
import org.apache.tuweni.faucet.controller.FaucetRequest;
import org.apache.tuweni.jsonrpc.ClientRequestException;
import org.apache.tuweni.jsonrpc.JSONRPCClient;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.ethereum.Gas;
import org.apache.tuweni.units.ethereum.Wei;
import org.apache.tuweni.wallet.Wallet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;

@Controller
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010.\u001a\u00020/H\u0017J\u0010\u00100\u001a\u00020\"2\u0006\u00101\u001a\u000202H\u0017J\u001a\u00103\u001a\u00020\"2\b\b\u0001\u00104\u001a\u0002052\u0006\u00101\u001a\u000202H\u0017R\"\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u0004\u0018\u00010\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\u0004\u0018\u00010\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u001f\u0010\u0011\"\u0004\b \u0010\u0013R \u0010!\u001a\u0004\u0018\u00010\"8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010'\u001a\u0004\u0018\u00010\b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b(\u0010\n\"\u0004\b)\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u00066"}, d2={"Lorg/apache/tuweni/faucet/controller/FaucetController;", "", "vertx", "Lio/vertx/core/Vertx;", "wallet", "Lorg/apache/tuweni/wallet/Wallet;", "(Lio/vertx/core/Vertx;Lorg/apache/tuweni/wallet/Wallet;)V", "chainId", "", "getChainId", "()Ljava/lang/Integer;", "setChainId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "gas", "", "getGas", "()Ljava/lang/Long;", "setGas", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "gasPrice", "getGasPrice", "setGasPrice", "jsonrpcClient", "Lorg/apache/tuweni/jsonrpc/JSONRPCClient;", "getJsonrpcClient", "()Lorg/apache/tuweni/jsonrpc/JSONRPCClient;", "setJsonrpcClient", "(Lorg/apache/tuweni/jsonrpc/JSONRPCClient;)V", "maxETH", "getMaxETH", "setMaxETH", "rpcHost", "", "getRpcHost", "()Ljava/lang/String;", "setRpcHost", "(Ljava/lang/String;)V", "rpcPort", "getRpcPort", "setRpcPort", "getVertx", "()Lio/vertx/core/Vertx;", "getWallet", "()Lorg/apache/tuweni/wallet/Wallet;", "createClient", "", "index", "model", "Lorg/springframework/ui/Model;", "send", "request", "Lorg/apache/tuweni/faucet/controller/FaucetRequest;", "eth-faucet"})
public class FaucetController {
    @NotNull
    private final Vertx vertx;
    @NotNull
    private final Wallet wallet;
    @Nullable
    private JSONRPCClient jsonrpcClient;
    @Value(value="${faucet.chainId}")
    @Nullable
    private Integer chainId;
    @Value(value="${faucet.gasPrice}")
    @Nullable
    private Long gasPrice;
    @Value(value="${faucet.gas}")
    @Nullable
    private Long gas;
    @Value(value="${faucet.maxETH}")
    @Nullable
    private Long maxETH;
    @Value(value="${faucet.rpcPort}")
    @Nullable
    private Integer rpcPort;
    @Value(value="${faucet.rpcHost}")
    @Nullable
    private String rpcHost;

    public FaucetController(@Autowired @NotNull Vertx vertx, @Autowired @NotNull Wallet wallet) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)wallet, (String)"wallet");
        this.vertx = vertx;
        this.wallet = wallet;
    }

    @NotNull
    public Vertx getVertx() {
        return this.vertx;
    }

    @NotNull
    public Wallet getWallet() {
        return this.wallet;
    }

    @Nullable
    public JSONRPCClient getJsonrpcClient() {
        return this.jsonrpcClient;
    }

    public void setJsonrpcClient(@Nullable JSONRPCClient jSONRPCClient) {
        this.jsonrpcClient = jSONRPCClient;
    }

    @Nullable
    public Integer getChainId() {
        return this.chainId;
    }

    public void setChainId(@Nullable Integer n) {
        this.chainId = n;
    }

    @Nullable
    public Long getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(@Nullable Long l) {
        this.gasPrice = l;
    }

    @Nullable
    public Long getGas() {
        return this.gas;
    }

    public void setGas(@Nullable Long l) {
        this.gas = l;
    }

    @Nullable
    public Long getMaxETH() {
        return this.maxETH;
    }

    public void setMaxETH(@Nullable Long l) {
        this.maxETH = l;
    }

    @Nullable
    public Integer getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(@Nullable Integer n) {
        this.rpcPort = n;
    }

    @Nullable
    public String getRpcHost() {
        return this.rpcHost;
    }

    public void setRpcHost(@Nullable String string) {
        this.rpcHost = string;
    }

    @PostConstruct
    public void createClient() {
        this.setJsonrpcClient(new JSONRPCClient(this.getVertx(), "http://" + this.getRpcHost() + ":" + this.getRpcPort(), null, false, null, null, 60, null));
    }

    @GetMapping(value={"/"})
    @NotNull
    public String index(@NotNull Model model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        model.addAttribute("faucetRequest", (Object)new FaucetRequest("", null, ""));
        return "index";
    }

    @PostMapping(value={"/"})
    @NotNull
    public String send(@ModelAttribute @NotNull FaucetRequest request, @NotNull Model model) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        model.addAttribute("faucetRequest", (Object)request);
        Address addr = null;
        try {
            String string = request.getAddr();
            if (string == null) {
                string = "";
            }
            Address address = Address.fromHexString((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)address, (String)"fromHexString(request.addr ?: \"\")");
            addr = address;
        }
        catch (IllegalArgumentException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Invalid address";
            }
            request.setMessage(string);
            request.setAlertClass("alert-danger");
            return "index";
        }
        try {
            return (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, addr, request, null){
                Object L$0;
                int label;
                final /* synthetic */ FaucetController this$0;
                final /* synthetic */ Address $addr;
                final /* synthetic */ FaucetRequest $request;
                {
                    this.this$0 = $receiver;
                    this.$addr = $addr;
                    this.$request = $request;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = this.this$0.getJsonrpcClient();
                            Intrinsics.checkNotNull((Object)v0);
                            this.label = 1;
                            v1 = v0.getBalance_latest(this.$addr, (Continuation)this);
                            if (v1 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl15:
                            // 2 sources

                            balance = (UInt256)v1;
                            v2 = this.this$0.getMaxETH();
                            Intrinsics.checkNotNull((Object)v2);
                            v3 = lessThanMax = Wei.fromEth((long)v2).compareTo(balance) == 1;
                            if (!lessThanMax) {
                                this.$request.setMessage("Balance is more than this faucet gives.");
                                this.$request.setAlertClass("alert-primary");
                                return "index";
                            }
                            v4 = this.this$0.getMaxETH();
                            Intrinsics.checkNotNull((Object)v4);
                            missing = (Wei)Wei.fromEth((long)v4).subtract(balance);
                            v5 = this.this$0.getJsonrpcClient();
                            Intrinsics.checkNotNull((Object)v5);
                            this.L$0 = missing;
                            this.label = 2;
                            v6 = v5.getTransactionCount_latest(this.this$0.getWallet().address(), (Continuation)this);
                            if (v6 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl38
                        }
                        case 2: {
                            missing = (Wei)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
lbl38:
                            // 2 sources

                            nonce = (UInt256)v6;
                            FaucetControllerKt.getLogger().info("Sending " + missing + " to " + this.$addr);
                            v7 = this.this$0.getWallet();
                            v8 = this.this$0.getGasPrice();
                            Intrinsics.checkNotNull((Object)v8);
                            var7_7 = Wei.valueOf((long)v8);
                            Intrinsics.checkNotNullExpressionValue((Object)var7_7, (String)"valueOf(gasPrice!!)");
                            v9 = var7_7;
                            v10 = this.this$0.getGas();
                            Intrinsics.checkNotNull((Object)v10);
                            var7_7 = Gas.valueOf((long)v10);
                            Intrinsics.checkNotNullExpressionValue((Object)var7_7, (String)"valueOf(gas!!)");
                            v11 = var7_7;
                            Intrinsics.checkNotNullExpressionValue((Object)missing, (String)"missing");
                            var7_7 = Bytes.EMPTY;
                            Intrinsics.checkNotNullExpressionValue((Object)var7_7, (String)"EMPTY");
                            v12 = this.this$0.getChainId();
                            Intrinsics.checkNotNull((Object)v12);
                            tx = v7.sign(nonce, v9, (Gas)v11, this.$addr, missing, (Bytes)var7_7, v12);
                            FaucetControllerKt.getLogger().info("Transaction ready to send");
                            v13 = this.this$0.getJsonrpcClient();
                            Intrinsics.checkNotNull((Object)v13);
                            this.L$0 = null;
                            this.label = 3;
                            v14 = v13.sendRawTransaction(tx, (Continuation)this);
                            if (v14 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl69
                        }
                        case 3: {
                            ResultKt.throwOnFailure((Object)$result);
                            v14 = $result;
lbl69:
                            // 2 sources

                            txHash = (String)v14;
                            FaucetControllerKt.getLogger().info("Transaction sent to client with hash " + txHash);
                            this.$request.setMessage("Transaction hash: " + txHash);
                            this.$request.setAlertClass("alert-success");
                            return "index";
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        catch (ClientRequestException e) {
            request.setMessage(e.getMessage());
            request.setAlertClass("alert-danger");
            return "index";
        }
        catch (ConnectException e) {
            request.setMessage("Could not connect to a client. Try again later.");
            request.setAlertClass("alert-danger");
            return "index";
        }
    }
}

