/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.evm.impl.berlin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.evm.EVMExecutionStatusCode;
import org.apache.tuweni.evm.EVMMessage;
import org.apache.tuweni.evm.HostContext;
import org.apache.tuweni.evm.impl.GasManager;
import org.apache.tuweni.evm.impl.Memory;
import org.apache.tuweni.evm.impl.Opcode;
import org.apache.tuweni.evm.impl.Result;
import org.apache.tuweni.evm.impl.Stack;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt256Value;
import org.apache.tuweni.units.ethereum.Gas;
import org.apache.tuweni.units.ethereum.Wei;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\bz\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010{\u001a\b\u0012\u0004\u0012\u00020}0|2\u0006\u0010~\u001a\u00020\u007f\u001a\u0010\u0010\u0080\u0001\u001a\u00020\u00012\u0007\u0010\u0081\u0001\u001a\u00020}\u001a\u0010\u0010\u0082\u0001\u001a\u00020\u00012\u0007\u0010\u0083\u0001\u001a\u00020}\u001a\u0012\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001\u001a\u0010\u0010\u0088\u0001\u001a\u00020\u00012\u0007\u0010\u0086\u0001\u001a\u00020}\u001a\u0010\u0010\u0089\u0001\u001a\u00020\u00012\u0007\u0010\u0081\u0001\u001a\u00020}\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0003\"\u0011\u0010\f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0003\"\u0011\u0010\u000e\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0003\"\u0011\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0003\"\u0011\u0010\u0012\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0003\"\u0011\u0010\u0014\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0003\"\u0011\u0010\u0016\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0003\"\u0011\u0010\u0018\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0003\"\u0011\u0010\u001a\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0003\"\u0011\u0010\u001c\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0003\"\u0011\u0010\u001e\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0003\"\u0011\u0010 \u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0003\"\u0011\u0010\"\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0003\"\u0011\u0010$\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0003\"\u0011\u0010&\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0003\"\u0011\u0010(\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0003\"\u0011\u0010*\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0003\"\u0011\u0010,\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0003\"\u0011\u0010.\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0003\"\u0011\u00100\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0003\"\u0011\u00102\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0003\"\u0011\u00104\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0003\"\u0011\u00106\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0003\"\u0011\u00108\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0003\"\u0011\u00109\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0003\"\u0011\u0010;\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0003\"\u0011\u0010=\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0003\"\u0011\u0010?\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0003\"\u0011\u0010A\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u0003\"\u0011\u0010C\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u0003\"\u0011\u0010E\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u0003\"\u0011\u0010G\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\u0003\"\u0011\u0010I\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010\u0003\"\u0011\u0010K\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\u0003\"\u0011\u0010M\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010\u0003\"\u0011\u0010O\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010\u0003\"\u0011\u0010Q\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\u0003\"\u0011\u0010S\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010\u0003\"\u0011\u0010U\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\u0003\"\u0011\u0010W\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010\u0003\"\u0011\u0010Y\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010\u0003\"\u0011\u0010[\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010\u0003\"\u0011\u0010]\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010\u0003\"\u0011\u0010_\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010\u0003\"\u0011\u0010a\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010\u0003\"\u0011\u0010c\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010\u0003\"\u0011\u0010e\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010\u0003\"\u0011\u0010g\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010\u0003\"\u0011\u0010i\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010\u0003\"\u0011\u0010k\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010\u0003\"\u0011\u0010m\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bn\u0010\u0003\"\u0011\u0010o\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bp\u0010\u0003\"\u0011\u0010q\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010\u0003\"\u0011\u0010s\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010\u0003\"\u0011\u0010u\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bv\u0010\u0003\"\u0011\u0010w\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bx\u0010\u0003\"\u0011\u0010y\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\bz\u0010\u0003\u00a8\u0006\u008a\u0001"}, d2={"add", "Lorg/apache/tuweni/evm/impl/Opcode;", "getAdd", "()Lorg/apache/tuweni/evm/impl/Opcode;", "addmod", "getAddmod", "address", "getAddress", "and", "getAnd", "balance", "getBalance", "blockhash", "getBlockhash", "byte", "getByte", "calldatacopy", "getCalldatacopy", "calldataload", "getCalldataload", "calldatasize", "getCalldatasize", "caller", "getCaller", "callvalue", "getCallvalue", "codecopy", "getCodecopy", "codesize", "getCodesize", "coinbase", "getCoinbase", "difficulty", "getDifficulty", "div", "getDiv", "eq", "getEq", "exp", "getExp", "extcodecopy", "getExtcodecopy", "extcodehash", "getExtcodehash", "extcodesize", "getExtcodesize", "gas", "getGas", "gasLimit", "getGasLimit", "gasPrice", "getGasPrice", "gt", "getGt", "invalid", "getInvalid", "isZero", "jump", "getJump", "jumpdest", "getJumpdest", "jumpi", "getJumpi", "lt", "getLt", "mload", "getMload", "mod", "getMod", "msize", "getMsize", "mstore", "getMstore", "mstore8", "getMstore8", "mul", "getMul", "mulmod", "getMulmod", "not", "getNot", "number", "getNumber", "or", "getOr", "origin", "getOrigin", "pc", "getPc", "pop", "getPop", "retuRn", "getRetuRn", "returndatacopy", "getReturndatacopy", "returndatasize", "getReturndatasize", "sdiv", "getSdiv", "selfdestruct", "getSelfdestruct", "sgt", "getSgt", "sha3", "getSha3", "signextend", "getSignextend", "sload", "getSload", "slt", "getSlt", "smod", "getSmod", "sstore", "getSstore", "stop", "getStop", "sub", "getSub", "timestamp", "getTimestamp", "xor", "getXor", "computeValidJumpDestinations", "", "", "code", "Lorg/apache/tuweni/bytes/Bytes;", "dup", "index", "log", "topics", "memoryCost", "Lorg/apache/tuweni/units/ethereum/Gas;", "length", "Lorg/apache/tuweni/units/bigints/UInt256;", "push", "swap", "evm"})
public final class OpCodesKt {
    @NotNull
    private static final Opcode add = OpCodesKt::add$lambda-0;
    @NotNull
    private static final Opcode addmod = OpCodesKt::addmod$lambda-1;
    @NotNull
    private static final Opcode not = OpCodesKt::not$lambda-2;
    @NotNull
    private static final Opcode eq = OpCodesKt::eq$lambda-3;
    @NotNull
    private static final Opcode lt = OpCodesKt::lt$lambda-4;
    @NotNull
    private static final Opcode slt = OpCodesKt::slt$lambda-5;
    @NotNull
    private static final Opcode gt = OpCodesKt::gt$lambda-6;
    @NotNull
    private static final Opcode sgt = OpCodesKt::sgt$lambda-7;
    @NotNull
    private static final Opcode isZero = OpCodesKt::isZero$lambda-8;
    @NotNull
    private static final Opcode and = OpCodesKt::and$lambda-9;
    @NotNull
    private static final Opcode pop = OpCodesKt::pop$lambda-10;
    @NotNull
    private static final Opcode or = OpCodesKt::or$lambda-11;
    @NotNull
    private static final Opcode xor = OpCodesKt::xor$lambda-12;
    @NotNull
    private static final Opcode byte = OpCodesKt::byte$lambda-13;
    @NotNull
    private static final Opcode mul = OpCodesKt::mul$lambda-14;
    @NotNull
    private static final Opcode mod = OpCodesKt::mod$lambda-15;
    @NotNull
    private static final Opcode smod = OpCodesKt::smod$lambda-16;
    @NotNull
    private static final Opcode mulmod = OpCodesKt::mulmod$lambda-17;
    @NotNull
    private static final Opcode sub = OpCodesKt::sub$lambda-18;
    @NotNull
    private static final Opcode exp = OpCodesKt::exp$lambda-19;
    @NotNull
    private static final Opcode div = OpCodesKt::div$lambda-20;
    @NotNull
    private static final Opcode sstore = OpCodesKt::sstore$lambda-24;
    @NotNull
    private static final Opcode sload = OpCodesKt::sload$lambda-25;
    @NotNull
    private static final Opcode stop = OpCodesKt::stop$lambda-26;
    @NotNull
    private static final Opcode invalid = OpCodesKt::invalid$lambda-27;
    @NotNull
    private static final Opcode retuRn = OpCodesKt::retuRn$lambda-28;
    @NotNull
    private static final Opcode address = OpCodesKt::address$lambda-29;
    @NotNull
    private static final Opcode origin = OpCodesKt::origin$lambda-30;
    @NotNull
    private static final Opcode caller = OpCodesKt::caller$lambda-31;
    @NotNull
    private static final Opcode callvalue = OpCodesKt::callvalue$lambda-32;
    @NotNull
    private static final Opcode balance = OpCodesKt::balance$lambda-34;
    @NotNull
    private static final Opcode pc = OpCodesKt::pc$lambda-35;
    @NotNull
    private static final Opcode gasPrice = OpCodesKt::gasPrice$lambda-36;
    @NotNull
    private static final Opcode gas = OpCodesKt::gas$lambda-37;
    @NotNull
    private static final Opcode coinbase = OpCodesKt::coinbase$lambda-38;
    @NotNull
    private static final Opcode gasLimit = OpCodesKt::gasLimit$lambda-39;
    @NotNull
    private static final Opcode difficulty = OpCodesKt::difficulty$lambda-40;
    @NotNull
    private static final Opcode number = OpCodesKt::number$lambda-41;
    @NotNull
    private static final Opcode blockhash = OpCodesKt::blockhash$lambda-42;
    @NotNull
    private static final Opcode codesize = OpCodesKt::codesize$lambda-43;
    @NotNull
    private static final Opcode timestamp = OpCodesKt::timestamp$lambda-44;
    @NotNull
    private static final Opcode codecopy = OpCodesKt::codecopy$lambda-45;
    @NotNull
    private static final Opcode extcodecopy = OpCodesKt::extcodecopy$lambda-46;
    @NotNull
    private static final Opcode returndatasize = OpCodesKt::returndatasize$lambda-47;
    @NotNull
    private static final Opcode returndatacopy = OpCodesKt::returndatacopy$lambda-48;
    @NotNull
    private static final Opcode mstore = OpCodesKt::mstore$lambda-49;
    @NotNull
    private static final Opcode mstore8 = OpCodesKt::mstore8$lambda-50;
    @NotNull
    private static final Opcode mload = OpCodesKt::mload$lambda-51;
    @NotNull
    private static final Opcode extcodesize = OpCodesKt::extcodesize$lambda-52;
    @NotNull
    private static final Opcode extcodehash = OpCodesKt::extcodehash$lambda-53;
    @NotNull
    private static final Opcode msize = OpCodesKt::msize$lambda-54;
    @NotNull
    private static final Opcode calldatasize = OpCodesKt::calldatasize$lambda-55;
    @NotNull
    private static final Opcode calldatacopy = OpCodesKt::calldatacopy$lambda-56;
    @NotNull
    private static final Opcode calldataload = OpCodesKt::calldataload$lambda-57;
    @NotNull
    private static final Opcode sha3 = OpCodesKt::sha3$lambda-58;
    @NotNull
    private static final Opcode jump = OpCodesKt::jump$lambda-59;
    @NotNull
    private static final Opcode jumpi = OpCodesKt::jumpi$lambda-60;
    @NotNull
    private static final Opcode jumpdest = OpCodesKt::jumpdest$lambda-61;
    @NotNull
    private static final Opcode sdiv = OpCodesKt::sdiv$lambda-63;
    @NotNull
    private static final Opcode signextend = OpCodesKt::signextend$lambda-64;
    @NotNull
    private static final Opcode selfdestruct = OpCodesKt::selfdestruct$lambda-66;

    @NotNull
    public static final Opcode getAdd() {
        return add;
    }

    @NotNull
    public static final Opcode getAddmod() {
        return addmod;
    }

    @NotNull
    public static final Opcode getNot() {
        return not;
    }

    @NotNull
    public static final Opcode getEq() {
        return eq;
    }

    @NotNull
    public static final Opcode getLt() {
        return lt;
    }

    @NotNull
    public static final Opcode getSlt() {
        return slt;
    }

    @NotNull
    public static final Opcode getGt() {
        return gt;
    }

    @NotNull
    public static final Opcode getSgt() {
        return sgt;
    }

    @NotNull
    public static final Opcode isZero() {
        return isZero;
    }

    @NotNull
    public static final Opcode getAnd() {
        return and;
    }

    @NotNull
    public static final Opcode getPop() {
        return pop;
    }

    @NotNull
    public static final Opcode getOr() {
        return or;
    }

    @NotNull
    public static final Opcode getXor() {
        return xor;
    }

    @NotNull
    public static final Opcode getByte() {
        return byte;
    }

    @NotNull
    public static final Opcode getMul() {
        return mul;
    }

    @NotNull
    public static final Opcode getMod() {
        return mod;
    }

    @NotNull
    public static final Opcode getSmod() {
        return smod;
    }

    @NotNull
    public static final Opcode getMulmod() {
        return mulmod;
    }

    @NotNull
    public static final Opcode getSub() {
        return sub;
    }

    @NotNull
    public static final Opcode getExp() {
        return exp;
    }

    @NotNull
    public static final Opcode getDiv() {
        return div;
    }

    @NotNull
    public static final Opcode push(int length) {
        return (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7) -> OpCodesKt.push$lambda-21(length, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7);
    }

    @NotNull
    public static final Opcode dup(int index) {
        return (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7) -> OpCodesKt.dup$lambda-22(index, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7);
    }

    @NotNull
    public static final Opcode swap(int index) {
        return (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7) -> OpCodesKt.swap$lambda-23(index, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7);
    }

    @NotNull
    public static final Opcode getSstore() {
        return sstore;
    }

    @NotNull
    public static final Opcode getSload() {
        return sload;
    }

    @NotNull
    public static final Opcode getStop() {
        return stop;
    }

    @NotNull
    public static final Opcode getInvalid() {
        return invalid;
    }

    @NotNull
    public static final Opcode getRetuRn() {
        return retuRn;
    }

    @NotNull
    public static final Opcode getAddress() {
        return address;
    }

    @NotNull
    public static final Opcode getOrigin() {
        return origin;
    }

    @NotNull
    public static final Opcode getCaller() {
        return caller;
    }

    @NotNull
    public static final Opcode getCallvalue() {
        return callvalue;
    }

    @NotNull
    public static final Opcode getBalance() {
        return balance;
    }

    @NotNull
    public static final Opcode getPc() {
        return pc;
    }

    @NotNull
    public static final Opcode getGasPrice() {
        return gasPrice;
    }

    @NotNull
    public static final Opcode getGas() {
        return gas;
    }

    @NotNull
    public static final Opcode getCoinbase() {
        return coinbase;
    }

    @NotNull
    public static final Opcode getGasLimit() {
        return gasLimit;
    }

    @NotNull
    public static final Opcode getDifficulty() {
        return difficulty;
    }

    @NotNull
    public static final Opcode getNumber() {
        return number;
    }

    @NotNull
    public static final Opcode getBlockhash() {
        return blockhash;
    }

    @NotNull
    public static final Opcode getCodesize() {
        return codesize;
    }

    @NotNull
    public static final Opcode getTimestamp() {
        return timestamp;
    }

    @NotNull
    public static final Gas memoryCost(@NotNull UInt256 length) {
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        if (!length.fitsInt()) {
            Gas gas = Gas.TOO_HIGH;
            Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"TOO_HIGH");
            return gas;
        }
        Gas gas = Gas.valueOf((UInt256)length);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"valueOf(length)");
        Gas len = gas;
        Gas gas2 = len.multiply(len).divide(Gas.valueOf((long)512L));
        Intrinsics.checkNotNullExpressionValue((Object)gas2, (String)"len.multiply(len).divide(Gas.valueOf(512))");
        Gas base = gas2;
        gas2 = Gas.valueOf((long)3L).multiply(len).add(base);
        Intrinsics.checkNotNullExpressionValue((Object)gas2, (String)"valueOf(3).multiply(len).add(base)");
        return gas2;
    }

    @NotNull
    public static final Opcode getCodecopy() {
        return codecopy;
    }

    @NotNull
    public static final Opcode getExtcodecopy() {
        return extcodecopy;
    }

    @NotNull
    public static final Opcode getReturndatasize() {
        return returndatasize;
    }

    @NotNull
    public static final Opcode getReturndatacopy() {
        return returndatacopy;
    }

    @NotNull
    public static final Opcode getMstore() {
        return mstore;
    }

    @NotNull
    public static final Opcode getMstore8() {
        return mstore8;
    }

    @NotNull
    public static final Opcode getMload() {
        return mload;
    }

    @NotNull
    public static final Opcode getExtcodesize() {
        return extcodesize;
    }

    @NotNull
    public static final Opcode getExtcodehash() {
        return extcodehash;
    }

    @NotNull
    public static final Opcode getMsize() {
        return msize;
    }

    @NotNull
    public static final Opcode getCalldatasize() {
        return calldatasize;
    }

    @NotNull
    public static final Opcode getCalldatacopy() {
        return calldatacopy;
    }

    @NotNull
    public static final Opcode getCalldataload() {
        return calldataload;
    }

    @NotNull
    public static final Opcode getSha3() {
        return sha3;
    }

    @NotNull
    public static final Set<Integer> computeValidJumpDestinations(@NotNull Bytes code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        int index = 0;
        HashSet<Integer> destinations = new HashSet<Integer>();
        while (index < code.size()) {
            byte currentOpcode = code.get(index);
            if (currentOpcode == 91) {
                destinations.add(index);
            }
            if (currentOpcode >= 96 && currentOpcode < 128) {
                index += currentOpcode - 96 + 1;
            }
            int n = index;
            index = n + 1;
        }
        return destinations;
    }

    @NotNull
    public static final Opcode getJump() {
        return jump;
    }

    @NotNull
    public static final Opcode getJumpi() {
        return jumpi;
    }

    @NotNull
    public static final Opcode getJumpdest() {
        return jumpdest;
    }

    @NotNull
    public static final Opcode log(int topics) {
        return (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7) -> OpCodesKt.log$lambda-62(topics, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7);
    }

    @NotNull
    public static final Opcode getSdiv() {
        return sdiv;
    }

    @NotNull
    public static final Opcode getSignextend() {
        return signextend;
    }

    @NotNull
    public static final Opcode getSelfdestruct() {
        return selfdestruct;
    }

    private static final Result add$lambda-0(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            UInt256 uInt256 = item.add(item2);
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"item.add(item2)");
            stack.push((Bytes32)uInt256);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result addmod$lambda-1(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(8L);
        UInt256 operand1 = stack.pop();
        UInt256 operand2 = stack.pop();
        UInt256 mod = stack.pop();
        if (operand1 == null || operand2 == null || mod == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            UInt256 uInt256 = mod.isZero() ? UInt256.ZERO : operand1.addMod(operand2, mod);
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"if (mod.isZero) UInt256.\u2026nd1.addMod(operand2, mod)");
            stack.push((Bytes32)uInt256);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result not$lambda-2(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 item = stack.pop();
        if (item == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            UInt256 uInt256 = item.not();
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"item.not()");
            stack.push((Bytes32)uInt256);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result eq$lambda-3(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            if (item.equals((Object)item2)) {
                UInt256 uInt256 = UInt256.ONE;
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"ONE");
                stack.push((Bytes32)uInt256);
            } else {
                UInt256 uInt256 = UInt256.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"ZERO");
                stack.push((Bytes32)uInt256);
            }
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result lt$lambda-4(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            if (item.lessThan((UInt256Value)item2)) {
                UInt256 uInt256 = UInt256.ONE;
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"ONE");
                stack.push((Bytes32)uInt256);
            } else {
                UInt256 uInt256 = UInt256.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"ZERO");
                stack.push((Bytes32)uInt256);
            }
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result slt$lambda-5(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            if (item.toSignedBigInteger().compareTo(item2.toSignedBigInteger()) < 0) {
                UInt256 uInt256 = UInt256.ONE;
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"ONE");
                stack.push((Bytes32)uInt256);
            } else {
                UInt256 uInt256 = UInt256.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"ZERO");
                stack.push((Bytes32)uInt256);
            }
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result gt$lambda-6(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            if (item.greaterThan((UInt256Value)item2)) {
                UInt256 uInt256 = UInt256.ONE;
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"ONE");
                stack.push((Bytes32)uInt256);
            } else {
                UInt256 uInt256 = UInt256.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"ZERO");
                stack.push((Bytes32)uInt256);
            }
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result sgt$lambda-7(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            if (item.toSignedBigInteger().compareTo(item2.toSignedBigInteger()) > 0) {
                UInt256 uInt256 = UInt256.ONE;
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"ONE");
                stack.push((Bytes32)uInt256);
            } else {
                UInt256 uInt256 = UInt256.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"ZERO");
                stack.push((Bytes32)uInt256);
            }
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result isZero$lambda-8(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 item = stack.pop();
        if (item == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            UInt256 uInt256 = item.isZero() ? UInt256.ONE : UInt256.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"if (item.isZero) UInt256.ONE else UInt256.ZERO");
            stack.push((Bytes32)uInt256);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result and$lambda-9(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            UInt256 uInt256 = item.and(item2);
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"item.and(item2)");
            stack.push((Bytes32)uInt256);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result pop$lambda-10(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        if (stack.pop() == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result or$lambda-11(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            UInt256 uInt256 = item.or(item2);
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"item.or(item2)");
            stack.push((Bytes32)uInt256);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result xor$lambda-12(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            UInt256 uInt256 = item.xor(item2);
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"item.xor(item2)");
            stack.push((Bytes32)uInt256);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result byte$lambda-13(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 offset = stack.pop();
        UInt256 stackElement = stack.pop();
        if (offset == null || stackElement == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            if (!offset.fitsInt() || offset.intValue() >= 32) {
                UInt256 uInt256 = UInt256.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"ZERO");
                stack.push((Bytes32)uInt256);
            } else {
                byte[] byArray = new byte[]{stackElement.get(offset.intValue())};
                Bytes32 bytes32 = Bytes32.leftPad((Bytes)Bytes.of((byte[])byArray));
                Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"leftPad(Bytes.of(stackEl\u2026.get(offset.intValue())))");
                stack.push(bytes32);
            }
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result mul$lambda-14(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(5L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            UInt256 uInt256 = item.multiply(item2);
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"item.multiply(item2)");
            stack.push((Bytes32)uInt256);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result mod$lambda-15(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(5L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            UInt256 uInt256 = item.mod0(item2);
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"item.mod0(item2)");
            stack.push((Bytes32)uInt256);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result smod$lambda-16(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(5L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            UInt256 uInt256 = item.smod0(item2);
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"item.smod0(item2)");
            stack.push((Bytes32)uInt256);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result mulmod$lambda-17(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(8L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        UInt256 item3 = stack.pop();
        if (item == null || item2 == null || item3 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            if (item3.isZero()) {
                Bytes32 bytes32 = Bytes32.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"ZERO");
                stack.push(bytes32);
            } else {
                UInt256 uInt256 = item.multiplyMod(item2, item3);
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"item.multiplyMod(item2, item3)");
                stack.push((Bytes32)uInt256);
            }
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result sub$lambda-18(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            UInt256 uInt256 = item.subtract(item2);
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"item.subtract(item2)");
            stack.push((Bytes32)uInt256);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result exp$lambda-19(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        UInt256 number = stack.pop();
        UInt256 power = stack.pop();
        if (number == null || power == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            int numBytes = (power.bitLength() + 7) / 8;
            Gas cost = Gas.valueOf((long)50L).multiply(Gas.valueOf((long)numBytes)).add(Gas.valueOf((long)10L));
            Intrinsics.checkNotNullExpressionValue((Object)cost, (String)"cost");
            gasManager.add(cost);
            UInt256 uInt256 = number.pow(power);
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"number.pow(power)");
            UInt256 result2 = uInt256;
            stack.push((Bytes32)result2);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result div$lambda-20(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(5L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            UInt256 uInt256 = item2.isZero() ? UInt256.ZERO : item.divide(item2);
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"if (item2.isZero) UInt25\u2026O else item.divide(item2)");
            stack.push((Bytes32)uInt256);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result push$lambda-21(int $length, GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes code, int currentIndex, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        int minLength = Math.min($length, code.size() - currentIndex);
        Bytes32 bytes32 = Bytes32.leftPad((Bytes)code.slice(currentIndex, minLength));
        Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"leftPad(code.slice(currentIndex, minLength))");
        stack.push(bytes32);
        return new Result(null, currentIndex + minLength, null, null, 13, null);
    }

    private static final Result dup$lambda-22(int $index, GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 uInt256 = stack.get($index - 1);
        if (uInt256 == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 value = uInt256;
        stack.push((Bytes32)value);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result swap$lambda-23(int $index, GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 uInt256 = stack.get($index);
        if (uInt256 == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 eltN = uInt256;
        UInt256 uInt2562 = stack.pop();
        if (uInt2562 == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 elt0 = uInt2562;
        stack.push((Bytes32)eltN);
        stack.set($index, elt0);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result sstore$lambda-24(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage msg, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        return (Result)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result>, Object>(stack, gasManager, msg, hostContext, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            boolean Z$0;
            int label;
            final /* synthetic */ Stack $stack;
            final /* synthetic */ GasManager $gasManager;
            final /* synthetic */ EVMMessage $msg;
            final /* synthetic */ HostContext $hostContext;
            {
                this.$stack = $stack;
                this.$gasManager = $gasManager;
                this.$msg = $msg;
                this.$hostContext = $hostContext;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        key = this.$stack.pop();
                        value = this.$stack.pop();
                        if (key == null || value == null) {
                            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
                        }
                        remainingGas = this.$gasManager.gasLeft();
                        if (remainingGas.compareTo(2300L) <= 0) {
                            return new Result(EVMExecutionStatusCode.OUT_OF_GAS, null, null, null, 14, null);
                        }
                        address = this.$msg.getDestination();
                        slotIsWarm = this.$hostContext.warmUpStorage(address, key);
                        this.L$0 = key;
                        this.L$1 = value;
                        this.L$2 = address;
                        this.Z$0 = slotIsWarm;
                        this.label = 1;
                        v0 = this.$hostContext.getStorage(address, (Bytes32)key, (Continuation<? super Bytes32>)((Continuation)this));
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl30
                    }
                    case 1: {
                        slotIsWarm = this.Z$0;
                        address = (Address)this.L$2;
                        value = (UInt256)this.L$1;
                        key = (UInt256)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl30:
                        // 2 sources

                        if (!value.equals((Object)(currentValue = (Bytes32)v0))) ** GOTO lbl33
                        v1 = Gas.valueOf((long)100L);
                        ** GOTO lbl52
lbl33:
                        // 1 sources

                        this.L$0 = key;
                        this.L$1 = value;
                        this.L$2 = address;
                        this.L$3 = currentValue;
                        this.Z$0 = slotIsWarm;
                        this.label = 2;
                        v2 = this.$hostContext.getRepositoryStorage(address, (Bytes)key, (Continuation<? super Bytes32>)((Continuation)this));
                        if (v2 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl51
                    }
                    case 2: {
                        slotIsWarm = this.Z$0;
                        currentValue = (Bytes32)this.L$3;
                        address = (Address)this.L$2;
                        value = (UInt256)this.L$1;
                        key = (UInt256)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl51:
                        // 2 sources

                        v1 = (originalValue = (Bytes32)v2).equals(currentValue) ? (originalValue.isZero() ? Gas.valueOf((long)17900L) : Gas.valueOf((long)2900L)) : Gas.valueOf((long)100L);
lbl52:
                        // 2 sources

                        cost = v1.add(slotIsWarm != false ? Gas.ZERO : Gas.valueOf((long)2100L));
                        Intrinsics.checkNotNullExpressionValue((Object)cost, (String)"cost");
                        this.$gasManager.add(cost);
                        this.L$0 = null;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.label = 3;
                        v3 = this.$hostContext.setStorage(address, (Bytes)key, (Bytes32)value, (Continuation<? super Integer>)((Continuation)this));
                        if (v3 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl67
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl67:
                        // 2 sources

                        return new Result(null, null, null, null, 15, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Result> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final Result sload$lambda-25(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage msg, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        UInt256 uInt256 = stack.pop();
        if (uInt256 == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 key = uInt256;
        Address address = msg.getDestination();
        boolean slotIsWarm = hostContext.warmUpStorage(address, key);
        gasManager.add(slotIsWarm ? 100L : 2600L);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(stack, hostContext, address, key, null){
            Object L$0;
            int label;
            final /* synthetic */ Stack $stack;
            final /* synthetic */ HostContext $hostContext;
            final /* synthetic */ Address $address;
            final /* synthetic */ UInt256 $key;
            {
                this.$stack = $stack;
                this.$hostContext = $hostContext;
                this.$address = $address;
                this.$key = $key;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Stack stack = this.$stack;
                        this.L$0 = stack;
                        this.label = 1;
                        Object object3 = this.$hostContext.getStorage(this.$address, (Bytes32)this.$key, (Continuation<? super Bytes32>)((Continuation)this));
                        if (object3 != object2) return Boxing.boxBoolean((boolean)stack.push((Bytes32)object3));
                        return object2;
                    }
                    case 1: {
                        void $result;
                        Stack stack = (Stack)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Boxing.boxBoolean((boolean)stack.push((Bytes32)object3));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result stop$lambda-26(GasManager gasManager, HostContext $noName_1, Stack $noName_2, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)$noName_2, (String)"$noName_2");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(0L);
        return new Result(EVMExecutionStatusCode.SUCCESS, null, null, null, 14, null);
    }

    private static final Result invalid$lambda-27(GasManager $noName_0, HostContext $noName_1, Stack $noName_2, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)$noName_2, (String)"$noName_2");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        return new Result(EVMExecutionStatusCode.INVALID_INSTRUCTION, null, null, null, 14, null);
    }

    private static final Result retuRn$lambda-28(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory memory, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        UInt256 location = stack.pop();
        UInt256 length = stack.pop();
        if (location == null || length == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        Gas pre = OpCodesKt.memoryCost(memory.size());
        Gas post = OpCodesKt.memoryCost(memory.newSize(location, length));
        Gas gas = post.subtract(pre);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"post.subtract(pre)");
        gasManager.add(gas);
        Bytes output = memory.read(location, length);
        return new Result(EVMExecutionStatusCode.SUCCESS, null, output, null, 10, null);
    }

    private static final Result address$lambda-29(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage msg, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        Bytes32 bytes32 = Bytes32.leftPad((Bytes)((Bytes)msg.getDestination()));
        Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"leftPad(msg.destination)");
        stack.push(bytes32);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result origin$lambda-30(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage msg, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        Bytes32 bytes32 = Bytes32.leftPad((Bytes)((Bytes)msg.getSender()));
        Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"leftPad(msg.sender)");
        stack.push(bytes32);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result caller$lambda-31(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage msg, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        Bytes32 bytes32 = Bytes32.leftPad((Bytes)((Bytes)msg.getSender()));
        Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"leftPad(msg.sender)");
        stack.push(bytes32);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result callvalue$lambda-32(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage msg, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        Bytes32 bytes32 = Bytes32.leftPad((Bytes)msg.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"leftPad(msg.value)");
        stack.push(bytes32);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result balance$lambda-34(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Address address;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        UInt256 uInt256 = stack.pop();
        if (uInt256 == null) {
            address = null;
        } else {
            Bytes bytes = uInt256.slice(12, 20);
            if (bytes == null) {
                address = null;
            } else {
                Bytes it = bytes;
                boolean bl = false;
                address = Address.fromBytes((Bytes)it);
            }
        }
        Address address2 = address;
        if (address2 == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        Address address3 = address2;
        boolean accountIsWarm = hostContext.warmUpAccount(address3);
        if (accountIsWarm) {
            gasManager.add(100L);
        } else {
            gasManager.add(2600L);
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(stack, hostContext, address3, null){
            Object L$0;
            int label;
            final /* synthetic */ Stack $stack;
            final /* synthetic */ HostContext $hostContext;
            final /* synthetic */ Address $address;
            {
                this.$stack = $stack;
                this.$hostContext = $hostContext;
                this.$address = $address;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Stack stack = this.$stack;
                        this.L$0 = stack;
                        this.label = 1;
                        Object object3 = this.$hostContext.getBalance(this.$address, (Continuation<? super Wei>)((Continuation)this));
                        if (object3 != object2) return Boxing.boxBoolean((boolean)stack.push((Bytes32)object3));
                        return object2;
                    }
                    case 1: {
                        void $result;
                        Stack stack = (Stack)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Boxing.boxBoolean((boolean)stack.push((Bytes32)object3));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result pc$lambda-35(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int currentIndex, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        UInt256 uInt256 = UInt256.valueOf((long)((long)currentIndex - 1L));
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"valueOf(currentIndex.toLong() - 1)");
        stack.push((Bytes32)uInt256);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result gasPrice$lambda-36(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        Bytes32 bytes32 = Bytes32.leftPad((Bytes)((Bytes)hostContext.getGasPrice()));
        Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"leftPad(hostContext.getGasPrice())");
        stack.push(bytes32);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result gas$lambda-37(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        UInt256 uInt256 = UInt256.valueOf((long)gasManager.gasLeft().toLong());
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"valueOf(gasManager.gasLeft().toLong())");
        stack.push((Bytes32)uInt256);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result coinbase$lambda-38(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        Bytes32 bytes32 = Bytes32.leftPad((Bytes)((Bytes)hostContext.getCoinbase()));
        Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"leftPad(hostContext.getCoinbase())");
        stack.push(bytes32);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result gasLimit$lambda-39(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        UInt256 uInt256 = UInt256.valueOf((long)hostContext.getGasLimit());
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"valueOf(hostContext.getGasLimit())");
        stack.push((Bytes32)uInt256);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result difficulty$lambda-40(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        stack.push((Bytes32)hostContext.getDifficulty());
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result number$lambda-41(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        UInt256 uInt256 = UInt256.valueOf((long)hostContext.getBlockNumber());
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"valueOf(hostContext.getBlockNumber())");
        stack.push((Bytes32)uInt256);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result blockhash$lambda-42(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(20L);
        UInt256 uInt256 = stack.pop();
        if (uInt256 == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 number = uInt256;
        if (!number.fitsLong() || number.toLong() < hostContext.getBlockNumber() - (long)256) {
            UInt256 uInt2562 = UInt256.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)uInt2562, (String)"ZERO");
            stack.push((Bytes32)uInt2562);
        } else {
            UInt256 uInt2563 = UInt256.fromBytes((Bytes)((Bytes)hostContext.getBlockHash(number.toLong())));
            Intrinsics.checkNotNullExpressionValue((Object)uInt2563, (String)"fromBytes(hostContext.ge\u2026ockHash(number.toLong()))");
            stack.push((Bytes32)uInt2563);
        }
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result codesize$lambda-43(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes code, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        UInt256 uInt256 = UInt256.valueOf((long)code.size());
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"valueOf(code.size().toLong())");
        stack.push((Bytes32)uInt256);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result timestamp$lambda-44(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        stack.push((Bytes32)hostContext.timestamp());
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result codecopy$lambda-45(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes code, int $noName_5, Memory memory, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        UInt256 memOffset = stack.pop();
        UInt256 sourceOffset = stack.pop();
        UInt256 length = stack.pop();
        if (memOffset == null || sourceOffset == null || length == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 uInt256 = length.divideCeil(32L);
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"length.divideCeil(Bytes32.SIZE.toLong())");
        UInt256 numWords = uInt256;
        Gas copyCost = Gas.valueOf((long)3L).multiply(Gas.valueOf((UInt256)numWords)).add(Gas.valueOf((long)3L));
        Gas pre = OpCodesKt.memoryCost(memory.size());
        Gas post = OpCodesKt.memoryCost(memory.newSize(memOffset, length));
        Gas memoryCost = post.subtract(pre);
        Gas gas = copyCost.add(memoryCost);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"copyCost.add(memoryCost)");
        gasManager.add(gas);
        memory.write(memOffset, sourceOffset, length, code);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result extcodecopy$lambda-46(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory memory, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        UInt256 address = stack.pop();
        UInt256 memOffset = stack.pop();
        UInt256 sourceOffset = stack.pop();
        UInt256 length = stack.pop();
        if (address == null || memOffset == null || sourceOffset == null || length == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 uInt256 = length.divideCeil(32L);
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"length.divideCeil(Bytes32.SIZE.toLong())");
        UInt256 numWords = uInt256;
        Gas copyCost = Gas.valueOf((long)3L).multiply(Gas.valueOf((UInt256)numWords)).add(Gas.valueOf((long)3L));
        Gas pre = org.apache.tuweni.evm.impl.istanbul.OpCodesKt.memoryCost(memory.size());
        Gas post = org.apache.tuweni.evm.impl.istanbul.OpCodesKt.memoryCost(memory.newSize(memOffset, length));
        Gas memoryCost = post.subtract(pre);
        Gas gas = copyCost.add(memoryCost);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"copyCost.add(memoryCost)");
        gasManager.add(gas);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(hostContext, address, memory, memOffset, sourceOffset, length, null){
            int label;
            final /* synthetic */ HostContext $hostContext;
            final /* synthetic */ UInt256 $address;
            final /* synthetic */ Memory $memory;
            final /* synthetic */ UInt256 $memOffset;
            final /* synthetic */ UInt256 $sourceOffset;
            final /* synthetic */ UInt256 $length;
            {
                this.$hostContext = $hostContext;
                this.$address = $address;
                this.$memory = $memory;
                this.$memOffset = $memOffset;
                this.$sourceOffset = $sourceOffset;
                this.$length = $length;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_3 = Address.fromBytes((Bytes)this.$address.slice(12, 20));
                        Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"fromBytes(address.slice(12, 20))");
                        this.label = 1;
                        v0 = this.$hostContext.getCode(var3_3, (Continuation<? super Bytes>)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        code = (Bytes)v0;
                        return Boxing.boxBoolean((boolean)this.$memory.write(this.$memOffset, this.$sourceOffset, this.$length, code));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result returndatasize$lambda-47(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result callResult) {
        long l;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        Result result = callResult;
        if (result == null) {
            l = 0L;
        } else {
            Bytes bytes = result.getOutput();
            if (bytes == null) {
                l = 0L;
            } else {
                long l2;
                int n = bytes.size();
                l = l2 = (long)n;
            }
        }
        UInt256 uInt256 = UInt256.valueOf((long)l);
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"valueOf(callResult?.outp\u2026?.size()?.toLong() ?: 0L)");
        stack.push((Bytes32)uInt256);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result returndatacopy$lambda-48(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory memory, Result callResult) {
        Bytes returnData;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        UInt256 memOffset = stack.pop();
        UInt256 sourceOffset = stack.pop();
        UInt256 length = stack.pop();
        Result result = callResult;
        Object object = result == null ? null : result.getOutput();
        if (object == null) {
            object = returnData = Bytes.EMPTY;
        }
        if (memOffset == null || sourceOffset == null || length == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 uInt256 = length.divideCeil(32L);
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"length.divideCeil(Bytes32.SIZE.toLong())");
        UInt256 numWords = uInt256;
        Gas copyCost = Gas.valueOf((long)3L).multiply(Gas.valueOf((UInt256)numWords)).add(Gas.valueOf((long)3L));
        Gas pre = org.apache.tuweni.evm.impl.istanbul.OpCodesKt.memoryCost(memory.size());
        Gas post = org.apache.tuweni.evm.impl.istanbul.OpCodesKt.memoryCost(memory.newSize(memOffset, length));
        Gas memoryCost = post.subtract(pre);
        Gas gas = copyCost.add(memoryCost);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"copyCost.add(memoryCost)");
        gasManager.add(gas);
        Intrinsics.checkNotNullExpressionValue((Object)returnData, (String)"returnData");
        memory.write(memOffset, sourceOffset, length, returnData);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result mstore$lambda-49(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory memory, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        UInt256 location = stack.pop();
        UInt256 value = stack.pop();
        if (location == null || value == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        Gas pre = OpCodesKt.memoryCost(memory.size());
        UInt256 uInt256 = UInt256.valueOf((long)32L);
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"valueOf(32)");
        Gas post = OpCodesKt.memoryCost(memory.newSize(location, uInt256));
        Gas memoryCost = post.subtract(pre);
        Gas gas = Gas.valueOf((long)3L).add(memoryCost);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"valueOf(3L).add(memoryCost)");
        gasManager.add(gas);
        gas = UInt256.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"ZERO");
        Gas gas2 = gas;
        gas = UInt256.valueOf((long)32L);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"valueOf(32)");
        memory.write(location, (UInt256)gas2, (UInt256)gas, (Bytes)value);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result mstore8$lambda-50(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory memory, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        UInt256 location = stack.pop();
        UInt256 value = stack.pop();
        if (location == null || value == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        Gas pre = OpCodesKt.memoryCost(memory.size());
        UInt256 uInt256 = UInt256.valueOf((long)1L);
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"valueOf(1)");
        Gas post = OpCodesKt.memoryCost(memory.newSize(location, uInt256));
        Gas memoryCost = post.subtract(pre);
        Gas gas = Gas.valueOf((long)3L).add(memoryCost);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"valueOf(3L).add(memoryCost)");
        gasManager.add(gas);
        gas = UInt256.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"ZERO");
        Gas gas2 = gas;
        gas = UInt256.valueOf((long)1L);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"valueOf(1)");
        Gas gas3 = gas;
        gas = value.slice(31, 1);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"value.slice(31, 1)");
        memory.write(location, (UInt256)gas2, (UInt256)gas3, (Bytes)gas);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result mload$lambda-51(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory memory, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        UInt256 uInt256 = stack.pop();
        if (uInt256 == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 location = uInt256;
        Gas pre = OpCodesKt.memoryCost(memory.size());
        UInt256 uInt2562 = UInt256.valueOf((long)32L);
        Intrinsics.checkNotNullExpressionValue((Object)uInt2562, (String)"valueOf(32)");
        Gas post = OpCodesKt.memoryCost(memory.newSize(location, uInt2562));
        Gas memoryCost = post.subtract(pre);
        Gas gas = Gas.valueOf((long)3L).add(memoryCost);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"valueOf(3L).add(memoryCost)");
        gasManager.add(gas);
        UInt256 uInt2563 = UInt256.valueOf((long)32L);
        Intrinsics.checkNotNullExpressionValue((Object)uInt2563, (String)"valueOf(32)");
        Bytes bytes = memory.read(location, uInt2563);
        if (bytes == null) {
            bytes = Bytes.EMPTY;
        }
        gas = Bytes32.leftPad((Bytes)bytes);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"leftPad(memory.read(loca\u2026ueOf(32)) ?: Bytes.EMPTY)");
        stack.push((Bytes32)gas);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result extcodesize$lambda-52(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage msg, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(700L);
        return (Result)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result>, Object>(stack, hostContext, msg, null){
            Object L$0;
            int label;
            final /* synthetic */ Stack $stack;
            final /* synthetic */ HostContext $hostContext;
            final /* synthetic */ EVMMessage $msg;
            {
                this.$stack = $stack;
                this.$hostContext = $hostContext;
                this.$msg = $msg;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_3 = this.$stack;
                        this.L$0 = var3_3;
                        this.label = 1;
                        v0 = this.$hostContext.getCode(this.$msg.getDestination(), (Continuation<? super Bytes>)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        var3_3 = (Stack)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        var2_4 = UInt256.valueOf((long)((Bytes)v0).size());
                        Intrinsics.checkNotNullExpressionValue((Object)var2_4, (String)"valueOf(hostContext.getC\u2026ination).size().toLong())");
                        var3_3.push((Bytes32)var2_4);
                        return new Result(null, null, null, null, 15, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Result> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final Result extcodehash$lambda-53(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage msg, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(700L);
        return (Result)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result>, Object>(stack, hostContext, msg, null){
            Object L$0;
            int label;
            final /* synthetic */ Stack $stack;
            final /* synthetic */ HostContext $hostContext;
            final /* synthetic */ EVMMessage $msg;
            {
                this.$stack = $stack;
                this.$hostContext = $hostContext;
                this.$msg = $msg;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_3 = this.$stack;
                        this.L$0 = var3_3;
                        this.label = 1;
                        v0 = this.$hostContext.getCode(this.$msg.getDestination(), (Continuation<? super Bytes>)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        var3_3 = (Stack)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        var2_4 = Hash.keccak256((Bytes)((Bytes)v0));
                        Intrinsics.checkNotNullExpressionValue((Object)var2_4, (String)"keccak256(hostContext.getCode(msg.destination))");
                        var3_3.push(var2_4);
                        return new Result(null, null, null, null, 15, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Result> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final Result msize$lambda-54(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory memory, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        gasManager.add(2L);
        stack.push((Bytes32)memory.allocatedBytes());
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result calldatasize$lambda-55(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage msg, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(2L);
        UInt256 uInt256 = UInt256.valueOf((long)msg.getInputData().size());
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"valueOf(msg.inputData.size().toLong())");
        stack.push((Bytes32)uInt256);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result calldatacopy$lambda-56(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage msg, Bytes $noName_4, int $noName_5, Memory memory, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        UInt256 memOffset = stack.pop();
        UInt256 sourceOffset = stack.pop();
        UInt256 length = stack.pop();
        if (memOffset == null || sourceOffset == null || length == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 uInt256 = length.divideCeil(32L);
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"length.divideCeil(Bytes32.SIZE.toLong())");
        UInt256 numWords = uInt256;
        Gas copyCost = Gas.valueOf((long)3L).multiply(Gas.valueOf((UInt256)numWords)).add(Gas.valueOf((long)3L));
        Gas pre = OpCodesKt.memoryCost(memory.size());
        Gas post = OpCodesKt.memoryCost(memory.newSize(memOffset, length));
        Gas memoryCost = post.subtract(pre);
        Gas gas = copyCost.add(memoryCost);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"copyCost.add(memoryCost)");
        gasManager.add(gas);
        memory.write(memOffset, sourceOffset, length, msg.getInputData());
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result calldataload$lambda-57(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage msg, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Bytes32 bytes32;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(3L);
        UInt256 uInt256 = stack.pop();
        if (uInt256 == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 start = uInt256;
        boolean set = false;
        if (start.fitsInt() && msg.getInputData().size() > start.intValue()) {
            bytes32 = Bytes32.rightPad((Bytes)msg.getInputData().slice(start.intValue(), Math.min(32, msg.getInputData().size() - start.intValue())));
            Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"rightPad(\n          msg.\u2026())\n          )\n        )");
            stack.push(bytes32);
            set = true;
        }
        if (!set) {
            bytes32 = Bytes32.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"ZERO");
            stack.push(bytes32);
        }
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result sha3$lambda-58(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory memory, Result $noName_7) {
        Bytes bytes;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        UInt256 from = stack.pop();
        UInt256 length = stack.pop();
        if (from == null || length == null) {
            return new Result(EVMExecutionStatusCode.OUT_OF_GAS, null, null, null, 14, null);
        }
        UInt256 uInt256 = length.divideCeil(32L);
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"length.divideCeil(Bytes32.SIZE.toLong())");
        UInt256 numWords = uInt256;
        Gas copyCost = Gas.valueOf((long)6L).multiply(Gas.valueOf((UInt256)numWords)).add(Gas.valueOf((long)30L));
        Gas pre = OpCodesKt.memoryCost(memory.size());
        Gas post = OpCodesKt.memoryCost(memory.newSize(from, length));
        Gas memoryCost = post.subtract(pre);
        Gas gas = copyCost.add(memoryCost);
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"copyCost.add(memoryCost)");
        gasManager.add(gas);
        Bytes bytes2 = bytes = memory.read(from, length);
        Bytes32 bytes32 = bytes2 == null ? Bytes32.ZERO : Hash.keccak256((Bytes)bytes2);
        Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"if (bytes == null) Bytes\u2026lse Hash.keccak256(bytes)");
        stack.push(bytes32);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result jump$lambda-59(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes code, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(8L);
        UInt256 uInt256 = stack.pop();
        if (uInt256 == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 jumpDest = uInt256;
        if (!jumpDest.fitsInt() || jumpDest.intValue() >= code.size()) {
            return new Result(EVMExecutionStatusCode.BAD_JUMP_DESTINATION, null, null, null, 14, null);
        }
        Set<Integer> validDestinations = OpCodesKt.computeValidJumpDestinations(code);
        if (!validDestinations.contains(jumpDest.intValue())) {
            return new Result(EVMExecutionStatusCode.BAD_JUMP_DESTINATION, null, null, null, 14, null);
        }
        return new Result(null, jumpDest.intValue(), null, null, 13, null);
    }

    private static final Result jumpi$lambda-60(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes code, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(10L);
        UInt256 uInt256 = stack.pop();
        if (uInt256 == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 jumpDest = uInt256;
        UInt256 uInt2562 = stack.pop();
        if (uInt2562 == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        UInt256 condition = uInt2562;
        if (condition.isZero()) {
            return new Result(null, null, null, null, 15, null);
        }
        if (!jumpDest.fitsInt() || jumpDest.intValue() >= code.size()) {
            return new Result(EVMExecutionStatusCode.BAD_JUMP_DESTINATION, null, null, null, 14, null);
        }
        Set<Integer> validDestinations = OpCodesKt.computeValidJumpDestinations(code);
        if (!validDestinations.contains(jumpDest.intValue())) {
            return new Result(EVMExecutionStatusCode.BAD_JUMP_DESTINATION, null, null, null, 14, null);
        }
        return new Result(null, jumpDest.intValue(), null, null, 13, null);
    }

    private static final Result jumpdest$lambda-61(GasManager gasManager, HostContext $noName_1, Stack $noName_2, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)$noName_2, (String)"$noName_2");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(1L);
        return new Result(null, null, null, null, 15, null);
    }

    private static final Result log$lambda-62(int $topics, GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage msg, Bytes $noName_4, int $noName_5, Memory memory, Result $noName_7) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        UInt256 location = stack.pop();
        UInt256 length = stack.pop();
        if (location == null || length == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        Gas cost = Gas.valueOf((long)375L).add(Gas.valueOf((long)8L).multiply(Gas.valueOf((UInt256)length))).add(Gas.valueOf((long)375L).multiply(Gas.valueOf((long)$topics)));
        Gas pre = OpCodesKt.memoryCost(memory.size());
        Gas post = OpCodesKt.memoryCost(memory.newSize(location, length));
        Gas gas = cost.add(post.subtract(pre));
        Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"cost.add(post.subtract(pre))");
        gasManager.add(gas);
        Address address = msg.getDestination();
        Bytes data = memory.read(location, length);
        List topicList = new ArrayList();
        int n = 0;
        while (n < $topics) {
            int i = n++;
            UInt256 uInt256 = stack.pop();
            if (uInt256 == null) {
                return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
            }
            topicList.add(uInt256);
        }
        Bytes bytes = data;
        if (bytes == null) {
            bytes = Bytes.EMPTY;
        }
        Bytes bytes2 = bytes;
        Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"data ?: Bytes.EMPTY");
        hostContext.emitLog(address, bytes2, CollectionsKt.toList((Iterable)topicList));
        return data == null ? new Result(null, null, null, EVMExecutionStatusCode.INVALID_MEMORY_ACCESS, 7, null) : new Result(null, null, null, null, 15, null);
    }

    private static final Result sdiv$lambda-63(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(5L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            UInt256 uInt256 = item.sdiv0(item2);
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"item.sdiv0(item2)");
            stack.push((Bytes32)uInt256);
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result signextend$lambda-64(GasManager gasManager, HostContext $noName_1, Stack stack, EVMMessage $noName_3, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)$noName_3, (String)"$noName_3");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        gasManager.add(5L);
        UInt256 item = stack.pop();
        UInt256 item2 = stack.pop();
        if (item == null || item2 == null) {
            result = new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        } else {
            if (!item.fitsInt() || item.intValue() > 31) {
                stack.push((Bytes32)item2);
            } else {
                int byteIndex = 31 - item.getInt(28);
                UInt256 uInt256 = UInt256.fromBytes((Bytes)((Bytes)Bytes32.leftPad((Bytes)item2.slice(byteIndex), (byte)(item2.get(byteIndex) < 0 ? (byte)-1 : 0))));
                Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"fromBytes(\n          Byt\u2026x00\n          )\n        )");
                stack.push((Bytes32)uInt256);
            }
            result = new Result(null, null, null, null, 15, null);
        }
        return result;
    }

    private static final Result selfdestruct$lambda-66(GasManager gasManager, HostContext hostContext, Stack stack, EVMMessage msg, Bytes $noName_4, int $noName_5, Memory $noName_6, Result $noName_7) {
        Address address;
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter((Object)hostContext, (String)"hostContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)$noName_4, (String)"$noName_4");
        Intrinsics.checkNotNullParameter((Object)$noName_6, (String)"$noName_6");
        UInt256 uInt256 = stack.pop();
        if (uInt256 == null) {
            address = null;
        } else {
            Bytes bytes = uInt256.slice(12, 20);
            if (bytes == null) {
                address = null;
            } else {
                Bytes it = bytes;
                boolean bl = false;
                address = Address.fromBytes((Bytes)it);
            }
        }
        if (address == null) {
            return new Result(EVMExecutionStatusCode.STACK_UNDERFLOW, null, null, null, 14, null);
        }
        Address recipientAddress = address;
        return (Result)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result>, Object>(hostContext, recipientAddress, gasManager, msg, null){
            Object L$0;
            boolean Z$0;
            int label;
            final /* synthetic */ HostContext $hostContext;
            final /* synthetic */ Address $recipientAddress;
            final /* synthetic */ GasManager $gasManager;
            final /* synthetic */ EVMMessage $msg;
            {
                this.$hostContext = $hostContext;
                this.$recipientAddress = $recipientAddress;
                this.$gasManager = $gasManager;
                this.$msg = $msg;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$hostContext.getBalance(this.$recipientAddress, (Continuation<? super Wei>)((Continuation)this));
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        inheritance = (Wei)v0;
                        accountIsWarm = this.$hostContext.warmUpAccount(this.$recipientAddress);
                        this.L$0 = inheritance;
                        this.Z$0 = accountIsWarm;
                        this.label = 2;
                        v1 = this.$hostContext.accountExists(this.$recipientAddress, (Continuation<? super Boolean>)((Continuation)this));
                        if (v1 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        accountIsWarm = this.Z$0;
                        inheritance = (Wei)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl27:
                        // 2 sources

                        cost = ((Boolean)v1 != false && inheritance.isZero() == false ? Gas.valueOf((long)30000L) : Gas.valueOf((long)5000L)).add(accountIsWarm != false ? Gas.ZERO : Gas.valueOf((long)2600L));
                        Intrinsics.checkNotNullExpressionValue((Object)cost, (String)"cost");
                        this.$gasManager.add(cost);
                        address = this.$msg.getDestination();
                        this.L$0 = null;
                        this.label = 3;
                        v2 = this.$hostContext.selfdestruct(address, this.$recipientAddress, (Continuation<? super Unit>)((Continuation)this));
                        if (v2 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl40
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl40:
                        // 2 sources

                        return new Result(EVMExecutionStatusCode.SUCCESS, null, null, null, 14, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Result> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }
}

