/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.evm.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.evm.EVMExecutionStatusCode;
import org.apache.tuweni.evm.EVMMessage;
import org.apache.tuweni.evm.EVMResult;
import org.apache.tuweni.evm.EthereumVirtualMachineKt;
import org.apache.tuweni.evm.EvmVm;
import org.apache.tuweni.evm.HardFork;
import org.apache.tuweni.evm.HostContext;
import org.apache.tuweni.evm.impl.GasManager;
import org.apache.tuweni.evm.impl.Memory;
import org.apache.tuweni.evm.impl.OpcodeRegistry;
import org.apache.tuweni.evm.impl.Result;
import org.apache.tuweni.evm.impl.Stack;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0011\u0010\u0005\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J1\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lorg/apache/tuweni/evm/impl/EvmVmImpl;", "Lorg/apache/tuweni/evm/EvmVm;", "()V", "capabilities", "", "close", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "execute", "Lorg/apache/tuweni/evm/EVMResult;", "hostContext", "Lorg/apache/tuweni/evm/HostContext;", "fork", "Lorg/apache/tuweni/evm/HardFork;", "msg", "Lorg/apache/tuweni/evm/EVMMessage;", "code", "Lorg/apache/tuweni/bytes/Bytes;", "(Lorg/apache/tuweni/evm/HostContext;Lorg/apache/tuweni/evm/HardFork;Lorg/apache/tuweni/evm/EVMMessage;Lorg/apache/tuweni/bytes/Bytes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setOption", "key", "", "value", "version", "Companion", "evm"})
public final class EvmVmImpl
implements EvmVm {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final OpcodeRegistry registry = OpcodeRegistry.Companion.create();
    private static final Logger logger = LoggerFactory.getLogger(EvmVmImpl.class);

    @Override
    public void setOption(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented"));
    }

    @Override
    @NotNull
    public String version() {
        return "0.0.1";
    }

    @Override
    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object execute(@NotNull HostContext hostContext, @NotNull HardFork fork, @NotNull EVMMessage msg, @NotNull Bytes code, @NotNull Continuation<? super EVMResult> $completion) {
        byte by;
        Result result;
        Object opcode;
        logger.trace("Code: " + code);
        Stack stack = new Stack(0, 1, null);
        int current = 0;
        GasManager gasManager = new GasManager(msg.getGas());
        Memory memory = new Memory();
        List executionPath = new ArrayList();
        while (current < code.size()) {
            String string;
            int i;
            if (logger.isTraceEnabled()) {
                logger.trace("Stack contents (" + stack.size() + "):");
                int n = 0;
                int n2 = stack.size();
                while (n < n2) {
                    i = n++;
                    UInt256 uInt256 = stack.get(i);
                    logger.trace(i + " - " + (String)(uInt256 == null ? null : uInt256.toHexString()));
                }
            }
            executionPath.add(Boxing.boxByte((byte)code.get(current)));
            opcode = registry.get(fork, code.get(current));
            if (opcode == null) {
                logger.error("Could not find opcode for " + code.slice(current, 1) + " at position " + current);
                return new EVMResult(EVMExecutionStatusCode.INVALID_INSTRUCTION, gasManager, hostContext, null, 8, null);
            }
            byte currentOpcodeByte = code.get(current);
            i = current;
            current = i + 1;
            result = opcode.execute(gasManager, hostContext, stack, msg, code, current, memory, null);
            Object object = EthereumVirtualMachineKt.getOpcodes().get(Boxing.boxByte((byte)currentOpcodeByte));
            if (object == null) {
                String string2 = Integer.toString(currentOpcodeByte, CharsKt.checkRadix((int)CharsKt.checkRadix((int)16)));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
                string = string2;
            } else {
                string = object;
            }
            logger.trace(">> OPCODE: " + string + " gas: " + gasManager.gasLeft() + " cost: " + gasManager.lastGasCost());
            Result result2 = result;
            if ((result2 == null ? null : result2.getStatus()) != null) {
                if (logger.isTraceEnabled()) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    object = executionPath;
                    Logger logger = EvmVmImpl.logger;
                    boolean $i$f$map = false;
                    void var16_24 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        String string3;
                        void it;
                        byte by2 = ((Number)item$iv$iv).byteValue();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String string4 = EthereumVirtualMachineKt.getOpcodes().get(Boxing.boxByte((byte)it));
                        if (string4 == null) {
                            String string5 = Integer.toString((int)it, CharsKt.checkRadix((int)CharsKt.checkRadix((int)16)));
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this, checkRadix(radix))");
                            string3 = string5;
                        } else {
                            string3 = string4;
                        }
                        collection.add(string3);
                    }
                    logger.trace(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)">", null, null, (int)0, null, null, (int)62, null));
                }
                if (result.getStatus() == EVMExecutionStatusCode.SUCCESS && !gasManager.hasGasLeft()) {
                    return new EVMResult(EVMExecutionStatusCode.OUT_OF_GAS, gasManager, hostContext, null, 8, null);
                }
                return new EVMResult(result.getStatus(), gasManager, hostContext, result.getOutput());
            }
            Result result3 = result;
            if (result3 != null) {
                Integer n = result3.getNewCodePosition();
                if (n != null) {
                    int it = ((Number)n).intValue();
                    by = 0;
                    current = result.getNewCodePosition();
                }
            }
            if (!gasManager.hasGasLeft()) {
                return new EVMResult(EVMExecutionStatusCode.OUT_OF_GAS, gasManager, hostContext, null, 8, null);
            }
            if (stack.overflowed()) {
                return new EVMResult(EVMExecutionStatusCode.STACK_OVERFLOW, gasManager, hostContext, null, 8, null);
            }
            Result result4 = result;
            if ((result4 == null ? null : result4.getValidationStatus()) == null) continue;
            return new EVMResult(result.getValidationStatus(), gasManager, hostContext, null, 8, null);
        }
        if (logger.isTraceEnabled()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            opcode = executionPath;
            Logger logger = EvmVmImpl.logger;
            boolean $i$f$map = false;
            result = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void it;
                by = ((Number)item$iv$iv).byteValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string6 = EthereumVirtualMachineKt.getOpcodes().get(Boxing.boxByte((byte)it));
                if (string6 == null) {
                    String string7 = Integer.toString((int)it, CharsKt.checkRadix((int)CharsKt.checkRadix((int)16)));
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(this, checkRadix(radix))");
                    string = string7;
                } else {
                    string = string6;
                }
                collection.add(string);
            }
            logger.trace(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)">", null, null, (int)0, null, null, (int)62, null));
        }
        return new EVMResult(EVMExecutionStatusCode.SUCCESS, gasManager, hostContext, null, 8, null);
    }

    @Override
    public int capabilities() {
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented"));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/apache/tuweni/evm/impl/EvmVmImpl$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "registry", "Lorg/apache/tuweni/evm/impl/OpcodeRegistry;", "getRegistry", "()Lorg/apache/tuweni/evm/impl/OpcodeRegistry;", "create", "Lorg/apache/tuweni/evm/EvmVm;", "evm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EvmVm create() {
            return new EvmVmImpl();
        }

        @NotNull
        public final OpcodeRegistry getRegistry() {
            return registry;
        }

        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

