/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.repository;

import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.eth.AccountState;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.Block;
import org.apache.tuweni.eth.BlockBody;
import org.apache.tuweni.eth.BlockHeader;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.eth.Transaction;
import org.apache.tuweni.eth.TransactionReceipt;
import org.apache.tuweni.eth.repository.BlockHeaderFields;
import org.apache.tuweni.eth.repository.BlockchainIndex;
import org.apache.tuweni.eth.repository.BlockchainIndexWriter;
import org.apache.tuweni.eth.repository.BlockchainRepository;
import org.apache.tuweni.eth.repository.TransactionReceiptFields;
import org.apache.tuweni.kv.KeyValueStore;
import org.apache.tuweni.kv.MapKeyValueStore;
import org.apache.tuweni.trie.MerkleStorage;
import org.apache.tuweni.trie.StoredMerklePatriciaTrie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 |2\u00020\u0001:\u0001|B\u009b\u0001\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u001a\u0010-\u001a\u00020\u00172\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018J\u0006\u0010/\u001a\u00020\u001aJ\u0014\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u00103\u001a\u00020\u0004J\u0014\u00104\u001a\b\u0012\u0004\u0012\u000202012\u0006\u00105\u001a\u00020\u0004J\u001b\u00106\u001a\u0004\u0018\u0001072\u0006\u0010*\u001a\u00020+H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u001b\u00108\u001a\u0004\u0018\u00010\u00042\u0006\u0010*\u001a\u00020+H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J#\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010*\u001a\u00020+2\u0006\u0010;\u001a\u00020:H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0019\u0010=\u001a\u00020$2\u0006\u0010>\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u0019\u0010@\u001a\u00020$2\u0006\u0010>\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u0019\u0010A\u001a\u00020\u001a2\u0006\u0010B\u001a\u00020\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010CJ1\u0010D\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u0004H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010JJ\u0011\u0010K\u001a\u00020\u001aH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010LJ!\u0010M\u001a\u00020\u001a2\u0006\u0010N\u001a\u00020O2\u0006\u0010B\u001a\u00020\u0019H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010PJ\u000e\u0010Q\u001a\u00020\u001a2\u0006\u0010R\u001a\u00020\u0017J\u001b\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010>\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u001b\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010>\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u001b\u0010W\u001a\u0004\u0018\u00010\u00042\u0006\u0010>\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u001b\u0010X\u001a\u0004\u0018\u00010\u00192\u0006\u0010>\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u001b\u0010Y\u001a\u0004\u0018\u00010\u00042\u0006\u0010>\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u0011\u0010Z\u001a\u00020TH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010LJ\u0011\u0010[\u001a\u00020\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010LJ\u0011\u0010\\\u001a\u00020TH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010LJ'\u0010]\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0004012\f\u0010^\u001a\b\u0012\u0004\u0012\u00020201H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010_J#\u0010`\u001a\u0004\u0018\u00010F2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010a\u001a\u00020HH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010bJ\u001b\u0010`\u001a\u0004\u0018\u00010F2\u0006\u0010I\u001a\u000202H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010cJ\u001f\u0010d\u001a\b\u0012\u0004\u0012\u00020F012\u0006\u0010>\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u0019\u0010e\u001a\u00020\u001a2\u0006\u0010f\u001a\u00020TH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010gJ!\u0010h\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010i\u001a\u000207H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010jJ\u0019\u0010k\u001a\u00020\u001a2\u0006\u0010f\u001a\u00020TH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010gJ!\u0010l\u001a\u00020\u001a2\u0006\u0010>\u001a\u0002022\u0006\u0010m\u001a\u00020VH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010nJ\u0019\u0010o\u001a\u00020\u001a2\u0006\u0010B\u001a\u00020\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010CJ\u0019\u0010p\u001a\u00020\u001a2\u0006\u0010q\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J!\u0010r\u001a\u00020\u001a2\u0006\u0010s\u001a\u0002022\u0006\u0010t\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010uJ\u0019\u0010v\u001a\u00020\u001a2\u0006\u0010w\u001a\u00020xH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010yJ1\u0010z\u001a\u00020\u001a2\u0006\u0010{\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010JR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00180\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006}"}, d2={"Lorg/apache/tuweni/eth/repository/BlockchainRepository;", "Lkotlinx/coroutines/CoroutineScope;", "chainMetadata", "Lorg/apache/tuweni/kv/KeyValueStore;", "Lorg/apache/tuweni/bytes/Bytes;", "blockBodyStore", "blockHeaderStore", "transactionReceiptStore", "transactionStore", "stateStore", "blockchainIndex", "Lorg/apache/tuweni/eth/repository/BlockchainIndex;", "meter", "Lio/opentelemetry/api/metrics/Meter;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lorg/apache/tuweni/kv/KeyValueStore;Lorg/apache/tuweni/kv/KeyValueStore;Lorg/apache/tuweni/kv/KeyValueStore;Lorg/apache/tuweni/kv/KeyValueStore;Lorg/apache/tuweni/kv/KeyValueStore;Lorg/apache/tuweni/kv/KeyValueStore;Lorg/apache/tuweni/eth/repository/BlockchainIndex;Lio/opentelemetry/api/metrics/Meter;Lkotlin/coroutines/CoroutineContext;)V", "blockBodiesStoredCounter", "Lio/opentelemetry/api/metrics/LongCounter;", "getBlockBodiesStoredCounter", "()Lio/opentelemetry/api/metrics/LongCounter;", "blockHeaderListeners", "", "", "Lkotlin/Function1;", "Lorg/apache/tuweni/eth/BlockHeader;", "", "getBlockHeaderListeners", "()Ljava/util/Map;", "blockHeadersStoredCounter", "getBlockHeadersStoredCounter", "blocksStoredCounter", "getBlocksStoredCounter", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "indexing", "", "getIndexing", "()Z", "setIndexing", "(Z)V", "accountsExists", "address", "Lorg/apache/tuweni/eth/Address;", "(Lorg/apache/tuweni/eth/Address;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addBlockHeaderListener", "listener", "close", "findBlockByHashOrNumber", "", "Lorg/apache/tuweni/eth/Hash;", "blockNumberOrBlockHash", "findBlocksByParentHash", "parentHash", "getAccount", "Lorg/apache/tuweni/eth/AccountState;", "getAccountCode", "getAccountStoreValue", "Lorg/apache/tuweni/bytes/Bytes32;", "key", "(Lorg/apache/tuweni/eth/Address;Lorg/apache/tuweni/bytes/Bytes32;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasBlockBody", "blockHash", "(Lorg/apache/tuweni/bytes/Bytes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasBlockHeader", "indexBlockHeader", "header", "(Lorg/apache/tuweni/eth/BlockHeader;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indexTransactionReceipt", "txReceipt", "Lorg/apache/tuweni/eth/TransactionReceipt;", "txIndex", "", "txHash", "(Lorg/apache/tuweni/eth/TransactionReceipt;ILorg/apache/tuweni/bytes/Bytes;Lorg/apache/tuweni/bytes/Bytes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reIndexTotalDifficulty", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reIndexTotalDifficultyInternal", "writer", "Lorg/apache/tuweni/eth/repository/BlockchainIndexWriter;", "(Lorg/apache/tuweni/eth/repository/BlockchainIndexWriter;Lorg/apache/tuweni/eth/BlockHeader;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeBlockHeaderListener", "listenerId", "retrieveBlock", "Lorg/apache/tuweni/eth/Block;", "retrieveBlockBody", "Lorg/apache/tuweni/eth/BlockBody;", "retrieveBlockBodyBytes", "retrieveBlockHeader", "retrieveBlockHeaderBytes", "retrieveChainHead", "retrieveChainHeadHeader", "retrieveGenesisBlock", "retrieveNodeData", "hashes", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveTransactionReceipt", "index", "(Lorg/apache/tuweni/bytes/Bytes;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lorg/apache/tuweni/eth/Hash;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveTransactionReceipts", "setGenesisBlock", "block", "(Lorg/apache/tuweni/eth/Block;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "storeAccount", "account", "(Lorg/apache/tuweni/eth/Address;Lorg/apache/tuweni/eth/AccountState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "storeBlock", "storeBlockBody", "blockBody", "(Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/eth/BlockBody;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "storeBlockHeader", "storeCode", "code", "storeNodeData", "hash", "bytes", "(Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/bytes/Bytes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "storeTransaction", "transaction", "Lorg/apache/tuweni/eth/Transaction;", "(Lorg/apache/tuweni/eth/Transaction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "storeTransactionReceipt", "transactionReceipt", "Companion", "eth-repository"})
public final class BlockchainRepository
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeyValueStore<Bytes, Bytes> chainMetadata;
    @NotNull
    private final KeyValueStore<Bytes, Bytes> blockBodyStore;
    @NotNull
    private final KeyValueStore<Bytes, Bytes> blockHeaderStore;
    @NotNull
    private final KeyValueStore<Bytes, Bytes> transactionReceiptStore;
    @NotNull
    private final KeyValueStore<Bytes, Bytes> transactionStore;
    @NotNull
    private final KeyValueStore<Bytes, Bytes> stateStore;
    @NotNull
    private final BlockchainIndex blockchainIndex;
    @Nullable
    private final Meter meter;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final Map<String, Function1<BlockHeader, Unit>> blockHeaderListeners;
    @Nullable
    private final LongCounter blocksStoredCounter;
    @Nullable
    private final LongCounter blockHeadersStoredCounter;
    @Nullable
    private final LongCounter blockBodiesStoredCounter;
    private boolean indexing;
    private static final Logger logger = LoggerFactory.getLogger(BlockchainRepository.class);
    private static final Bytes GENESIS_BLOCK;

    public BlockchainRepository(@NotNull KeyValueStore<Bytes, Bytes> chainMetadata, @NotNull KeyValueStore<Bytes, Bytes> blockBodyStore, @NotNull KeyValueStore<Bytes, Bytes> blockHeaderStore, @NotNull KeyValueStore<Bytes, Bytes> transactionReceiptStore, @NotNull KeyValueStore<Bytes, Bytes> transactionStore, @NotNull KeyValueStore<Bytes, Bytes> stateStore, @NotNull BlockchainIndex blockchainIndex, @Nullable Meter meter, @NotNull CoroutineContext coroutineContext) {
        Object object;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter(chainMetadata, (String)"chainMetadata");
        Intrinsics.checkNotNullParameter(blockBodyStore, (String)"blockBodyStore");
        Intrinsics.checkNotNullParameter(blockHeaderStore, (String)"blockHeaderStore");
        Intrinsics.checkNotNullParameter(transactionReceiptStore, (String)"transactionReceiptStore");
        Intrinsics.checkNotNullParameter(transactionStore, (String)"transactionStore");
        Intrinsics.checkNotNullParameter(stateStore, (String)"stateStore");
        Intrinsics.checkNotNullParameter((Object)blockchainIndex, (String)"blockchainIndex");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.chainMetadata = chainMetadata;
        this.blockBodyStore = blockBodyStore;
        this.blockHeaderStore = blockHeaderStore;
        this.transactionReceiptStore = transactionReceiptStore;
        this.transactionStore = transactionStore;
        this.stateStore = stateStore;
        this.blockchainIndex = blockchainIndex;
        this.meter = meter;
        this.coroutineContext = coroutineContext;
        this.blockHeaderListeners = new LinkedHashMap();
        Meter meter2 = this.meter;
        if (meter2 == null) {
            object3 = null;
        } else {
            LongCounterBuilder longCounterBuilder = meter2.longCounterBuilder("blocks_stored");
            if (longCounterBuilder == null) {
                object3 = null;
            } else {
                LongCounterBuilder longCounterBuilder2 = longCounterBuilder.setDescription("Number of blocks stored");
                object3 = longCounterBuilder2 == null ? null : longCounterBuilder2.build();
            }
        }
        this.blocksStoredCounter = object3;
        Meter meter3 = this.meter;
        if (meter3 == null) {
            object2 = null;
        } else {
            LongCounterBuilder longCounterBuilder = meter3.longCounterBuilder("block_headers_stored");
            if (longCounterBuilder == null) {
                object2 = null;
            } else {
                LongCounterBuilder longCounterBuilder3 = longCounterBuilder.setDescription("Number of block headers stored");
                object2 = longCounterBuilder3 == null ? null : longCounterBuilder3.build();
            }
        }
        this.blockHeadersStoredCounter = object2;
        Meter meter4 = this.meter;
        if (meter4 == null) {
            object = null;
        } else {
            LongCounterBuilder longCounterBuilder = meter4.longCounterBuilder("blocks_bodies_stored");
            if (longCounterBuilder == null) {
                object = null;
            } else {
                LongCounterBuilder longCounterBuilder4 = longCounterBuilder.setDescription("Number of block bodies stored");
                object = longCounterBuilder4 == null ? null : longCounterBuilder4.build();
            }
        }
        this.blockBodiesStoredCounter = object;
        this.indexing = true;
    }

    public /* synthetic */ BlockchainRepository(KeyValueStore keyValueStore, KeyValueStore keyValueStore2, KeyValueStore keyValueStore3, KeyValueStore keyValueStore4, KeyValueStore keyValueStore5, KeyValueStore keyValueStore6, BlockchainIndex blockchainIndex, Meter meter, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            meter = null;
        }
        if ((n & 0x100) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this((KeyValueStore<Bytes, Bytes>)keyValueStore, (KeyValueStore<Bytes, Bytes>)keyValueStore2, (KeyValueStore<Bytes, Bytes>)keyValueStore3, (KeyValueStore<Bytes, Bytes>)keyValueStore4, (KeyValueStore<Bytes, Bytes>)keyValueStore5, (KeyValueStore<Bytes, Bytes>)keyValueStore6, blockchainIndex, meter, coroutineContext);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @NotNull
    public final Map<String, Function1<BlockHeader, Unit>> getBlockHeaderListeners() {
        return this.blockHeaderListeners;
    }

    @Nullable
    public final LongCounter getBlocksStoredCounter() {
        return this.blocksStoredCounter;
    }

    @Nullable
    public final LongCounter getBlockHeadersStoredCounter() {
        return this.blockHeadersStoredCounter;
    }

    @Nullable
    public final LongCounter getBlockBodiesStoredCounter() {
        return this.blockBodiesStoredCounter;
    }

    public final boolean getIndexing() {
        return this.indexing;
    }

    public final void setIndexing(boolean bl) {
        this.indexing = bl;
    }

    @Nullable
    public final Object storeBlockBody(@NotNull Hash blockHash, @NotNull BlockBody blockBody, @NotNull Continuation<? super Unit> $completion) {
        LongCounter longCounter = this.getBlockBodiesStoredCounter();
        if (longCounter != null) {
            longCounter.add(1L);
        }
        Bytes bytes = blockBody.toBytes();
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"blockBody.toBytes()");
        Object object = this.blockBodyStore.put((Object)blockHash, (Object)bytes, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object storeNodeData(@NotNull Hash hash, @NotNull Bytes bytes, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.stateStore.put((Object)hash, (Object)bytes, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object storeBlock(@NotNull Block var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof storeBlock.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.storeBlock(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getBlocksStoredCounter();
                if (v0 != null) {
                    v0.add(1L);
                }
                var3_6 = block.getHeader().getHash();
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"block.getHeader().getHash()");
                v1 = var3_6;
                var3_6 = block.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"block.getBody()");
                $continuation.L$0 = this;
                $continuation.L$1 = block;
                $continuation.label = 1;
                v2 = this.storeBlockBody(v1, (BlockBody)var3_6, (Continuation<? super Unit>)$continuation);
                if (v2 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl32
            }
            case 1: {
                block = (Block)$continuation.L$1;
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl32:
                // 2 sources

                var3_6 = block.getHeader().getHash();
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"block.getHeader().getHash()");
                v3 = var3_6;
                var3_6 = block.getHeader().toBytes();
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"block.getHeader().toBytes()");
                $continuation.L$0 = this;
                $continuation.L$1 = block;
                $continuation.label = 2;
                v4 = this.blockHeaderStore.put((Object)v3, (Object)var3_6, (Continuation)$continuation);
                if (v4 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl49
            }
            case 2: {
                block = (Block)$continuation.L$1;
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl49:
                // 2 sources

                var3_6 = block.getHeader();
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"block.getHeader()");
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v5 = this.indexBlockHeader((BlockHeader)var3_6, (Continuation<? super Unit>)$continuation);
                if (v5 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl61
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl61:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object storeTransactionReceipt(@NotNull TransactionReceipt var1_1, int var2_2, @NotNull Bytes var3_3, @NotNull Bytes var4_4, @NotNull Continuation<? super Unit> var5_5) {
        if (!(var5_5 instanceof storeTransactionReceipt.1)) ** GOTO lbl-1000
        var8_6 = var5_5;
        if ((var8_6.label & -2147483648) != 0) {
            var8_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.storeTransactionReceipt(null, 0, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_9 = transactionReceipt.toBytes();
                Intrinsics.checkNotNullExpressionValue((Object)var6_9, (String)"transactionReceipt.toBytes()");
                $continuation.L$0 = this;
                $continuation.L$1 = transactionReceipt;
                $continuation.L$2 = txHash;
                $continuation.L$3 = blockHash;
                $continuation.I$0 = txIndex;
                $continuation.label = 1;
                v0 = this.transactionReceiptStore.put((Object)txHash, (Object)var6_9, (Continuation)$continuation);
                if (v0 == var9_8) {
                    return var9_8;
                }
                ** GOTO lbl32
            }
            case 1: {
                txIndex = $continuation.I$0;
                blockHash = (Bytes)$continuation.L$3;
                txHash = (Bytes)$continuation.L$2;
                transactionReceipt = (TransactionReceipt)$continuation.L$1;
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 2;
                v1 = this.indexTransactionReceipt(transactionReceipt, txIndex, txHash, blockHash, (Continuation<? super Unit>)$continuation);
                if (v1 == var9_8) {
                    return var9_8;
                }
                ** GOTO lbl44
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl44:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object storeBlockHeader(@NotNull BlockHeader var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof storeBlockHeader.1)) ** GOTO lbl-1000
        var10_3 = var2_2;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.storeBlockHeader(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getBlockHeadersStoredCounter();
                if (v0 != null) {
                    v0.add(1L);
                }
                var3_6 = header.getHash();
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"header.hash");
                v1 = var3_6;
                var3_6 = header.toBytes();
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"header.toBytes()");
                $continuation.L$0 = this;
                $continuation.L$1 = header;
                $continuation.label = 1;
                v2 = this.blockHeaderStore.put((Object)v1, (Object)var3_6, (Continuation)$continuation);
                if (v2 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl32
            }
            case 1: {
                header = (BlockHeader)$continuation.L$1;
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl32:
                // 2 sources

                if (this.getIndexing()) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = header;
                    $continuation.label = 2;
                    v3 = this.indexBlockHeader(header, (Continuation<? super Unit>)$continuation);
                    if (v3 == var11_5) {
                        return var11_5;
                    }
                }
                ** GOTO lbl45
            }
            case 2: {
                header = (BlockHeader)$continuation.L$1;
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl45:
                // 2 sources

                BlockchainRepository.logger.debug("Stored header {} {}", (Object)header.getNumber(), (Object)header.getHash());
                $this$forEach$iv = this.getBlockHeaderListeners().values();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (Function1)element$iv;
                    $i$a$-forEach-BlockchainRepository$storeBlockHeader$2 = false;
                    it.invoke((Object)header);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final String addBlockHeaderListener(@NotNull Function1<? super BlockHeader, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String uuid = string;
        this.blockHeaderListeners.put(uuid, listener);
        return uuid;
    }

    public final void removeBlockHeaderListener(@NotNull String listenerId) {
        Intrinsics.checkNotNullParameter((Object)listenerId, (String)"listenerId");
        this.blockHeaderListeners.remove(listenerId);
    }

    @Nullable
    public final Object indexBlockHeader(@NotNull BlockHeader header, @NotNull Continuation<? super Unit> $completion) {
        logger.info("Indexing " + header.getNumber() + " " + header.getHash());
        this.blockchainIndex.index((Function1<? super BlockchainIndexWriter, Unit>)((Function1)new Function1<BlockchainIndexWriter, Unit>(header, this){
            final /* synthetic */ BlockHeader $header;
            final /* synthetic */ BlockchainRepository this$0;
            {
                this.$header = $header;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BlockchainIndexWriter writer) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                writer.indexBlockHeader(this.$header, this.this$0.getIndexing());
            }
        }));
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object reIndexTotalDifficulty(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof reIndexTotalDifficulty.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.reIndexTotalDifficulty((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.retrieveGenesisBlock((Continuation<? super Block>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                header = ((Block)v0).getHeader();
                this.blockchainIndex.index((Function1<? super BlockchainIndexWriter, Unit>)((Function1)new Function1<BlockchainIndexWriter, Unit>(this, header){
                    final /* synthetic */ BlockchainRepository this$0;
                    final /* synthetic */ BlockHeader $header;
                    {
                        this.this$0 = $receiver;
                        this.$header = $header;
                        super(1);
                    }

                    public final void invoke(@NotNull BlockchainIndexWriter writer) {
                        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, writer, this.$header, null){
                            int label;
                            final /* synthetic */ BlockchainRepository this$0;
                            final /* synthetic */ BlockchainIndexWriter $writer;
                            final /* synthetic */ BlockHeader $header;
                            {
                                this.this$0 = $receiver;
                                this.$writer = $writer;
                                this.$header = $header;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        BlockHeader blockHeader = this.$header;
                                        Intrinsics.checkNotNullExpressionValue((Object)blockHeader, (String)"header");
                                        this.label = 1;
                                        Object object3 = BlockchainRepository.access$reIndexTotalDifficultyInternal(this.this$0, this.$writer, blockHeader, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                    }
                }));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object reIndexTotalDifficultyInternal(BlockchainIndexWriter var1_1, BlockHeader var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof reIndexTotalDifficultyInternal.1)) ** GOTO lbl-1000
        var15_4 = var3_3;
        if ((var15_4.label & -2147483648) != 0) {
            var15_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BlockchainRepository.access$reIndexTotalDifficultyInternal(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                writer.indexTotalDifficulty((BlockHeader)header);
                var4_7 = header.getHash();
                Intrinsics.checkNotNullExpressionValue((Object)var4_7, (String)"header.getHash()");
                $this$map$iv = this.findBlocksByParentHash((Bytes)var4_7);
                $i$f$map = false;
                var6_9 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var9_12 = $this$mapTo$iv$iv.iterator();
lbl21:
                // 2 sources

                while (var9_12.hasNext()) {
                    item$iv$iv = var9_12.next();
                    var11_14 = (Hash)item$iv$iv;
                    var13_16 = destination$iv$iv;
                    $i$a$-map-BlockchainRepository$reIndexTotalDifficultyInternal$2 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = writer;
                    $continuation.L$2 = destination$iv$iv;
                    $continuation.L$3 = var9_12;
                    $continuation.L$4 = var13_16;
                    $continuation.label = 1;
                    v0 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Deferred<? extends Unit>>, Object>(this, (Hash)hash, writer, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ BlockchainRepository this$0;
                        final /* synthetic */ Hash $hash;
                        final /* synthetic */ BlockchainIndexWriter $writer;
                        {
                            this.this$0 = $receiver;
                            this.$hash = $hash;
                            this.$writer = $writer;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                                    return BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$hash, this.$writer, null){
                                        int label;
                                        final /* synthetic */ BlockchainRepository this$0;
                                        final /* synthetic */ Hash $hash;
                                        final /* synthetic */ BlockchainIndexWriter $writer;
                                        {
                                            this.this$0 = $receiver;
                                            this.$hash = $hash;
                                            this.$writer = $writer;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object var1_1) {
                                            var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                    this.label = 1;
                                                    v0 = BlockchainRepository.access$getBlockHeaderStore$p(this.this$0).get((Object)this.$hash, (Continuation)this);
                                                    if (v0 == var8_2) {
                                                        return var8_2;
                                                    }
                                                    ** GOTO lbl13
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
lbl13:
                                                    // 2 sources

                                                    v1 = (Bytes)v0;
                                                    if (v1 != null) ** GOTO lbl17
                                                    v2 = null;
                                                    ** GOTO lbl34
lbl17:
                                                    // 1 sources

                                                    var2_3 = v1;
                                                    var3_4 = this.this$0;
                                                    var4_5 = this.$writer;
                                                    bytes = var2_3;
                                                    $i$a$-let-BlockchainRepository$reIndexTotalDifficultyInternal$2$1$1$1 = false;
                                                    var7_9 = BlockHeader.fromBytes((Bytes)bytes);
                                                    Intrinsics.checkNotNullExpressionValue((Object)var7_9, (String)"fromBytes(bytes)");
                                                    this.label = 2;
                                                    v3 = BlockchainRepository.access$reIndexTotalDifficultyInternal(var3_4, var4_5, var7_9, (Continuation)this);
                                                    if (v3 == var8_2) {
                                                        return var8_2;
                                                    }
                                                    ** GOTO lbl33
                                                }
                                                case 2: {
                                                    $i$a$-let-BlockchainRepository$reIndexTotalDifficultyInternal$2$1$1$1 = false;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v3 = $result;
lbl33:
                                                    // 2 sources

                                                    v2 = Unit.INSTANCE;
lbl34:
                                                    // 2 sources

                                                    return v2;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Deferred<Unit>> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var16_6) {
                        return var16_6;
                    }
                    ** GOTO lbl48
                }
                break;
            }
            case 1: {
                $i$f$map = false;
                $i$f$mapTo = false;
                $i$a$-map-BlockchainRepository$reIndexTotalDifficultyInternal$2 = false;
                var13_16 = (Collection)$continuation.L$4;
                var9_12 = (Iterator<T>)$continuation.L$3;
                destination$iv$iv = (Collection)$continuation.L$2;
                writer = (BlockchainIndexWriter)$continuation.L$1;
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl48:
                // 2 sources

                var13_16.add((Deferred)v0);
                ** GOTO lbl21
            }
        }
        $continuation.L$0 = null;
        $continuation.L$1 = null;
        $continuation.L$2 = null;
        $continuation.L$3 = null;
        $continuation.L$4 = null;
        $continuation.label = 2;
        v1 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)$continuation);
        if (v1 == var16_6) {
            return var16_6;
        }
        ** GOTO lbl64
        {
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl64:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object indexTransactionReceipt(TransactionReceipt txReceipt, int txIndex, Bytes txHash, Bytes blockHash, Continuation<? super Unit> $completion) {
        this.blockchainIndex.index((Function1<? super BlockchainIndexWriter, Unit>)((Function1)new Function1<BlockchainIndexWriter, Unit>(txReceipt, txIndex, txHash, blockHash){
            final /* synthetic */ TransactionReceipt $txReceipt;
            final /* synthetic */ int $txIndex;
            final /* synthetic */ Bytes $txHash;
            final /* synthetic */ Bytes $blockHash;
            {
                this.$txReceipt = $txReceipt;
                this.$txIndex = $txIndex;
                this.$txHash = $txHash;
                this.$blockHash = $blockHash;
                super(1);
            }

            public final void invoke(@NotNull BlockchainIndexWriter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.indexTransactionReceipt(this.$txReceipt, this.$txIndex, this.$txHash, this.$blockHash);
            }
        }));
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object retrieveBlockBodyBytes(@NotNull Bytes blockHash, @NotNull Continuation<? super Bytes> $completion) {
        return this.blockBodyStore.get((Object)blockHash, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object retrieveBlockBody(@NotNull Bytes var1_1, @NotNull Continuation<? super BlockBody> var2_2) {
        if (!(var2_2 instanceof retrieveBlockBody.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retrieveBlockBody(null, (Continuation<? super BlockBody>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.retrieveBlockBodyBytes((Bytes)blockHash, (Continuation<? super Bytes>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                v1 = (Bytes)v0;
                if (v1 == null) {
                    v2 = null;
                } else {
                    it = v1;
                    $i$a$-let-BlockchainRepository$retrieveBlockBody$2 = false;
                    v2 = BlockBody.fromBytes((Bytes)it);
                }
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object hasBlockBody(@NotNull Bytes blockHash, @NotNull Continuation<? super Boolean> $completion) {
        return this.blockBodyStore.containsKey((Object)blockHash, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object retrieveBlock(@NotNull Bytes var1_1, @NotNull Continuation<? super Block> var2_2) {
        if (!(var2_2 instanceof retrieveBlock.1)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retrieveBlock(null, (Continuation<? super Block>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = blockHash;
                $continuation.label = 1;
                v0 = this.retrieveBlockBody(blockHash, (Continuation<? super BlockBody>)$continuation);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                blockHash = (Bytes)$continuation.L$1;
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                v1 = (BlockBody)v0;
                if (v1 != null) ** GOTO lbl28
                v2 = null;
                ** GOTO lbl52
lbl28:
                // 1 sources

                body = v1;
                $i$a$-let-BlockchainRepository$retrieveBlock$2 = false;
                $continuation.L$0 = body;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v3 = this.retrieveBlockHeader(blockHash, (Continuation<? super BlockHeader>)$continuation);
                if (v3 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl42
            }
            case 2: {
                $i$a$-let-BlockchainRepository$retrieveBlock$2 = false;
                body = (BlockBody)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl42:
                // 2 sources

                v4 = (BlockHeader)v3;
                if (v4 == null) {
                    v2 = null;
                } else {
                    it = v4;
                    $i$a$-let-BlockchainRepository$retrieveBlock$2$1 = false;
                    v2 = new Block(it, body);
                }
lbl52:
                // 3 sources

                var3_11 = v2;
                if (var3_11 == null) {
                    return null;
                }
                return var3_11;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object retrieveBlockHeaderBytes(@NotNull Bytes blockHash, @NotNull Continuation<? super Bytes> $completion) {
        return this.blockHeaderStore.get((Object)blockHash, $completion);
    }

    @Nullable
    public final Object hasBlockHeader(@NotNull Bytes blockHash, @NotNull Continuation<? super Boolean> $completion) {
        return this.blockHeaderStore.containsKey((Object)blockHash, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object retrieveBlockHeader(@NotNull Bytes var1_1, @NotNull Continuation<? super BlockHeader> var2_2) {
        if (!(var2_2 instanceof retrieveBlockHeader.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retrieveBlockHeader(null, (Continuation<? super BlockHeader>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.retrieveBlockHeaderBytes((Bytes)blockHash, (Continuation<? super Bytes>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                v1 = (Bytes)v0;
                if (v1 == null) {
                    return null;
                }
                bytes = v1;
                return BlockHeader.fromBytes((Bytes)bytes);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object retrieveChainHead(@NotNull Continuation<? super Block> var1_1) {
        if (!(var1_1 instanceof retrieveChainHead.1)) ** GOTO lbl-1000
        var7_2 = var1_1;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retrieveChainHead((Continuation<? super Block>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_5 = this.blockchainIndex.findLargestTotalDifficulty();
                if (var3_5 != null) ** GOTO lbl16
                v0 = null;
                ** GOTO lbl31
lbl16:
                // 1 sources

                it = var3_5;
                $i$a$-let-BlockchainRepository$retrieveChainHead$2 = false;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = this.retrieveBlock((Bytes)it, (Continuation<? super Block>)$continuation);
                if (v1 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl29
            }
            case 1: {
                $i$a$-let-BlockchainRepository$retrieveChainHead$2 = false;
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                v0 = (Block)v1;
lbl31:
                // 2 sources

                var2_9 = v0;
                if (var2_9 != null) break;
                $continuation.L$0 = null;
                $continuation.label = 2;
                v2 = this.retrieveGenesisBlock((Continuation<? super Block>)$continuation);
                if (v2 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl42
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl42:
                // 2 sources

                return v2;
            }
        }
        return var2_9;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object retrieveChainHeadHeader(@NotNull Continuation<? super BlockHeader> var1_1) {
        block9: {
            if (!(var1_1 instanceof retrieveChainHeadHeader.1)) ** GOTO lbl-1000
            var7_2 = var1_1;
            if ((var7_2.label & -2147483648) != 0) {
                var7_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ BlockchainRepository this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.retrieveChainHeadHeader((Continuation<? super BlockHeader>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var3_5 = this.blockchainIndex.findLargestTotalDifficulty();
                    if (var3_5 != null) ** GOTO lbl16
                    v0 = null;
                    ** GOTO lbl31
lbl16:
                    // 1 sources

                    it = var3_5;
                    $i$a$-let-BlockchainRepository$retrieveChainHeadHeader$2 = false;
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v1 = this.retrieveBlockHeader((Bytes)it, (Continuation<? super BlockHeader>)$continuation);
                    if (v1 == var8_4) {
                        return var8_4;
                    }
                    ** GOTO lbl29
                }
                case 1: {
                    $i$a$-let-BlockchainRepository$retrieveChainHeadHeader$2 = false;
                    this = (BlockchainRepository)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl29:
                    // 2 sources

                    v0 = (BlockHeader)v1;
lbl31:
                    // 2 sources

                    var2_9 = v0;
                    if (var2_9 != null) break;
                    $continuation.L$0 = null;
                    $continuation.label = 2;
                    v2 = this.retrieveGenesisBlock((Continuation<? super Block>)$continuation);
                    if (v2 == var8_4) {
                        return var8_4;
                    }
                    ** GOTO lbl42
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl42:
                    // 2 sources

                    var3_5 = ((Block)v2).getHeader();
                    Intrinsics.checkNotNullExpressionValue((Object)var3_5, (String)"retrieveGenesisBlock().getHeader()");
                    v3 = var3_5;
                    break block9;
                }
            }
            v3 = var2_9;
        }
        return v3;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object retrieveGenesisBlock(@NotNull Continuation<? super Block> var1_1) {
        if (!(var1_1 instanceof retrieveGenesisBlock.1)) ** GOTO lbl-1000
        var6_2 = var1_1;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retrieveGenesisBlock((Continuation<? super Block>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = BlockchainRepository.GENESIS_BLOCK;
                Intrinsics.checkNotNullExpressionValue((Object)var2_5, (String)"GENESIS_BLOCK");
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.chainMetadata.get((Object)var2_5, (Continuation)$continuation);
                if (v0 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl24
            }
            case 1: {
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                it = (Bytes)v0;
                $i$a$-let-BlockchainRepository$retrieveGenesisBlock$2 = false;
                v1 = it;
                Intrinsics.checkNotNull((Object)v1);
                $continuation.L$0 = null;
                $continuation.label = 2;
                v2 = this.retrieveBlock(v1, (Continuation<? super Block>)$continuation);
                if (v2 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl38
            }
            case 2: {
                $i$a$-let-BlockchainRepository$retrieveGenesisBlock$2 = false;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl38:
                // 2 sources

                Intrinsics.checkNotNull((Object)v2);
                return (Block)v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object retrieveTransactionReceipts(@NotNull Bytes var1_1, @NotNull Continuation<? super List<TransactionReceipt>> var2_2) {
        if (!(var2_2 instanceof retrieveTransactionReceipts.1)) ** GOTO lbl-1000
        var21_3 = var2_2;
        if ((var21_3.label & -2147483648) != 0) {
            var21_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retrieveTransactionReceipts(null, (Continuation<? super List<TransactionReceipt>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var22_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$mapNotNull$iv = this.blockchainIndex.findBy(TransactionReceiptFields.BLOCK_HASH, (Bytes)blockHash);
                $i$f$mapNotNull = false;
                var5_8 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var10_13 = $this$forEach$iv$iv$iv.iterator();
lbl20:
                // 3 sources

                while (var10_13.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var10_13.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (Hash)element$iv$iv;
                    $i$a$-mapNotNull-BlockchainRepository$retrieveTransactionReceipts$2 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = destination$iv$iv;
                    $continuation.L$2 = var10_13;
                    $continuation.label = 1;
                    v0 = this.transactionReceiptStore.get((Object)it, (Continuation)$continuation);
                    if (v0 == var22_5) {
                        return var22_5;
                    }
                    ** GOTO lbl45
                }
                break;
            }
            case 1: {
                $i$f$mapNotNull = false;
                $i$f$mapNotNullTo = false;
                $i$f$forEach = false;
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                $i$a$-mapNotNull-BlockchainRepository$retrieveTransactionReceipts$2 = false;
                var10_13 = (Iterator<T>)$continuation.L$2;
                destination$iv$iv = (Collection)$continuation.L$1;
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl45:
                // 2 sources

                if ((Bytes)v0 == null) {
                    v1 = null;
                } else {
                    $i$a$-let-BlockchainRepository$retrieveTransactionReceipts$2$1 = false;
                    v1 = TransactionReceipt.fromBytes((Bytes)it);
                }
                if (v1 == null) ** GOTO lbl20
                it$iv$iv = v1;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
                ** GOTO lbl20
            }
        }
        return (List)destination$iv$iv;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object retrieveTransactionReceipt(@NotNull Bytes var1_1, int var2_2, @NotNull Continuation<? super TransactionReceipt> var3_3) {
        if (!(var3_3 instanceof retrieveTransactionReceipt.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retrieveTransactionReceipt(null, 0, (Continuation<? super TransactionReceipt>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.blockchainIndex.findByBlockHashAndIndex((Bytes)blockHash, (int)index);
                if (v0 != null) ** GOTO lbl16
                v1 = null;
                ** GOTO lbl37
lbl16:
                // 1 sources

                it = v0;
                $i$a$-let-BlockchainRepository$retrieveTransactionReceipt$2 = false;
                $continuation.label = 1;
                v2 = this.transactionReceiptStore.get((Object)it, (Continuation)$continuation);
                if (v2 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl27
            }
            case 1: {
                $i$a$-let-BlockchainRepository$retrieveTransactionReceipt$2 = false;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl27:
                // 2 sources

                v3 = (Bytes)v2;
                if (v3 == null) {
                    v1 = null;
                } else {
                    it = v3;
                    $i$a$-let-BlockchainRepository$retrieveTransactionReceipt$2$1 = false;
                    v1 = TransactionReceipt.fromBytes((Bytes)it);
                }
lbl37:
                // 3 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object retrieveTransactionReceipt(@NotNull Hash var1_1, @NotNull Continuation<? super TransactionReceipt> var2_2) {
        if (!(var2_2 instanceof retrieveTransactionReceipt.3)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retrieveTransactionReceipt(null, (Continuation<? super TransactionReceipt>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.transactionReceiptStore.get((Object)txHash, (Continuation)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                v1 = (Bytes)v0;
                if (v1 == null) {
                    v2 = null;
                } else {
                    it = v1;
                    $i$a$-let-BlockchainRepository$retrieveTransactionReceipt$4 = false;
                    v2 = TransactionReceipt.fromBytes((Bytes)it);
                }
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final List<Hash> findBlockByHashOrNumber(@NotNull Bytes blockNumberOrBlockHash) {
        Intrinsics.checkNotNullParameter((Object)blockNumberOrBlockHash, (String)"blockNumberOrBlockHash");
        return this.blockchainIndex.findByHashOrNumber(blockNumberOrBlockHash);
    }

    @NotNull
    public final List<Hash> findBlocksByParentHash(@NotNull Bytes parentHash) {
        Intrinsics.checkNotNullParameter((Object)parentHash, (String)"parentHash");
        return this.blockchainIndex.findBy(BlockHeaderFields.PARENT_HASH, parentHash);
    }

    private final Object setGenesisBlock(Block block, Continuation<? super Unit> $completion) {
        Bytes bytes = GENESIS_BLOCK;
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"GENESIS_BLOCK");
        Bytes bytes2 = bytes;
        bytes = block.getHeader().getHash();
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"block.getHeader().getHash()");
        Object object = this.chainMetadata.put((Object)bytes2, (Object)bytes, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object retrieveNodeData(@NotNull List<Hash> var1_1, @NotNull Continuation<? super List<? extends Bytes>> var2_2) {
        if (!(var2_2 instanceof retrieveNodeData.1)) ** GOTO lbl-1000
        var14_3 = var2_2;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retrieveNodeData(null, (Continuation<? super List<? extends Bytes>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$map$iv = (Iterable)hashes;
                $i$f$map = false;
                var5_8 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var8_11 = $this$mapTo$iv$iv.iterator();
lbl18:
                // 2 sources

                while (var8_11.hasNext()) {
                    item$iv$iv = var8_11.next();
                    var10_13 = (Hash)item$iv$iv;
                    var12_15 = destination$iv$iv;
                    $i$a$-map-BlockchainRepository$retrieveNodeData$2 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = destination$iv$iv;
                    $continuation.L$2 = var8_11;
                    $continuation.L$3 = var12_15;
                    $continuation.label = 1;
                    v0 = this.stateStore.get((Object)it, (Continuation)$continuation);
                    if (v0 == var15_5) {
                        return var15_5;
                    }
                    ** GOTO lbl43
                }
                break;
            }
            case 1: {
                $i$f$map = false;
                $i$f$mapTo = false;
                $i$a$-map-BlockchainRepository$retrieveNodeData$2 = false;
                var12_15 = (Collection)$continuation.L$3;
                var8_11 = (Iterator<T>)$continuation.L$2;
                destination$iv$iv = (Collection)$continuation.L$1;
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl43:
                // 2 sources

                var12_15.add((Bytes)v0);
                ** GOTO lbl18
            }
        }
        return (List)destination$iv$iv;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object storeTransaction(@NotNull Transaction var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof storeTransaction.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.storeTransaction(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = transaction.getHash();
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"transaction.hash");
                v0 = var3_6;
                var3_6 = transaction.toBytes();
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"transaction.toBytes()");
                $continuation.L$0 = this;
                $continuation.L$1 = transaction;
                $continuation.label = 1;
                v1 = this.transactionStore.put((Object)v0, (Object)var3_6, (Continuation)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl29
            }
            case 1: {
                transaction = (Transaction)$continuation.L$1;
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                this.blockchainIndex.indexTransaction(transaction);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object storeAccount(@NotNull Address address, @NotNull AccountState account, @NotNull Continuation<? super Unit> $completion) {
        Hash hash = Hash.hash((Bytes)((Bytes)address));
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash(address)");
        Hash hash2 = hash;
        hash = account.toBytes();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"account.toBytes()");
        Object object = this.stateStore.put((Object)hash2, (Object)hash, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getAccount(@NotNull Address var1_1, @NotNull Continuation<? super AccountState> var2_2) {
        if (!(var2_2 instanceof getAccount.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getAccount(null, (Continuation<? super AccountState>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = Hash.hash((Bytes)((Bytes)address));
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"hash(address)");
                $continuation.label = 1;
                v0 = this.stateStore.get((Object)var3_6, (Continuation)$continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                v1 = (Bytes)v0;
                if (v1 == null) {
                    v2 = null;
                } else {
                    it = v1;
                    $i$a$-let-BlockchainRepository$getAccount$2 = false;
                    v2 = AccountState.fromBytes((Bytes)it);
                }
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object accountsExists(@NotNull Address address, @NotNull Continuation<? super Boolean> $completion) {
        Hash hash = Hash.hash((Bytes)((Bytes)address));
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash(address)");
        return this.stateStore.containsKey((Object)hash, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getAccountStoreValue(@NotNull Address var1_1, @NotNull Bytes32 var2_2, @NotNull Continuation<? super Bytes32> var3_3) {
        if (!(var3_3 instanceof getAccountStoreValue.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getAccountStoreValue(null, null, (Continuation<? super Bytes32>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                BlockchainRepository.logger.trace("Entering getAccountStoreValue");
                var6_7 = Hash.hash((Bytes)((Bytes)address));
                Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"hash(address)");
                $continuation.L$0 = this;
                $continuation.L$1 = key;
                $continuation.label = 1;
                v0 = this.stateStore.get((Object)var6_7, (Continuation)$continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl27
            }
            case 1: {
                key = (Bytes32)$continuation.L$1;
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                v1 = (Bytes)v0;
                if (v1 == null) {
                    return null;
                }
                accountStateBytes = v1;
                accountState = AccountState.fromBytes((Bytes)accountStateBytes);
                v2 = new MerkleStorage(this){
                    final /* synthetic */ BlockchainRepository this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    @Nullable
                    public Object get(@NotNull Bytes32 hash, @NotNull Continuation<? super Bytes> $completion) {
                        return BlockchainRepository.access$getStateStore$p(this.this$0).get((Object)hash, $completion);
                    }

                    @Nullable
                    public Object put(@NotNull Bytes32 hash, @NotNull Bytes content, @NotNull Continuation<? super Unit> $completion) {
                        Object object = BlockchainRepository.access$getStateStore$p(this.this$0).put((Object)hash, (Object)content, $completion);
                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            return object;
                        }
                        return Unit.INSTANCE;
                    }
                };
                var7_10 = accountState.getStorageRoot();
                Intrinsics.checkNotNullExpressionValue((Object)var7_10, (String)"accountState.storageRoot");
                tree = StoredMerklePatriciaTrie.Companion.storingBytes32(v2, (Bytes32)var7_10);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v3 = tree.get((Bytes)key, (Continuation)$continuation);
                if (v3 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl46
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl46:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getAccountCode(@NotNull Address var1_1, @NotNull Continuation<? super Bytes> var2_2) {
        if (!(var2_2 instanceof getAccountCode.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BlockchainRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getAccountCode(null, (Continuation<? super Bytes>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = Hash.hash((Bytes)((Bytes)address));
                Intrinsics.checkNotNullExpressionValue((Object)var4_6, (String)"hash(address)");
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.stateStore.get((Object)var4_6, (Continuation)$continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                this = (BlockchainRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((accountStateBytes = (Bytes)v0) == null) {
                    return null;
                }
                accountState = AccountState.fromBytes((Bytes)accountStateBytes);
                var5_8 = accountState.getCodeHash();
                Intrinsics.checkNotNullExpressionValue((Object)var5_8, (String)"accountState.codeHash");
                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = this.stateStore.get((Object)var5_8, (Continuation)$continuation);
                if (v1 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl38
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl38:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void close() {
        this.blockBodyStore.close();
        this.blockHeaderStore.close();
        this.chainMetadata.close();
        this.stateStore.close();
        this.transactionStore.close();
        this.transactionReceiptStore.close();
    }

    @Nullable
    public final Object storeCode(@NotNull Bytes code, @NotNull Continuation<? super Unit> $completion) {
        Hash hash = Hash.hash((Bytes)code);
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash(code)");
        Object object = this.stateStore.put((Object)hash, (Object)code, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$setGenesisBlock(BlockchainRepository $this, Block block, Continuation $completion) {
        return $this.setGenesisBlock(block, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$reIndexTotalDifficultyInternal(BlockchainRepository $this, BlockchainIndexWriter writer, BlockHeader header, Continuation $completion) {
        return $this.reIndexTotalDifficultyInternal(writer, header, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$indexTransactionReceipt(BlockchainRepository $this, TransactionReceipt txReceipt, int txIndex, Bytes txHash, Bytes blockHash, Continuation $completion) {
        return $this.indexTransactionReceipt(txReceipt, txIndex, txHash, blockHash, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ KeyValueStore access$getStateStore$p(BlockchainRepository $this) {
        return $this.stateStore;
    }

    public static final /* synthetic */ KeyValueStore access$getBlockHeaderStore$p(BlockchainRepository $this) {
        return $this.blockHeaderStore;
    }

    static {
        String string = "genesisBlock";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        GENESIS_BLOCK = Bytes.wrap((byte[])byArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u00a5\u0001\u0010\u000e\u001a\u00020\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lorg/apache/tuweni/eth/repository/BlockchainRepository$Companion;", "", "()V", "GENESIS_BLOCK", "Lorg/apache/tuweni/bytes/Bytes;", "kotlin.jvm.PlatformType", "getGENESIS_BLOCK$eth_repository", "()Lorg/apache/tuweni/bytes/Bytes;", "logger", "Lorg/slf4j/Logger;", "getLogger$eth_repository", "()Lorg/slf4j/Logger;", "inMemory", "Lorg/apache/tuweni/eth/repository/BlockchainRepository;", "init", "blockBodyStore", "Lorg/apache/tuweni/kv/KeyValueStore;", "blockHeaderStore", "chainMetadata", "transactionReceiptsStore", "transactionStore", "stateStore", "blockchainIndex", "Lorg/apache/tuweni/eth/repository/BlockchainIndex;", "genesisBlock", "Lorg/apache/tuweni/eth/Block;", "meter", "Lio/opentelemetry/api/metrics/Meter;", "(Lorg/apache/tuweni/kv/KeyValueStore;Lorg/apache/tuweni/kv/KeyValueStore;Lorg/apache/tuweni/kv/KeyValueStore;Lorg/apache/tuweni/kv/KeyValueStore;Lorg/apache/tuweni/kv/KeyValueStore;Lorg/apache/tuweni/kv/KeyValueStore;Lorg/apache/tuweni/eth/repository/BlockchainIndex;Lorg/apache/tuweni/eth/Block;Lio/opentelemetry/api/metrics/Meter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "eth-repository"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger$eth_repository() {
            return logger;
        }

        public final Bytes getGENESIS_BLOCK$eth_repository() {
            return GENESIS_BLOCK;
        }

        @NotNull
        public final BlockchainRepository inMemory() {
            StandardAnalyzer analyzer = new StandardAnalyzer();
            IndexWriterConfig config = new IndexWriterConfig((Analyzer)analyzer);
            IndexWriter writer = new IndexWriter((Directory)new ByteBuffersDirectory(), config);
            return new BlockchainRepository((KeyValueStore)new MapKeyValueStore(null, null, 3, null), (KeyValueStore)new MapKeyValueStore(null, null, 3, null), (KeyValueStore)new MapKeyValueStore(null, null, 3, null), (KeyValueStore)new MapKeyValueStore(null, null, 3, null), (KeyValueStore)new MapKeyValueStore(null, null, 3, null), (KeyValueStore)new MapKeyValueStore(null, null, 3, null), new BlockchainIndex(writer), null, null, 384, null);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object init(@NotNull KeyValueStore<Bytes, Bytes> var1_1, @NotNull KeyValueStore<Bytes, Bytes> var2_2, @NotNull KeyValueStore<Bytes, Bytes> var3_3, @NotNull KeyValueStore<Bytes, Bytes> var4_4, @NotNull KeyValueStore<Bytes, Bytes> var5_5, @NotNull KeyValueStore<Bytes, Bytes> var6_6, @NotNull BlockchainIndex var7_7, @NotNull Block var8_8, @Nullable Meter var9_9, @NotNull Continuation<? super BlockchainRepository> var10_10) {
            if (!(var10_10 instanceof init.1)) ** GOTO lbl-1000
            var13_11 = var10_10;
            if ((var13_11.label & -2147483648) != 0) {
                var13_11.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var10_10){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.init(null, null, null, null, null, null, null, null, null, (Continuation<? super BlockchainRepository>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var14_13 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    repo = new BlockchainRepository(var3_3, var1_1, var2_2, (KeyValueStore)transactionReceiptsStore, (KeyValueStore)transactionStore, (KeyValueStore)stateStore, (BlockchainIndex)blockchainIndex, (Meter)meter, null, 256, null);
                    $continuation.L$0 = genesisBlock;
                    $continuation.L$1 = repo;
                    $continuation.label = 1;
                    v0 = BlockchainRepository.access$setGenesisBlock(repo, genesisBlock, (Continuation)$continuation);
                    if (v0 == var14_13) {
                        return var14_13;
                    }
                    ** GOTO lbl25
                }
                case 1: {
                    repo = (BlockchainRepository)$continuation.L$1;
                    genesisBlock = (Block)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl25:
                    // 2 sources

                    $continuation.L$0 = repo;
                    $continuation.L$1 = null;
                    $continuation.label = 2;
                    v1 = repo.storeBlock(genesisBlock, (Continuation<? super Unit>)$continuation);
                    if (v1 == var14_13) {
                        return var14_13;
                    }
                    ** GOTO lbl36
                }
                case 2: {
                    repo = (BlockchainRepository)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl36:
                    // 2 sources

                    return repo;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static /* synthetic */ Object init$default(Companion companion, KeyValueStore keyValueStore, KeyValueStore keyValueStore2, KeyValueStore keyValueStore3, KeyValueStore keyValueStore4, KeyValueStore keyValueStore5, KeyValueStore keyValueStore6, BlockchainIndex blockchainIndex, Block block, Meter meter, Continuation continuation, int n, Object object) {
            if ((n & 0x100) != 0) {
                meter = null;
            }
            return companion.init((KeyValueStore<Bytes, Bytes>)keyValueStore, (KeyValueStore<Bytes, Bytes>)keyValueStore2, (KeyValueStore<Bytes, Bytes>)keyValueStore3, (KeyValueStore<Bytes, Bytes>)keyValueStore4, (KeyValueStore<Bytes, Bytes>)keyValueStore5, (KeyValueStore<Bytes, Bytes>)keyValueStore6, blockchainIndex, block, meter, (Continuation<? super BlockchainRepository>)continuation);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

