/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.handshake;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.sodium.Allocated;
import org.apache.tuweni.crypto.sodium.Box;
import org.apache.tuweni.crypto.sodium.Concatenate;
import org.apache.tuweni.crypto.sodium.DiffieHelman;
import org.apache.tuweni.crypto.sodium.HMACSHA512256;
import org.apache.tuweni.crypto.sodium.SHA256Hash;
import org.apache.tuweni.crypto.sodium.SecretBox;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.scuttlebutt.Identity;
import org.apache.tuweni.scuttlebutt.Invite;
import org.apache.tuweni.scuttlebutt.handshake.HandshakeException;
import org.apache.tuweni.scuttlebutt.handshake.SecureScuttlebuttStream;
import org.apache.tuweni.scuttlebutt.handshake.SecureScuttlebuttStreamClient;

public final class SecureScuttlebuttHandshakeClient {
    private final Signature.KeyPair longTermKeyPair;
    private final Box.KeyPair ephemeralKeyPair;
    private final HMACSHA512256.Key networkIdentifier;
    private final Signature.PublicKey serverLongTermPublicKey;
    private Box.PublicKey serverEphemeralPublicKey;
    private DiffieHelman.Secret sharedSecret;
    private DiffieHelman.Secret sharedSecret2;
    private DiffieHelman.Secret sharedSecret3;
    private Allocated detachedSignature;

    public static SecureScuttlebuttHandshakeClient create(Signature.KeyPair ourKeyPair, Bytes32 networkIdentifier, Signature.PublicKey serverLongTermPublicKey) {
        return new SecureScuttlebuttHandshakeClient(ourKeyPair, networkIdentifier, serverLongTermPublicKey);
    }

    public static SecureScuttlebuttHandshakeClient fromInvite(Bytes32 networkIdentifier, Invite invite) {
        if (!Identity.Curve.Ed25519.equals((Object)invite.identity().curve())) {
            throw new IllegalArgumentException("Only ed25519 keys are supported");
        }
        return new SecureScuttlebuttHandshakeClient(Signature.KeyPair.fromSeed((Signature.Seed)invite.seedKey()), networkIdentifier, invite.identity().ed25519PublicKey());
    }

    private SecureScuttlebuttHandshakeClient(Signature.KeyPair longTermKeyPair, Bytes32 networkIdentifier, Signature.PublicKey serverLongTermPublicKey) {
        this.longTermKeyPair = longTermKeyPair;
        this.ephemeralKeyPair = Box.KeyPair.random();
        this.networkIdentifier = HMACSHA512256.Key.fromBytes((Bytes)networkIdentifier);
        this.serverLongTermPublicKey = serverLongTermPublicKey;
    }

    public Bytes createHello() {
        Bytes hmac = HMACSHA512256.authenticate((Bytes)this.ephemeralKeyPair.publicKey().bytes(), (HMACSHA512256.Key)this.networkIdentifier);
        return Bytes.concatenate((Bytes[])new Bytes[]{hmac, this.ephemeralKeyPair.publicKey().bytes()});
    }

    public void readHello(Bytes message) {
        Bytes key;
        if (message.size() != 64) {
            throw new HandshakeException("Invalid handshake message length: " + message.size());
        }
        Bytes hmac = message.slice(0, 32);
        if (!HMACSHA512256.verify((Bytes)hmac, (Bytes)(key = message.slice(32, 32)), (HMACSHA512256.Key)this.networkIdentifier)) {
            throw new HandshakeException("MAC does not match our network identifier");
        }
        this.serverEphemeralPublicKey = Box.PublicKey.fromBytes((Bytes)key);
        this.sharedSecret = DiffieHelman.Secret.forKeys((DiffieHelman.SecretKey)DiffieHelman.SecretKey.forBoxSecretKey((Box.SecretKey)this.ephemeralKeyPair.secretKey()), (DiffieHelman.PublicKey)DiffieHelman.PublicKey.forBoxPublicKey((Box.PublicKey)this.serverEphemeralPublicKey));
        this.sharedSecret2 = DiffieHelman.Secret.forKeys((DiffieHelman.SecretKey)DiffieHelman.SecretKey.forBoxSecretKey((Box.SecretKey)this.ephemeralKeyPair.secretKey()), (DiffieHelman.PublicKey)DiffieHelman.PublicKey.forSignaturePublicKey((Signature.PublicKey)this.serverLongTermPublicKey));
        this.sharedSecret3 = DiffieHelman.Secret.forKeys((DiffieHelman.SecretKey)DiffieHelman.SecretKey.forSignatureSecretKey((Signature.SecretKey)this.longTermKeyPair.secretKey()), (DiffieHelman.PublicKey)DiffieHelman.PublicKey.forBoxPublicKey((Box.PublicKey)this.serverEphemeralPublicKey));
    }

    DiffieHelman.Secret sharedSecret() {
        return this.sharedSecret;
    }

    DiffieHelman.Secret sharedSecret2() {
        return this.sharedSecret2;
    }

    DiffieHelman.Secret sharedSecret3() {
        return this.sharedSecret3;
    }

    public Bytes createIdentityMessage() {
        Concatenate concatenate = new Concatenate();
        concatenate.add(this.networkIdentifier);
        concatenate.add(this.serverLongTermPublicKey);
        concatenate.add(SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromSecret((DiffieHelman.Secret)this.sharedSecret)));
        this.detachedSignature = Signature.signDetached((Allocated)concatenate.concatenate(), (Signature.SecretKey)this.longTermKeyPair.secretKey());
        return SecretBox.encrypt((Allocated)new Concatenate().add(this.detachedSignature).add(this.longTermKeyPair.publicKey()).concatenate(), (SecretBox.Key)SecretBox.Key.fromHash((SHA256Hash.Hash)SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromPointer((Allocated)new Concatenate().add(this.networkIdentifier).add(this.sharedSecret).add(this.sharedSecret2).concatenate()))), (SecretBox.Nonce)SecretBox.Nonce.fromBytes((byte[])new byte[24])).bytes();
    }

    public void readAcceptMessage(Bytes message) {
        Allocated serverSignature = SecretBox.decrypt((Allocated)Allocated.fromBytes((Bytes)message), (SecretBox.Key)SecretBox.Key.fromHash((SHA256Hash.Hash)SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromPointer((Allocated)new Concatenate().add(this.networkIdentifier).add(this.sharedSecret).add(this.sharedSecret2).add(this.sharedSecret3).concatenate()))), (SecretBox.Nonce)SecretBox.Nonce.fromBytes((byte[])new byte[24]));
        if (serverSignature == null) {
            throw new HandshakeException("Could not decrypt accept message with our shared secrets");
        }
        boolean verified = this.serverLongTermPublicKey.verify(new Concatenate().add(this.networkIdentifier).add(this.detachedSignature).add(this.longTermKeyPair.publicKey()).add(SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromSecret((DiffieHelman.Secret)this.sharedSecret))).concatenate(), serverSignature);
        if (!verified) {
            throw new HandshakeException("Accept message signature does not match");
        }
    }

    SHA256Hash.Hash clientToServerSecretBoxKey() {
        return SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromPointer((Allocated)new Concatenate().add(SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromHash((SHA256Hash.Hash)SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromPointer((Allocated)new Concatenate().add(this.networkIdentifier).add(this.sharedSecret).add(this.sharedSecret2).add(this.sharedSecret3).concatenate()))))).add(this.serverLongTermPublicKey).concatenate()));
    }

    Bytes clientToServerNonce() {
        return HMACSHA512256.authenticate((Bytes)this.serverEphemeralPublicKey.bytes(), (HMACSHA512256.Key)this.networkIdentifier).slice(0, 24);
    }

    SHA256Hash.Hash serverToClientSecretBoxKey() {
        return SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromPointer((Allocated)new Concatenate().add(SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromHash((SHA256Hash.Hash)SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromPointer((Allocated)new Concatenate().add(this.networkIdentifier).add(this.sharedSecret).add(this.sharedSecret2).add(this.sharedSecret3).concatenate()))))).add(this.longTermKeyPair.publicKey()).concatenate()));
    }

    Bytes serverToClientNonce() {
        return HMACSHA512256.authenticate((Bytes)this.ephemeralKeyPair.publicKey().bytes(), (HMACSHA512256.Key)this.networkIdentifier).slice(0, 24);
    }

    public SecureScuttlebuttStreamClient createStream() {
        return new SecureScuttlebuttStream(this.clientToServerSecretBoxKey(), this.clientToServerNonce(), this.serverToClientSecretBoxKey(), this.serverToClientNonce());
    }
}

