/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.crawler.rest;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.concurrent.ExpiringMap;
import org.apache.tuweni.devp2p.EnodeUriKt;
import org.apache.tuweni.devp2p.eth.EthClientKt;
import org.apache.tuweni.eth.EthJsonModule;
import org.apache.tuweni.eth.crawler.PeerConnectionInfoDetails;
import org.apache.tuweni.eth.crawler.RESTMetrics;
import org.apache.tuweni.eth.crawler.RelationalPeerRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Path(value="peers")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000bH\u0007J\u0012\u0010\u000f\u001a\u00020\r2\b\b\u0001\u0010\u0010\u001a\u00020\u000bH\u0007J\u001c\u0010\u0011\u001a\u00020\u000b2\b\b\u0003\u0010\u0012\u001a\u00020\u00132\b\b\u0003\u0010\u0014\u001a\u00020\u0013H\u0007R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/apache/tuweni/eth/crawler/rest/PeersService;", "", "()V", "context", "Ljavax/servlet/ServletContext;", "getContext", "()Ljavax/servlet/ServletContext;", "setContext", "(Ljavax/servlet/ServletContext;)V", "localCache", "Lorg/apache/tuweni/concurrent/ExpiringMap;", "", "addPeer", "Ljavax/ws/rs/core/Response;", "uri", "getPeer", "publicKeyOrUri", "getPeers", "from", "", "limit", "Companion", "eth-crawler"})
public final class PeersService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExpiringMap<String, String> localCache = new ExpiringMap();
    @Context
    @Nullable
    private ServletContext context;
    @NotNull
    private static final ObjectMapper mapper = new ObjectMapper();

    @Nullable
    public final ServletContext getContext() {
        return this.context;
    }

    public final void setContext(@Nullable ServletContext servletContext) {
        this.context = servletContext;
    }

    @GET
    @Produces(value={"application/json"})
    @NotNull
    public final String getPeers(@QueryParam(value="from") int from, @QueryParam(value="limit") int limit) {
        String key = "from" + from + "limit" + limit;
        Object object = this.localCache.computeIfAbsent((Object)key, 30000L, arg_0 -> PeersService.getPeers$lambda-0(this, from, limit, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"localCache.computeIfAbse\u2026alueAsString(peers)\n    }");
        return (String)object;
    }

    public static /* synthetic */ String getPeers$default(PeersService peersService, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 10;
        }
        return peersService.getPeers(n, n2);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{publickey}")
    @NotNull
    public final Response getPeer(@PathParam(value="publickey") @NotNull String publicKeyOrUri) {
        Object uri;
        Intrinsics.checkNotNullParameter((Object)publicKeyOrUri, (String)"publicKeyOrUri");
        try {
            uri = URI.create(publicKeyOrUri);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
            uri = EnodeUriKt.parseEnodeUri((URI)uri).getNodeId().toHexString();
        }
        catch (IllegalArgumentException e) {
            uri = publicKeyOrUri;
        }
        Object publicKey = uri;
        ServletContext servletContext = this.context;
        Intrinsics.checkNotNull((Object)servletContext);
        Object object = servletContext.getAttribute("repo");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.eth.crawler.RelationalPeerRepository");
        }
        RelationalPeerRepository repo = (RelationalPeerRepository)object;
        long l = System.currentTimeMillis();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"publicKey");
        PeerConnectionInfoDetails peer = repo.getPeerWithInfo$eth_crawler(l, (String)publicKey);
        if (peer != null) {
            Response response = Response.ok((Object)mapper.writeValueAsString((Object)peer)).build();
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"ok(mapper.writeValueAsString(peer)).build()");
            return response;
        }
        Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"status(Response.Status.NOT_FOUND).build()");
        return response;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{enode}")
    @NotNull
    public final Response addPeer(@PathParam(value="enode") @NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        ServletContext servletContext = this.context;
        Intrinsics.checkNotNull((Object)servletContext);
        Object object = servletContext.getAttribute("repo");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.eth.crawler.RelationalPeerRepository");
        }
        RelationalPeerRepository repo = (RelationalPeerRepository)object;
        try {
            repo.getAsync(uri);
            Response response = Response.status((Response.Status)Response.Status.OK).build();
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"status(Response.Status.OK).build()");
            return response;
        }
        catch (IllegalArgumentException e) {
            EthClientKt.getLogger().error("Error adding peer", (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"status(Response.Status.BAD_REQUEST).build()");
            return response;
        }
    }

    private static final String getPeers$lambda-0(PeersService this$0, int $from, int $limit, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ServletContext servletContext = this$0.context;
        Intrinsics.checkNotNull((Object)servletContext);
        Object object = servletContext.getAttribute("repo");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.eth.crawler.RelationalPeerRepository");
        }
        RelationalPeerRepository repo = (RelationalPeerRepository)object;
        ServletContext servletContext2 = this$0.context;
        Intrinsics.checkNotNull((Object)servletContext2);
        Object object2 = servletContext2.getAttribute("metrics");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.eth.crawler.RESTMetrics");
        }
        RESTMetrics metrics = (RESTMetrics)object2;
        metrics.getPeersCounter().add(1L);
        List<PeerConnectionInfoDetails> peers = repo.getPeersWithInfo$eth_crawler(System.currentTimeMillis(), $from, $limit);
        return mapper.writeValueAsString(peers);
    }

    static {
        mapper.registerModule((Module)new EthJsonModule());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/apache/tuweni/eth/crawler/rest/PeersService$Companion;", "", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "eth-crawler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

