/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.crawler;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.eth.crawler.PeerData;
import org.apache.tuweni.ethstats.BlockStats;
import org.apache.tuweni.ethstats.NodeInfo;
import org.apache.tuweni.ethstats.NodeStats;
import org.apache.tuweni.ethstats.TxStats;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\f2\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\rJ$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bJ$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eJ$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0018J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lorg/apache/tuweni/eth/crawler/EthstatsDataRepository;", "Lkotlinx/coroutines/CoroutineScope;", "ds", "Ljavax/sql/DataSource;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Ljavax/sql/DataSource;Lkotlin/coroutines/CoroutineContext;)V", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getDs", "()Ljavax/sql/DataSource;", "getLatestBlock", "Lkotlinx/coroutines/Deferred;", "Lorg/apache/tuweni/ethstats/BlockStats;", "id", "", "getPeerData", "Lorg/apache/tuweni/eth/crawler/PeerData;", "storeBlock", "", "remoteAddress", "block", "storeLatency", "latency", "", "storeNodeInfo", "nodeInfo", "Lorg/apache/tuweni/ethstats/NodeInfo;", "storeNodeStats", "nodeStats", "Lorg/apache/tuweni/ethstats/NodeStats;", "storePendingTx", "pendingTx", "updateDisconnect", "eth-crawler"})
public final class EthstatsDataRepository
implements CoroutineScope {
    @NotNull
    private final DataSource ds;
    @NotNull
    private final CoroutineContext coroutineContext;

    public EthstatsDataRepository(@NotNull DataSource ds, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.ds = ds;
        this.coroutineContext = coroutineContext;
    }

    public /* synthetic */ EthstatsDataRepository(DataSource dataSource, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(dataSource, coroutineContext);
    }

    @NotNull
    public final DataSource getDs() {
        return this.ds;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @NotNull
    public final Deferred<Boolean> storeNodeInfo(@NotNull String remoteAddress, @NotNull String id, @NotNull NodeInfo nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        return BuildersKt.async$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, remoteAddress, id, nodeInfo, null){
            int label;
            final /* synthetic */ EthstatsDataRepository this$0;
            final /* synthetic */ String $remoteAddress;
            final /* synthetic */ String $id;
            final /* synthetic */ NodeInfo $nodeInfo;
            {
                this.this$0 = $receiver;
                this.$remoteAddress = $remoteAddress;
                this.$id = $id;
                this.$nodeInfo = $nodeInfo;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        AutoCloseable autoCloseable = this.this$0.getDs().getConnection();
                        String string = this.$remoteAddress;
                        String string2 = this.$id;
                        NodeInfo nodeInfo = this.$nodeInfo;
                        Throwable throwable = null;
                        try {
                            boolean bl2;
                            Connection conn = (Connection)autoCloseable;
                            boolean bl3 = false;
                            PreparedStatement stmt = conn.prepareStatement("insert into ethstats_peer(address, id, name, client, net, api, protocol, os, osVer, node, port) values(?,?,?,?,?,?,?,?,?,?,?)");
                            AutoCloseable autoCloseable2 = stmt;
                            Throwable throwable2 = null;
                            try {
                                PreparedStatement it = (PreparedStatement)autoCloseable2;
                                boolean bl4 = false;
                                it.setString(1, string);
                                it.setString(2, string2);
                                it.setString(3, nodeInfo.getName());
                                it.setString(4, nodeInfo.getClient());
                                it.setString(5, nodeInfo.getNet());
                                it.setString(6, nodeInfo.getApi());
                                it.setString(7, nodeInfo.getProtocol());
                                it.setString(8, nodeInfo.getOs());
                                it.setString(9, nodeInfo.osVersion());
                                it.setString(10, nodeInfo.getNode());
                                it.setInt(11, nodeInfo.getPort());
                                bl2 = it.execute();
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                            }
                            bl = Boxing.boxBoolean((boolean)bl2);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return bl;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Deferred<Boolean> storeBlock(@NotNull String remoteAddress, @NotNull String id, @NotNull BlockStats block) {
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return BuildersKt.async$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, block, remoteAddress, id, null){
            int label;
            final /* synthetic */ EthstatsDataRepository this$0;
            final /* synthetic */ BlockStats $block;
            final /* synthetic */ String $remoteAddress;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                this.$remoteAddress = $remoteAddress;
                this.$id = $id;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        AutoCloseable autoCloseable = this.this$0.getDs().getConnection();
                        BlockStats blockStats = this.$block;
                        String string = this.$remoteAddress;
                        String string2 = this.$id;
                        Throwable throwable = null;
                        try {
                            boolean bl2;
                            Connection conn = (Connection)autoCloseable;
                            boolean bl3 = false;
                            PreparedStatement stmt = conn.prepareStatement("insert into ethstats_block(address, id, number, hash, parentHash, timestamp, miner, gasUsed, gasLimit, difficulty, totalDifficulty, transactions, transactionsRoot, stateRoot, uncles) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                            AutoCloseable autoCloseable2 = stmt;
                            Throwable throwable2 = null;
                            try {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                Collection<byte[]> collection;
                                void $this$mapTo$iv$iv2;
                                void $this$map$iv2;
                                PreparedStatement it = (PreparedStatement)autoCloseable2;
                                boolean bl4 = false;
                                Iterable iterable = blockStats.getTransactions();
                                String string3 = "bytea";
                                Connection connection = conn;
                                boolean $i$f$map = false;
                                void var18_24 = $this$map$iv2;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv2) {
                                    void it2;
                                    TxStats txStats = (TxStats)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl5 = false;
                                    collection.add(it2.getHash().toArrayUnsafe());
                                }
                                collection = (List)destination$iv$iv;
                                Collection $this$toTypedArray$iv = collection;
                                boolean $i$f$toTypedArray22 = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                Object[] objectArray = thisCollection$iv.toArray((T[])new byte[0][]);
                                if (objectArray == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                                }
                                Array txArray = connection.createArrayOf(string3, objectArray);
                                Iterable $i$f$toTypedArray22 = blockStats.getUncles();
                                string3 = "bytea";
                                connection = conn;
                                boolean $i$f$map2 = false;
                                destination$iv$iv = $this$map$iv;
                                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo2 = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it3;
                                    Hash bl5 = (Hash)item$iv$iv;
                                    collection = destination$iv$iv2;
                                    boolean bl6 = false;
                                    collection.add(it3.toArrayUnsafe());
                                }
                                Collection<byte[]> $this$toTypedArray$iv2 = collection = (List)destination$iv$iv2;
                                boolean $i$f$toTypedArray = false;
                                Collection<byte[]> thisCollection$iv2 = $this$toTypedArray$iv2;
                                Object[] objectArray2 = thisCollection$iv2.toArray((T[])new byte[0][]);
                                if (objectArray2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                                }
                                Array unclesArray = connection.createArrayOf(string3, objectArray2);
                                it.setString(1, string);
                                it.setString(2, string2);
                                it.setBytes(3, blockStats.getNumber().toArrayUnsafe());
                                it.setBytes(4, blockStats.getHash().toArrayUnsafe());
                                it.setBytes(5, blockStats.getParentHash().toArrayUnsafe());
                                it.setLong(6, blockStats.getTimestamp());
                                it.setBytes(7, blockStats.getMiner().toArrayUnsafe());
                                it.setLong(8, blockStats.getGasUsed());
                                it.setLong(9, blockStats.getGasLimit());
                                it.setBytes(10, blockStats.getDifficulty().toArrayUnsafe());
                                it.setBytes(11, blockStats.getTotalDifficulty().toArrayUnsafe());
                                it.setArray(12, txArray);
                                it.setBytes(13, blockStats.getTransactionsRoot().toArrayUnsafe());
                                it.setBytes(14, blockStats.getStateRoot().toArrayUnsafe());
                                it.setArray(15, unclesArray);
                                bl2 = it.execute();
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                            }
                            bl = Boxing.boxBoolean((boolean)bl2);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return bl;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Deferred<Boolean> storeLatency(@NotNull String remoteAddress, @NotNull String id, long latency) {
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return BuildersKt.async$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, remoteAddress, id, latency, null){
            int label;
            final /* synthetic */ EthstatsDataRepository this$0;
            final /* synthetic */ String $remoteAddress;
            final /* synthetic */ String $id;
            final /* synthetic */ long $latency;
            {
                this.this$0 = $receiver;
                this.$remoteAddress = $remoteAddress;
                this.$id = $id;
                this.$latency = $latency;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        AutoCloseable autoCloseable = this.this$0.getDs().getConnection();
                        String string = this.$remoteAddress;
                        String string2 = this.$id;
                        long l = this.$latency;
                        Throwable throwable = null;
                        try {
                            boolean bl2;
                            Connection conn = (Connection)autoCloseable;
                            boolean bl3 = false;
                            PreparedStatement stmt = conn.prepareStatement("insert into latency(address, id, value) values(?,?,?)");
                            AutoCloseable autoCloseable2 = stmt;
                            Throwable throwable2 = null;
                            try {
                                PreparedStatement it = (PreparedStatement)autoCloseable2;
                                boolean bl4 = false;
                                it.setString(1, string);
                                it.setString(2, string2);
                                it.setLong(3, l);
                                bl2 = it.execute();
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                            }
                            bl = Boxing.boxBoolean((boolean)bl2);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return bl;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Deferred<Boolean> storeNodeStats(@NotNull String remoteAddress, @NotNull String id, @NotNull NodeStats nodeStats) {
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)nodeStats, (String)"nodeStats");
        return BuildersKt.async$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, remoteAddress, id, nodeStats, null){
            int label;
            final /* synthetic */ EthstatsDataRepository this$0;
            final /* synthetic */ String $remoteAddress;
            final /* synthetic */ String $id;
            final /* synthetic */ NodeStats $nodeStats;
            {
                this.this$0 = $receiver;
                this.$remoteAddress = $remoteAddress;
                this.$id = $id;
                this.$nodeStats = $nodeStats;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        AutoCloseable autoCloseable = this.this$0.getDs().getConnection();
                        String string = this.$remoteAddress;
                        String string2 = this.$id;
                        NodeStats nodeStats = this.$nodeStats;
                        Throwable throwable = null;
                        try {
                            boolean bl2;
                            Connection conn = (Connection)autoCloseable;
                            boolean bl3 = false;
                            PreparedStatement stmt = conn.prepareStatement("insert into ethstats_nodestats(address, id, gasPrice, hashrate, mining, syncing, active, uptime, peers) values(?,?,?,?,?,?,?,?,?)");
                            AutoCloseable autoCloseable2 = stmt;
                            Throwable throwable2 = null;
                            try {
                                PreparedStatement it = (PreparedStatement)autoCloseable2;
                                boolean bl4 = false;
                                it.setString(1, string);
                                it.setString(2, string2);
                                it.setInt(3, nodeStats.getGasPrice());
                                it.setInt(4, nodeStats.getHashrate());
                                it.setBoolean(5, nodeStats.getMining());
                                it.setBoolean(6, nodeStats.getSyncing());
                                it.setBoolean(7, nodeStats.getActive());
                                it.setInt(8, nodeStats.getUptime());
                                it.setInt(9, nodeStats.getPeers());
                                bl2 = it.execute();
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                            }
                            bl = Boxing.boxBoolean((boolean)bl2);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return bl;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Deferred<Boolean> storePendingTx(@NotNull String remoteAddress, @NotNull String id, long pendingTx) {
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return BuildersKt.async$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, remoteAddress, id, pendingTx, null){
            int label;
            final /* synthetic */ EthstatsDataRepository this$0;
            final /* synthetic */ String $remoteAddress;
            final /* synthetic */ String $id;
            final /* synthetic */ long $pendingTx;
            {
                this.this$0 = $receiver;
                this.$remoteAddress = $remoteAddress;
                this.$id = $id;
                this.$pendingTx = $pendingTx;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        AutoCloseable autoCloseable = this.this$0.getDs().getConnection();
                        String string = this.$remoteAddress;
                        String string2 = this.$id;
                        long l = this.$pendingTx;
                        Throwable throwable = null;
                        try {
                            boolean bl2;
                            Connection conn = (Connection)autoCloseable;
                            boolean bl3 = false;
                            PreparedStatement stmt = conn.prepareStatement("insert into pendingtx(address, id, value) values(?,?,?)");
                            AutoCloseable autoCloseable2 = stmt;
                            Throwable throwable2 = null;
                            try {
                                PreparedStatement it = (PreparedStatement)autoCloseable2;
                                boolean bl4 = false;
                                it.setString(1, string);
                                it.setString(2, string2);
                                it.setLong(3, l);
                                bl2 = it.execute();
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                            }
                            bl = Boxing.boxBoolean((boolean)bl2);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return bl;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Deferred<Boolean> updateDisconnect(@NotNull String remoteAddress, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return BuildersKt.async$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, remoteAddress, id, null){
            int label;
            final /* synthetic */ EthstatsDataRepository this$0;
            final /* synthetic */ String $remoteAddress;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$remoteAddress = $remoteAddress;
                this.$id = $id;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Boolean bl;
                        ResultKt.throwOnFailure((Object)object);
                        AutoCloseable autoCloseable = this.this$0.getDs().getConnection();
                        String string = this.$remoteAddress;
                        String string2 = this.$id;
                        Throwable throwable = null;
                        try {
                            boolean bl2;
                            Connection conn = (Connection)autoCloseable;
                            boolean bl3 = false;
                            PreparedStatement stmt = conn.prepareStatement("update ethstats_peer set disconnect_time=now() where address=? and id=?");
                            AutoCloseable autoCloseable2 = stmt;
                            Throwable throwable2 = null;
                            try {
                                PreparedStatement it = (PreparedStatement)autoCloseable2;
                                boolean bl4 = false;
                                it.setString(1, string);
                                it.setString(2, string2);
                                bl2 = it.execute();
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                            }
                            bl = Boxing.boxBoolean((boolean)bl2);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return bl;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Deferred<BlockStats> getLatestBlock(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return BuildersKt.async$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BlockStats>, Object>(this, id, null){
            int label;
            final /* synthetic */ EthstatsDataRepository this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        BlockStats blockStats;
                        ResultKt.throwOnFailure((Object)object);
                        AutoCloseable autoCloseable = this.this$0.getDs().getConnection();
                        String string = this.$id;
                        Throwable throwable = null;
                        try {
                            BlockStats blockStats2;
                            Connection conn = (Connection)autoCloseable;
                            boolean bl = false;
                            PreparedStatement stmt = conn.prepareStatement("select number, hash, parentHash, timestamp, miner, gasUsed, gasLimit, difficulty, totalDifficulty, transactions, transactionsRoot, stateRoot, uncles from ethstats_block where id=? order by createdAt desc limit 1");
                            AutoCloseable autoCloseable2 = stmt;
                            Throwable throwable2 = null;
                            try {
                                BlockStats blockStats3;
                                PreparedStatement it = (PreparedStatement)autoCloseable2;
                                boolean bl2 = false;
                                it.setString(1, string);
                                ResultSet rs = it.executeQuery();
                                if (rs.next()) {
                                    Collection<Hash> collection;
                                    Object it2;
                                    Collection<TxStats> collection2;
                                    Object[] $this$mapTo$iv$iv;
                                    Object[] $this$map$iv;
                                    Object[] objectArray = UInt256.fromBytes((Bytes)Bytes.wrap((byte[])rs.getBytes(1)));
                                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"fromBytes(Bytes.wrap(rs.getBytes(1)))");
                                    Object[] objectArray2 = objectArray;
                                    objectArray = Hash.fromBytes((Bytes)Bytes.wrap((byte[])rs.getBytes(2)));
                                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"fromBytes(Bytes.wrap(rs.getBytes(2)))");
                                    Object[] objectArray3 = objectArray;
                                    objectArray = Hash.fromBytes((Bytes)Bytes.wrap((byte[])rs.getBytes(3)));
                                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"fromBytes(Bytes.wrap(rs.getBytes(3)))");
                                    Object[] objectArray4 = objectArray;
                                    long l = rs.getLong(4);
                                    objectArray = Address.fromBytes((Bytes)Bytes.wrap((byte[])rs.getBytes(5)));
                                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"fromBytes(Bytes.wrap(rs.getBytes(5)))");
                                    Object[] objectArray5 = objectArray;
                                    long l2 = rs.getLong(6);
                                    long l3 = rs.getLong(7);
                                    objectArray = UInt256.fromBytes((Bytes)Bytes.wrap((byte[])rs.getBytes(8)));
                                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"fromBytes(Bytes.wrap(rs.getBytes(8)))");
                                    Object[] objectArray6 = objectArray;
                                    objectArray = UInt256.fromBytes((Bytes)Bytes.wrap((byte[])rs.getBytes(9)));
                                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"fromBytes(Bytes.wrap(rs.getBytes(9)))");
                                    Object[] objectArray7 = objectArray;
                                    Object object2 = rs.getArray(10).getArray();
                                    if (object2 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<*>");
                                    }
                                    objectArray = (Object[])object2;
                                    Object[] objectArray8 = objectArray7;
                                    Object[] objectArray9 = objectArray6;
                                    long l4 = l3;
                                    long l5 = l2;
                                    Object[] objectArray10 = objectArray5;
                                    long l6 = l;
                                    Object[] objectArray11 = objectArray4;
                                    Object[] objectArray12 = objectArray3;
                                    Object[] objectArray13 = objectArray2;
                                    boolean $i$f$map = false;
                                    void var27_28 = $this$map$iv;
                                    Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                                    boolean $i$f$mapTo = false;
                                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                        void var34_35 = item$iv$iv;
                                        collection2 = destination$iv$iv;
                                        boolean bl3 = false;
                                        void v10 = it2;
                                        if (v10 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
                                        }
                                        Hash hash = Hash.fromBytes((Bytes)Bytes.wrap((byte[])((byte[])v10)));
                                        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"fromBytes(Bytes.wrap(it as ByteArray))");
                                        collection2.add(new TxStats(hash));
                                    }
                                    collection2 = (List)destination$iv$iv;
                                    $this$map$iv = Hash.fromBytes((Bytes)Bytes.wrap((byte[])rs.getBytes(11)));
                                    Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"fromBytes(Bytes.wrap(rs.getBytes(11)))");
                                    Object[] objectArray14 = $this$map$iv;
                                    $this$map$iv = Hash.fromBytes((Bytes)Bytes.wrap((byte[])rs.getBytes(12)));
                                    Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"fromBytes(Bytes.wrap(rs.getBytes(12)))");
                                    Object[] objectArray15 = $this$map$iv;
                                    Object object3 = rs.getArray(13).getArray();
                                    if (object3 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<*>");
                                    }
                                    $this$map$iv = (Object[])object3;
                                    Object[] objectArray16 = objectArray15;
                                    Object[] objectArray17 = objectArray14;
                                    $i$f$map = false;
                                    $this$mapTo$iv$iv = $this$map$iv;
                                    destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                                    $i$f$mapTo = false;
                                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                        it2 = item$iv$iv;
                                        collection = destination$iv$iv;
                                        boolean bl4 = false;
                                        Object object4 = it2;
                                        if (object4 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
                                        }
                                        collection.add(Hash.fromBytes((Bytes)Bytes.wrap((byte[])((byte[])object4))));
                                    }
                                    Collection<Hash> collection3 = collection = (List)destination$iv$iv;
                                    Object[] objectArray18 = objectArray16;
                                    Object[] objectArray19 = objectArray17;
                                    Collection<TxStats> collection4 = collection2;
                                    Object[] objectArray20 = objectArray8;
                                    Object[] objectArray21 = objectArray9;
                                    long l7 = l4;
                                    long l8 = l5;
                                    Object[] objectArray22 = objectArray10;
                                    long l9 = l6;
                                    Object[] objectArray23 = objectArray11;
                                    Object[] objectArray24 = objectArray12;
                                    Object[] objectArray25 = objectArray13;
                                    blockStats3 = new BlockStats((UInt256)objectArray25, (Hash)objectArray24, (Hash)objectArray23, l9, (Address)objectArray22, l8, l7, (UInt256)objectArray21, (UInt256)objectArray20, collection4, (Hash)objectArray19, (Hash)objectArray18, collection3);
                                } else {
                                    blockStats3 = null;
                                }
                                blockStats2 = blockStats3;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                            }
                            blockStats = blockStats2;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return blockStats;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super BlockStats> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Deferred<PeerData> getPeerData(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return BuildersKt.async$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PeerData>, Object>(this, id, null){
            int label;
            final /* synthetic */ EthstatsDataRepository this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        PeerData peerData;
                        ResultKt.throwOnFailure((Object)object);
                        AutoCloseable autoCloseable = this.this$0.getDs().getConnection();
                        String string = this.$id;
                        Throwable throwable = null;
                        try {
                            NodeStats nodeStats;
                            Object object2;
                            Object it3;
                            Object it22;
                            Connection conn = (Connection)autoCloseable;
                            boolean bl = false;
                            PreparedStatement stmt = conn.prepareStatement("select latency.value from latency where latency.id=? order by latency.createdAt desc limit 1");
                            AutoCloseable autoCloseable2 = stmt;
                            Throwable throwable2 = null;
                            try {
                                it22 = (PreparedStatement)autoCloseable2;
                                boolean bl2 = false;
                                it22.setString(1, string);
                                ResultSet rs = it22.executeQuery();
                                it22 = rs.next() ? Boxing.boxLong((long)rs.getLong(1)) : (Long)null;
                            }
                            catch (Throwable it22) {
                                throwable2 = it22;
                                throw it22;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                            }
                            Object latency = it22;
                            PreparedStatement pendingtxStmt = conn.prepareStatement("select pendingtx.value from pendingtx where pendingtx.id=? order by pendingtx.createdAt desc limit 1");
                            it22 = pendingtxStmt;
                            Throwable bl2 = null;
                            try {
                                it3 = (PreparedStatement)it22;
                                boolean bl3 = false;
                                it3.setString(1, string);
                                ResultSet rs = it3.executeQuery();
                                it3 = rs.next() ? Boxing.boxLong((long)rs.getLong(1)) : (Long)null;
                            }
                            catch (Throwable it3) {
                                bl2 = it3;
                                throw it3;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)it22, (Throwable)bl2);
                            }
                            Object pendingTx = it3;
                            PreparedStatement nodeInfoStmt = conn.prepareStatement("select name, node, port, net, protocol, api, os, osVer, client from ethstats_peer where id=? order by createdAt desc limit 1");
                            it3 = nodeInfoStmt;
                            Throwable bl3 = null;
                            try {
                                NodeInfo nodeInfo;
                                PreparedStatement it4 = (PreparedStatement)it3;
                                boolean bl4 = false;
                                it4.setString(1, string);
                                ResultSet rs = it4.executeQuery();
                                if (rs.next()) {
                                    String string2 = rs.getString(1);
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(1)");
                                    String string3 = string2;
                                    string2 = rs.getString(2);
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(2)");
                                    String string4 = string2;
                                    int n = rs.getInt(3);
                                    string2 = rs.getString(4);
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(4)");
                                    String string5 = string2;
                                    string2 = rs.getString(5);
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(5)");
                                    String string6 = string2;
                                    string2 = rs.getString(6);
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(6)");
                                    String string7 = string2;
                                    string2 = rs.getString(7);
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(7)");
                                    String string8 = string2;
                                    string2 = rs.getString(8);
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(8)");
                                    String string9 = string2;
                                    string2 = rs.getString(9);
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(9)");
                                    NodeInfo nodeInfo2 = new NodeInfo(string3, string4, n, string5, string6, string7, string8, string9, false, string2, 256, null);
                                    nodeInfo = nodeInfo2;
                                } else {
                                    nodeInfo = null;
                                }
                                object2 = nodeInfo;
                            }
                            catch (Throwable throwable3) {
                                bl3 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)it3, (Throwable)bl3);
                            }
                            NodeInfo nodeInfo = object2;
                            PreparedStatement nodeStatsStmt = conn.prepareStatement("select active, syncing, mining, hashrate, peers, gasPrice, uptime from ethstats_nodestats where id=? order by createdAt desc limit 1");
                            object2 = nodeStatsStmt;
                            Throwable throwable4 = null;
                            try {
                                PreparedStatement it5 = (PreparedStatement)object2;
                                boolean bl5 = false;
                                it5.setString(1, string);
                                ResultSet rs = it5.executeQuery();
                                nodeStats = rs.next() ? new NodeStats(rs.getBoolean(1), rs.getBoolean(2), rs.getBoolean(3), rs.getInt(4), rs.getInt(5), rs.getInt(6), rs.getInt(7)) : (NodeStats)null;
                            }
                            catch (Throwable throwable5) {
                                throwable4 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)throwable4);
                            }
                            NodeStats nodeStats2 = nodeStats;
                            peerData = new PeerData((Long)latency, (Long)pendingTx, nodeInfo, nodeStats2);
                        }
                        catch (Throwable throwable6) {
                            throwable = throwable6;
                            throw throwable6;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return peerData;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super PeerData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }
}

