/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.crawler;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.eth.crawler.EthstatsDataRepository;
import org.apache.tuweni.ethstats.BlockStats;
import org.apache.tuweni.ethstats.EthStatsServerController;
import org.apache.tuweni.ethstats.NodeInfo;
import org.apache.tuweni.ethstats.NodeStats;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lorg/apache/tuweni/eth/crawler/CrawlerEthstatsController;", "Lorg/apache/tuweni/ethstats/EthStatsServerController;", "repository", "Lorg/apache/tuweni/eth/crawler/EthstatsDataRepository;", "(Lorg/apache/tuweni/eth/crawler/EthstatsDataRepository;)V", "getRepository", "()Lorg/apache/tuweni/eth/crawler/EthstatsDataRepository;", "readBlock", "", "remoteAddress", "", "id", "block", "Lorg/apache/tuweni/ethstats/BlockStats;", "readDisconnect", "readLatency", "latency", "", "readNodeInfo", "nodeInfo", "Lorg/apache/tuweni/ethstats/NodeInfo;", "readNodeStats", "nodeStats", "Lorg/apache/tuweni/ethstats/NodeStats;", "readPendingTx", "pendingTx", "eth-crawler"})
public final class CrawlerEthstatsController
implements EthStatsServerController {
    @NotNull
    private final EthstatsDataRepository repository;

    public CrawlerEthstatsController(@NotNull EthstatsDataRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
    }

    @NotNull
    public final EthstatsDataRepository getRepository() {
        return this.repository;
    }

    public void readNodeInfo(@NotNull String remoteAddress, @NotNull String id, @NotNull NodeInfo nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        this.repository.storeNodeInfo(remoteAddress, id, nodeInfo);
    }

    public void readBlock(@NotNull String remoteAddress, @NotNull String id, @NotNull BlockStats block) {
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.repository.storeBlock(remoteAddress, id, block);
    }

    public void readLatency(@NotNull String remoteAddress, @NotNull String id, long latency) {
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.repository.storeLatency(remoteAddress, id, latency);
    }

    public void readNodeStats(@NotNull String remoteAddress, @NotNull String id, @NotNull NodeStats nodeStats) {
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)nodeStats, (String)"nodeStats");
        this.repository.storeNodeStats(remoteAddress, id, nodeStats);
    }

    public void readPendingTx(@NotNull String remoteAddress, @NotNull String id, long pendingTx) {
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.repository.storePendingTx(remoteAddress, id, pendingTx);
    }

    public void readDisconnect(@NotNull String remoteAddress, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.repository.updateDisconnect(remoteAddress, id);
    }
}

