/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.crawler;

import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.config.Configuration;
import org.apache.tuweni.config.PropertyValidator;
import org.apache.tuweni.config.Schema;
import org.apache.tuweni.config.SchemaBuilder;
import org.apache.tuweni.eth.crawler.UpgradeConfig;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e0\rJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\n \u0007*\u0004\u0018\u00010\u00130\u0013J\u000e\u0010\u0014\u001a\n \u0007*\u0004\u0018\u00010\u00130\u0013J\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\n \u0007*\u0004\u0018\u00010\u00130\u0013J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\n \u0007*\u0004\u0018\u00010\u00130\u0013J\u0006\u0010\u001a\u001a\u00020\u0018J\u000e\u0010\u001b\u001a\n \u0007*\u0004\u0018\u00010\u00130\u0013J\u000e\u0010\u001c\u001a\n \u0007*\u0004\u0018\u00010\u00130\u0013J\u0006\u0010\u001d\u001a\u00020\u0018J\u000e\u0010\u001e\u001a\n \u0007*\u0004\u0018\u00010\u00130\u0013J\u0006\u0010\u001f\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\n \u0007*\u0004\u0018\u00010\u00130\u0013J\u0006\u0010#\u001a\u00020\u0018J\u0006\u0010$\u001a\u00020!J\u000e\u0010%\u001a\n \u0007*\u0004\u0018\u00010\u00130\u0013J\u0006\u0010&\u001a\u00020\u0018J\u0006\u0010'\u001a\u00020\u0010J\u000e\u0010(\u001a\n \u0007*\u0004\u0018\u00010\u00130\u0013J\u0006\u0010)\u001a\u00020\u0018J\u0006\u0010*\u001a\u00020\u0010J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\rR\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006."}, d2={"Lorg/apache/tuweni/eth/crawler/CrawlerConfig;", "", "filePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "config", "Lorg/apache/tuweni/config/Configuration;", "kotlin.jvm.PlatformType", "getConfig", "()Lorg/apache/tuweni/config/Configuration;", "getFilePath", "()Ljava/nio/file/Path;", "bootNodes", "", "Ljava/net/URI;", "clientIdsInterval", "", "clientsStatsDelay", "corsAllowedOrigins", "", "discoveryDNS", "discoveryDNSPollingPeriod", "discoveryNetworkInterface", "discoveryPort", "", "ethstatsNetworkInterface", "ethstatsPort", "ethstatsSecret", "genesisFile", "jdbcConnections", "jdbcUrl", "maxRequestsPerSec", "metricsGrpcPushEnabled", "", "metricsNetworkInterface", "metricsPort", "metricsPrometheusEnabled", "network", "numberOfThreads", "peerCacheExpiration", "restNetworkInterface", "restPort", "rlpxDisconnectionDelay", "upgradesVersions", "Lorg/apache/tuweni/eth/crawler/UpgradeConfig;", "Companion", "eth-crawler"})
public final class CrawlerConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path filePath;
    private final Configuration config;
    @NotNull
    private static final List<String> mainnetEthereumBootnodes;
    @NotNull
    private static final String mainnetDiscoveryDNS;

    public CrawlerConfig(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.filePath = filePath;
        this.config = Configuration.fromToml((Path)this.filePath, (Schema)Companion.schema());
    }

    @NotNull
    public final Path getFilePath() {
        return this.filePath;
    }

    public final Configuration getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<URI> bootNodes() {
        void $this$mapTo$iv$iv;
        List list = this.config.getListOfString("bootnodes");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"config.getListOfString(\"bootnodes\")");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(URI.create((String)it));
        }
        return (List)destination$iv$iv;
    }

    public final int discoveryPort() {
        return this.config.getInteger("discoveryPort");
    }

    public final String discoveryNetworkInterface() {
        return this.config.getString("discoveryNetworkInterface");
    }

    public final String discoveryDNS() {
        return this.config.getString("discoveryDNS");
    }

    public final long discoveryDNSPollingPeriod() {
        return this.config.getLong("discoveryDNSPollingPeriod");
    }

    public final String jdbcUrl() {
        return this.config.getString("jdbcUrl");
    }

    public final String genesisFile() {
        return this.config.getString("genesisFile");
    }

    public final String network() {
        return this.config.getString("network");
    }

    public final int restPort() {
        return this.config.getInteger("restPort");
    }

    public final String restNetworkInterface() {
        return this.config.getString("restNetworkInterface");
    }

    public final int ethstatsPort() {
        return this.config.getInteger("ethstatsPort");
    }

    public final String ethstatsNetworkInterface() {
        return this.config.getString("ethstatsNetworkInterface");
    }

    public final String ethstatsSecret() {
        return this.config.getString("ethstatsSecret");
    }

    public final long peerCacheExpiration() {
        return this.config.getLong("peerCacheExpiration");
    }

    public final long clientIdsInterval() {
        return this.config.getLong("clientIdsInterval");
    }

    public final long clientsStatsDelay() {
        return this.config.getLong("clientsStatsDelay");
    }

    public final int jdbcConnections() {
        return this.config.getInteger("jdbcConnections");
    }

    public final long rlpxDisconnectionDelay() {
        return this.config.getLong("rlpxDisconnectionsDelay");
    }

    public final int maxRequestsPerSec() {
        return this.config.getInteger("maxRequestsPerSec");
    }

    public final int numberOfThreads() {
        return this.config.getInteger("numberOfThreads");
    }

    public final int metricsPort() {
        return this.config.getInteger("metricsPort");
    }

    public final String metricsNetworkInterface() {
        return this.config.getString("metricsNetworkInterface");
    }

    public final boolean metricsGrpcPushEnabled() {
        return this.config.getBoolean("metricsGrpcPushEnabled");
    }

    public final boolean metricsPrometheusEnabled() {
        return this.config.getBoolean("metricsPrometheusEnabled");
    }

    public final String corsAllowedOrigins() {
        return this.config.getString("corsAllowedOrigins");
    }

    @NotNull
    public final List<UpgradeConfig> upgradesVersions() {
        Set upgrades = this.config.sections("upgrades");
        List result = new ArrayList();
        for (String upgrade : upgrades) {
            Configuration section = this.config.getConfigurationSection(upgrade);
            Map versions = new LinkedHashMap();
            for (Map map : section.getListOfMap("versions")) {
                for (Map.Entry entry : map.entrySet()) {
                    Object k = entry.getKey();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"entry.key");
                    String string = ((String)k).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    versions.put(string, entry.getValue().toString());
                }
            }
            String string = section.getString("name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"section.getString(\"name\")");
            UpgradeConfig upgradeConfig = new UpgradeConfig(string, versions);
            result.add(upgradeConfig);
        }
        return result;
    }

    static {
        Object[] objectArray = new String[]{"enode://d860a01f9722d78051619d1e2351aba3f43f943f6f00718d1b9baa4101932a1f5011f16bb2b1bb35db20d6fe28fa0bf09636d26a87d31de9ec6203eeedb1f666@18.138.108.67:30303", "enode://22a8232c3abc76a16ae9d6c3b164f98775fe226f0917b0ca871128a74a8e9630b458460865bab457221f1d448dd9791d24c4e5d88786180ac185df813a68d4de@3.209.45.79:30303", "enode://ca6de62fce278f96aea6ec5a2daadb877e51651247cb96ee310a318def462913b653963c155a0ef6c7d50048bba6e6cea881130857413d9f50a621546b590758@34.255.23.113:30303", "enode://279944d8dcd428dffaa7436f25ca0ca43ae19e7bcf94a8fb7d1641651f92d121e972ac2e8f381414b80cc8e5555811c2ec6e1a99bb009b3f53c4c69923e11bd8@35.158.244.151:30303", "enode://8499da03c47d637b20eee24eec3c356c9a2e6148d6fe25ca195c7949ab8ec2c03e3556126b0d7ed644675e78c4318b08691b7b57de10e5f0d40d05b09238fa0a@52.187.207.27:30303", "enode://103858bdb88756c71f15e9b5e09b56dc1be52f0a5021d46301dbbfb7e130029cc9d0d6f73f693bc29b665770fff7da4d34f3c6379fe12721b5d7a0bcb5ca1fc1@191.234.162.198:30303", "enode://715171f50508aba88aecd1250af392a45a330af91d7b90701c436b618c86aaa1589c9184561907bebbb56439b8f8787bc01f49a7c77276c58c1b09822d75e8e8@52.231.165.108:30303", "enode://5d6d7cd20d6da4bb83a1d28cadb5d409b64edf314c0335df658c1a54e32c7c4a7ab7823d57c39b6a757556e68ff1df17c748b698544a55cb488b52479a92b60f@104.42.217.25:30303", "enode://a979fb575495b8d6db44f750317d0f4622bf4c2aa3365d6af7c284339968eef29b69ad0dce72a4d8db5ebb4968de0e3bec910127f134779fbcb0cb6d3331163c@52.16.188.185:30303", "enode://3f1d12044546b76342d59d4a05532c14b85aa669704bfe1f864fe079415aa2c02d743e03218e57a33fb94523adb54032871a6c51b2cc5514cb7c7e35b3ed0a99@13.93.211.84:30303", "enode://78de8a0916848093c73790ead81d1928bec737d565119932b98c6b100d944b7a95e94f847f689fc723399d2e31129d182f7ef3863f2b4c820abbf3ab2722344d@191.235.84.50:30303", "enode://158f8aab45f6d19c6cbf4a089c2670541a8da11978a2f90dbf6a502a4a3bab80d288afdbeb7ec0ef6d92de563767f3b1ea9e8e334ca711e9f8e2df5a0385e8e6@13.75.154.138:30303", "enode://1118980bf48b0a3640bdba04e0fe78b1add18e1cd99bf22d53daac1fd9972ad650df52176e7c7d89d1114cfef2bc23a2959aa54998a46afcf7d91809f0855082@52.74.57.123:30303", "enode://979b7fa28feeb35a4741660a16076f1943202cb72b6af70d327f053e248bab9ba81760f39d0701ef1d8f89cc1fbd2cacba0710a12cd5314d5e0c9021aa3637f9@5.1.83.226:30303"};
        mainnetEthereumBootnodes = CollectionsKt.listOf((Object[])objectArray);
        mainnetDiscoveryDNS = "enrtree://AKA3AM6LPBYEUDMVNU3BSVQJ5AD45Y7YPOHJLEF6W26QOE4VTUDPE@all.mainnet.ethdisco.net";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/apache/tuweni/eth/crawler/CrawlerConfig$Companion;", "", "()V", "mainnetDiscoveryDNS", "", "getMainnetDiscoveryDNS", "()Ljava/lang/String;", "mainnetEthereumBootnodes", "", "getMainnetEthereumBootnodes", "()Ljava/util/List;", "schema", "Lorg/apache/tuweni/config/Schema;", "eth-crawler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getMainnetEthereumBootnodes() {
            return mainnetEthereumBootnodes;
        }

        @NotNull
        public final String getMainnetDiscoveryDNS() {
            return mainnetDiscoveryDNS;
        }

        @NotNull
        public final Schema schema() {
            SchemaBuilder schema = SchemaBuilder.create().addInteger("discoveryPort", Integer.valueOf(11000), "Discovery service port", PropertyValidator.isValidPort()).addString("discoveryNetworkInterface", "127.0.0.1", "Discovery network interface", null).addInteger("rlpxPort", Integer.valueOf(11000), "RLPx service port", PropertyValidator.inRange((long)1L, (long)65536L)).addString("rlpxNetworkInterface", "127.0.0.1", "RLPx network interface", null).addListOfString("bootnodes", this.getMainnetEthereumBootnodes(), "Bootnodes to discover other peers from", null).addString("discoveryDNS", this.getMainnetDiscoveryDNS(), "DNS discovery crawler", null).addLong("discoveryDNSPollingPeriod", Long.valueOf(60000L), "DNS Discovery Polling Period in milliseconds", null).addString("jdbcUrl", System.getProperty("DATABASE_URL", System.getenv("DATABASE_URL")), "JDBC URL of the form jdbc:posgresql://localhost:5432", PropertyValidator.isPresent()).addInteger("jdbcConnections", Integer.valueOf(25), "Number of JDBC connections for the connections pool", null).addString("network", "mainnet", "Network to use instead of providing a genesis file.", null).addString("genesisFile", "", "Genesis file to use in hello", null).addInteger("restPort", Integer.valueOf(1337), "REST port", null).addString("restNetworkInterface", "0.0.0.0", "REST network interface", null).addString("ethstatsNetworkInterface", "0.0.0.0", "Ethstats network interface", null).addInteger("ethstatsPort", Integer.valueOf(1338), "Ethstats port", null).addString("ethstatsSecret", "changeme", "Ethstats shared secret", null).addLong("peerCacheExpiration", Long.valueOf(300000L), "Peer data cache expiration", null).addLong("clientIdsInterval", Long.valueOf(172800000L), "Client IDs Interval - number of milliseconds to go back in time", null).addLong("clientsStatsDelay", Long.valueOf(30000L), "Delay between client stats calculations", null).addLong("rlpxDisconnectionDelay", Long.valueOf(10000L), "RLPx connections disconnection delay", null).addInteger("maxRequestsPerSec", Integer.valueOf(30), "Number of requests per second over HTTP", null).addInteger("numberOfThreads", Integer.valueOf(10), "Number of Threads for each thread pool", null).addInteger("metricsPort", Integer.valueOf(9090), "Metric service port", PropertyValidator.isValidPort()).addString("metricsNetworkInterface", "localhost", "Metric service network interface", null).addBoolean("metricsGrpcPushEnabled", Boolean.valueOf(false), "Enable pushing metrics to gRPC service", null).addBoolean("metricsPrometheusEnabled", Boolean.valueOf(false), "Enable exposing metrics on the Prometheus endpoint", null).addString("corsAllowedOrigins", "*", "CORS allowed domains filter for REST service", null);
            Schema upgradesSection = SchemaBuilder.create().addString("name", null, "Upgrade name, eg London or Magneto", PropertyValidator.isNotBlank()).addListOfMap("versions", CollectionsKt.emptyList(), "List of minimum version mappings for the upgrade", null).toSchema();
            schema.addSection("upgrades", upgradesSection);
            Schema schema2 = schema.toSchema();
            Intrinsics.checkNotNullExpressionValue((Object)schema2, (String)"schema.toSchema()");
            return schema2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

