/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.crawler;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.opentelemetry.api.metrics.Meter;
import io.vertx.core.Vertx;
import io.vertx.core.net.SocketAddress;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.Job;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.ExpiringSet;
import org.apache.tuweni.concurrent.coroutines.AsyncCompletionKt;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.devp2p.Peer;
import org.apache.tuweni.devp2p.PeerRepository;
import org.apache.tuweni.devp2p.Scraper;
import org.apache.tuweni.devp2p.eth.BlockchainInformation;
import org.apache.tuweni.devp2p.eth.EthClientKt;
import org.apache.tuweni.devp2p.eth.EthHelloSubprotocol;
import org.apache.tuweni.devp2p.eth.SimpleBlockchainInformation;
import org.apache.tuweni.devp2p.eth.Status;
import org.apache.tuweni.discovery.DNSDaemon;
import org.apache.tuweni.discovery.DNSDaemonListener;
import org.apache.tuweni.eth.Block;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.eth.crawler.CrawlerApp;
import org.apache.tuweni.eth.crawler.CrawlerConfig;
import org.apache.tuweni.eth.crawler.CrawlerEthstatsController;
import org.apache.tuweni.eth.crawler.CrawlerRESTService;
import org.apache.tuweni.eth.crawler.EthstatsDataRepository;
import org.apache.tuweni.eth.crawler.PeerConnectionInfo;
import org.apache.tuweni.eth.crawler.RelationalPeerRepository;
import org.apache.tuweni.eth.crawler.StatsJob;
import org.apache.tuweni.eth.crawler.UpgradeConfig;
import org.apache.tuweni.eth.genesis.GenesisFile;
import org.apache.tuweni.ethstats.EthStatsServer;
import org.apache.tuweni.ethstats.EthStatsServerController;
import org.apache.tuweni.metrics.MetricsService;
import org.apache.tuweni.rlpx.MemoryWireConnectionsRepository;
import org.apache.tuweni.rlpx.RLPxService;
import org.apache.tuweni.rlpx.WireConnectionRepository;
import org.apache.tuweni.rlpx.vertx.VertxRLPxService;
import org.apache.tuweni.rlpx.wire.DisconnectReason;
import org.apache.tuweni.rlpx.wire.WireConnection;
import org.apache.tuweni.units.bigints.UInt256;
import org.flywaydb.core.Flyway;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/apache/tuweni/eth/crawler/CrawlerApplication;", "Lkotlinx/coroutines/CoroutineScope;", "vertx", "Lio/vertx/core/Vertx;", "config", "Lorg/apache/tuweni/eth/crawler/CrawlerConfig;", "coroutineContext", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lio/vertx/core/Vertx;Lorg/apache/tuweni/eth/crawler/CrawlerConfig;Lkotlinx/coroutines/CoroutineDispatcher;)V", "getConfig", "()Lorg/apache/tuweni/eth/crawler/CrawlerConfig;", "getCoroutineContext", "()Lkotlinx/coroutines/CoroutineDispatcher;", "metricsService", "Lorg/apache/tuweni/metrics/MetricsService;", "getVertx", "()Lio/vertx/core/Vertx;", "connect", "Lorg/apache/tuweni/concurrent/AsyncCompletion;", "rlpxService", "Lorg/apache/tuweni/rlpx/RLPxService;", "key", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "address", "Ljava/net/InetSocketAddress;", "createCoroutineContext", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "run", "", "eth-crawler"})
public final class CrawlerApplication
implements CoroutineScope {
    @NotNull
    private final Vertx vertx;
    @NotNull
    private final CrawlerConfig config;
    @NotNull
    private final CoroutineDispatcher coroutineContext;
    @NotNull
    private final MetricsService metricsService;

    public CrawlerApplication(@NotNull Vertx vertx, @NotNull CrawlerConfig config, @NotNull CoroutineDispatcher coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.vertx = vertx;
        this.config = config;
        this.coroutineContext = coroutineContext;
        int n = this.config.metricsPort();
        String string = this.config.metricsNetworkInterface();
        boolean bl = this.config.metricsGrpcPushEnabled();
        boolean bl2 = this.config.metricsPrometheusEnabled();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"metricsNetworkInterface()");
        this.metricsService = new MetricsService("eth-crawler", 0L, n, string, bl2, bl, null, 0L, 194, null);
    }

    public /* synthetic */ CrawlerApplication(Vertx vertx, CrawlerConfig crawlerConfig, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ExecutorService executorService = Executors.newFixedThreadPool(crawlerConfig.numberOfThreads(), CrawlerApplication::_init_$lambda-0);
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"class CrawlerApplication\u2026ENT_QUITTING)\n    }\n  }\n}");
            coroutineDispatcher = (CoroutineDispatcher)ExecutorsKt.from((ExecutorService)executorService);
        }
        this(vertx, crawlerConfig, coroutineDispatcher);
    }

    @NotNull
    public final Vertx getVertx() {
        return this.vertx;
    }

    @NotNull
    public final CrawlerConfig getConfig() {
        return this.config;
    }

    @NotNull
    public CoroutineDispatcher getCoroutineContext() {
        return this.coroutineContext;
    }

    private final ExecutorCoroutineDispatcher createCoroutineContext() {
        ExecutorService executorService = Executors.newFixedThreadPool(this.config.numberOfThreads(), CrawlerApplication::createCoroutineContext$lambda-1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newFixedThreadPool(\n    \u2026mon = true\n    thread\n  }");
        return ExecutorsKt.from((ExecutorService)executorService);
    }

    public final void run() {
        HikariConfig dbConfig = new HikariConfig();
        dbConfig.setMaximumPoolSize(this.config.jdbcConnections());
        dbConfig.setJdbcUrl(this.config.jdbcUrl());
        HikariDataSource ds = new HikariDataSource(dbConfig);
        Flyway flyway = Flyway.configure().dataSource((DataSource)ds).load();
        flyway.migrate();
        Meter crawlerMeter = this.metricsService.getMeterSdkProvider().get("crawler");
        RelationalPeerRepository repo = new RelationalPeerRepository((DataSource)ds, this.config.peerCacheExpiration(), this.config.clientIdsInterval(), null, 8, null);
        List<UpgradeConfig> list = this.config.upgradesVersions();
        Intrinsics.checkNotNullExpressionValue((Object)crawlerMeter, (String)"crawlerMeter");
        StatsJob statsJob = new StatsJob(repo, list, crawlerMeter, this.config.clientsStatsDelay(), (CoroutineContext)this.getCoroutineContext());
        EthClientKt.getLogger().info("Initial bootnodes: " + this.config.bootNodes());
        Vertx vertx = this.vertx;
        Object object = this.config.bootNodes();
        SocketAddress socketAddress = SocketAddress.inetSocketAddress((int)this.config.discoveryPort(), (String)this.config.discoveryNetworkInterface());
        ExecutorCoroutineDispatcher executorCoroutineDispatcher = this.createCoroutineContext();
        CoroutineContext coroutineContext = (CoroutineContext)executorCoroutineDispatcher;
        Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"inetSocketAddress(config\u2026coveryNetworkInterface())");
        Scraper scraper = new Scraper(coroutineContext, vertx, object, socketAddress, (PeerRepository)repo, null, 0L, 96, null);
        object = this.config.discoveryDNS();
        long l = this.config.discoveryDNSPollingPeriod();
        DNSDaemonListener dNSDaemonListener = new DNSDaemonListener(this, repo){
            final /* synthetic */ CrawlerApplication this$0;
            final /* synthetic */ RelationalPeerRepository $repo;
            {
                this.this$0 = $receiver;
                this.$repo = $repo;
            }

            public void newRecords(long seq, @NotNull List<EthereumNodeRecord> records) {
                Intrinsics.checkNotNullParameter(records, (String)"records");
                BuildersKt.launch$default((CoroutineScope)this.this$0, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(records, this.$repo, null){
                    Object L$0;
                    Object L$1;
                    int label;
                    final /* synthetic */ List<EthereumNodeRecord> $records;
                    final /* synthetic */ RelationalPeerRepository $repo;
                    {
                        this.$records = $records;
                        this.$repo = $repo;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                var2_3 = this.$records;
                                var3_4 = this.$repo;
                                $i$f$forEach = false;
                                var5_6 = $this$forEach$iv.iterator();
lbl9:
                                // 3 sources

                                while (var5_6.hasNext()) {
                                    element$iv = var5_6.next();
                                    it = (EthereumNodeRecord)element$iv;
                                    $i$a$-forEach-CrawlerApplication$run$dnsDaemon$1$newRecords$1$1 = false;
                                    var9_10 = it.ip().getHostAddress();
                                    Intrinsics.checkNotNullExpressionValue((Object)var9_10, (String)"it.ip().hostAddress");
                                    v0 = it.tcp();
                                    Intrinsics.checkNotNull((Object)v0);
                                    this.L$0 = var3_4;
                                    this.L$1 = var5_6;
                                    this.label = 1;
                                    v1 = var3_4.get(var9_10, v0, it.publicKey(), (Continuation<? super Peer>)this);
                                    if (v1 != var10_2) continue;
                                    return var10_2;
                                }
                                break;
                            }
                            case 1: {
                                $i$f$forEach = false;
                                $i$a$-forEach-CrawlerApplication$run$dnsDaemon$1$newRecords$1$1 = false;
                                var5_6 = (Iterator<T>)this.L$1;
                                var3_4 = (RelationalPeerRepository)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                                ** GOTO lbl9
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        };
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"discoveryDNS()");
        DNSDaemon dnsDaemon2 = new DNSDaemon((String)object, dNSDaemonListener, 0L, l, null, null, 48, null);
        byte[] contents = this.config.network() == null ? Files.readAllBytes(Paths.get(this.config.genesisFile(), new String[0])) : CrawlerApp.class.getResourceAsStream("/" + this.config.network() + ".json").readAllBytes();
        GenesisFile genesisFile = GenesisFile.read((byte[])contents);
        Block genesisBlock = genesisFile.toBlock();
        Object object2 = UInt256.valueOf((long)genesisFile.getChainId());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"valueOf(genesisFile.chainId.toLong())");
        UInt256 uInt256 = object2;
        object2 = genesisBlock.getHeader().getDifficulty();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"genesisBlock.header.difficulty");
        UInt256 uInt2562 = object2;
        object2 = genesisBlock.getHeader().getHash();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"genesisBlock.header.hash");
        UInt256 uInt2563 = object2;
        object2 = UInt256.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ZERO");
        UInt256 uInt2564 = object2;
        object2 = genesisBlock.getHeader().getHash();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"genesisBlock.header.hash");
        UInt256 uInt2565 = object2;
        object2 = genesisFile.getForks();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"genesisFile.forks");
        SimpleBlockchainInformation blockchainInformation = new SimpleBlockchainInformation(uInt256, uInt2562, (Hash)uInt2563, uInt2564, (Hash)uInt2565, (List)object2);
        ExpiringSet expiringConnectionIds = new ExpiringSet();
        EthHelloSubprotocol ethHelloProtocol2 = new EthHelloSubprotocol(null, (BlockchainInformation)blockchainInformation, (Function2)new Function2<WireConnection, Status, Unit>((ExpiringSet<String>)expiringConnectionIds, repo){
            final /* synthetic */ ExpiringSet<String> $expiringConnectionIds;
            final /* synthetic */ RelationalPeerRepository $repo;
            {
                this.$expiringConnectionIds = $expiringConnectionIds;
                this.$repo = $repo;
                super(2);
            }

            public final void invoke(@NotNull WireConnection conn, @NotNull Status status) {
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                this.$expiringConnectionIds.add((Object)conn.uri());
                this.$repo.recordInfo(conn, status);
            }
        }, 1, null);
        Meter meter = this.metricsService.getMeterSdkProvider().get("rlpx-crawler");
        MemoryWireConnectionsRepository wireConnectionsRepository = new MemoryWireConnectionsRepository();
        wireConnectionsRepository.addDisconnectionListener(arg_0 -> CrawlerApplication.run$lambda-2(expiringConnectionIds, repo, arg_0));
        wireConnectionsRepository.addConnectionListener(arg_0 -> CrawlerApplication.run$lambda-3(this, arg_0));
        VertxRLPxService rlpxService = new VertxRLPxService(this.vertx, 30303, "127.0.0.1", 30303, SECP256K1.KeyPair.random(), CollectionsKt.listOf((Object)ethHelloProtocol2), "Apache Tuweni network crawler", meter, (WireConnectionRepository)wireConnectionsRepository);
        repo.addListener((Function1<? super Peer, Unit>)((Function1)new Function1<Peer, Unit>(this, rlpxService){
            final /* synthetic */ CrawlerApplication this$0;
            final /* synthetic */ VertxRLPxService $rlpxService;
            {
                this.this$0 = $receiver;
                this.$rlpxService = $rlpxService;
                super(1);
            }

            public final void invoke(@NotNull Peer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BuildersKt.launch$default((CoroutineScope)this.this$0, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$rlpxService, it, null){
                    int label;
                    final /* synthetic */ CrawlerApplication this$0;
                    final /* synthetic */ VertxRLPxService $rlpxService;
                    final /* synthetic */ Peer $it;
                    {
                        this.this$0 = $receiver;
                        this.$rlpxService = $rlpxService;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Integer n = this.$it.getEndpoint().getTcpPort();
                                this.this$0.connect((RLPxService)this.$rlpxService, this.$it.getNodeId(), new InetSocketAddress(this.$it.getEndpoint().getAddress(), n == null ? 30303 : n));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }));
        int n = this.config.restPort();
        String string = this.config.restNetworkInterface();
        int n2 = this.config.maxRequestsPerSec();
        String string2 = this.config.corsAllowedOrigins();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"restNetworkInterface()");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"corsAllowedOrigins()");
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"meter");
        CrawlerRESTService restService = new CrawlerRESTService(n, string, null, n2, string2, null, null, repo, statsJob, meter, null, 1124, null);
        AtomicBoolean refreshLoop = new AtomicBoolean(true);
        EthstatsDataRepository ethstatsDataRepository = new EthstatsDataRepository((DataSource)ds, null, 2, null);
        string2 = this.config.ethstatsNetworkInterface();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.ethstatsNetworkInterface()");
        String string3 = string2;
        int n3 = this.config.ethstatsPort();
        string2 = this.config.ethstatsSecret();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.ethstatsSecret()");
        EthStatsServer ethstatsServer = new EthStatsServer(this.vertx, string3, n3, string2, null, (EthStatsServerController)new CrawlerEthstatsController(ethstatsDataRepository), (CoroutineContext)this.createCoroutineContext(), 16, null);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> CrawlerApplication.run$lambda-4(statsJob, refreshLoop, scraper, dnsDaemon2, rlpxService, restService, this, ethstatsServer)));
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(statsJob, restService, rlpxService, dnsDaemon2, scraper, ethstatsServer, refreshLoop, repo, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ StatsJob $statsJob;
            final /* synthetic */ CrawlerRESTService $restService;
            final /* synthetic */ VertxRLPxService $rlpxService;
            final /* synthetic */ DNSDaemon $dnsDaemon;
            final /* synthetic */ Scraper $scraper;
            final /* synthetic */ EthStatsServer $ethstatsServer;
            final /* synthetic */ AtomicBoolean $refreshLoop;
            final /* synthetic */ RelationalPeerRepository $repo;
            final /* synthetic */ CrawlerApplication this$0;
            {
                this.$statsJob = $statsJob;
                this.$restService = $restService;
                this.$rlpxService = $rlpxService;
                this.$dnsDaemon = $dnsDaemon;
                this.$scraper = $scraper;
                this.$ethstatsServer = $ethstatsServer;
                this.$refreshLoop = $refreshLoop;
                this.$repo = $repo;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        this.$statsJob.start();
                        this.L$0 = $this$runBlocking;
                        this.label = 1;
                        v0 = this.$restService.start().await((Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$refreshLoop, this.$repo, this.this$0, this.$rlpxService, null){
                            int label;
                            final /* synthetic */ AtomicBoolean $refreshLoop;
                            final /* synthetic */ RelationalPeerRepository $repo;
                            final /* synthetic */ CrawlerApplication this$0;
                            final /* synthetic */ VertxRLPxService $rlpxService;
                            {
                                this.$refreshLoop = $refreshLoop;
                                this.$repo = $repo;
                                this.this$0 = $receiver;
                                this.$rlpxService = $rlpxService;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                                        // 3 sources

                                        while (this.$refreshLoop.get()) {
                                            try {
                                                for (PeerConnectionInfo connectionInfo : RelationalPeerRepository.getPeers$eth_crawler$default(this.$repo, System.currentTimeMillis() - (long)3600000, null, null, 6, null)) {
                                                    this.this$0.connect((RLPxService)this.$rlpxService, connectionInfo.getNodeId(), new InetSocketAddress(connectionInfo.getHost(), connectionInfo.getPort() == 0 ? 30303 : connectionInfo.getPort()));
                                                }
                                            }
                                            catch (Exception e) {
                                                EthClientKt.getLogger().error("Error connecting to peers", (Throwable)e);
                                            }
                                            this.label = 1;
                                            v0 = DelayKt.delay((long)300000L, (Continuation)((Continuation)this));
                                            if (v0 != var4_2) continue;
                                            return var4_2;
                                        }
                                        break;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        ** GOTO lbl5
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        var3_4 = this.$rlpxService.start();
                        Intrinsics.checkNotNullExpressionValue((Object)var3_4, (String)"rlpxService.start()");
                        this.L$0 = $this$runBlocking;
                        this.label = 2;
                        v1 = AsyncCompletionKt.await((AsyncCompletion)var3_4, (Continuation)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl31
                    }
                    case 2: {
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl31:
                        // 2 sources

                        this.$dnsDaemon.start();
                        this.$scraper.start();
                        this.L$0 = $this$runBlocking;
                        this.label = 3;
                        v2 = this.$ethstatsServer.start((Continuation)this);
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl44
                    }
                    case 3: {
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl44:
                        // 2 sources

                        peerSeen = new ExpiringSet(300000L);
                        return BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$refreshLoop, this.$repo, (ExpiringSet<PeerConnectionInfo>)peerSeen, this.this$0, this.$rlpxService, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ AtomicBoolean $refreshLoop;
                            final /* synthetic */ RelationalPeerRepository $repo;
                            final /* synthetic */ ExpiringSet<PeerConnectionInfo> $peerSeen;
                            final /* synthetic */ CrawlerApplication this$0;
                            final /* synthetic */ VertxRLPxService $rlpxService;
                            {
                                this.$refreshLoop = $refreshLoop;
                                this.$repo = $repo;
                                this.$peerSeen = $peerSeen;
                                this.this$0 = $receiver;
                                this.$rlpxService = $rlpxService;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        $this$launch = (CoroutineScope)this.L$0;
lbl6:
                                        // 3 sources

                                        while (this.$refreshLoop.get()) {
                                            try {
                                                BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$repo, this.$peerSeen, this.this$0, this.$rlpxService, null){
                                                    int label;
                                                    private /* synthetic */ Object L$0;
                                                    final /* synthetic */ RelationalPeerRepository $repo;
                                                    final /* synthetic */ ExpiringSet<PeerConnectionInfo> $peerSeen;
                                                    final /* synthetic */ CrawlerApplication this$0;
                                                    final /* synthetic */ VertxRLPxService $rlpxService;
                                                    {
                                                        this.$repo = $repo;
                                                        this.$peerSeen = $peerSeen;
                                                        this.this$0 = $receiver;
                                                        this.$rlpxService = $rlpxService;
                                                        super(2, $completion);
                                                    }

                                                    /*
                                                     * WARNING - void declaration
                                                     * Enabled force condition propagation
                                                     * Lifted jumps to return sites
                                                     */
                                                    @Nullable
                                                    public final Object invokeSuspend(@NotNull Object object) {
                                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                void $this$mapTo$iv$iv;
                                                                void $this$map$iv;
                                                                ResultKt.throwOnFailure((Object)object);
                                                                CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                                                EthClientKt.getLogger().info("Requesting pending peers");
                                                                List pendingPeers = RelationalPeerRepository.getPendingPeers$eth_crawler$default(this.$repo, 100, 0, 2, null);
                                                                EthClientKt.getLogger().info("Requesting connections to " + pendingPeers.size() + " peers");
                                                                Iterable iterable = pendingPeers;
                                                                ExpiringSet<PeerConnectionInfo> expiringSet = this.$peerSeen;
                                                                CrawlerApplication crawlerApplication = this.this$0;
                                                                VertxRLPxService vertxRLPxService = this.$rlpxService;
                                                                boolean $i$f$map = false;
                                                                void var9_10 = $this$map$iv;
                                                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                                boolean $i$f$mapTo = false;
                                                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                                    void connectionInfo;
                                                                    PeerConnectionInfo peerConnectionInfo = (PeerConnectionInfo)item$iv$iv;
                                                                    Collection collection = destination$iv$iv;
                                                                    boolean bl = false;
                                                                    collection.add(BuildersKt.async$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(expiringSet, (PeerConnectionInfo)connectionInfo, crawlerApplication, vertxRLPxService, null){
                                                                        int label;
                                                                        final /* synthetic */ ExpiringSet<PeerConnectionInfo> $peerSeen;
                                                                        final /* synthetic */ PeerConnectionInfo $connectionInfo;
                                                                        final /* synthetic */ CrawlerApplication this$0;
                                                                        final /* synthetic */ VertxRLPxService $rlpxService;
                                                                        {
                                                                            this.$peerSeen = $peerSeen;
                                                                            this.$connectionInfo = $connectionInfo;
                                                                            this.this$0 = $receiver;
                                                                            this.$rlpxService = $rlpxService;
                                                                            super(2, $completion);
                                                                        }

                                                                        /*
                                                                         * WARNING - void declaration
                                                                         * Enabled force condition propagation
                                                                         * Lifted jumps to return sites
                                                                         */
                                                                        @Nullable
                                                                        public final Object invokeSuspend(@NotNull Object object) {
                                                                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                            switch (this.label) {
                                                                                case 0: {
                                                                                    ResultKt.throwOnFailure((Object)object);
                                                                                    if (!this.$peerSeen.add((Object)this.$connectionInfo)) return Unit.INSTANCE;
                                                                                    this.label = 1;
                                                                                    Object object3 = AsyncCompletionKt.await((AsyncCompletion)this.this$0.connect((RLPxService)this.$rlpxService, this.$connectionInfo.getNodeId(), new InetSocketAddress(this.$connectionInfo.getHost(), this.$connectionInfo.getPort() == 0 ? 30303 : this.$connectionInfo.getPort())), (Continuation)((Continuation)this));
                                                                                    if (object3 != object2) return Unit.INSTANCE;
                                                                                    return object2;
                                                                                }
                                                                                case 1: {
                                                                                    void $result;
                                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                                    Object object3 = $result;
                                                                                    return Unit.INSTANCE;
                                                                                }
                                                                            }
                                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                        }

                                                                        @NotNull
                                                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                                        }

                                                                        @Nullable
                                                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                        }
                                                                    }), (int)3, null));
                                                                }
                                                                this.label = 1;
                                                                Object object3 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                                                                if (object3 != object2) return Unit.INSTANCE;
                                                                return object2;
                                                            }
                                                            case 1: {
                                                                void $result;
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                Object object3 = $result;
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    @NotNull
                                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                        var3_3.L$0 = value;
                                                        return (Continuation)var3_3;
                                                    }

                                                    @Nullable
                                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                }), (int)3, null);
                                            }
                                            catch (Exception e) {
                                                EthClientKt.getLogger().error("Error connecting to pending peers", (Throwable)e);
                                            }
                                            this.L$0 = $this$launch;
                                            this.label = 1;
                                            v0 = DelayKt.delay((long)10000L, (Continuation)((Continuation)this));
                                            if (v0 != var4_2) continue;
                                            return var4_2;
                                        }
                                        break;
                                    }
                                    case 1: {
                                        $this$launch = (CoroutineScope)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        ** GOTO lbl6
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Job> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public final AsyncCompletion connect(@NotNull RLPxService rlpxService, @NotNull SECP256K1.PublicKey key, @NotNull InetSocketAddress address) {
        Intrinsics.checkNotNullParameter((Object)rlpxService, (String)"rlpxService");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        AsyncCompletion asyncCompletion = rlpxService.connectTo(key, address).thenAccept(arg_0 -> CrawlerApplication.connect$lambda-5(rlpxService, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)asyncCompletion, (String)"rlpxService.connectTo(ke\u2026on.CLIENT_QUITTING)\n    }");
        return asyncCompletion;
    }

    private static final Thread _init_$lambda-0(Runnable it) {
        Thread thread = new Thread("crawler");
        thread.setDaemon(true);
        return thread;
    }

    private static final Thread createCoroutineContext$lambda-1(Runnable it) {
        Thread thread = new Thread("crawler");
        thread.setDaemon(true);
        return thread;
    }

    private static final void run$lambda-2(ExpiringSet $expiringConnectionIds, RelationalPeerRepository $repo, WireConnection it) {
        Intrinsics.checkNotNullParameter((Object)$expiringConnectionIds, (String)"$expiringConnectionIds");
        Intrinsics.checkNotNullParameter((Object)$repo, (String)"$repo");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($expiringConnectionIds.add((Object)it.uri())) {
            $repo.recordInfo(it, null);
        }
    }

    private static final void run$lambda-3(CrawlerApplication this$0, WireConnection it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BuildersKt.launch$default((CoroutineScope)this$0, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, it, null){
            int label;
            final /* synthetic */ CrawlerApplication this$0;
            final /* synthetic */ WireConnection $it;
            {
                this.this$0 = $receiver;
                this.$it = $it;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)this.this$0.getConfig().rlpxDisconnectionDelay(), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.$it.disconnect(DisconnectReason.CLIENT_QUITTING);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void run$lambda-4(StatsJob $statsJob, AtomicBoolean $refreshLoop, Scraper $scraper, DNSDaemon $dnsDaemon, VertxRLPxService $rlpxService, CrawlerRESTService $restService, CrawlerApplication this$0, EthStatsServer $ethstatsServer) {
        Intrinsics.checkNotNullParameter((Object)$statsJob, (String)"$statsJob");
        Intrinsics.checkNotNullParameter((Object)$refreshLoop, (String)"$refreshLoop");
        Intrinsics.checkNotNullParameter((Object)$scraper, (String)"$scraper");
        Intrinsics.checkNotNullParameter((Object)$dnsDaemon, (String)"$dnsDaemon");
        Intrinsics.checkNotNullParameter((Object)$rlpxService, (String)"$rlpxService");
        Intrinsics.checkNotNullParameter((Object)$restService, (String)"$restService");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$ethstatsServer, (String)"$ethstatsServer");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($statsJob, $refreshLoop, $scraper, $dnsDaemon, $rlpxService, $restService, this$0, $ethstatsServer, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ StatsJob $statsJob;
            final /* synthetic */ AtomicBoolean $refreshLoop;
            final /* synthetic */ Scraper $scraper;
            final /* synthetic */ DNSDaemon $dnsDaemon;
            final /* synthetic */ VertxRLPxService $rlpxService;
            final /* synthetic */ CrawlerRESTService $restService;
            final /* synthetic */ CrawlerApplication this$0;
            final /* synthetic */ EthStatsServer $ethstatsServer;
            {
                this.$statsJob = $statsJob;
                this.$refreshLoop = $refreshLoop;
                this.$scraper = $scraper;
                this.$dnsDaemon = $dnsDaemon;
                this.$rlpxService = $rlpxService;
                this.$restService = $restService;
                this.this$0 = $receiver;
                this.$ethstatsServer = $ethstatsServer;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        this.L$0 = $this$runBlocking;
                        this.label = 1;
                        v0 = this.$statsJob.stop((Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.$refreshLoop.set(false);
                        this.L$0 = $this$runBlocking;
                        this.label = 2;
                        v1 = this.$scraper.stop().await((Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl27:
                        // 2 sources

                        this.$dnsDaemon.close();
                        var3_4 = this.$rlpxService.stop();
                        Intrinsics.checkNotNullExpressionValue((Object)var3_4, (String)"rlpxService.stop()");
                        this.L$0 = $this$runBlocking;
                        this.label = 3;
                        v2 = AsyncCompletionKt.await((AsyncCompletion)var3_4, (Continuation)((Continuation)this));
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl40
                    }
                    case 3: {
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl40:
                        // 2 sources

                        this.L$0 = $this$runBlocking;
                        this.label = 4;
                        v3 = this.$restService.stop().await((Continuation)this);
                        if (v3 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl50
                    }
                    case 4: {
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl50:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 5;
                        v4 = BuildersKt.async$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$ethstatsServer, null){
                            int label;
                            final /* synthetic */ EthStatsServer $ethstatsServer;
                            {
                                this.$ethstatsServer = $ethstatsServer;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.$ethstatsServer.stop((Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null).await((Continuation)this);
                        if (v4 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl59
                    }
                    case 5: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl59:
                        // 2 sources

                        CrawlerApplication.access$getMetricsService$p(this.this$0).close();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final void connect$lambda-5(RLPxService $rlpxService, WireConnection it) {
        Intrinsics.checkNotNullParameter((Object)$rlpxService, (String)"$rlpxService");
        $rlpxService.disconnect(it, DisconnectReason.CLIENT_QUITTING);
    }

    public static final /* synthetic */ MetricsService access$getMetricsService$p(CrawlerApplication $this) {
        return $this.metricsService;
    }
}

