/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.crawler;

import io.vertx.core.Vertx;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.config.ConfigurationError;
import org.apache.tuweni.eth.crawler.CrawlerApplication;
import org.apache.tuweni.eth.crawler.CrawlerConfig;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/apache/tuweni/eth/crawler/CrawlerApp;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "eth-crawler"})
public final class CrawlerApp {
    @NotNull
    public static final CrawlerApp INSTANCE = new CrawlerApp();

    private CrawlerApp() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Path configFile = Paths.get(!(args.length == 0) ? args[0] : "config.toml", new String[0]);
        Security.addProvider((Provider)new BouncyCastleProvider());
        Vertx vertx = Vertx.vertx();
        Intrinsics.checkNotNullExpressionValue((Object)configFile, (String)"configFile");
        CrawlerConfig config = new CrawlerConfig(configFile);
        if (config.getConfig().hasErrors()) {
            for (ConfigurationError error : config.getConfig().errors()) {
                System.out.println((Object)error.getMessage());
            }
            System.exit(1);
        }
        Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
        CrawlerApplication app = new CrawlerApplication(vertx, config, null, 4, null);
        app.run();
    }
}

